// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/ntp/ntp_pac.h"

namespace binpac {






namespace NTP {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextNTP::ContextNTP(NTP_Conn* connection, NTP_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextNTP::~ContextNTP() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Conn::NTP_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new NTP_Flow(this, true);
    downflow_ = new NTP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Conn::~NTP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void NTP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void NTP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void NTP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_mode7_msg::NTP_mode7_msg() {
    second_byte_ = 0;
    implementation_ = 0;
    request_code_ = 0;
    err_and_data_len_ = 0;
    have_mac_case_index_ = -1;
    mac_ = nullptr;
    byteorder_ = bigendian;
    auth_bit_ = false;
    sequence_ = 0;
    error_code_ = 0;
    data_len_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_mode7_msg::~NTP_mode7_msg() {
    data_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_mac_case_index() ) {
        case true:
            // Clean up "mac"
            {
                delete mac_;
                mac_ = nullptr;
            }
            break;
        case false:
            // Clean up "nil"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int NTP_mode7_msg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    sourcedata_ = const_bytestring(t_begin_of_data, t_end_of_data);
    // Checking out-of-bound for "NTP_mode7_msg:err_and_data_len"
    if ( (t_begin_of_data + 3) + (2) > t_end_of_data || (t_begin_of_data + 3) + (2) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_mode7_msg:err_and_data_len",
        	(3) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "second_byte"
    second_byte_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "implementation"
    implementation_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "request_code"
    request_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "err_and_data_len"
    err_and_data_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "data"
    int t_data__size;
    data_len_ =  ( err_and_data_len() & 0x0FFF ) ;
    t_data__size = data_len();
    // Checking out-of-bound for "NTP_mode7_msg:data"
    if ( (t_begin_of_data + 5) + (t_data__size) > t_end_of_data || (t_begin_of_data + 5) + (t_data__size) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_mode7_msg:data",
        	(5) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + t_data__size;
        int t_data_string_length;
        t_data_string_length = data_len();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-mode7.pac:112", t_data_string_length);
        data_.init((t_begin_of_data + 5), t_data_string_length);
    }

    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 5) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    // Parse "have_mac"
    int t_have_mac__size;
    auth_bit_ =  ( second_byte() & 0x80 )  > 0;
    have_mac_case_index_ =  ( auth_bit() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_mac_case_index() ) {
        case true:
            // Parse "mac"
            {
                mac_ = new NTP_MAC();
                int t_mac__size;
                t_mac__size = mac_->Parse(t_dataptr_after_data, t_end_of_data, byteorder());
                t_have_mac__size = t_mac__size;
            }
            break;
        case false:
            // Parse "nil"
            {
                t_have_mac__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("NTP_mode7_msg", (int64)have_mac_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_NTP_mode7_msg__size;
    const_byteptr const t_dataptr_after_have_mac = t_dataptr_after_data + (t_have_mac__size);
    BINPAC_ASSERT(t_dataptr_after_have_mac <= t_end_of_data);
    t_NTP_mode7_msg__size = t_dataptr_after_have_mac - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    sequence_ =  ( second_byte() & 0x7F ) ;
    error_code_ =  ( err_and_data_len() & 0xF000 )  >> 12;
    sourcedata_.set_end(t_begin_of_data + t_NTP_mode7_msg__size);
    BINPAC_ASSERT(t_begin_of_data + (t_NTP_mode7_msg__size) <= t_end_of_data);
    return t_NTP_mode7_msg__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_PDU::NTP_PDU(bool is_orig) {
    first_byte_ = 0;
    standard_modes_case_index_ = -1;
    std_ = nullptr;
    modes_6_7_case_index_ = -1;
    control_ = nullptr;
    mode7_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    leap_ = 0;
    version_ = 0;
    mode_ = 0;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_PDU::~NTP_PDU() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( standard_modes_case_index() ) {
        case ((int)1):
            // Clean up "std"
            {
                delete std_;
                std_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "emp"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( modes_6_7_case_index() ) {
        case ((uint8)6):
            // Clean up "control"
            {
                delete control_;
                control_ = nullptr;
            }
            break;
        case ((uint8)7):
            // Clean up "mode7"
            {
                delete mode7_;
                mode7_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int NTP_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTP* t_context) {
    sourcedata_ = const_bytestring(t_begin_of_data, t_end_of_data);
    // Checking out-of-bound for "NTP_PDU:first_byte"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_PDU:first_byte",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "first_byte"
    first_byte_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "standard_modes"
    int t_standard_modes__size;
    mode_ =  ( first_byte() & 0x07 ) ;
    standard_modes_case_index_ =  ( mode() >= 1 && mode() <= 5 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( standard_modes_case_index() ) {
        case ((int)1):
            // Parse "std"
            {
                std_ = new NTP_std_msg();
                int t_std__size;
                t_std__size = std_->Parse((t_begin_of_data + 1), t_end_of_data);
                t_standard_modes__size = t_std__size;
            }
            break;
        case ((int)0):
            // Parse "emp"
            {
                t_standard_modes__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("NTP_PDU", (int64)standard_modes_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_standard_modes = (t_begin_of_data + 1) + (t_standard_modes__size);
    BINPAC_ASSERT(t_dataptr_after_standard_modes <= t_end_of_data);
    // Parse "modes_6_7"
    int t_modes_6_7__size;
    modes_6_7_case_index_ =  ( mode() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( modes_6_7_case_index() ) {
        case ((uint8)6):
            // Parse "control"
            {
                control_ = new NTP_control_msg();
                int t_control__size;
                t_control__size = control_->Parse(t_dataptr_after_standard_modes, t_end_of_data);
                t_modes_6_7__size = t_control__size;
            }
            break;
        case ((uint8)7):
            // Parse "mode7"
            {
                mode7_ = new NTP_mode7_msg();
                int t_mode7__size;
                t_mode7__size = mode7_->Parse(t_dataptr_after_standard_modes, t_end_of_data);
                t_modes_6_7__size = t_mode7__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_dataptr_after_standard_modes);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:29", t_unknown_string_length);
                unknown_.init(t_dataptr_after_standard_modes, t_unknown_string_length);
                t_modes_6_7__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_NTP_PDU__size;
    const_byteptr const t_dataptr_after_modes_6_7 = t_dataptr_after_standard_modes + (t_modes_6_7__size);
    BINPAC_ASSERT(t_dataptr_after_modes_6_7 <= t_end_of_data);
    t_NTP_PDU__size = t_dataptr_after_modes_6_7 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    leap_ =  ( first_byte() & 0xc0 )  >> 6;
    version_ =  ( first_byte() & 0x38 )  >> 3;
    proc_ = t_context->flow()->proc_ntp_message(this);
    sourcedata_.set_end(t_begin_of_data + t_NTP_PDU__size);
    BINPAC_ASSERT(t_begin_of_data + (t_NTP_PDU__size) <= t_end_of_data);
    return t_NTP_PDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_std_msg::NTP_std_msg() {
    stratum_ = 0;
    poll_ = 0;
    precision_ = 0;
    root_delay_ = nullptr;
    root_dispersion_ = nullptr;
    reference_ts_ = nullptr;
    origin_ts_ = nullptr;
    receive_ts_ = nullptr;
    transmit_ts_ = nullptr;
    extensions_case_index_ = -1;
    exts_ = nullptr;
    exts__elem_ = nullptr;
    mac_fields_case_index_ = -1;
    mac_ = nullptr;
    mac_ext_ = nullptr;
    byteorder_ = bigendian;
    length_ = 0;
    has_exts_ = false;
    mac_len_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_std_msg::~NTP_std_msg() {
    delete root_delay_;
    root_delay_ = nullptr;
    delete root_dispersion_;
    root_dispersion_ = nullptr;
    reference_id_.free();
    delete reference_ts_;
    reference_ts_ = nullptr;
    delete origin_ts_;
    origin_ts_ = nullptr;
    delete receive_ts_;
    receive_ts_ = nullptr;
    delete transmit_ts_;
    transmit_ts_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( extensions_case_index() ) {
        case true:
            // Clean up "exts"
            {
                delete exts__elem_;
                exts__elem_ = nullptr;
                if ( exts() ) {
                    for ( auto* exts__elem_ : *exts() ) {
                        delete exts__elem_;
                        exts__elem_ = nullptr;
                    }
                }
                delete exts_;
            }
            break;
        case false:
            // Clean up "nil"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( mac_fields_case_index() ) {
        case ((uint32)20):
            // Clean up "mac"
            {
                delete mac_;
                mac_ = nullptr;
            }
            break;
        case ((uint32)24):
            // Clean up "mac_ext"
            {
                delete mac_ext_;
                mac_ext_ = nullptr;
            }
            break;
        default:
            // Clean up "nil2"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int NTP_std_msg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    sourcedata_ = const_bytestring(t_begin_of_data, t_end_of_data);
    // Checking out-of-bound for "NTP_std_msg:root_dispersion"
    if ( (t_begin_of_data + 7) + (4) > t_end_of_data || (t_begin_of_data + 7) + (4) < (t_begin_of_data + 7) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_std_msg:root_dispersion",
        	(7) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "stratum"
    stratum_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "poll"
    poll_ = *(reinterpret_cast<int8 const*>((t_begin_of_data + 1)));

    // Parse "precision"
    precision_ = *(reinterpret_cast<int8 const*>((t_begin_of_data + 2)));

    // Parse "root_delay"
    root_delay_ = new NTP_Short_Time();
    root_delay_->Parse((t_begin_of_data + 3), t_end_of_data, byteorder());

    // Parse "root_dispersion"
    root_dispersion_ = new NTP_Short_Time();
    root_dispersion_->Parse((t_begin_of_data + 7), t_end_of_data, byteorder());

    // Parse "reference_id"
    // Checking out-of-bound for "NTP_std_msg:reference_id"
    if ( (t_begin_of_data + 11) + (4) > t_end_of_data || (t_begin_of_data + 11) + (4) < (t_begin_of_data + 11) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_std_msg:reference_id",
        	(11) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 11) + 4;
        int t_reference_id_string_length;
        t_reference_id_string_length = 4;
        int t_reference_id__size;
        t_reference_id__size = t_reference_id_string_length;
        reference_id_.init((t_begin_of_data + 11), t_reference_id_string_length);
    }

    const_byteptr const t_dataptr_after_reference_id = (t_begin_of_data + 11) + (4);
    BINPAC_ASSERT(t_dataptr_after_reference_id <= t_end_of_data);
    // Checking out-of-bound for "NTP_std_msg:transmit_ts"
    if ( (t_dataptr_after_reference_id + 24) + (8) > t_end_of_data || (t_dataptr_after_reference_id + 24) + (8) < (t_dataptr_after_reference_id + 24) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_std_msg:transmit_ts",
        	(((t_dataptr_after_reference_id + 24) - t_begin_of_data)) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "reference_ts"
    reference_ts_ = new NTP_Time();
    reference_ts_->Parse(t_dataptr_after_reference_id, t_end_of_data, byteorder());

    // Parse "origin_ts"
    origin_ts_ = new NTP_Time();
    origin_ts_->Parse((t_dataptr_after_reference_id + 8), t_end_of_data, byteorder());

    // Parse "receive_ts"
    receive_ts_ = new NTP_Time();
    receive_ts_->Parse((t_dataptr_after_reference_id + 16), t_end_of_data, byteorder());

    // Parse "transmit_ts"
    transmit_ts_ = new NTP_Time();
    transmit_ts_->Parse((t_dataptr_after_reference_id + 24), t_end_of_data, byteorder());

    // Parse "extensions"
    length_ = sourcedata().length();
    has_exts_ =  ( length() - ((t_dataptr_after_reference_id + 32) - t_begin_of_data) )  > 24;
    int t_extensions__size;
    extensions_case_index_ =  ( has_exts() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( extensions_case_index() ) {
        case true:
            // Parse "exts"
            {
                int t_exts__arraylength;
                t_exts__arraylength = 0;
                exts__elem_ = nullptr;
                int t_exts__elem__it;
                t_exts__elem__it = 0;
                int t_exts__size;
                exts_ = new vector<Extension_Field*>;
                const_byteptr t_exts__elem__dataptr = (t_dataptr_after_reference_id + 32);
                for (; /* forever */; ++t_exts__elem__it) {
                    // Check &until(exts__elem__dataptr >= end_of_data)
                    if ( t_exts__elem__dataptr >= t_end_of_data ) {
                        exts__elem_ = nullptr;
                        goto end_of_exts;
                    }
                    exts__elem_ = new Extension_Field();
                    int t_exts__elem__size;
                    t_exts__elem__size = exts__elem_->Parse(t_exts__elem__dataptr, t_end_of_data, byteorder());
                    exts_->push_back(exts__elem_);
                    t_exts__elem__dataptr += t_exts__elem__size;
                    BINPAC_ASSERT(t_exts__elem__dataptr <= t_end_of_data);
                    exts__elem_ = nullptr;
                }
            end_of_exts: ;
                t_exts__size = t_exts__elem__dataptr - ((t_dataptr_after_reference_id + 32));
                // Evaluate 'let' and 'withinput' fields
                t_extensions__size = t_exts__size;
            }
            break;
        case false:
            // Parse "nil"
            {
                t_extensions__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("NTP_std_msg", (int64)extensions_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_extensions = (t_dataptr_after_reference_id + 32) + (t_extensions__size);
    BINPAC_ASSERT(t_dataptr_after_extensions <= t_end_of_data);
    // Parse "mac_fields"
    mac_len_ =  ( length() - (t_dataptr_after_extensions - t_begin_of_data) ) ;
    int t_mac_fields__size;
    mac_fields_case_index_ =  ( mac_len() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( mac_fields_case_index() ) {
        case ((uint32)20):
            // Parse "mac"
            {
                mac_ = new NTP_MAC();
                int t_mac__size;
                t_mac__size = mac_->Parse(t_dataptr_after_extensions, t_end_of_data, byteorder());
                t_mac_fields__size = t_mac__size;
            }
            break;
        case ((uint32)24):
            // Parse "mac_ext"
            {
                mac_ext_ = new NTP_MAC_ext();
                int t_mac_ext__size;
                t_mac_ext__size = mac_ext_->Parse(t_dataptr_after_extensions, t_end_of_data, byteorder());
                t_mac_fields__size = t_mac_ext__size;
            }
            break;
        default:
            // Parse "nil2"
            {
                t_mac_fields__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_NTP_std_msg__size;
    const_byteptr const t_dataptr_after_mac_fields = t_dataptr_after_extensions + (t_mac_fields__size);
    BINPAC_ASSERT(t_dataptr_after_mac_fields <= t_end_of_data);
    t_NTP_std_msg__size = t_dataptr_after_mac_fields - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    sourcedata_.set_end(t_begin_of_data + t_NTP_std_msg__size);
    BINPAC_ASSERT(t_begin_of_data + (t_NTP_std_msg__size) <= t_end_of_data);
    return t_NTP_std_msg__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_control_msg::NTP_control_msg() {
    second_byte_ = 0;
    sequence_ = 0;
    status_ = 0;
    association_id_ = 0;
    offs_ = 0;
    c_ = 0;
    mac_fields_case_index_ = -1;
    mac_ = nullptr;
    byteorder_ = bigendian;
    R_ = false;
    E_ = false;
    M_ = false;
    OpCode_ = 0;
    length_ = 0;
    has_control_mac_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_control_msg::~NTP_control_msg() {
    data_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( mac_fields_case_index() ) {
        case true:
            // Clean up "mac"
            {
                delete mac_;
                mac_ = nullptr;
            }
            break;
        case false:
            // Clean up "nil"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int NTP_control_msg::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    sourcedata_ = const_bytestring(t_begin_of_data, t_end_of_data);
    // Checking out-of-bound for "NTP_control_msg:c"
    if ( (t_begin_of_data + 9) + (2) > t_end_of_data || (t_begin_of_data + 9) + (2) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_control_msg:c",
        	(9) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "second_byte"
    second_byte_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "sequence"
    sequence_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "status"
    status_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "association_id"
    association_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "offs"
    offs_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "c"
    c_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "data"
    int t_data__size;
    t_data__size = c();
    // Checking out-of-bound for "NTP_control_msg:data"
    if ( (t_begin_of_data + 11) + (t_data__size) > t_end_of_data || (t_begin_of_data + 11) + (t_data__size) < (t_begin_of_data + 11) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_control_msg:data",
        	(11) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 11) + t_data__size;
        int t_data_string_length;
        t_data_string_length = c();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:80", t_data_string_length);
        data_.init((t_begin_of_data + 11), t_data_string_length);
    }

    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 11) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    // Parse "mac_fields"
    length_ = sourcedata().length();
    has_control_mac_ =  ( length() - (t_dataptr_after_data - t_begin_of_data) )  == 12;
    int t_mac_fields__size;
    mac_fields_case_index_ =  ( has_control_mac() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( mac_fields_case_index() ) {
        case true:
            // Parse "mac"
            {
                mac_ = new NTP_CONTROL_MAC();
                int t_mac__size;
                t_mac__size = mac_->Parse(t_dataptr_after_data, t_end_of_data, byteorder());
                t_mac_fields__size = t_mac__size;
            }
            break;
        case false:
            // Parse "nil"
            {
                t_mac_fields__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("NTP_control_msg", (int64)mac_fields_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_NTP_control_msg__size;
    const_byteptr const t_dataptr_after_mac_fields = t_dataptr_after_data + (t_mac_fields__size);
    BINPAC_ASSERT(t_dataptr_after_mac_fields <= t_end_of_data);
    t_NTP_control_msg__size = t_dataptr_after_mac_fields - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    R_ =  ( second_byte() & 0x80 )  > 0;
    E_ =  ( second_byte() & 0x40 )  > 0;
    M_ =  ( second_byte() & 0x20 )  > 0;
    OpCode_ =  ( second_byte() & 0x1F ) ;
    sourcedata_.set_end(t_begin_of_data + t_NTP_control_msg__size);
    BINPAC_ASSERT(t_begin_of_data + (t_NTP_control_msg__size) <= t_end_of_data);
    return t_NTP_control_msg__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_MAC::NTP_MAC() {
    key_id_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_MAC::~NTP_MAC() {
    digest_.free();
}

int NTP_MAC::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTP_MAC"
    if ( t_begin_of_data + (20) > t_end_of_data || t_begin_of_data + (20) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_MAC",
        	(0) + (20), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 20;
        // Checking out-of-bound for "NTP_MAC:key_id"
        if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("NTP_MAC:key_id",
            	(0) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "key_id"
        key_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Parse "digest"
        // Checking out-of-bound for "NTP_MAC:digest"
        if ( (t_begin_of_data + 4) + (16) > t_end_of_data || (t_begin_of_data + 4) + (16) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("NTP_MAC:digest",
            	(4) + (16), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 4) + 16;
            int t_digest_string_length;
            t_digest_string_length = 16;
            int t_digest__size;
            t_digest__size = t_digest_string_length;
            digest_.init((t_begin_of_data + 4), t_digest_string_length);
        }

        int t_NTP_MAC__size;
        const_byteptr const t_dataptr_after_digest = (t_begin_of_data + 4) + (16);
        BINPAC_ASSERT(t_dataptr_after_digest <= t_end_of_data);
        t_NTP_MAC__size = t_dataptr_after_digest - t_begin_of_data;
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (20) <= t_end_of_data);
    return 20;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_MAC_ext::NTP_MAC_ext() {
    key_id_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_MAC_ext::~NTP_MAC_ext() {
    digest_.free();
}

int NTP_MAC_ext::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTP_MAC_ext"
    if ( t_begin_of_data + (24) > t_end_of_data || t_begin_of_data + (24) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_MAC_ext",
        	(0) + (24), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 24;
        // Checking out-of-bound for "NTP_MAC_ext:key_id"
        if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("NTP_MAC_ext:key_id",
            	(0) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "key_id"
        key_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Parse "digest"
        // Checking out-of-bound for "NTP_MAC_ext:digest"
        if ( (t_begin_of_data + 4) + (20) > t_end_of_data || (t_begin_of_data + 4) + (20) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("NTP_MAC_ext:digest",
            	(4) + (20), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 4) + 20;
            int t_digest_string_length;
            t_digest_string_length = 20;
            int t_digest__size;
            t_digest__size = t_digest_string_length;
            digest_.init((t_begin_of_data + 4), t_digest_string_length);
        }

        int t_NTP_MAC_ext__size;
        const_byteptr const t_dataptr_after_digest = (t_begin_of_data + 4) + (20);
        BINPAC_ASSERT(t_dataptr_after_digest <= t_end_of_data);
        t_NTP_MAC_ext__size = t_dataptr_after_digest - t_begin_of_data;
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (24) <= t_end_of_data);
    return 24;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_CONTROL_MAC::NTP_CONTROL_MAC() {
    key_id_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_CONTROL_MAC::~NTP_CONTROL_MAC() {
    crypto_checksum_.free();
}

int NTP_CONTROL_MAC::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTP_CONTROL_MAC"
    if ( t_begin_of_data + (12) > t_end_of_data || t_begin_of_data + (12) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_CONTROL_MAC",
        	(0) + (12), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 12;
        // Checking out-of-bound for "NTP_CONTROL_MAC:key_id"
        if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("NTP_CONTROL_MAC:key_id",
            	(0) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "key_id"
        key_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Parse "crypto_checksum"
        // Checking out-of-bound for "NTP_CONTROL_MAC:crypto_checksum"
        if ( (t_begin_of_data + 4) + (8) > t_end_of_data || (t_begin_of_data + 4) + (8) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("NTP_CONTROL_MAC:crypto_checksum",
            	(4) + (8), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 4) + 8;
            int t_crypto_checksum_string_length;
            t_crypto_checksum_string_length = 8;
            int t_crypto_checksum__size;
            t_crypto_checksum__size = t_crypto_checksum_string_length;
            crypto_checksum_.init((t_begin_of_data + 4), t_crypto_checksum_string_length);
        }

        int t_NTP_CONTROL_MAC__size;
        const_byteptr const t_dataptr_after_crypto_checksum = (t_begin_of_data + 4) + (8);
        BINPAC_ASSERT(t_dataptr_after_crypto_checksum <= t_end_of_data);
        t_NTP_CONTROL_MAC__size = t_dataptr_after_crypto_checksum - t_begin_of_data;
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (12) <= t_end_of_data);
    return 12;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Extension_Field::Extension_Field() {
    first_byte_ext_ = 0;
    field_type_ = 0;
    len_ = 0;
    association_id_ = 0;
    timestamp_ = 0;
    filestamp_ = 0;
    value_len_ = 0;
    sig_len_ = 0;
    R_ = false;
    E_ = false;
    Code_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Extension_Field::~Extension_Field() {
    value_.free();
    signature_.free();
}

int Extension_Field::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "Extension_Field:value_len"
    if ( (t_begin_of_data + 14) + (4) > t_end_of_data || (t_begin_of_data + 14) + (4) < (t_begin_of_data + 14) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Extension_Field:value_len",
        	(14) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "first_byte_ext"
    first_byte_ext_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "field_type"
    field_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "len"
    len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "association_id"
    association_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "timestamp"
    timestamp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 6))));

    // Parse "filestamp"
    filestamp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 10))));

    // Parse "value_len"
    value_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 14))));

    // Parse "value"
    int t_value__size;
    t_value__size = value_len();
    // Checking out-of-bound for "Extension_Field:value"
    if ( (t_begin_of_data + 18) + (t_value__size) > t_end_of_data || (t_begin_of_data + 18) + (t_value__size) < (t_begin_of_data + 18) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Extension_Field:value",
        	(18) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 18) + t_value__size;
        int t_value_string_length;
        t_value_string_length = value_len();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:122", t_value_string_length);
        value_.init((t_begin_of_data + 18), t_value_string_length);
    }

    const_byteptr const t_dataptr_after_value = (t_begin_of_data + 18) + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    // Checking out-of-bound for "Extension_Field:sig_len"
    if ( t_dataptr_after_value + (4) > t_end_of_data || t_dataptr_after_value + (4) < t_dataptr_after_value ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Extension_Field:sig_len",
        	((t_dataptr_after_value - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "sig_len"
    sig_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_value)));

    // Parse "signature"
    int t_signature__size;
    t_signature__size = sig_len();
    // Checking out-of-bound for "Extension_Field:signature"
    if ( (t_dataptr_after_value + 4) + (t_signature__size) > t_end_of_data || (t_dataptr_after_value + 4) + (t_signature__size) < (t_dataptr_after_value + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Extension_Field:signature",
        	(((t_dataptr_after_value + 4) - t_begin_of_data)) + (t_signature__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_value + 4) + t_signature__size;
        int t_signature_string_length;
        t_signature_string_length = sig_len();
        // check for negative sizes
        if ( t_signature_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:124", t_signature_string_length);
        signature_.init((t_dataptr_after_value + 4), t_signature_string_length);
    }


    int t_Extension_Field__size;
    const_byteptr const t_dataptr_after_signature = (t_dataptr_after_value + 4) + (t_signature__size);
    BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
    const_byteptr t_dataptr_after_pad = t_begin_of_data + ( ( len() - 0 ) );
    if ( t_dataptr_after_pad < t_dataptr_after_signature ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:125:pad", t_dataptr_after_signature - t_begin_of_data,  ( len() - 0 ) );
        t_dataptr_after_pad = t_dataptr_after_signature;
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("Extension_Field:pad",
        	( ( len() - 0 ) ), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    t_Extension_Field__size = t_dataptr_after_pad - t_begin_of_data;
    // Checking out-of-bound for "Extension_Field"
    if ( t_begin_of_data + (t_Extension_Field__size) > t_end_of_data || t_begin_of_data + (t_Extension_Field__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Extension_Field",
        	(0) + (t_Extension_Field__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    R_ =  ( first_byte_ext() & 0x80 )  > 0;
    E_ =  ( first_byte_ext() & 0x40 )  > 0;
    Code_ =  ( first_byte_ext() & 0x3F ) ;
    BINPAC_ASSERT(t_begin_of_data + (t_Extension_Field__size) <= t_end_of_data);
    return t_Extension_Field__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Short_Time::NTP_Short_Time() {
    seconds_ = 0;
    fractions_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Short_Time::~NTP_Short_Time() {
}

int NTP_Short_Time::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTP_Short_Time"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_Short_Time",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "seconds"
    seconds_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int16 const*>(t_begin_of_data)));

    // Parse "fractions"
    fractions_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Time::NTP_Time() {
    seconds_ = 0;
    fractions_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Time::~NTP_Time() {
}

int NTP_Time::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTP_Time"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTP_Time",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "seconds"
    seconds_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "fractions"
    fractions_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Flow::NTP_Flow(NTP_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;

		flipped_ = false;
	
    dataunit_ = nullptr;
    context_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTP_Flow::~NTP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void NTP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new NTP_PDU(is_orig());
        context_ = new ContextNTP(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void NTP_Flow::NewGap(int gap_length) {
}
void NTP_Flow::FlowEOF() {
}
bool NTP_Flow::proc_ntp_message(NTP_PDU* msg) {

		connection()->zeek_analyzer()->AnalyzerConfirmation();

		// Flip roles for SERVER mode message from orig or a CLIENT mode message from resp.
		if ( ((msg->mode() == SERVER && is_orig()) || (msg->mode() == CLIENT && ! is_orig())) && ! flipped_ )
			{
			connection()->zeek_analyzer()->Conn()->FlipRoles();
			flipped_ = true;
			}

		if ( ! ntp_message )
			return false;

		auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTP::Message);
		rv->Assign(0, msg->version());
		rv->Assign(1, msg->mode());

		// The standard record
		if ( msg->mode() >=1 && msg->mode() <= 5 )
			rv->Assign(2, BuildNTPStdMsg(msg->std()));
		else if ( msg->mode() == 6 )
			rv->Assign(3, BuildNTPControlMsg(msg->control()));
		else if ( msg->mode() == 7 )
			rv->Assign(4, BuildNTPMode7Msg(msg->mode7()));

		zeek::BifEvent::enqueue_ntp_message(connection()->zeek_analyzer(),
		                              connection()->zeek_analyzer()->Conn(),
		                              is_orig(), std::move(rv));
		return true;
		
}


	zeek::ValPtr proc_ntp_short(const NTP_Short_Time* t)
		{
		if ( t->seconds() == 0 && t->fractions() == 0 )
			return zeek::make_intrusive<zeek::IntervalVal>(0.0);
		return zeek::make_intrusive<zeek::IntervalVal>(t->seconds() + t->fractions()*FRAC_16);
		}

	zeek::ValPtr proc_ntp_timestamp(const NTP_Time* t)
		{
		if ( t->seconds() == 0 && t->fractions() == 0)
			return zeek::make_intrusive<zeek::TimeVal>(0.0);
		return zeek::make_intrusive<zeek::TimeVal>(EPOCH_OFFSET + t->seconds() + t->fractions()*FRAC_32);
		}

	// This builds the standard msg record
	zeek::RecordValPtr BuildNTPStdMsg(NTP_std_msg* nsm)
		{
		auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTP::StandardMessage);

		rv->Assign(0, nsm->stratum());
		rv->AssignInterval(1, pow(2, nsm->poll()));
		rv->AssignInterval(2, pow(2, nsm->precision()));
		rv->Assign(3, proc_ntp_short(nsm->root_delay()));
		rv->Assign(4, proc_ntp_short(nsm->root_dispersion()));

		switch ( nsm->stratum() ) {
		case 0:
			// unknown stratum => kiss code
			rv->Assign(5, to_stringval(nsm->reference_id()));
			break;
		case 1:
			// reference clock => ref clock string
			rv->Assign(6, to_stringval(nsm->reference_id()));
			break;
		default:
			{
			const uint8* d = nsm->reference_id().data();
			rv->Assign(7, zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr(IPv4, reinterpret_cast<const uint32*>(d), zeek::IPAddr::Network)));
			}
			break;
		}

		rv->Assign(8, proc_ntp_timestamp(nsm->reference_ts()));
		rv->Assign(9, proc_ntp_timestamp(nsm->origin_ts()));
		rv->Assign(10, proc_ntp_timestamp(nsm->receive_ts()));
		rv->Assign(11, proc_ntp_timestamp(nsm->transmit_ts()));

		if ( nsm->mac_len() == 20 )
			{
			rv->Assign(12, nsm->mac()->key_id());
			rv->Assign(13, to_stringval(nsm->mac()->digest()));
			}
		else if ( nsm->mac_len() == 24 )
			{
			rv->Assign(12, nsm->mac_ext()->key_id());
			rv->Assign(13, to_stringval(nsm->mac_ext()->digest()));
			}

		if ( nsm->has_exts() )
			{
			// TODO: add extension fields
			rv->Assign(14, static_cast<uint32>(nsm->exts()->size()));
			}

		return rv;
		}

	// This builds the control msg record
	zeek::RecordValPtr BuildNTPControlMsg(NTP_control_msg* ncm)
		{
		auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTP::ControlMessage);

		rv->Assign(0, ncm->OpCode());
		rv->Assign(1, ncm->R());
		rv->Assign(2, ncm->E());
		rv->Assign(3, ncm->M());
		rv->Assign(4, ncm->sequence());
		rv->Assign(5, ncm->status());
		rv->Assign(6, ncm->association_id());

		if ( ncm->c() > 0 )
			rv->Assign(7, to_stringval(ncm->data()));

		if ( ncm->has_control_mac() )
			{
			rv->Assign(8, ncm->mac()->key_id());
			rv->Assign(9, to_stringval(ncm->mac()->crypto_checksum()));
			}

		return rv;
		}

	// This builds the mode7 msg record
	zeek::RecordValPtr BuildNTPMode7Msg(NTP_mode7_msg* m7)
		{
		auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTP::Mode7Message);

		rv->Assign(0, m7->request_code());
		rv->Assign(1, m7->auth_bit());
		rv->Assign(2, m7->sequence());
		rv->Assign(3, m7->implementation());
		rv->Assign(4, m7->error_code());

		if ( m7->data_len() > 0 )
			rv->Assign(5, to_stringval(m7->data()));

		return rv;
		}

} // namespace NTP
}  // namespace binpac
