// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/sip/sip.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_sip_sip_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_sip_sip_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/protocol/sip/events.bif.h"


#include "zeek/ZeekString.h"

namespace binpac {

namespace SIP {
class ContextSIP;
class SIP_Conn;
extern RegExMatcher SIP_TOKEN_re_001;

class SIP_TOKEN;
extern RegExMatcher NOT_SIP_TOKEN_re_002;

class NOT_SIP_TOKEN;
extern RegExMatcher SIP_WS_re_003;

class SIP_WS;
extern RegExMatcher SIP_URI_re_004;

class SIP_URI;
class SIP_PDU;
class SIP_Request;
class SIP_Reply;
class SIP_RequestLine;
class SIP_ReplyLine;
extern RegExMatcher SIP_Status_re_009;

class SIP_Status;
extern RegExMatcher SIP_Version_re_011;

class SIP_Version;
class SIP_Headers;
class SIP_Message;
extern RegExMatcher SIP_HEADER_NAME_re_012;

class SIP_HEADER_NAME;
class SIP_Header;
class SIP_Body;
class SIP_Flow;
} // namespace SIP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace SIP {

class ContextSIP final {
public:
    ContextSIP(SIP_Conn* connection, SIP_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextSIP();

    // Member access functions
    SIP_Conn* connection() const { return connection_; }
    SIP_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    SIP_Conn* connection_;
    SIP_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class SIP_Conn final : public binpac::ConnectionAnalyzer {
public:
    SIP_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~SIP_Conn() override;

    // Member access functions
    SIP_Flow* upflow() const { return upflow_; }
    SIP_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

protected:
    SIP_Flow* upflow_;
    SIP_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class SIP_PDU final {
public:
    SIP_PDU(bool is_orig);
    ~SIP_PDU();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SIP_Request* request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:7:request", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_;
    }
    SIP_Reply* reply() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:8:reply", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return reply_;
    }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    int val_case_index_;
    SIP_Request* request_;
    SIP_Reply* reply_;
    bool is_orig_;
    bool proc_;
};


class SIP_Request final {
public:
    SIP_Request();
    ~SIP_Request();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context);

    // Member access functions
    SIP_RequestLine* request() const { return request_; }
    SIP_Message* msg() const { return msg_; }

protected:
    SIP_RequestLine* request_;
    int buffering_state_;
    SIP_Message* msg_;
    int parsing_state_;
};


class SIP_Reply final {
public:
    SIP_Reply();
    ~SIP_Reply();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context);

    // Member access functions
    SIP_ReplyLine* reply() const { return reply_; }
    SIP_Message* msg() const { return msg_; }

protected:
    SIP_ReplyLine* reply_;
    int buffering_state_;
    SIP_Message* msg_;
    int parsing_state_;
};


class SIP_RequestLine final {
public:
    SIP_RequestLine();
    ~SIP_RequestLine();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSIP* t_context);

    // Member access functions
    bytestring const& junk() const { return junk_; }
    bytestring const& method() const { return method_; }
    bytestring const& anonymous_field_005() const { return anonymous_field_005_; }
    bytestring const& uri() const { return uri_; }
    bytestring const& anonymous_field_006() const { return anonymous_field_006_; }
    SIP_Version* version() const { return version_; }
    bool proc() const { return proc_; }

protected:
    bytestring junk_;
    bytestring method_;
    bytestring anonymous_field_005_;
    bytestring uri_;
    bytestring anonymous_field_006_;
    SIP_Version* version_;
    bool proc_;
};


class SIP_ReplyLine final {
public:
    SIP_ReplyLine();
    ~SIP_ReplyLine();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSIP* t_context);

    // Member access functions
    SIP_Version* version() const { return version_; }
    bytestring const& anonymous_field_007() const { return anonymous_field_007_; }
    SIP_Status* status() const { return status_; }
    bytestring const& anonymous_field_008() const { return anonymous_field_008_; }
    bytestring const& reason() const { return reason_; }
    bool proc() const { return proc_; }

protected:
    SIP_Version* version_;
    bytestring anonymous_field_007_;
    SIP_Status* status_;
    bytestring anonymous_field_008_;
    bytestring reason_;
    bool proc_;
};


class SIP_Status final {
public:
    SIP_Status();
    ~SIP_Status();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& stat_str() const { return stat_str_; }
    int stat_num() const { return stat_num_; }

protected:
    bytestring stat_str_;
    int stat_num_;
};


class SIP_Version final {
public:
    SIP_Version();
    ~SIP_Version();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& anonymous_field_010() const { return anonymous_field_010_; }
    bytestring const& vers_str() const { return vers_str_; }
    double vers_num() const { return vers_num_; }

protected:
    bytestring anonymous_field_010_;
    bytestring vers_str_;
    double vers_num_;
};


class SIP_Headers final {
public:
    SIP_Headers();
    ~SIP_Headers();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context);

    // Member access functions
    vector<SIP_Header*>* val() const { return val_; }
    bool proc() const { return proc_; }
    int size() const	{ return val() ? val()->size() : 0; }
    SIP_Header* operator[](int index) const { BINPAC_ASSERT(val()); return (*val())[index]; }

protected:
    vector<SIP_Header*>* val_;
    SIP_Header* val__elem_;
    int buffering_state_;
    int val__arraylength_;
    int val__elem__it_;
    bool proc_;
};


class SIP_Message final {
public:
    SIP_Message();
    ~SIP_Message();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context);

    // Member access functions
    SIP_Headers* headers() const { return headers_; }
    SIP_Body* body() const { return body_; }

protected:
    SIP_Headers* headers_;
    SIP_Body* body_;
    int parsing_state_;
};


class SIP_Header final {
public:
    SIP_Header();
    ~SIP_Header();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context);

    // Member access functions
    bytestring const& name() const { return name_; }
    bytestring const& anonymous_field_013() const { return anonymous_field_013_; }
    bytestring const& anonymous_field_014() const { return anonymous_field_014_; }
    bytestring const& anonymous_field_015() const { return anonymous_field_015_; }
    bytestring const& value() const { return value_; }
    bool proc() const { return proc_; }

protected:
    bytestring name_;
    bytestring anonymous_field_013_;
    bytestring anonymous_field_014_;
    bytestring anonymous_field_015_;
    bytestring value_;
    bool proc_;
    int buffering_state_;
};


class SIP_Body final {
public:
    SIP_Body();
    ~SIP_Body();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context);

    // Member access functions
    bytestring const& body() const { return body_; }

protected:
    bytestring body_;
    int buffering_state_;
    int parsing_state_;
};


class SIP_Flow final : public binpac::FlowAnalyzer {
public:
    SIP_Flow(SIP_Conn* connection, bool is_orig);
    ~SIP_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    SIP_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    int get_content_length();
    bool proc_sip_request(bytestring const& junk, bytestring const& method, bytestring const& uri, SIP_Version* vers);
    bool proc_sip_reply(SIP_Version* vers, int code, bytestring const& reason);
    bool proc_sip_header(bytestring const& name, bytestring const& value);
    ZeekVal build_sip_headers_val();
    void gen_sip_all_headers();
    bool proc_sip_end_of_headers(SIP_Headers* headers);
    ZeekVal build_sip_header_val(const_bytestring const& name, const_bytestring const& value);
    void proc_sip_message_begin();
    bool proc_sip_message_done(SIP_PDU* pdu);

protected:
    SIP_PDU* dataunit_;
    ContextSIP* context_;

    // Additional members

		int content_length;
		bool build_headers;
		std::vector<zeek::ValPtr> headers;
	
    FlowBuffer* flow_buffer_;
    SIP_Conn* connection_;
    bool is_orig_;
};

} // namespace SIP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_sip_sip_pac_h */
