// This file was automatically generated by bifcl from /build/zeek/src/zeek/src/analyzer/protocol/ssl/events.bif (plugin mode).


#include "events.bif.h"
#include "zeek/Func.h"

zeek::EventHandlerPtr ssl_client_hello; 
void zeek::BifEvent::enqueue_ssl_client_hello(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek_uint_t version, zeek_uint_t record_version, double possible_ts, zeek::IntrusivePtr<zeek::StringVal> client_random, zeek::IntrusivePtr<zeek::StringVal> session_id, zeek::IntrusivePtr<zeek::Val> ciphers, zeek::IntrusivePtr<zeek::Val> comp_methods)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_client_hello is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_client_hello is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_client_hello, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Count(version),
	        zeek::val_mgr->Count(record_version),
	        zeek::make_intrusive<zeek::TimeVal>(possible_ts),
	        std::move(client_random),
	        std::move(session_id),
	        std::move(ciphers),
	        std::move(comp_methods),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_server_hello; 
void zeek::BifEvent::enqueue_ssl_server_hello(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek_uint_t version, zeek_uint_t record_version, double possible_ts, zeek::IntrusivePtr<zeek::StringVal> server_random, zeek::IntrusivePtr<zeek::StringVal> session_id, zeek_uint_t cipher, zeek_uint_t comp_method)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_server_hello is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_server_hello is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_server_hello, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Count(version),
	        zeek::val_mgr->Count(record_version),
	        zeek::make_intrusive<zeek::TimeVal>(possible_ts),
	        std::move(server_random),
	        std::move(session_id),
	        zeek::val_mgr->Count(cipher),
	        zeek::val_mgr->Count(comp_method),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension; 
void zeek::BifEvent::enqueue_ssl_extension(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t code, zeek::IntrusivePtr<zeek::StringVal> val)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(code),
	        std::move(val),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_elliptic_curves; 
void zeek::BifEvent::enqueue_ssl_extension_elliptic_curves(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> curves)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_elliptic_curves is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_elliptic_curves is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_elliptic_curves, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(curves),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_ec_point_formats; 
void zeek::BifEvent::enqueue_ssl_extension_ec_point_formats(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> point_formats)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_ec_point_formats is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_ec_point_formats is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_ec_point_formats, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(point_formats),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_signature_algorithm; 
void zeek::BifEvent::enqueue_ssl_extension_signature_algorithm(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> signature_algorithms)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_signature_algorithm is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_signature_algorithm is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_signature_algorithm, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(signature_algorithms),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_key_share; 
void zeek::BifEvent::enqueue_ssl_extension_key_share(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> curves)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_key_share is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_key_share is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_key_share, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(curves),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_pre_shared_key_client_hello; 
void zeek::BifEvent::enqueue_ssl_extension_pre_shared_key_client_hello(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> identities, zeek::IntrusivePtr<zeek::Val> binders)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_pre_shared_key_client_hello is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_pre_shared_key_client_hello is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_pre_shared_key_client_hello, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(identities),
	        std::move(binders),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_pre_shared_key_server_hello; 
void zeek::BifEvent::enqueue_ssl_extension_pre_shared_key_server_hello(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t selected_identity)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_pre_shared_key_server_hello is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_pre_shared_key_server_hello is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_pre_shared_key_server_hello, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(selected_identity),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_ecdh_server_params; 
void zeek::BifEvent::enqueue_ssl_ecdh_server_params(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek_uint_t curve, zeek::IntrusivePtr<zeek::StringVal> point)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_ecdh_server_params is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_ecdh_server_params is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_ecdh_server_params, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Count(curve),
	        std::move(point),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_dh_server_params; 
void zeek::BifEvent::enqueue_ssl_dh_server_params(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek::IntrusivePtr<zeek::StringVal> p, zeek::IntrusivePtr<zeek::StringVal> q, zeek::IntrusivePtr<zeek::StringVal> Ys)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_dh_server_params is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_dh_server_params is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_dh_server_params, zeek::Args{
	        c->GetVal(),
	        std::move(p),
	        std::move(q),
	        std::move(Ys),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_server_signature; 
void zeek::BifEvent::enqueue_ssl_server_signature(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek::IntrusivePtr<zeek::Val> signature_and_hashalgorithm, zeek::IntrusivePtr<zeek::StringVal> signature)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_server_signature is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_server_signature is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_server_signature, zeek::Args{
	        c->GetVal(),
	        std::move(signature_and_hashalgorithm),
	        std::move(signature),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_ecdh_client_params; 
void zeek::BifEvent::enqueue_ssl_ecdh_client_params(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek::IntrusivePtr<zeek::StringVal> point)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_ecdh_client_params is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_ecdh_client_params is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_ecdh_client_params, zeek::Args{
	        c->GetVal(),
	        std::move(point),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_dh_client_params; 
void zeek::BifEvent::enqueue_ssl_dh_client_params(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek::IntrusivePtr<zeek::StringVal> Yc)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_dh_client_params is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_dh_client_params is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_dh_client_params, zeek::Args{
	        c->GetVal(),
	        std::move(Yc),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_rsa_client_pms; 
void zeek::BifEvent::enqueue_ssl_rsa_client_pms(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek::IntrusivePtr<zeek::StringVal> pms)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_rsa_client_pms is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_rsa_client_pms is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_rsa_client_pms, zeek::Args{
	        c->GetVal(),
	        std::move(pms),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_application_layer_protocol_negotiation; 
void zeek::BifEvent::enqueue_ssl_extension_application_layer_protocol_negotiation(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> protocols)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_application_layer_protocol_negotiation is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_application_layer_protocol_negotiation is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_application_layer_protocol_negotiation, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(protocols),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_server_name; 
void zeek::BifEvent::enqueue_ssl_extension_server_name(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> names)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_server_name is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_server_name is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_server_name, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(names),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_signed_certificate_timestamp; 
void zeek::BifEvent::enqueue_ssl_extension_signed_certificate_timestamp(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t version, zeek::IntrusivePtr<zeek::StringVal> logid, zeek_uint_t timestamp, zeek::IntrusivePtr<zeek::Val> signature_and_hashalgorithm, zeek::IntrusivePtr<zeek::StringVal> signature)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_signed_certificate_timestamp is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_signed_certificate_timestamp is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_signed_certificate_timestamp, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(version),
	        std::move(logid),
	        zeek::val_mgr->Count(timestamp),
	        std::move(signature_and_hashalgorithm),
	        std::move(signature),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_supported_versions; 
void zeek::BifEvent::enqueue_ssl_extension_supported_versions(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> versions)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_supported_versions is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_supported_versions is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_supported_versions, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(versions),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_psk_key_exchange_modes; 
void zeek::BifEvent::enqueue_ssl_extension_psk_key_exchange_modes(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> modes)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_psk_key_exchange_modes is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_psk_key_exchange_modes is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_psk_key_exchange_modes, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(modes),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_extension_connection_id; 
void zeek::BifEvent::enqueue_ssl_extension_connection_id(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::StringVal> cid)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_extension_connection_id is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_extension_connection_id is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_extension_connection_id, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(cid),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_established; 
void zeek::BifEvent::enqueue_ssl_established(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_established is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_established is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_established, zeek::Args{
	        c->GetVal(),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_alert; 
void zeek::BifEvent::enqueue_ssl_alert(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t level, zeek_uint_t desc)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_alert is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_alert is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_alert, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(level),
	        zeek::val_mgr->Count(desc),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_session_ticket_handshake; 
void zeek::BifEvent::enqueue_ssl_session_ticket_handshake(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, zeek_uint_t ticket_lifetime_hint, zeek::IntrusivePtr<zeek::StringVal> ticket)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_session_ticket_handshake is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_session_ticket_handshake is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_session_ticket_handshake, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Count(ticket_lifetime_hint),
	        std::move(ticket),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_heartbeat; 
void zeek::BifEvent::enqueue_ssl_heartbeat(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t length, zeek_uint_t heartbeat_type, zeek_uint_t payload_length, zeek::IntrusivePtr<zeek::StringVal> payload)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_heartbeat is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_heartbeat is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_heartbeat, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(length),
	        zeek::val_mgr->Count(heartbeat_type),
	        zeek::val_mgr->Count(payload_length),
	        std::move(payload),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_plaintext_data; 
void zeek::BifEvent::enqueue_ssl_plaintext_data(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t record_version, zeek_uint_t content_type, zeek_uint_t length)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_plaintext_data is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_plaintext_data is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_plaintext_data, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(record_version),
	        zeek::val_mgr->Count(content_type),
	        zeek::val_mgr->Count(length),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_encrypted_data; 
void zeek::BifEvent::enqueue_ssl_encrypted_data(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t record_version, zeek_uint_t content_type, zeek_uint_t length)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_encrypted_data is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_encrypted_data is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_encrypted_data, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(record_version),
	        zeek::val_mgr->Count(content_type),
	        zeek::val_mgr->Count(length),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_probable_encrypted_handshake_message; 
void zeek::BifEvent::enqueue_ssl_probable_encrypted_handshake_message(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t length)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_probable_encrypted_handshake_message is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_probable_encrypted_handshake_message is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_probable_encrypted_handshake_message, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(length),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_stapled_ocsp; 
void zeek::BifEvent::enqueue_ssl_stapled_ocsp(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::StringVal> response)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_stapled_ocsp is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_stapled_ocsp is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_stapled_ocsp, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(response),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_handshake_message; 
void zeek::BifEvent::enqueue_ssl_handshake_message(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek_uint_t msg_type, zeek_uint_t length)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_handshake_message is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_handshake_message is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_handshake_message, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        zeek::val_mgr->Count(msg_type),
	        zeek::val_mgr->Count(length),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_change_cipher_spec; 
void zeek::BifEvent::enqueue_ssl_change_cipher_spec(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_change_cipher_spec is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_change_cipher_spec is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_change_cipher_spec, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_connection_flipped; 
void zeek::BifEvent::enqueue_ssl_connection_flipped(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_connection_flipped is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_connection_flipped is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_connection_flipped, zeek::Args{
	        c->GetVal(),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

zeek::EventHandlerPtr ssl_certificate_request; 
void zeek::BifEvent::enqueue_ssl_certificate_request(zeek::analyzer::Analyzer* analyzer, zeek::Connection* c, int is_client, zeek::IntrusivePtr<zeek::Val> certificate_types, zeek::IntrusivePtr<zeek::Val> supported_signature_algorithms, zeek::IntrusivePtr<zeek::Val> certificate_authorities)
	{
	// Note that it is intentional that here we do not
	// check if ::ssl_certificate_request is NULL, which should happen *before*
	// zeek::BifEvent::enqueue_ssl_certificate_request is called to avoid unnecessary Val
	// allocation.

	zeek::event_mgr.Enqueue(::ssl_certificate_request, zeek::Args{
	        c->GetVal(),
	        zeek::val_mgr->Bool(is_client),
	        std::move(certificate_types),
	        std::move(supported_signature_algorithms),
	        std::move(certificate_authorities),
	        },
	    zeek::util::detail::SOURCE_LOCAL, analyzer ? analyzer->GetID() : 0, c);
	}

