// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/websocket/websocket_pac.h"

namespace binpac {






namespace WebSocket {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextWebSocket::ContextWebSocket(WebSocket_Conn* connection, WebSocket_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextWebSocket::~ContextWebSocket() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Conn::WebSocket_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new WebSocket_Flow(this, true);
    downflow_ = new WebSocket_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Conn::~WebSocket_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void WebSocket_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void WebSocket_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void WebSocket_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_FrameHeader::WebSocket_FrameHeader(bool first_frame) {
    first2_ = 0;
    maybe_more_len_case_index_ = -1;
    payload_len2_ = 0;
    payload_len8_ = 0;
    maybe_masking_key_case_index_ = -1;
    first_frame_ = first_frame;
    fin_ = false;
    reserved_ = 0;
    opcode_ = 0;
    payload_len1_ = 0;
    has_mask_ = false;
    rest_header_len_ = 0;
    payload_len_ = 0;
    new_frame_payload_ = 0;
    proc_header_ = 0;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_FrameHeader::~WebSocket_FrameHeader() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( maybe_more_len_case_index() ) {
        case ((uint8)126):
            // Clean up "payload_len2"
            {
            }
            break;
        case ((uint8)127):
            // Clean up "payload_len8"
            {
            }
            break;
        default:
            // Clean up "short_len"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( maybe_masking_key_case_index() ) {
        case true:
            // Clean up "masking_key"
            {
                masking_key_.free();
            }
            break;
        case false:
            // Clean up "no_masking_key"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool WebSocket_FrameHeader::ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(2, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "first2"
            // Checking out-of-bound for "WebSocket_FrameHeader:first2"
            if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("WebSocket_FrameHeader:first2",
                	(0) + (2), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            first2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
            opcode_ =  ( first2() & 0x0f00 )  >> 8;
            // Evaluate '&enforce' attribute
            if (! (  ( first_frame() && opcode() != 0 )  ||  ( ! first_frame() && opcode() == 0 )  ) ) {
                throw binpac::ExceptionEnforceViolation("WebSocket_FrameHeader:first2");
            }
            has_mask_ =  ( first2() & 0x0080 )  ? true : false;
            payload_len1_ =  ( first2() & 0x007f ) ;
            rest_header_len_ =  ( has_mask() ? 4 : 0 )  +  ( payload_len1() < 126 ? 0 :  ( payload_len1() == 126 ? 2 : 8 )  ) ;
            t_flow_buffer->GrowFrame(2 + rest_header_len());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "maybe_more_len"
                int t_maybe_more_len__size;
                maybe_more_len_case_index_ = payload_len1();
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( maybe_more_len_case_index() ) {
                    case ((uint8)126):
                        // Parse "payload_len2"
                        {
                            // Checking out-of-bound for "WebSocket_FrameHeader:payload_len2"
                            if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
                                // Handle out-of-bound condition
                                throw binpac::ExceptionOutOfBound("WebSocket_FrameHeader:payload_len2",
                                	(2) + (2), 
                                	(t_end_of_data) - (t_begin_of_data));
                            }
                            payload_len2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));
                            t_maybe_more_len__size = 2;
                        }
                        break;
                    case ((uint8)127):
                        // Parse "payload_len8"
                        {
                            // Checking out-of-bound for "WebSocket_FrameHeader:payload_len8"
                            if ( (t_begin_of_data + 2) + (8) > t_end_of_data || (t_begin_of_data + 2) + (8) < (t_begin_of_data + 2) ) {
                                // Handle out-of-bound condition
                                throw binpac::ExceptionOutOfBound("WebSocket_FrameHeader:payload_len8",
                                	(2) + (8), 
                                	(t_end_of_data) - (t_begin_of_data));
                            }
                            payload_len8_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 2))));
                            t_maybe_more_len__size = 8;
                        }
                        break;
                    default:
                        // Parse "short_len"
                        {
                            t_maybe_more_len__size = 0;
                        }
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                const_byteptr const t_dataptr_after_maybe_more_len = (t_begin_of_data + 2) + (t_maybe_more_len__size);
                BINPAC_ASSERT(t_dataptr_after_maybe_more_len <= t_end_of_data);
                // Parse "maybe_masking_key"
                int t_maybe_masking_key__size;
                maybe_masking_key_case_index_ = has_mask();
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( maybe_masking_key_case_index() ) {
                    case true:
                        // Parse "masking_key"
                        {
                            // Checking out-of-bound for "WebSocket_FrameHeader:masking_key"
                            if ( t_dataptr_after_maybe_more_len + (4) > t_end_of_data || t_dataptr_after_maybe_more_len + (4) < t_dataptr_after_maybe_more_len ) {
                                // Handle out-of-bound condition
                                throw binpac::ExceptionOutOfBound("WebSocket_FrameHeader:masking_key",
                                	((t_dataptr_after_maybe_more_len - t_begin_of_data)) + (4), 
                                	(t_end_of_data) - (t_begin_of_data));
                            }
                            {
                                // Setting t_end_of_data with &length
                                const_byteptr t_end_of_data = t_dataptr_after_maybe_more_len + 4;
                                int t_masking_key_string_length;
                                t_masking_key_string_length = 4;
                                int t_masking_key__size;
                                t_masking_key__size = t_masking_key_string_length;
                                masking_key_.init(t_dataptr_after_maybe_more_len, t_masking_key_string_length);
                            }
                            t_maybe_masking_key__size = 4;
                        }
                        break;
                    case false:
                        // Parse "no_masking_key"
                        {
                            t_maybe_masking_key__size = 0;
                        }
                        break;
                    default:
                        throw binpac::ExceptionInvalidCaseIndex("WebSocket_FrameHeader", (int64)maybe_masking_key_case_index());
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    fin_ =  ( first2() & 0x8000 )  ? true : false;
                    reserved_ =  (  ( first2() & 0x7000 )  >> 12 ) ;
                    payload_len_ = payload_len1() < 126 ? payload_len1() :  ( payload_len1() == 126 ? payload_len2() : payload_len8() ) ;
                    new_frame_payload_ = t_context->flow()->new_frame_payload(this);
                    proc_header_ = t_context->flow()->process_header(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_FramePayloadClose::WebSocket_FramePayloadClose() {
    status_ = 0;
    byteorder_ = bigendian;
    proc_payload_close_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_FramePayloadClose::~WebSocket_FramePayloadClose() {
    reason_.free();
}

int WebSocket_FramePayloadClose::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextWebSocket* t_context) {
    // Checking out-of-bound for "WebSocket_FramePayloadClose:status"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("WebSocket_FramePayloadClose:status",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "status"
    status_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reason"
    int t_reason_string_length;
    t_reason_string_length = (t_end_of_data) - ((t_begin_of_data + 2));
    int t_reason__size;
    t_reason__size = t_reason_string_length;
    // check for negative sizes
    if ( t_reason_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket-protocol.pac:44", t_reason_string_length);
    reason_.init((t_begin_of_data + 2), t_reason_string_length);

    int t_WebSocket_FramePayloadClose__size;
    const_byteptr const t_dataptr_after_reason = (t_begin_of_data + 2) + (t_reason__size);
    BINPAC_ASSERT(t_dataptr_after_reason <= t_end_of_data);
    t_WebSocket_FramePayloadClose__size = t_dataptr_after_reason - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_payload_close_ = t_context->flow()->process_payload_close(this);
    BINPAC_ASSERT(t_begin_of_data + (t_WebSocket_FramePayloadClose__size) <= t_end_of_data);
    return t_WebSocket_FramePayloadClose__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_FramePayloadChunk::WebSocket_FramePayloadChunk(uint64 len, WebSocket_FrameHeader* hdr) {
    len_ = len;
    hdr_ = hdr;
    consumed_payload_ = 0;
    payload_chunk_ = 0;
    close_payload_ = nullptr;
    has_close_payload_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_FramePayloadChunk::~WebSocket_FramePayloadChunk() {
    data_.free();
    delete close_payload_;
    close_payload_ = nullptr;
}

bool WebSocket_FramePayloadChunk::ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(len());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "data"
                int t_data_string_length;
                t_data_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_data__size;
                t_data__size = t_data_string_length;
                // check for negative sizes
                if ( t_data_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket-protocol.pac:48", t_data_string_length);
                data_.init(t_begin_of_data, t_data_string_length);

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    consumed_payload_ = t_context->flow()->consumed_chunk_len(len());
                    payload_chunk_ = t_context->flow()->process_payload_chunk(this);
                    // Parse "close_payload"
                    has_close_payload_ =  ( hdr()->opcode() == OPCODE_CLOSE ) ;
                    if ( has_close_payload() ) {
                        close_payload_ = new WebSocket_FramePayloadClose();
                        const_byteptr t_begin_of_data;
                        const_byteptr t_end_of_data;
                        get_pointers(data(), &t_begin_of_data, &t_end_of_data);
                        int t_close_payload__size;
                        t_close_payload__size = len();
                        // Checking out-of-bound for "WebSocket_FramePayloadChunk:close_payload"
                        if ( t_begin_of_data + (t_close_payload__size) > t_end_of_data || t_begin_of_data + (t_close_payload__size) < t_begin_of_data ) {
                            // Handle out-of-bound condition
                            throw binpac::ExceptionOutOfBound("WebSocket_FramePayloadChunk:close_payload",
                            	(0) + (t_close_payload__size), 
                            	(t_end_of_data) - (t_begin_of_data));
                        }
                        {
                            // Setting t_end_of_data with &length
                            const_byteptr t_end_of_data = t_begin_of_data + t_close_payload__size;
                            close_payload_->Parse(t_begin_of_data, t_end_of_data, t_context);
                            // Evaluate 'let' and 'withinput' fields
                        }
                    }
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Frame::WebSocket_Frame(bool first_frame, WebSocket_Message* msg) {
    hdr_ = nullptr;
    chunks_ = nullptr;
    chunks__elem_ = nullptr;
    chunks__arraylength_ = 0;
    chunks__elem__it_ = 0;
    chunks__elem__it_ = -1;
    first_frame_ = first_frame;
    msg_ = msg;
    empty_close_ = 0;
    has_empty_close_ = false;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Frame::~WebSocket_Frame() {
    delete hdr_;
    hdr_ = nullptr;
    delete chunks__elem_;
    chunks__elem_ = nullptr;
    if ( chunks_ ) {
        for ( auto* chunks__elem_ : *chunks_ ) {
            delete chunks__elem_;
            chunks__elem_ = nullptr;
        }
    }
    delete chunks_;
}

bool WebSocket_Frame::ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "hdr"
        if ( ! hdr_ ) {
            hdr_ = new WebSocket_FrameHeader(first_frame());
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_hdr_parsing_complete;
        t_hdr_parsing_complete = false;
        while ( ! t_hdr_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            t_hdr_parsing_complete = hdr_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
            if ( t_hdr_parsing_complete ) {
            }
        }
        if ( ! (t_hdr_parsing_complete) )
            goto need_more_data;
        }

        // Parse "chunks"
        if ( ! chunks_ ) {
        }
        parsing_state_ = 2;
        /* fall through */
    case 2:
    {
        bool t_chunks_parsing_complete;
        t_chunks_parsing_complete = false;
        if ( chunks__elem__it_ < 0 ) {
            // Initialize only once
            chunks__elem__it_ = 0;
            chunks_ = new vector<WebSocket_FramePayloadChunk*>;
        }
        for (; /* forever */; ++chunks__elem__it_) {
            // Check &until( ( @@$context->flow@->remaining_frame_payload_len@() == ((int) 0) ) )
            if (  ( t_context->flow()->remaining_frame_payload_len() == 0 )  ) {
                t_chunks_parsing_complete = true;
                delete chunks__elem_;
                chunks__elem_ = nullptr;
                goto end_of_chunks;
            }
            if ( ! chunks__elem_ ) {
                chunks__elem_ = new WebSocket_FramePayloadChunk(t_context->flow()->next_chunk_len(), hdr());
            }
            bool t_chunks__elem_parsing_complete;
            t_chunks__elem_parsing_complete = false;
            while ( ! t_chunks__elem_parsing_complete && t_flow_buffer->ready() ) {
                const_byteptr t_begin_of_data = t_flow_buffer->begin();
                const_byteptr t_end_of_data = t_flow_buffer->end();
                t_chunks__elem_parsing_complete = chunks__elem_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_chunks__elem_parsing_complete ) {
                }
            }
            if ( ! t_chunks__elem_parsing_complete )
                goto need_more_data;
            delete chunks__elem_;
            chunks__elem_ = nullptr;
        }
    end_of_chunks: ;
        if ( t_chunks_parsing_complete ) {
            // Evaluate 'let' and 'withinput' fields
        }
        if ( ! (t_chunks_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        has_empty_close_ =  ( hdr()->opcode() == OPCODE_CLOSE )  && hdr()->payload_len() == 0;
        if ( has_empty_close() ) {
            empty_close_ = t_context->flow()->process_empty_close(hdr());
        }
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Message::WebSocket_Message() {
    first_frame_ = nullptr;
    optional_more_frames_case_index_ = -1;
    more_frames_ = nullptr;
    more_frames__elem_ = nullptr;
    more_frames__arraylength_ = 0;
    more_frames__elem__it_ = 0;
    more_frames__elem__it_ = -1;
    byteorder_ = bigendian;
    opcode_ = 0;
    proc_message_ = 0;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Message::~WebSocket_Message() {
    delete first_frame_;
    first_frame_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( optional_more_frames_case_index() ) {
        case true:
            // Clean up "no_more_frames"
            {
            }
            break;
        case false:
            // Clean up "more_frames"
            {
                delete more_frames__elem_;
                more_frames__elem_ = nullptr;
                if ( more_frames() ) {
                    for ( auto* more_frames__elem_ : *more_frames() ) {
                        delete more_frames__elem_;
                        more_frames__elem_ = nullptr;
                    }
                }
                delete more_frames_;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool WebSocket_Message::ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "first_frame"
        if ( ! first_frame_ ) {
            first_frame_ = new WebSocket_Frame(true, this);
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_first_frame_parsing_complete;
        t_first_frame_parsing_complete = false;
        t_first_frame_parsing_complete = first_frame_->ParseBuffer(t_flow_buffer, t_context, byteorder());
        if ( t_first_frame_parsing_complete ) {
        }
        if ( ! (t_first_frame_parsing_complete) )
            goto need_more_data;
        }

        // Parse "optional_more_frames"
        parsing_state_ = 2;
        /* fall through */
    case 2:
    {
        bool t_optional_more_frames_parsing_complete;
        t_optional_more_frames_parsing_complete = false;
        optional_more_frames_case_index_ = first_frame()->hdr()->fin();
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( optional_more_frames_case_index() ) {
            case true:
                // Parse "no_more_frames"
                {
                    bool t_no_more_frames_parsing_complete;
                    t_no_more_frames_parsing_complete = false;
                    t_no_more_frames_parsing_complete = true;
                    t_optional_more_frames_parsing_complete = t_no_more_frames_parsing_complete;
                }
                break;
            case false:
                // Parse "more_frames"
                {
                    if ( ! more_frames_ ) {
                    }
                    bool t_more_frames_parsing_complete;
                    t_more_frames_parsing_complete = false;
                    if ( more_frames__elem__it_ < 0 ) {
                        // Initialize only once
                        more_frames__elem__it_ = 0;
                        more_frames_ = new vector<WebSocket_Frame*>;
                    }
                    for (; /* forever */; ++more_frames__elem__it_) {
                        if ( ! more_frames__elem_ ) {
                            more_frames__elem_ = new WebSocket_Frame(false, this);
                        }
                        bool t_more_frames__elem_parsing_complete;
                        t_more_frames__elem_parsing_complete = false;
                        t_more_frames__elem_parsing_complete = more_frames__elem_->ParseBuffer(t_flow_buffer, t_context, byteorder());
                        if ( t_more_frames__elem_parsing_complete ) {
                        }
                        if ( ! t_more_frames__elem_parsing_complete )
                            goto need_more_data;
                        more_frames_->push_back(more_frames__elem_);
                        // Check &until( ( @@$element->hdr@->fin@ ) )
                        if (  ( more_frames__elem_->hdr()->fin() )  ) {
                            t_more_frames_parsing_complete = true;
                            more_frames__elem_ = nullptr;
                            goto end_of_more_frames;
                        }
                        more_frames__elem_ = nullptr;
                    }
                end_of_more_frames: ;
                    if ( t_more_frames_parsing_complete ) {
                        // Evaluate 'let' and 'withinput' fields
                    }
                    t_optional_more_frames_parsing_complete = t_more_frames_parsing_complete;
                }
                break;
            default:
                throw binpac::ExceptionInvalidCaseIndex("WebSocket_Message", (int64)optional_more_frames_case_index());
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        if ( t_optional_more_frames_parsing_complete ) {
            // Evaluate 'let' and 'withinput' fields
        }
        if ( ! (t_optional_more_frames_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        opcode_ = first_frame()->hdr()->opcode();
        proc_message_ = t_context->flow()->process_message(this);
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Flow::WebSocket_Flow(WebSocket_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;

		has_mask_ = false;
		masking_key_idx_ = 0;
		frame_payload_len_ = 0;
		effective_opcode_ = OPCODE_CONTINUATION;
	
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

// NOLINTNEXTLINE(modernize-use-equals-default)
WebSocket_Flow::~WebSocket_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void WebSocket_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new WebSocket_Message();
                context_ = new ContextWebSocket(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void WebSocket_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void WebSocket_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
uint64 WebSocket_Flow::new_frame_payload(WebSocket_FrameHeader* hdr) {

		if ( frame_payload_len_ > 0 )
			connection()->zeek_analyzer()->Weird("websocket_frame_not_consumed");

		// Update the effective_opcode for all frames
		// following this one in the message.
		if ( hdr->first_frame() )
			effective_opcode_ = hdr->opcode();

		frame_payload_len_ = hdr->payload_len();
		has_mask_ = hdr->has_mask();
		masking_key_idx_ = 0;
		if ( has_mask_ ) {
			assert(hdr->masking_key().length() == static_cast<int>(masking_key_.size()));
			memcpy(masking_key_.data(), hdr->masking_key().data(), masking_key_.size());
		}
		return frame_payload_len_;
		
}

uint64 WebSocket_Flow::remaining_frame_payload_len() {

		return frame_payload_len_;
		
}

uint64 WebSocket_Flow::consumed_chunk_len(uint64 len) {

		if ( len > frame_payload_len_ ) {
			connection()->zeek_analyzer()->Weird("websocket_frame_consuming_too_much");
			len = frame_payload_len_;
		}

		frame_payload_len_ -= len;
		return len;
		
}

uint64 WebSocket_Flow::next_chunk_len() {

		uint64_t len = frame_payload_len_;

		// It would be somewhat nicer if we could just consume
		// anything still left to consume from the current packet,
		// but couldn't figure out if that information can be pulled
		// flow buffer.
		if ( len > zeek::BifConst::WebSocket::payload_chunk_size )
			len = zeek::BifConst::WebSocket::payload_chunk_size;

		return len;
		
}

bool WebSocket_Flow::process_message(WebSocket_Message* msg) {

		connection()->zeek_analyzer()->AnalyzerConfirmation();

		if ( websocket_message )
			{
			zeek::BifEvent::enqueue_websocket_message(connection()->zeek_analyzer(),
			                                          connection()->zeek_analyzer()->Conn(),
			                                          is_orig(),
			                                          msg->opcode());
			}

		return true;
		
}

bool WebSocket_Flow::process_header(WebSocket_FrameHeader* hdr) {

		if ( websocket_frame )
			{
			zeek::BifEvent::enqueue_websocket_frame(connection()->zeek_analyzer(),
			                                        connection()->zeek_analyzer()->Conn(),
			                                        is_orig(),
			                                        hdr->fin(),
			                                        hdr->reserved(),
			                                        hdr->opcode(),
			                                        hdr->payload_len());
			}

		return true;
		
}

bool WebSocket_Flow::process_payload_close(WebSocket_FramePayloadClose* close) {

		if ( websocket_close )
			{
			const auto& reason = close->reason();
			auto reason_val = zeek::make_intrusive<zeek::StringVal>(reason.length(),
			                                                        reinterpret_cast<const char*>(reason.data()));
			zeek::BifEvent::enqueue_websocket_close(connection()->zeek_analyzer(),
			                                        connection()->zeek_analyzer()->Conn(),
			                                        is_orig(),
			                                        close->status(),
			                                        reason_val);
			}

		return true;
		
}

bool WebSocket_Flow::process_empty_close(WebSocket_FrameHeader* hdr) {

		if ( websocket_close )
			{
			zeek::BifEvent::enqueue_websocket_close(connection()->zeek_analyzer(),
			                                        connection()->zeek_analyzer()->Conn(),
			                                        is_orig(),
			                                        0, /* use placeholder status */
			                                        zeek::val_mgr->EmptyString());
			}

		return true;
		
}

bool WebSocket_Flow::process_payload_chunk(WebSocket_FramePayloadChunk* chunk) {

		auto& data = chunk->data();

		// In-place unmasking if frame payload is masked.
		if ( has_mask_ )
			{
			auto *d = data.data();
			for ( int i = 0; i < data.length(); i++ )
				d[i] = d[i] ^ masking_key_[masking_key_idx_++ % masking_key_.size()];
			}

		if ( websocket_frame_data )
			{
			auto data_val = zeek::make_intrusive<zeek::StringVal>(data.length(), reinterpret_cast<const char*>(data.data()));
			zeek::BifEvent::enqueue_websocket_frame_data(connection()->zeek_analyzer(),
			                                             connection()->zeek_analyzer()->Conn(),
			                                             is_orig(),
			                                             std::move(data_val));
			}

		// Forward text and binary data to downstream analyzers.
		if ( effective_opcode_ == OPCODE_TEXT || effective_opcode_ == OPCODE_BINARY)
			connection()->zeek_analyzer()->ForwardStream(data.length(),
			                                             data.data(),
			                                             is_orig());

		return true;
		
}

} // namespace WebSocket
}  // namespace binpac
