// This file is automatically generated from /build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe.pac.

#ifndef _build_zeek_src_zeek_src_file_analysis_analyzer_pe_pe_pac_h
#define _build_zeek_src_zeek_src_file_analysis_analyzer_pe_pe_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/Event.h"
#include "zeek/file_analysis/File.h"

#include "zeek/file_analysis/analyzer/pe/events.bif.h"

namespace binpac {

namespace PE {
class ContextPE;
class MockConnection;
// NOLINTNEXTLINE(performance-enum-size)
enum PE_File_Format {
    UNKNOWN_VERSION = 0,
    PE32 = 1,
    PE32_PLUS = 2,
};
class Mem_Info32;
class Mem_Info64;
class RVAS;
class RVA;
class Padding;
extern RegExMatcher null_terminated_string_re_001;

class null_terminated_string;
class Headers;
class DOS_Header;
class DOS_Code;
class NT_Headers;
class File_Header;
class Optional_Header;
class Section_Headers;
class Section_Header;
class PE_File;
class Portable_Executable;
class File;
} // namespace PE

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace PE {

class ContextPE final {
public:
    ContextPE(MockConnection* connection, File* flow, FlowBuffer* flow_buffer);
    ~ContextPE();

    // Member access functions
    MockConnection* connection() const { return connection_; }
    File* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    MockConnection* connection_;
    File* flow_;
    FlowBuffer* flow_buffer_;
};


class MockConnection final : public binpac::ConnectionAnalyzer {
public:
    MockConnection(ZeekFileAnalyzer* zeek_analyzer);
    ~MockConnection() override;

    // Member access functions
    File* upflow() const { return upflow_; }
    File* downflow() const { return downflow_; }
    ZeekFileAnalyzer* zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool add_section(Section_Header* h);
    uint8 set_pe32_format(uint16 magic);
    uint64 get_max_file_location();
    uint8 get_pe32_format();
    bool mark_done();
    bool is_done();

protected:

    // Additional members

		uint64 max_file_location_;
		uint8  pe32_format_;
	

		bool done_;
	
    File* upflow_;
    File* downflow_;
    ZeekFileAnalyzer* zeek_analyzer_;
};


class Mem_Info32 final {
public:
    Mem_Info32();
    ~Mem_Info32();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint32 size_of_stack_reserve() const { return size_of_stack_reserve_; }
    uint32 size_of_stack_commit() const { return size_of_stack_commit_; }
    uint32 size_of_heap_reserve() const { return size_of_heap_reserve_; }
    uint32 size_of_heap_commit() const { return size_of_heap_commit_; }
    int byteorder() const { return byteorder_; }

protected:
    uint32 size_of_stack_reserve_;
    uint32 size_of_stack_commit_;
    uint32 size_of_heap_reserve_;
    uint32 size_of_heap_commit_;
    int byteorder_;
};


class Mem_Info64 final {
public:
    Mem_Info64();
    ~Mem_Info64();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint64 size_of_stack_reserve() const { return size_of_stack_reserve_; }
    uint64 size_of_stack_commit() const { return size_of_stack_commit_; }
    uint64 size_of_heap_reserve() const { return size_of_heap_reserve_; }
    uint64 size_of_heap_commit() const { return size_of_heap_commit_; }
    int byteorder() const { return byteorder_; }

protected:
    uint64 size_of_stack_reserve_;
    uint64 size_of_stack_commit_;
    uint64 size_of_heap_reserve_;
    uint64 size_of_heap_commit_;
    int byteorder_;
};


class RVAS final {
public:
    RVAS(uint32 num);
    ~RVAS();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    vector<RVA*>* rvas() const { return rvas_; }
    uint32 num() const { return num_; }

protected:
    vector<RVA*>* rvas_;
    RVA* rvas__elem_;
    uint32 num_;
};


class RVA final {
public:
    RVA();
    ~RVA();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 virtual_address() const { return virtual_address_; }
    uint32 size() const { return size_; }

protected:
    uint32 virtual_address_;
    uint32 size_;
};


class Padding final {
public:
    Padding(uint64 length);
    ~Padding();
    bool ParseBuffer(flow_buffer_t t_flow_buffer);

    // Member access functions
    uint64 length() const { return length_; }

protected:
    const_bytestring pad_;
    int buffering_state_;
    uint64 length_;
    int parsing_state_;
};

extern int const MAX_DOS_CODE_LENGTH;

class Headers final {
public:
    Headers();
    ~Headers();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder);

    // Member access functions
    DOS_Header* dos_header() const { return dos_header_; }
    DOS_Code* dos_code() const { return dos_code_; }
    NT_Headers* pe_header() const { return pe_header_; }
    Section_Headers* section_headers() const { return section_headers_; }
    uint32 dos_code_len() const { return dos_code_len_; }
    uint64 length() const { return length_; }
    bool proc() const { return proc_; }

protected:
    DOS_Header* dos_header_;
    DOS_Code* dos_code_;
    NT_Headers* pe_header_;
    Section_Headers* section_headers_;
    uint32 dos_code_len_;
    uint64 length_;
    bool proc_;
    int parsing_state_;
};


class DOS_Header final {
public:
    DOS_Header();
    ~DOS_Header();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder);

    // Member access functions
    bytestring const& signature() const { return signature_; }
    uint16 UsedBytesInTheLastPage() const { return UsedBytesInTheLastPage_; }
    uint16 FileSizeInPages() const { return FileSizeInPages_; }
    uint16 NumberOfRelocationItems() const { return NumberOfRelocationItems_; }
    uint16 HeaderSizeInParagraphs() const { return HeaderSizeInParagraphs_; }
    uint16 MinimumExtraParagraphs() const { return MinimumExtraParagraphs_; }
    uint16 MaximumExtraParagraphs() const { return MaximumExtraParagraphs_; }
    uint16 InitialRelativeSS() const { return InitialRelativeSS_; }
    uint16 InitialSP() const { return InitialSP_; }
    uint16 Checksum() const { return Checksum_; }
    uint16 InitialIP() const { return InitialIP_; }
    uint16 InitialRelativeCS() const { return InitialRelativeCS_; }
    uint16 AddressOfRelocationTable() const { return AddressOfRelocationTable_; }
    uint16 OverlayNumber() const { return OverlayNumber_; }
    vector<uint16>* Reserved() const { return Reserved_; }
    uint16 OEMid() const { return OEMid_; }
    uint16 OEMinfo() const { return OEMinfo_; }
    vector<uint16>* Reserved2() const { return Reserved2_; }
    uint32 AddressOfNewExeHeader() const { return AddressOfNewExeHeader_; }
    bool proc() const { return proc_; }

protected:
    bytestring signature_;
    uint16 UsedBytesInTheLastPage_;
    uint16 FileSizeInPages_;
    uint16 NumberOfRelocationItems_;
    uint16 HeaderSizeInParagraphs_;
    uint16 MinimumExtraParagraphs_;
    uint16 MaximumExtraParagraphs_;
    uint16 InitialRelativeSS_;
    uint16 InitialSP_;
    uint16 Checksum_;
    uint16 InitialIP_;
    uint16 InitialRelativeCS_;
    uint16 AddressOfRelocationTable_;
    uint16 OverlayNumber_;
    vector<uint16>* Reserved_;
    uint16 Reserved__elem_;
    uint16 OEMid_;
    uint16 OEMinfo_;
    vector<uint16>* Reserved2_;
    uint16 Reserved2__elem_;
    uint32 AddressOfNewExeHeader_;
    bool proc_;
    int buffering_state_;
};


class DOS_Code final {
public:
    DOS_Code(uint32 len);
    ~DOS_Code();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context);

    // Member access functions
    bytestring const& code() const { return code_; }
    uint32 len() const { return len_; }
    bool proc() const { return proc_; }

protected:
    bytestring code_;
    int buffering_state_;
    uint32 len_;
    bool proc_;
    int parsing_state_;
};


class NT_Headers final {
public:
    NT_Headers();
    ~NT_Headers();
    int initial_buffer_length() const { return 24; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder);

    // Member access functions
    uint32 PESignature() const { return PESignature_; }
    File_Header* file_header() const { return file_header_; }
    int have_opt_header_case_index() const	{ return have_opt_header_case_index_; }
    Optional_Header* optional_header() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_opt_header_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file-headers.pac:51:optional_header", (int64)have_opt_header_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return optional_header_;
    }
    uint32 length() const { return length_; }
    bool is_exe() const { return is_exe_; }
    uint32 size_of_headers() const { return size_of_headers_; }
    bool proc() const { return proc_; }

protected:
    uint32 PESignature_;
    File_Header* file_header_;
    int have_opt_header_case_index_;
    Optional_Header* optional_header_;
    uint32 length_;
    bool is_exe_;
    uint32 size_of_headers_;
    bool proc_;
    int buffering_state_;
};


class File_Header final {
public:
    File_Header();
    ~File_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextPE* t_context, int t_byteorder);

    // Member access functions
    uint16 Machine() const { return Machine_; }
    uint16 NumberOfSections() const { return NumberOfSections_; }
    uint32 TimeDateStamp() const { return TimeDateStamp_; }
    uint32 PointerToSymbolTable() const { return PointerToSymbolTable_; }
    uint32 NumberOfSymbols() const { return NumberOfSymbols_; }
    uint16 SizeOfOptionalHeader() const { return SizeOfOptionalHeader_; }
    uint16 Characteristics() const { return Characteristics_; }
    bool proc() const { return proc_; }

protected:
    uint16 Machine_;
    uint16 NumberOfSections_;
    uint32 TimeDateStamp_;
    uint32 PointerToSymbolTable_;
    uint32 NumberOfSymbols_;
    uint16 SizeOfOptionalHeader_;
    uint16 Characteristics_;
    bool proc_;
};


class Optional_Header final {
public:
    Optional_Header();
    ~Optional_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextPE* t_context, int t_byteorder);

    // Member access functions
    uint16 magic() const { return magic_; }
    uint8 major_linker_version() const { return major_linker_version_; }
    uint8 minor_linker_version() const { return minor_linker_version_; }
    uint32 size_of_code() const { return size_of_code_; }
    uint32 size_of_init_data() const { return size_of_init_data_; }
    uint32 size_of_uninit_data() const { return size_of_uninit_data_; }
    uint32 addr_of_entry_point() const { return addr_of_entry_point_; }
    uint32 base_of_code() const { return base_of_code_; }
    uint8 have_base_of_data_case_index() const	{ return have_base_of_data_case_index_; }
    uint32 base_of_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_base_of_data_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file-headers.pac:82:base_of_data", (int64)have_base_of_data_case_index(), "PE32");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return base_of_data_;
    }
    uint8 is_pe32_case_index() const	{ return is_pe32_case_index_; }
    uint64 image_base_64() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( is_pe32_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file-headers.pac:86:image_base_64", (int64)is_pe32_case_index(), "PE32_PLUS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return image_base_64_;
    }
    uint32 image_base_32() const {
        return image_base_32_;
    }
    uint32 section_alignment() const { return section_alignment_; }
    uint32 file_alignment() const { return file_alignment_; }
    uint16 os_version_major() const { return os_version_major_; }
    uint16 os_version_minor() const { return os_version_minor_; }
    uint16 major_image_version() const { return major_image_version_; }
    uint16 minor_image_version() const { return minor_image_version_; }
    uint16 major_subsys_version() const { return major_subsys_version_; }
    uint16 minor_subsys_version() const { return minor_subsys_version_; }
    uint32 win32_version() const { return win32_version_; }
    uint32 size_of_image() const { return size_of_image_; }
    uint32 size_of_headers() const { return size_of_headers_; }
    uint32 checksum() const { return checksum_; }
    uint16 subsystem() const { return subsystem_; }
    uint16 dll_characteristics() const { return dll_characteristics_; }
    uint8 mem_case_index() const	{ return mem_case_index_; }
    Mem_Info32* i32() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( mem_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file-headers.pac:104:i32", (int64)mem_case_index(), "PE32");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return i32_;
    }
    Mem_Info64* i64() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( mem_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file-headers.pac:105:i64", (int64)mem_case_index(), "PE32_PLUS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return i64_;
    }
    uint32 loader_flags() const { return loader_flags_; }
    uint32 number_of_rva_and_sizes() const { return number_of_rva_and_sizes_; }
    RVAS* rvas() const { return rvas_; }
    uint8 pe_format() const { return pe_format_; }
    uint64 image_base() const { return image_base_; }
    bool proc() const { return proc_; }

protected:
    uint16 magic_;
    uint8 major_linker_version_;
    uint8 minor_linker_version_;
    uint32 size_of_code_;
    uint32 size_of_init_data_;
    uint32 size_of_uninit_data_;
    uint32 addr_of_entry_point_;
    uint32 base_of_code_;
    uint8 have_base_of_data_case_index_;
    uint32 base_of_data_;
    uint8 is_pe32_case_index_;
    uint64 image_base_64_;
    uint32 image_base_32_;
    uint32 section_alignment_;
    uint32 file_alignment_;
    uint16 os_version_major_;
    uint16 os_version_minor_;
    uint16 major_image_version_;
    uint16 minor_image_version_;
    uint16 major_subsys_version_;
    uint16 minor_subsys_version_;
    uint32 win32_version_;
    uint32 size_of_image_;
    uint32 size_of_headers_;
    uint32 checksum_;
    uint16 subsystem_;
    uint16 dll_characteristics_;
    uint8 mem_case_index_;
    Mem_Info32* i32_;
    Mem_Info64* i64_;
    uint32 loader_flags_;
    uint32 number_of_rva_and_sizes_;
    RVAS* rvas_;
    uint8 pe_format_;
    uint64 image_base_;
    bool proc_;
};


class Section_Headers final {
public:
    Section_Headers(uint16 num);
    ~Section_Headers();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder);

    // Member access functions
    vector<Section_Header*>* sections() const { return sections_; }
    uint16 num() const { return num_; }
    uint32 length() const { return length_; }

protected:
    vector<Section_Header*>* sections_;
    Section_Header* sections__elem_;
    uint16 num_;
    uint32 length_;
    int buffering_state_;
};


class Section_Header final {
public:
    Section_Header();
    ~Section_Header();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextPE* t_context, int t_byteorder);

    // Member access functions
    bytestring const& name() const { return name_; }
    uint32 virtual_size() const { return virtual_size_; }
    uint32 virtual_addr() const { return virtual_addr_; }
    uint32 size_of_raw_data() const { return size_of_raw_data_; }
    uint32 ptr_to_raw_data() const { return ptr_to_raw_data_; }
    uint32 non_used_ptr_to_relocs() const { return non_used_ptr_to_relocs_; }
    uint32 non_used_ptr_to_line_nums() const { return non_used_ptr_to_line_nums_; }
    uint16 non_used_num_of_relocs() const { return non_used_num_of_relocs_; }
    uint16 non_used_num_of_line_nums() const { return non_used_num_of_line_nums_; }
    uint32 characteristics() const { return characteristics_; }
    bool add_section() const { return add_section_; }
    bool proc() const { return proc_; }

protected:
    bytestring name_;
    uint32 virtual_size_;
    uint32 virtual_addr_;
    uint32 size_of_raw_data_;
    uint32 ptr_to_raw_data_;
    uint32 non_used_ptr_to_relocs_;
    uint32 non_used_ptr_to_line_nums_;
    uint16 non_used_num_of_relocs_;
    uint16 non_used_num_of_line_nums_;
    uint32 characteristics_;
    bool add_section_;
    bool proc_;
};


class PE_File final {
public:
    PE_File();
    ~PE_File();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    Portable_Executable* PE() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file.pac:6:PE", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return PE_;
    }

protected:
    int val_case_index_;
    Portable_Executable* PE_;
    const_bytestring overlay_;
    int buffering_state_;
};


class Portable_Executable final {
public:
    Portable_Executable();
    ~Portable_Executable();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context);

    // Member access functions
    Headers* headers() const { return headers_; }
    Padding* pad() const { return pad_; }
    int byteorder() const { return byteorder_; }
    uint32 unparsed_hdr_len() const { return unparsed_hdr_len_; }
    uint64 data_post_hdrs() const { return data_post_hdrs_; }
    uint64 restofdata() const { return restofdata_; }
    bool proc() const { return proc_; }

protected:
    Headers* headers_;
    Padding* pad_;
    int byteorder_;
    uint32 unparsed_hdr_len_;
    uint64 data_post_hdrs_;
    uint64 restofdata_;
    bool proc_;
    int parsing_state_;
};


class File final : public binpac::FlowAnalyzer {
public:
    File(MockConnection* connection);
    ~File() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    MockConnection* connection() const { return connection_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool proc_dos_header(DOS_Header* h);
    bool proc_dos_code(bytestring const& code);
    bool proc_nt_headers(NT_Headers* h);
    bool proc_file_header(File_Header* h);
    bool proc_optional_header(Optional_Header* h);
    bool proc_section_header(Section_Header* h);

protected:
    PE_File* dataunit_;
    ContextPE* context_;
    FlowBuffer* flow_buffer_;
    MockConnection* connection_;
};


zeek::VectorValPtr process_rvas(const RVAS* rvas);
zeek::TableValPtr characteristics_to_zeek(uint32_t c, uint8_t len);

} // namespace PE
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_file_analysis_analyzer_pe_pe_pac_h */
