// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_ntp_ntp_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_ntp_ntp_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


	#include "zeek/analyzer/protocol/ntp/types.bif.h"
	#include "zeek/analyzer/protocol/ntp/events.bif.h"


	#include <cmath>
	#define FRAC_16 std::pow(2,-16)
	#define FRAC_32 std::pow(2,-32)
	// NTP defines the epoch from 1900, not 1970
	constexpr double EPOCH_OFFSET = -2208988800;

namespace binpac {

namespace NTP {
class ContextNTP;
class NTP_Conn;
class NTP_mode7_msg;
// NOLINTNEXTLINE(performance-enum-size)
enum NTP_Mode {
    SYMMETRIC_ACTIVE = 1,
    SYMMETRIC_PASSIVE = 2,
    CLIENT = 3,
    SERVER = 4,
    BROADCAST_SERVER = 5,
    BROADCAST_CLIENT = 6,
};
class NTP_PDU;
class NTP_std_msg;
class NTP_control_msg;
class NTP_MAC;
class NTP_MAC_ext;
class NTP_CONTROL_MAC;
class Extension_Field;
class NTP_Short_Time;
class NTP_Time;
class NTP_Flow;
} // namespace NTP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace NTP {

class ContextNTP final {
public:
    ContextNTP(NTP_Conn* connection, NTP_Flow* flow);
    ~ContextNTP();

    // Member access functions
    NTP_Conn* connection() const { return connection_; }
    NTP_Flow* flow() const { return flow_; }

protected:
    NTP_Conn* connection_;
    NTP_Flow* flow_;
};


class NTP_Conn final : public binpac::ConnectionAnalyzer {
public:
    NTP_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~NTP_Conn() override;

    // Member access functions
    NTP_Flow* upflow() const { return upflow_; }
    NTP_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

protected:
    NTP_Flow* upflow_;
    NTP_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class NTP_mode7_msg final {
public:
    NTP_mode7_msg();
    ~NTP_mode7_msg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 second_byte() const { return second_byte_; }
    uint8 implementation() const { return implementation_; }
    uint8 request_code() const { return request_code_; }
    uint16 err_and_data_len() const { return err_and_data_len_; }
    bytestring const& data() const { return data_; }
    int have_mac_case_index() const	{ return have_mac_case_index_; }
    NTP_MAC* mac() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_mac_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-mode7.pac:114:mac", (int64)have_mac_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mac_;
    }
    int byteorder() const { return byteorder_; }
    bool auth_bit() const { return auth_bit_; }
    uint8 sequence() const { return sequence_; }
    uint8 error_code() const { return error_code_; }
    uint16 data_len() const { return data_len_; }
    const_bytestring const& sourcedata() const { return sourcedata_; }

protected:
    uint8 second_byte_;
    uint8 implementation_;
    uint8 request_code_;
    uint16 err_and_data_len_;
    bytestring data_;
    int have_mac_case_index_;
    NTP_MAC* mac_;
    int byteorder_;
    bool auth_bit_;
    uint8 sequence_;
    uint8 error_code_;
    uint16 data_len_;
    const_bytestring sourcedata_;
};


class NTP_PDU final {
public:
    NTP_PDU(bool is_orig);
    ~NTP_PDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTP* t_context);

    // Member access functions
    uint8 first_byte() const { return first_byte_; }
    int standard_modes_case_index() const	{ return standard_modes_case_index_; }
    NTP_std_msg* std() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( standard_modes_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:19:std", (int64)standard_modes_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return std_;
    }
    uint8 modes_6_7_case_index() const	{ return modes_6_7_case_index_; }
    NTP_control_msg* control() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( modes_6_7_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:25:control", (int64)modes_6_7_case_index(), "((int) 6)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return control_;
    }
    NTP_mode7_msg* mode7() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( modes_6_7_case_index() ) {
            case ((uint8)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:28:mode7", (int64)modes_6_7_case_index(), "((int) 7)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mode7_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    uint8 leap() const { return leap_; }
    uint8 version() const { return version_; }
    uint8 mode() const { return mode_; }
    bool proc() const { return proc_; }
    const_bytestring const& sourcedata() const { return sourcedata_; }

protected:
    uint8 first_byte_;
    int standard_modes_case_index_;
    NTP_std_msg* std_;
    uint8 modes_6_7_case_index_;
    NTP_control_msg* control_;
    NTP_mode7_msg* mode7_;
    bytestring unknown_;
    bool is_orig_;
    int byteorder_;
    uint8 leap_;
    uint8 version_;
    uint8 mode_;
    bool proc_;
    const_bytestring sourcedata_;
};


class NTP_std_msg final {
public:
    NTP_std_msg();
    ~NTP_std_msg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 stratum() const { return stratum_; }
    int8 poll() const { return poll_; }
    int8 precision() const { return precision_; }
    NTP_Short_Time* root_delay() const { return root_delay_; }
    NTP_Short_Time* root_dispersion() const { return root_dispersion_; }
    bytestring const& reference_id() const { return reference_id_; }
    NTP_Time* reference_ts() const { return reference_ts_; }
    NTP_Time* origin_ts() const { return origin_ts_; }
    NTP_Time* receive_ts() const { return receive_ts_; }
    NTP_Time* transmit_ts() const { return transmit_ts_; }
    int extensions_case_index() const	{ return extensions_case_index_; }
    vector<Extension_Field*>* exts() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( extensions_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:56:exts", (int64)extensions_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return exts_;
    }
    uint32 mac_fields_case_index() const	{ return mac_fields_case_index_; }
    NTP_MAC* mac() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( mac_fields_case_index() ) {
            case ((uint32)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:61:mac", (int64)mac_fields_case_index(), "((int) 20)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mac_;
    }
    NTP_MAC_ext* mac_ext() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( mac_fields_case_index() ) {
            case ((uint32)24):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:62:mac_ext", (int64)mac_fields_case_index(), "((int) 24)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mac_ext_;
    }
    int byteorder() const { return byteorder_; }
    int length() const { return length_; }
    bool has_exts() const { return has_exts_; }
    uint32 mac_len() const { return mac_len_; }
    const_bytestring const& sourcedata() const { return sourcedata_; }

protected:
    uint8 stratum_;
    int8 poll_;
    int8 precision_;
    NTP_Short_Time* root_delay_;
    NTP_Short_Time* root_dispersion_;
    bytestring reference_id_;
    NTP_Time* reference_ts_;
    NTP_Time* origin_ts_;
    NTP_Time* receive_ts_;
    NTP_Time* transmit_ts_;
    int extensions_case_index_;
    vector<Extension_Field*>* exts_;
    Extension_Field* exts__elem_;
    uint32 mac_fields_case_index_;
    NTP_MAC* mac_;
    NTP_MAC_ext* mac_ext_;
    int byteorder_;
    int length_;
    bool has_exts_;
    uint32 mac_len_;
    const_bytestring sourcedata_;
};


class NTP_control_msg final {
public:
    NTP_control_msg();
    ~NTP_control_msg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 second_byte() const { return second_byte_; }
    uint16 sequence() const { return sequence_; }
    uint16 status() const { return status_; }
    uint16 association_id() const { return association_id_; }
    uint16 offs() const { return offs_; }
    uint16 c() const { return c_; }
    bytestring const& data() const { return data_; }
    int mac_fields_case_index() const	{ return mac_fields_case_index_; }
    NTP_CONTROL_MAC* mac() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( mac_fields_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntp/ntp-protocol.pac:83:mac", (int64)mac_fields_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mac_;
    }
    int byteorder() const { return byteorder_; }
    bool R() const { return R_; }
    bool E() const { return E_; }
    bool M() const { return M_; }
    uint8 OpCode() const { return OpCode_; }
    int length() const { return length_; }
    bool has_control_mac() const { return has_control_mac_; }
    const_bytestring const& sourcedata() const { return sourcedata_; }

protected:
    uint8 second_byte_;
    uint16 sequence_;
    uint16 status_;
    uint16 association_id_;
    uint16 offs_;
    uint16 c_;
    bytestring data_;
    int mac_fields_case_index_;
    NTP_CONTROL_MAC* mac_;
    int byteorder_;
    bool R_;
    bool E_;
    bool M_;
    uint8 OpCode_;
    int length_;
    bool has_control_mac_;
    const_bytestring sourcedata_;
};


class NTP_MAC final {
public:
    NTP_MAC();
    ~NTP_MAC();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 key_id() const { return key_id_; }
    bytestring const& digest() const { return digest_; }

protected:
    uint32 key_id_;
    bytestring digest_;
};


class NTP_MAC_ext final {
public:
    NTP_MAC_ext();
    ~NTP_MAC_ext();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 key_id() const { return key_id_; }
    bytestring const& digest() const { return digest_; }

protected:
    uint32 key_id_;
    bytestring digest_;
};


class NTP_CONTROL_MAC final {
public:
    NTP_CONTROL_MAC();
    ~NTP_CONTROL_MAC();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 key_id() const { return key_id_; }
    bytestring const& crypto_checksum() const { return crypto_checksum_; }

protected:
    uint32 key_id_;
    bytestring crypto_checksum_;
};


class Extension_Field final {
public:
    Extension_Field();
    ~Extension_Field();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 first_byte_ext() const { return first_byte_ext_; }
    uint8 field_type() const { return field_type_; }
    uint16 len() const { return len_; }
    uint16 association_id() const { return association_id_; }
    uint32 timestamp() const { return timestamp_; }
    uint32 filestamp() const { return filestamp_; }
    uint32 value_len() const { return value_len_; }
    bytestring const& value() const { return value_; }
    uint32 sig_len() const { return sig_len_; }
    bytestring const& signature() const { return signature_; }
    bool R() const { return R_; }
    bool E() const { return E_; }
    uint8 Code() const { return Code_; }

protected:
    uint8 first_byte_ext_;
    uint8 field_type_;
    uint16 len_;
    uint16 association_id_;
    uint32 timestamp_;
    uint32 filestamp_;
    uint32 value_len_;
    bytestring value_;
    uint32 sig_len_;
    bytestring signature_;
    bool R_;
    bool E_;
    uint8 Code_;
};


class NTP_Short_Time final {
public:
    NTP_Short_Time();
    ~NTP_Short_Time();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    int16 seconds() const { return seconds_; }
    int16 fractions() const { return fractions_; }

protected:
    int16 seconds_;
    int16 fractions_;
};


class NTP_Time final {
public:
    NTP_Time();
    ~NTP_Time();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 seconds() const { return seconds_; }
    uint32 fractions() const { return fractions_; }

protected:
    uint32 seconds_;
    uint32 fractions_;
};


class NTP_Flow final : public binpac::FlowAnalyzer {
public:
    NTP_Flow(NTP_Conn* connection, bool is_orig);
    ~NTP_Flow() override;

    // Member access functions
    NTP_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool proc_ntp_message(NTP_PDU* msg);

protected:
    NTP_PDU* dataunit_;
    ContextNTP* context_;

    // Additional members

		bool flipped_;
	
    NTP_Conn* connection_;
    bool is_orig_;
};


	zeek::ValPtr proc_ntp_short(const NTP_Short_Time* t);
	zeek::ValPtr proc_ntp_timestamp(const NTP_Time* t);
	zeek::RecordValPtr BuildNTPStdMsg(NTP_std_msg* nsm);
	zeek::RecordValPtr BuildNTPControlMsg(NTP_control_msg* ncm);
	zeek::RecordValPtr BuildNTPMode7Msg(NTP_mode7_msg* m7);

} // namespace NTP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_ntp_ntp_pac_h */
