/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "/build/zeek/src/zeek/src/rule-parse.y"

#include "zeek/zeek-config.h"
#include <cstdio>
#include <netinet/in.h>
#include <vector>

#include "zeek/RuleAction.h"
#include "zeek/RuleCondition.h"
#include "zeek/RuleMatcher.h"
#include "zeek/Reporter.h"
#include "zeek/IPAddr.h"
#include "zeek/net_util.h"

using namespace zeek::detail;

extern void begin_PS();
extern void end_PS();

zeek::detail::Rule* current_rule = nullptr;
const char* current_rule_file = nullptr;

static uint8_t ip4_mask_to_len(uint32_t mask) {
    if ( mask == 0xffffffff )
        return 32;

    uint32_t x = ~mask + 1;
    uint8_t len;
    for ( len = 0; len < 32 && (! (x & (1 << len))); ++len )
        ;

    return 32 - len;
}

#line 105 "/build/zeek/src/zeek/build/src/rup.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "rup.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_COMP = 3,                   /* TOK_COMP  */
  YYSYMBOL_TOK_DISABLE = 4,                /* TOK_DISABLE  */
  YYSYMBOL_TOK_DST_IP = 5,                 /* TOK_DST_IP  */
  YYSYMBOL_TOK_DST_PORT = 6,               /* TOK_DST_PORT  */
  YYSYMBOL_TOK_ENABLE = 7,                 /* TOK_ENABLE  */
  YYSYMBOL_TOK_EVAL = 8,                   /* TOK_EVAL  */
  YYSYMBOL_TOK_EVENT = 9,                  /* TOK_EVENT  */
  YYSYMBOL_TOK_MIME = 10,                  /* TOK_MIME  */
  YYSYMBOL_TOK_HEADER = 11,                /* TOK_HEADER  */
  YYSYMBOL_TOK_IDENT = 12,                 /* TOK_IDENT  */
  YYSYMBOL_TOK_INT = 13,                   /* TOK_INT  */
  YYSYMBOL_TOK_IP = 14,                    /* TOK_IP  */
  YYSYMBOL_TOK_IP6 = 15,                   /* TOK_IP6  */
  YYSYMBOL_TOK_IP_OPTIONS = 16,            /* TOK_IP_OPTIONS  */
  YYSYMBOL_TOK_IP_OPTION_SYM = 17,         /* TOK_IP_OPTION_SYM  */
  YYSYMBOL_TOK_IP_PROTO = 18,              /* TOK_IP_PROTO  */
  YYSYMBOL_TOK_PATTERN = 19,               /* TOK_PATTERN  */
  YYSYMBOL_TOK_PATTERN_TYPE = 20,          /* TOK_PATTERN_TYPE  */
  YYSYMBOL_TOK_PAYLOAD_SIZE = 21,          /* TOK_PAYLOAD_SIZE  */
  YYSYMBOL_TOK_PROT = 22,                  /* TOK_PROT  */
  YYSYMBOL_TOK_REQUIRES_SIGNATURE = 23,    /* TOK_REQUIRES_SIGNATURE  */
  YYSYMBOL_TOK_REQUIRES_REVERSE_SIGNATURE = 24, /* TOK_REQUIRES_REVERSE_SIGNATURE  */
  YYSYMBOL_TOK_SIGNATURE = 25,             /* TOK_SIGNATURE  */
  YYSYMBOL_TOK_SAME_IP = 26,               /* TOK_SAME_IP  */
  YYSYMBOL_TOK_SRC_IP = 27,                /* TOK_SRC_IP  */
  YYSYMBOL_TOK_SRC_PORT = 28,              /* TOK_SRC_PORT  */
  YYSYMBOL_TOK_TCP_STATE = 29,             /* TOK_TCP_STATE  */
  YYSYMBOL_TOK_UDP_STATE = 30,             /* TOK_UDP_STATE  */
  YYSYMBOL_TOK_STRING = 31,                /* TOK_STRING  */
  YYSYMBOL_TOK_STATE_SYM = 32,             /* TOK_STATE_SYM  */
  YYSYMBOL_TOK_ACTIVE = 33,                /* TOK_ACTIVE  */
  YYSYMBOL_TOK_BOOL = 34,                  /* TOK_BOOL  */
  YYSYMBOL_TOK_POLICY_SYMBOL = 35,         /* TOK_POLICY_SYMBOL  */
  YYSYMBOL_36_ = 36,                       /* '{'  */
  YYSYMBOL_37_ = 37,                       /* '}'  */
  YYSYMBOL_38_ = 38,                       /* '['  */
  YYSYMBOL_39_ = 39,                       /* ']'  */
  YYSYMBOL_40_ = 40,                       /* '!'  */
  YYSYMBOL_41_ = 41,                       /* '&'  */
  YYSYMBOL_42_ = 42,                       /* ','  */
  YYSYMBOL_43_ = 43,                       /* '-'  */
  YYSYMBOL_44_ = 44,                       /* ':'  */
  YYSYMBOL_YYACCEPT = 45,                  /* $accept  */
  YYSYMBOL_rule_list = 46,                 /* rule_list  */
  YYSYMBOL_rule = 47,                      /* rule  */
  YYSYMBOL_48_1 = 48,                      /* $@1  */
  YYSYMBOL_rule_attr_list = 49,            /* rule_attr_list  */
  YYSYMBOL_rule_attr = 50,                 /* rule_attr  */
  YYSYMBOL_51_2 = 51,                      /* $@2  */
  YYSYMBOL_52_3 = 52,                      /* $@3  */
  YYSYMBOL_hdr_expr = 53,                  /* hdr_expr  */
  YYSYMBOL_value_list = 54,                /* value_list  */
  YYSYMBOL_prefix_value_list = 55,         /* prefix_value_list  */
  YYSYMBOL_prefix_value = 56,              /* prefix_value  */
  YYSYMBOL_ranged_value = 57,              /* ranged_value  */
  YYSYMBOL_value = 58,                     /* value  */
  YYSYMBOL_rangeopt = 59,                  /* rangeopt  */
  YYSYMBOL_range = 60,                     /* range  */
  YYSYMBOL_ipoption_list = 61,             /* ipoption_list  */
  YYSYMBOL_state_list = 62,                /* state_list  */
  YYSYMBOL_integer = 63,                   /* integer  */
  YYSYMBOL_opt_negate = 64,                /* opt_negate  */
  YYSYMBOL_opt_strength = 65,              /* opt_strength  */
  YYSYMBOL_string = 66,                    /* string  */
  YYSYMBOL_pattern = 67                    /* pattern  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   123

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  45
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  23
/* YYNRULES -- Number of rules.  */
#define YYNRULES  71
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  123

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   290


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    40,     2,     2,     2,     2,    41,     2,
       2,     2,     2,     2,    42,    43,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    44,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    38,     2,    39,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    36,     2,    37,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   103,   103,   105,   110,   109,   119,   120,   124,   131,
     138,   138,   138,   143,   146,   152,   184,   193,   201,   204,
     207,   210,   213,   216,   219,   226,   232,   235,   238,   241,
     244,   247,   254,   261,   266,   274,   279,   292,   300,   302,
     311,   313,   318,   322,   330,   335,   340,   345,   353,   358,
     362,   375,   377,   381,   383,   385,   390,   392,   397,   399,
     404,   406,   411,   413,   418,   421,   425,   428,   432,   434,
     439,   441
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_COMP",
  "TOK_DISABLE", "TOK_DST_IP", "TOK_DST_PORT", "TOK_ENABLE", "TOK_EVAL",
  "TOK_EVENT", "TOK_MIME", "TOK_HEADER", "TOK_IDENT", "TOK_INT", "TOK_IP",
  "TOK_IP6", "TOK_IP_OPTIONS", "TOK_IP_OPTION_SYM", "TOK_IP_PROTO",
  "TOK_PATTERN", "TOK_PATTERN_TYPE", "TOK_PAYLOAD_SIZE", "TOK_PROT",
  "TOK_REQUIRES_SIGNATURE", "TOK_REQUIRES_REVERSE_SIGNATURE",
  "TOK_SIGNATURE", "TOK_SAME_IP", "TOK_SRC_IP", "TOK_SRC_PORT",
  "TOK_TCP_STATE", "TOK_UDP_STATE", "TOK_STRING", "TOK_STATE_SYM",
  "TOK_ACTIVE", "TOK_BOOL", "TOK_POLICY_SYMBOL", "'{'", "'}'", "'['",
  "']'", "'!'", "'&'", "','", "'-'", "':'", "$accept", "rule_list", "rule",
  "$@1", "rule_attr_list", "rule_attr", "$@2", "$@3", "hdr_expr",
  "value_list", "prefix_value_list", "prefix_value", "ranged_value",
  "value", "rangeopt", "range", "ipoption_list", "state_list", "integer",
  "opt_negate", "opt_strength", "string", "pattern", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-83)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
     -83,    16,   -83,     3,   -83,   -83,   -14,   -83,    39,     8,
      48,    53,    11,   -83,    -4,     1,    36,    44,    61,    -5,
      70,    -6,    -3,   -83,    71,    79,    51,    51,    50,   -83,
     -83,   -83,     9,    40,   -83,    52,    54,   -83,   -83,   -83,
      46,    55,   -83,   -83,    47,     6,   -83,   -83,    -8,   -83,
      13,   -83,    74,   -83,    78,     9,    40,   -83,    49,    49,
     -83,   -83,   -83,   -83,    56,   -83,   -83,    57,   -83,    59,
     -83,   -83,   -83,   -83,    60,   -83,    13,    75,   -83,    59,
     -83,   -83,    13,    58,   -83,    62,   -83,   -83,   -83,    56,
      59,    64,    63,    81,    67,   -83,   -83,    82,    65,    66,
     -83,   -83,    -2,    13,   -83,   -83,   -83,   -83,   -83,   -83,
     -83,   -83,    -1,    13,   -83,   -83,    40,    13,    59,    96,
      17,   -83,   -83
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       3,     0,     1,     0,     2,     4,     0,     7,     0,     0,
       0,     0,     0,    10,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     5,
       6,    22,     0,     0,    21,     0,    17,    19,    69,    68,
      67,     0,    13,    59,    14,     0,    71,    70,     0,    23,
       0,    26,     0,    28,     0,     0,     0,    61,    33,    34,
      35,    47,    48,    49,     8,    46,    43,    51,    52,     9,
      42,    41,    11,    18,    65,    20,     0,     0,    15,    16,
      63,    62,     0,     0,    53,    56,    25,    27,    29,    31,
      32,     0,     0,     0,     0,    12,    64,     0,     0,    56,
      58,    54,     0,    55,    60,    45,    44,    50,    40,    39,
      38,    66,     0,     0,    24,    57,     0,     0,    37,     0,
       0,    51,    36
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -83,   -83,   -83,   -83,   -83,   -83,   -83,   -83,   -83,   -45,
      68,    10,    14,   -82,   -83,    29,   -83,    80,   -47,   -83,
     -83,   -83,     7
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     1,     4,     6,     8,    30,    35,    95,    42,    69,
      64,    65,    70,    71,    83,    84,    44,    58,   115,    97,
      75,    40,    49
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      79,    85,   116,    86,    80,    81,    51,    46,    36,    53,
      46,    90,   110,    38,    47,     5,     2,    47,    66,    67,
      68,    61,     7,    62,    63,    80,    81,    37,    78,    99,
     121,    68,    39,    48,    52,   101,    82,    54,   122,    31,
     117,     3,    34,     9,    10,    11,    12,    13,    14,    15,
      16,    32,    66,    67,    68,    17,    33,    18,    41,    19,
      20,    43,    21,    22,    45,    23,    24,    25,    26,    27,
     119,   118,    28,    50,    55,   105,    29,    62,    63,   108,
      67,    68,    56,    57,    60,    73,    87,    72,    74,    77,
      88,    91,   100,    76,   107,   111,   104,   102,    92,   120,
      93,    94,   106,    96,   112,    98,   103,    59,   109,   114,
     113,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89
};

static const yytype_int8 yycheck[] =
{
      45,    48,     3,    50,    12,    13,    12,    12,    12,    12,
      12,    56,    94,    12,    19,    12,     0,    19,    12,    13,
      14,    12,    36,    14,    15,    12,    13,    31,    22,    76,
      13,    14,    31,    38,    40,    82,    44,    40,   120,    31,
      41,    25,    31,     4,     5,     6,     7,     8,     9,    10,
      11,     3,    12,    13,    14,    16,     3,    18,    22,    20,
      21,    17,    23,    24,     3,    26,    27,    28,    29,    30,
     117,   116,    33,     3,     3,    12,    37,    14,    15,    12,
      13,    14,     3,    32,    34,    31,    12,    35,    42,    42,
      12,    42,    17,    38,    13,    13,    32,    39,    42,     3,
      43,    42,    92,    43,    39,    76,    44,    27,    94,   102,
      44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    55
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    46,     0,    25,    47,    12,    48,    36,    49,     4,
       5,     6,     7,     8,     9,    10,    11,    16,    18,    20,
      21,    23,    24,    26,    27,    28,    29,    30,    33,    37,
      50,    31,     3,     3,    31,    51,    12,    31,    12,    31,
      66,    22,    53,    17,    61,     3,    12,    19,    38,    67,
       3,    12,    40,    12,    40,     3,     3,    32,    62,    62,
      34,    12,    14,    15,    55,    56,    12,    13,    14,    54,
      57,    58,    35,    31,    42,    65,    38,    42,    22,    54,
      12,    13,    44,    59,    60,    63,    63,    12,    12,    55,
      54,    42,    42,    43,    42,    52,    43,    64,    60,    63,
      17,    63,    39,    44,    32,    12,    56,    13,    12,    57,
      58,    13,    39,    44,    67,    63,     3,    41,    54,    63,
       3,    13,    58
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    45,    46,    46,    48,    47,    49,    49,    50,    50,
      51,    52,    50,    50,    50,    50,    50,    50,    50,    50,
      50,    50,    50,    50,    50,    50,    50,    50,    50,    50,
      50,    50,    50,    50,    50,    50,    53,    53,    54,    54,
      54,    54,    54,    54,    55,    55,    55,    55,    56,    56,
      57,    58,    58,    59,    59,    59,    60,    60,    61,    61,
      62,    62,    63,    63,    64,    64,    65,    65,    66,    66,
      67,    67
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     0,     0,     6,     2,     0,     3,     3,
       0,     0,     4,     2,     2,     3,     3,     2,     3,     2,
       3,     2,     2,     2,     5,     3,     2,     3,     2,     3,
       1,     3,     3,     2,     2,     2,     8,     6,     3,     3,
       3,     1,     1,     1,     3,     3,     1,     1,     1,     1,
       3,     1,     1,     1,     2,     2,     1,     3,     3,     1,
       3,     1,     1,     1,     1,     0,     3,     0,     1,     1,
       1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* rule_list: rule_list rule  */
#line 104 "/build/zeek/src/zeek/src/rule-parse.y"
                        { zeek::detail::rule_matcher->AddRule((yyvsp[0].rule)); }
#line 1246 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 4: /* $@1: %empty  */
#line 110 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			zeek::detail::Location l(current_rule_file, rules_line_number+1, 0);
			current_rule = new zeek::detail::Rule(yylval.str, l);
			}
#line 1255 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 5: /* rule: TOK_SIGNATURE TOK_IDENT $@1 '{' rule_attr_list '}'  */
#line 115 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.rule) = current_rule; }
#line 1261 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 8: /* rule_attr: TOK_DST_IP TOK_COMP prefix_value_list  */
#line 125 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			current_rule->AddHdrTest(new zeek::detail::RuleHdrTest(
				zeek::detail::RuleHdrTest::IPDst,
				(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), *((yyvsp[0].prefix_val_list))));
			}
#line 1271 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 9: /* rule_attr: TOK_DST_PORT TOK_COMP value_list  */
#line 132 "/build/zeek/src/zeek/src/rule-parse.y"
                        { // Works for both TCP and UDP
			current_rule->AddHdrTest(new zeek::detail::RuleHdrTest(
				zeek::detail::RuleHdrTest::TCP, 2, 2,
				(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), (yyvsp[0].vallist)));
			}
#line 1281 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 10: /* $@2: %empty  */
#line 138 "/build/zeek/src/zeek/src/rule-parse.y"
                         { begin_PS(); }
#line 1287 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 11: /* $@3: %empty  */
#line 138 "/build/zeek/src/zeek/src/rule-parse.y"
                                                           { end_PS(); }
#line 1293 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 12: /* rule_attr: TOK_EVAL $@2 TOK_POLICY_SYMBOL $@3  */
#line 139 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			current_rule->AddCondition(new zeek::detail::RuleConditionEval((yyvsp[-1].str)));
			}
#line 1301 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 13: /* rule_attr: TOK_HEADER hdr_expr  */
#line 144 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddHdrTest((yyvsp[0].hdr_test)); }
#line 1307 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 14: /* rule_attr: TOK_IP_OPTIONS ipoption_list  */
#line 147 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			current_rule->AddCondition(
				new zeek::detail::RuleConditionIPOptions((yyvsp[0].val)));
			}
#line 1316 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 15: /* rule_attr: TOK_IP_PROTO TOK_COMP TOK_PROT  */
#line 153 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			int proto = 0;
			switch ( (yyvsp[0].prot) ) {
				case zeek::detail::RuleHdrTest::ICMP: proto = IPPROTO_ICMP; break;
				case zeek::detail::RuleHdrTest::ICMPv6: proto = IPPROTO_ICMPV6; break;
				// signature matching against outer packet headers of IP-in-IP
				// tunneling not supported, so do a no-op there
				case zeek::detail::RuleHdrTest::IP: proto = 0; break;
				case zeek::detail::RuleHdrTest::IPv6: proto = 0; break;
				case zeek::detail::RuleHdrTest::TCP: proto = IPPROTO_TCP; break;
				case zeek::detail::RuleHdrTest::UDP: proto = IPPROTO_UDP; break;
				default:
					rules_error("internal_error: unknown protocol");
			}

			if ( proto ) {
				auto* vallist = new zeek::detail::maskedvalue_list;
				auto* val = new zeek::detail::MaskedValue();

				val->val = proto;
				val->mask = 0xffffffff;
				vallist->push_back(val);

				// offset & size params are dummies, actual next proto value in
				// header is retrieved dynamically via IP_Hdr::NextProto()
				current_rule->AddHdrTest(new zeek::detail::RuleHdrTest(
					zeek::detail::RuleHdrTest::NEXT, 0, 0,
					(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), vallist));
			}
			}
#line 1351 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 16: /* rule_attr: TOK_IP_PROTO TOK_COMP value_list  */
#line 185 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			// offset & size params are dummies, actual next proto value in
			// header is retrieved dynamically via IP_Hdr::NextProto()
			current_rule->AddHdrTest(new zeek::detail::RuleHdrTest(
				zeek::detail::RuleHdrTest::NEXT, 0, 0,
				(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), (yyvsp[0].vallist)));
			}
#line 1363 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 17: /* rule_attr: TOK_EVENT TOK_IDENT  */
#line 194 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			if ( is_event((yyvsp[0].str)) )
				current_rule->AddAction(new zeek::detail::RuleActionEvent(nullptr, (yyvsp[0].str)));
			else
				rules_error("identifier is not an event", (yyvsp[0].str));
			}
#line 1374 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 18: /* rule_attr: TOK_EVENT TOK_IDENT TOK_STRING  */
#line 202 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddAction(new zeek::detail::RuleActionEvent((yyvsp[0].str), (yyvsp[-1].str))); }
#line 1380 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 19: /* rule_attr: TOK_EVENT TOK_STRING  */
#line 205 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddAction(new zeek::detail::RuleActionEvent((yyvsp[0].str))); }
#line 1386 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 20: /* rule_attr: TOK_MIME string opt_strength  */
#line 208 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddAction(new zeek::detail::RuleActionMIME((yyvsp[-1].str), (yyvsp[0].val))); }
#line 1392 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 21: /* rule_attr: TOK_ENABLE TOK_STRING  */
#line 211 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddAction(new zeek::detail::RuleActionEnable((yyvsp[0].str))); }
#line 1398 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 22: /* rule_attr: TOK_DISABLE TOK_STRING  */
#line 214 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddAction(new zeek::detail::RuleActionDisable((yyvsp[0].str))); }
#line 1404 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 23: /* rule_attr: TOK_PATTERN_TYPE pattern  */
#line 217 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddPattern((yyvsp[0].str), (yyvsp[-1].ptype)); }
#line 1410 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 24: /* rule_attr: TOK_PATTERN_TYPE '[' rangeopt ']' pattern  */
#line 220 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			if ( (yyvsp[-2].range).offset > 0 )
				zeek::reporter->Warning("Offsets are currently ignored for patterns");
			current_rule->AddPattern((yyvsp[0].str), (yyvsp[-4].ptype), 0, (yyvsp[-2].range).len);
			}
#line 1420 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 25: /* rule_attr: TOK_PAYLOAD_SIZE TOK_COMP integer  */
#line 227 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			current_rule->AddCondition(
				new zeek::detail::RuleConditionPayloadSize((yyvsp[0].val), (zeek::detail::RuleConditionPayloadSize::Comp) ((yyvsp[-1].val))));
			}
#line 1429 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 26: /* rule_attr: TOK_REQUIRES_SIGNATURE TOK_IDENT  */
#line 233 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddRequires((yyvsp[0].str), false, false); }
#line 1435 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 27: /* rule_attr: TOK_REQUIRES_SIGNATURE '!' TOK_IDENT  */
#line 236 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddRequires((yyvsp[0].str), false, true); }
#line 1441 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 28: /* rule_attr: TOK_REQUIRES_REVERSE_SIGNATURE TOK_IDENT  */
#line 239 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddRequires((yyvsp[0].str), true, false); }
#line 1447 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 29: /* rule_attr: TOK_REQUIRES_REVERSE_SIGNATURE '!' TOK_IDENT  */
#line 242 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddRequires((yyvsp[0].str), true, true); }
#line 1453 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 30: /* rule_attr: TOK_SAME_IP  */
#line 245 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->AddCondition(new zeek::detail::RuleConditionSameIP()); }
#line 1459 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 31: /* rule_attr: TOK_SRC_IP TOK_COMP prefix_value_list  */
#line 248 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			current_rule->AddHdrTest(new zeek::detail::RuleHdrTest(
				zeek::detail::RuleHdrTest::IPSrc,
				(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), *((yyvsp[0].prefix_val_list))));
			}
#line 1469 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 32: /* rule_attr: TOK_SRC_PORT TOK_COMP value_list  */
#line 255 "/build/zeek/src/zeek/src/rule-parse.y"
                        { // Works for both TCP and UDP
			current_rule->AddHdrTest(new zeek::detail::RuleHdrTest(
				zeek::detail::RuleHdrTest::TCP, 0, 2,
				(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), (yyvsp[0].vallist)));
			}
#line 1479 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 33: /* rule_attr: TOK_TCP_STATE state_list  */
#line 262 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			current_rule->AddCondition(new zeek::detail::RuleConditionTCPState((yyvsp[0].val)));
			}
#line 1487 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 34: /* rule_attr: TOK_UDP_STATE state_list  */
#line 267 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			if ( (yyvsp[0].val) & zeek::detail::RULE_STATE_ESTABLISHED )
				rules_error("'established' is not a valid 'udp-state'");

			current_rule->AddCondition(new zeek::detail::RuleConditionUDPState((yyvsp[0].val)));
			}
#line 1498 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 35: /* rule_attr: TOK_ACTIVE TOK_BOOL  */
#line 275 "/build/zeek/src/zeek/src/rule-parse.y"
                        { current_rule->SetActiveStatus((yyvsp[0].bl)); }
#line 1504 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 36: /* hdr_expr: TOK_PROT '[' range ']' '&' integer TOK_COMP value  */
#line 280 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			auto* vallist = new zeek::detail::maskedvalue_list;
			auto* val = new zeek::detail::MaskedValue();

			val->val = (yyvsp[0].mval).val;
			val->mask = (yyvsp[-2].val);
			vallist->push_back(val);

			(yyval.hdr_test) = new zeek::detail::RuleHdrTest((yyvsp[-7].prot), (yyvsp[-5].range).offset, (yyvsp[-5].range).len,
					(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), vallist);
			}
#line 1520 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 37: /* hdr_expr: TOK_PROT '[' range ']' TOK_COMP value_list  */
#line 293 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.hdr_test) = new zeek::detail::RuleHdrTest((yyvsp[-5].prot), (yyvsp[-3].range).offset, (yyvsp[-3].range).len,
						(zeek::detail::RuleHdrTest::Comp) (yyvsp[-1].val), (yyvsp[0].vallist));
			}
#line 1529 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 38: /* value_list: value_list ',' value  */
#line 301 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyvsp[-2].vallist)->push_back(new zeek::detail::MaskedValue((yyvsp[0].mval))); (yyval.vallist) = (yyvsp[-2].vallist); }
#line 1535 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 39: /* value_list: value_list ',' ranged_value  */
#line 303 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			int numVals = (yyvsp[0].vallist)->length();
			for ( int idx = 0; idx < numVals; idx++ ) {
				zeek::detail::MaskedValue* val = (*(yyvsp[0].vallist))[idx];
				(yyvsp[-2].vallist)->push_back(val);
			}
			(yyval.vallist) = (yyvsp[-2].vallist);
			}
#line 1548 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 40: /* value_list: value_list ',' TOK_IDENT  */
#line 312 "/build/zeek/src/zeek/src/rule-parse.y"
                        { id_to_maskedvallist((yyvsp[0].str), (yyvsp[-2].vallist)); (yyval.vallist) = (yyvsp[-2].vallist); }
#line 1554 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 41: /* value_list: value  */
#line 314 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.vallist) = new zeek::detail::maskedvalue_list();
			(yyval.vallist)->push_back(new zeek::detail::MaskedValue((yyvsp[0].mval)));
			}
#line 1563 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 42: /* value_list: ranged_value  */
#line 319 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.vallist) = (yyvsp[0].vallist);
			}
#line 1571 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 43: /* value_list: TOK_IDENT  */
#line 323 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.vallist) = new zeek::detail::maskedvalue_list();
			id_to_maskedvallist((yyvsp[0].str), (yyval.vallist));
			}
#line 1580 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 44: /* prefix_value_list: prefix_value_list ',' prefix_value  */
#line 331 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.prefix_val_list) = (yyvsp[-2].prefix_val_list);
			(yyval.prefix_val_list)->push_back(*((yyvsp[0].prefixval)));
			}
#line 1589 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 45: /* prefix_value_list: prefix_value_list ',' TOK_IDENT  */
#line 336 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.prefix_val_list) = (yyvsp[-2].prefix_val_list);
			id_to_maskedvallist((yyvsp[0].str), 0, (yyvsp[-2].prefix_val_list));
			}
#line 1598 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 46: /* prefix_value_list: prefix_value  */
#line 341 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.prefix_val_list) = new std::vector<zeek::IPPrefix>();
			(yyval.prefix_val_list)->push_back(*((yyvsp[0].prefixval)));
			}
#line 1607 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 47: /* prefix_value_list: TOK_IDENT  */
#line 346 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.prefix_val_list) = new std::vector<zeek::IPPrefix>();
			id_to_maskedvallist((yyvsp[0].str), 0, (yyval.prefix_val_list));
			}
#line 1616 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 48: /* prefix_value: TOK_IP  */
#line 354 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.prefixval) = new zeek::IPPrefix(zeek::IPAddr(IPv4, &((yyvsp[0].mval).val), zeek::IPAddr::Host),
			                        ip4_mask_to_len((yyvsp[0].mval).mask));
			}
#line 1625 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 50: /* ranged_value: TOK_INT '-' TOK_INT  */
#line 363 "/build/zeek/src/zeek/src/rule-parse.y"
                        {
			(yyval.vallist) = new zeek::detail::maskedvalue_list();
			for ( int val = (yyvsp[-2].val); val <= (yyvsp[0].val); val++ ) {
				auto* masked = new zeek::detail::MaskedValue();
				masked->val = val;
				masked->mask = 0xffffffff;
				(yyval.vallist)->push_back(masked);
			}
			}
#line 1639 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 51: /* value: TOK_INT  */
#line 376 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.mval).val = (yyvsp[0].val); (yyval.mval).mask = 0xffffffff; }
#line 1645 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 53: /* rangeopt: range  */
#line 382 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.range) = (yyvsp[0].range); }
#line 1651 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 54: /* rangeopt: ':' integer  */
#line 384 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.range).offset = 0; (yyval.range).len = (yyvsp[0].val); }
#line 1657 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 55: /* rangeopt: integer ':'  */
#line 386 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.range).offset = (yyvsp[-1].val); (yyval.range).len = UINT_MAX; }
#line 1663 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 56: /* range: integer  */
#line 391 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.range).offset = (yyvsp[0].val); (yyval.range).len = 1; }
#line 1669 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 57: /* range: integer ':' integer  */
#line 393 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.range).offset = (yyvsp[-2].val); (yyval.range).len = (yyvsp[0].val); }
#line 1675 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 58: /* ipoption_list: ipoption_list ',' TOK_IP_OPTION_SYM  */
#line 398 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = (yyvsp[-2].val) | (yyvsp[0].val); }
#line 1681 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 59: /* ipoption_list: TOK_IP_OPTION_SYM  */
#line 400 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = (yyvsp[0].val); }
#line 1687 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 60: /* state_list: state_list ',' TOK_STATE_SYM  */
#line 405 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = (yyvsp[-2].val) | (yyvsp[0].val); }
#line 1693 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 61: /* state_list: TOK_STATE_SYM  */
#line 407 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = (yyvsp[0].val); }
#line 1699 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 62: /* integer: TOK_INT  */
#line 412 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = (yyvsp[0].val); }
#line 1705 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 63: /* integer: TOK_IDENT  */
#line 414 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = id_to_uint((yyvsp[0].str)); }
#line 1711 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 64: /* opt_negate: '-'  */
#line 419 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.bl) = true; }
#line 1717 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 65: /* opt_negate: %empty  */
#line 421 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.bl) = false; }
#line 1723 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 66: /* opt_strength: ',' opt_negate TOK_INT  */
#line 426 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = (yyvsp[-1].bl) ? -(yyvsp[0].val) : (yyvsp[0].val); }
#line 1729 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 67: /* opt_strength: %empty  */
#line 428 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.val) = 0; }
#line 1735 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 68: /* string: TOK_STRING  */
#line 433 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.str) = (yyvsp[0].str); }
#line 1741 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 69: /* string: TOK_IDENT  */
#line 435 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.str) = id_to_str((yyvsp[0].str)); }
#line 1747 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 70: /* pattern: TOK_PATTERN  */
#line 440 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.str) = (yyvsp[0].str); }
#line 1753 "/build/zeek/src/zeek/build/src/rup.cc"
    break;

  case 71: /* pattern: TOK_IDENT  */
#line 442 "/build/zeek/src/zeek/src/rule-parse.y"
                        { (yyval.str) = id_to_str((yyvsp[0].str)); }
#line 1759 "/build/zeek/src/zeek/build/src/rup.cc"
    break;


#line 1763 "/build/zeek/src/zeek/build/src/rup.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 445 "/build/zeek/src/zeek/src/rule-parse.y"


void rules_error(const char* msg) {
    zeek::reporter->Error("Error in signature (%s:%d): %s", current_rule_file, rules_line_number + 1, msg);
    zeek::detail::rule_matcher->SetParseError();
}

void rules_error(const char* msg, const char* addl) {
    zeek::reporter->Error("Error in signature (%s:%d): %s (%s)", current_rule_file, rules_line_number + 1, msg, addl);
    zeek::detail::rule_matcher->SetParseError();
}

void rules_error(zeek::detail::Rule* r, const char* msg) {
    const zeek::detail::Location& l = r->GetLocation();
    zeek::reporter->Error("Error in signature %s (%s:%d): %s", r->ID(), l.FileName(), l.FirstLine(), msg);
    zeek::detail::rule_matcher->SetParseError();
}

int rules_wrap(void) { return 1; }
