/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { z } from 'zod';
import type { IdeContext } from './types.js';
export declare const IdeDiffAcceptedNotificationSchema: z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    method: z.ZodLiteral<"ide/diffAccepted">;
    params: z.ZodObject<{
        filePath: z.ZodString;
        content: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        filePath: string;
        content: string;
    }, {
        filePath: string;
        content: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        filePath: string;
        content: string;
    };
    jsonrpc: "2.0";
    method: "ide/diffAccepted";
}, {
    params: {
        filePath: string;
        content: string;
    };
    jsonrpc: "2.0";
    method: "ide/diffAccepted";
}>;
export declare const IdeDiffClosedNotificationSchema: z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    method: z.ZodLiteral<"ide/diffClosed">;
    params: z.ZodObject<{
        filePath: z.ZodString;
        content: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        filePath: string;
        content?: string | undefined;
    }, {
        filePath: string;
        content?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        filePath: string;
        content?: string | undefined;
    };
    jsonrpc: "2.0";
    method: "ide/diffClosed";
}, {
    params: {
        filePath: string;
        content?: string | undefined;
    };
    jsonrpc: "2.0";
    method: "ide/diffClosed";
}>;
export declare const CloseDiffResponseSchema: z.ZodEffects<z.ZodObject<{
    content: z.ZodArray<z.ZodObject<{
        text: z.ZodString;
        type: z.ZodLiteral<"text">;
    }, "strip", z.ZodTypeAny, {
        text: string;
        type: "text";
    }, {
        text: string;
        type: "text";
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    content: {
        text: string;
        type: "text";
    }[];
}, {
    content: {
        text: string;
        type: "text";
    }[];
}>, {
    content?: string | undefined;
}, {
    content: {
        text: string;
        type: "text";
    }[];
}>;
export type DiffUpdateResult = {
    status: 'accepted';
    content?: string;
} | {
    status: 'rejected';
    content: undefined;
};
type IdeContextSubscriber = (ideContext: IdeContext | undefined) => void;
/**
 * Creates a new store for managing the IDE's context.
 * This factory function encapsulates the state and logic, allowing for the creation
 * of isolated instances, which is particularly useful for testing.
 *
 * @returns An object with methods to interact with the IDE context.
 */
export declare function createIdeContextStore(): {
    setIdeContext: (newIdeContext: IdeContext) => void;
    getIdeContext: () => IdeContext | undefined;
    subscribeToIdeContext: (subscriber: IdeContextSubscriber) => () => void;
    clearIdeContext: () => void;
};
/**
 * The default, shared instance of the IDE context store for the application.
 */
export declare const ideContext: {
    setIdeContext: (newIdeContext: IdeContext) => void;
    getIdeContext: () => IdeContext | undefined;
    subscribeToIdeContext: (subscriber: IdeContextSubscriber) => () => void;
    clearIdeContext: () => void;
};
export {};
