// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_ApplicationModel_DataTransfer_ShareTarget_H
#define WINRT_Windows_ApplicationModel_DataTransfer_ShareTarget_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.ApplicationModel.DataTransfer.h"
#include "winrt/impl/Windows.ApplicationModel.Contacts.2.h"
#include "winrt/impl/Windows.ApplicationModel.DataTransfer.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.ApplicationModel.DataTransfer.ShareTarget.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::Title() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::Title(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Title(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->put_Title(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::Thumbnail() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Thumbnail(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->get_Thumbnail(&value));
        }
        return winrt::Windows::Storage::Streams::RandomAccessStreamReference{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::Thumbnail(winrt::Windows::Storage::Streams::RandomAccessStreamReference const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Thumbnail(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->put_Thumbnail(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::Id() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::Id(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Id(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->put_Id(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::SupportedDataFormats() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedDataFormats(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->get_SupportedDataFormats(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IQuickLink<D>::SupportedFileTypes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedFileTypes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>**)this;
            check_hresult(_winrt_abi_type->get_SupportedFileTypes(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::ApplicationModel::DataTransfer::DataPackageView{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::QuickLinkId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_QuickLinkId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->get_QuickLinkId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::RemoveThisQuickLink() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveThisQuickLink());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->RemoveThisQuickLink());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::ReportStarted() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportStarted());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->ReportStarted());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::ReportDataRetrieved() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportDataRetrieved());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->ReportDataRetrieved());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::ReportSubmittedBackgroundTask() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportSubmittedBackgroundTask());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->ReportSubmittedBackgroundTask());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::ReportCompleted(winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::QuickLink const& quicklink) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportCompletedWithQuickLink(*(void**)(&quicklink)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->ReportCompletedWithQuickLink(*(void**)(&quicklink)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::ReportCompleted() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportCompleted());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->ReportCompleted());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation<D>::ReportError(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReportError(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>**)this;
            check_hresult(_winrt_abi_type->ReportError(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation2<D>::DismissUI() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DismissUI());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation2>**)this;
            check_hresult(_winrt_abi_type->DismissUI());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_DataTransfer_ShareTarget_IShareOperation3<D>::Contacts() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Contacts(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation3>**)this;
            check_hresult(_winrt_abi_type->get_Contacts(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Contacts::Contact>{ value, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink> : produce_base<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink>
    {
        int32_t __stdcall get_Title(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Title());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Title(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Title(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Thumbnail(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::RandomAccessStreamReference>(this->shim().Thumbnail());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Thumbnail(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Thumbnail(*reinterpret_cast<winrt::Windows::Storage::Streams::RandomAccessStreamReference const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Id(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Id(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Id(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedDataFormats(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<hstring>>(this->shim().SupportedDataFormats());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedFileTypes(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<hstring>>(this->shim().SupportedFileTypes());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation> : produce_base<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation>
    {
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::DataTransfer::DataPackageView>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_QuickLinkId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().QuickLinkId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveThisQuickLink() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveThisQuickLink();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportStarted() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportStarted();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportDataRetrieved() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportDataRetrieved();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportSubmittedBackgroundTask() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportSubmittedBackgroundTask();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportCompletedWithQuickLink(void* quicklink) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportCompleted(*reinterpret_cast<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::QuickLink const*>(&quicklink));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportCompleted() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportCompleted();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReportError(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReportError(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation2> : produce_base<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation2>
    {
        int32_t __stdcall DismissUI() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DismissUI();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation3> : produce_base<D, winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation3>
    {
        int32_t __stdcall get_Contacts(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Contacts::Contact>>(this->shim().Contacts());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::ApplicationModel::DataTransfer::ShareTarget
{
    inline QuickLink::QuickLink() :
        QuickLink(impl::call_factory_cast<QuickLink(*)(winrt::Windows::Foundation::IActivationFactory const&), QuickLink>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<QuickLink>(); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IQuickLink> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::IShareOperation3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::QuickLink> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::DataTransfer::ShareTarget::ShareOperation> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
