;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Same as inlining-trivial-calls-2, but the "trivial call" omits an
;; argument from its own arguments.
;;
;; This can result in `drop` instructions at the call sites and increase binary
;; sizes. So we don't inline these calls when optimizing for binary sizes.

;; RUN: foreach %s %t wasm-opt -all --inlining --shrink-level=0 -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt -all --inlining --shrink-level=1 -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt -all --inlining --shrink-level=2 -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt -all --inlining --shrink-level=3 -S -o - | filecheck %s

(module
 ;; CHECK:      (type $1 (func (param i32 i32)))

 ;; CHECK:      (type $0 (func (param i32 i32 i32)))
 (type $0 (func (param i32 i32 i32)))
 (type $1 (func (param i32 i32)))
 ;; CHECK:      (type $2 (func))
 (type $2 (func))
 ;; CHECK:      (import "env" "foo" (func $imported-foo (type $1) (param i32 i32)))
 (import "env" "foo" (func $imported-foo (type $1) (param i32 i32)))
 ;; CHECK:      (func $call-foo (type $0) (param $p1 i32) (param $p2 i32) (param $p3 i32)
 ;; CHECK-NEXT:  (call $imported-foo
 ;; CHECK-NEXT:   (local.get $p1)
 ;; CHECK-NEXT:   (local.get $p3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $call-foo (type $0) (param $p1 i32) (param $p2 i32) (param $p3 i32)
  (call $imported-foo
   (local.get $p1)
   (local.get $p3)
  )
 )
 ;; CHECK:      (func $main (type $2)
 ;; CHECK-NEXT:  (call $call-foo
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (i32.const 3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $call-foo
 ;; CHECK-NEXT:   (i32.const 4)
 ;; CHECK-NEXT:   (i32.const 5)
 ;; CHECK-NEXT:   (i32.const 6)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $call-foo
 ;; CHECK-NEXT:   (i32.const 7)
 ;; CHECK-NEXT:   (i32.const 8)
 ;; CHECK-NEXT:   (i32.const 9)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $main (type $2)
  (call $call-foo
   (i32.const 1)
   (i32.const 2)
   (i32.const 3)
  )
  (call $call-foo
   (i32.const 4)
   (i32.const 5)
   (i32.const 6)
  )
  (call $call-foo
   (i32.const 7)
   (i32.const 8)
   (i32.const 9)
  )
 )
)
