# based on https://github.com/stedolan/jq/blob/master/docs/content/manual/manual.yml
# partially generated using get_docs.jq
def docs:
{
  "@text/0": "Calls tostring, see that function for details.",
  "@json/0": "Serializes the input as JSON.",
  "@html/0": "Applies HTML/XML escaping, by mapping the characters <>&'\" to their entity equivalents &lt;, &gt;, &amp;, &apos;, &quot;.",
  "@uri/0": "Applies percent-encoding, by mapping all reserved URI characters to a %XX sequence.",
  "@urid/0": "The inverse of `@uri`, applies percent-decoding, by mapping all `%XX` sequences to their corresponding URI characters.",
  "@csv/0": "The input must be an array, and it is rendered as CSV with double quotes for strings, and quotes escaped by repetition.",
  "@tsv/0": "The input must be an array, and it is rendered as TSV (tab-separated values). Each input array will be printed as a single line. Fields are separated by a single tab (ascii 0x09). Input characters line-feed (ascii 0x0a), carriage-return (ascii 0x0d), tab (ascii 0x09) and backslash (ascii 0x5c) will be output as escape sequences \n, \r, \t, \\ respectively.",
  "@sh/0": "The input is escaped suitable for use in a command-line for a POSIX shell. If the input is an array, the output will be a series of space-separated strings.",
  "@base64/0": "The input is converted to base64 as specified by RFC 4648.",
  "@base64d/0": "The inverse of @base64, input is decoded as specified by RFC 4648. Note: If the decoded string is not UTF-8, the results are undefined.",

  "null/0": "return `null` value",
  "true/0": "return `true` value",
  "false/0": "retrun `false` value",

  "IN/1": "jq provides a few SQL-style operators.\n\n* `INDEX(stream; index_expression)`:\n\n  This builtin produces an object whose keys are computed by\n  the given index expression applied to each value from the\n  given stream.\n\n* `JOIN($idx; stream; idx_expr; join_expr)`:\n\n  This builtin joins the values from the given stream to the\n  given index.  The index's keys are computed by applying the\n  given index expression to each value from the given stream.\n  An array of the value in the stream and the corresponding\n  value from the index is fed to the given join expression to\n  produce each result.\n\n* `JOIN($idx; stream; idx_expr)`:\n\n  Same as `JOIN($idx; stream; idx_expr; .)`.\n\n* `JOIN($idx; idx_expr)`:\n\n  This builtin joins the input `.` to the given index, applying\n  the given index expression to `.` to compute the index key.\n  The join operation is as described above.\n\n* `IN(s)`:\n\n  This builtin outputs `true` if `.` appears in the given\n  stream, otherwise it outputs `false`.\n\n* `IN(source; s)`:\n\n  This builtin outputs `true` if any value in the source stream\n  appears in the second stream, otherwise it outputs `false`.",
  "IN/2": "jq provides a few SQL-style operators.\n\n* `INDEX(stream; index_expression)`:\n\n  This builtin produces an object whose keys are computed by\n  the given index expression applied to each value from the\n  given stream.\n\n* `JOIN($idx; stream; idx_expr; join_expr)`:\n\n  This builtin joins the values from the given stream to the\n  given index.  The index's keys are computed by applying the\n  given index expression to each value from the given stream.\n  An array of the value in the stream and the corresponding\n  value from the index is fed to the given join expression to\n  produce each result.\n\n* `JOIN($idx; stream; idx_expr)`:\n\n  Same as `JOIN($idx; stream; idx_expr; .)`.\n\n* `JOIN($idx; idx_expr)`:\n\n  This builtin joins the input `.` to the given index, applying\n  the given index expression to `.` to compute the index key.\n  The join operation is as described above.\n\n* `IN(s)`:\n\n  This builtin outputs `true` if `.` appears in the given\n  stream, otherwise it outputs `false`.\n\n* `IN(source; s)`:\n\n  This builtin outputs `true` if any value in the source stream\n  appears in the second stream, otherwise it outputs `false`.",
  "INDEX/2": "jq provides a few SQL-style operators.\n\n* `INDEX(stream; index_expression)`:\n\n  This builtin produces an object whose keys are computed by\n  the given index expression applied to each value from the\n  given stream.\n\n* `JOIN($idx; stream; idx_expr; join_expr)`:\n\n  This builtin joins the values from the given stream to the\n  given index.  The index's keys are computed by applying the\n  given index expression to each value from the given stream.\n  An array of the value in the stream and the corresponding\n  value from the index is fed to the given join expression to\n  produce each result.\n\n* `JOIN($idx; stream; idx_expr)`:\n\n  Same as `JOIN($idx; stream; idx_expr; .)`.\n\n* `JOIN($idx; idx_expr)`:\n\n  This builtin joins the input `.` to the given index, applying\n  the given index expression to `.` to compute the index key.\n  The join operation is as described above.\n\n* `IN(s)`:\n\n  This builtin outputs `true` if `.` appears in the given\n  stream, otherwise it outputs `false`.\n\n* `IN(source; s)`:\n\n  This builtin outputs `true` if any value in the source stream\n  appears in the second stream, otherwise it outputs `false`.",
  "JOIN/2": "jq provides a few SQL-style operators.\n\n* `INDEX(stream; index_expression)`:\n\n  This builtin produces an object whose keys are computed by\n  the given index expression applied to each value from the\n  given stream.\n\n* `JOIN($idx; stream; idx_expr; join_expr)`:\n\n  This builtin joins the values from the given stream to the\n  given index.  The index's keys are computed by applying the\n  given index expression to each value from the given stream.\n  An array of the value in the stream and the corresponding\n  value from the index is fed to the given join expression to\n  produce each result.\n\n* `JOIN($idx; stream; idx_expr)`:\n\n  Same as `JOIN($idx; stream; idx_expr; .)`.\n\n* `JOIN($idx; idx_expr)`:\n\n  This builtin joins the input `.` to the given index, applying\n  the given index expression to `.` to compute the index key.\n  The join operation is as described above.\n\n* `IN(s)`:\n\n  This builtin outputs `true` if `.` appears in the given\n  stream, otherwise it outputs `false`.\n\n* `IN(source; s)`:\n\n  This builtin outputs `true` if any value in the source stream\n  appears in the second stream, otherwise it outputs `false`.",
  "JOIN/3": "jq provides a few SQL-style operators.\n\n* `INDEX(stream; index_expression)`:\n\n  This builtin produces an object whose keys are computed by\n  the given index expression applied to each value from the\n  given stream.\n\n* `JOIN($idx; stream; idx_expr; join_expr)`:\n\n  This builtin joins the values from the given stream to the\n  given index.  The index's keys are computed by applying the\n  given index expression to each value from the given stream.\n  An array of the value in the stream and the corresponding\n  value from the index is fed to the given join expression to\n  produce each result.\n\n* `JOIN($idx; stream; idx_expr)`:\n\n  Same as `JOIN($idx; stream; idx_expr; .)`.\n\n* `JOIN($idx; idx_expr)`:\n\n  This builtin joins the input `.` to the given index, applying\n  the given index expression to `.` to compute the index key.\n  The join operation is as described above.\n\n* `IN(s)`:\n\n  This builtin outputs `true` if `.` appears in the given\n  stream, otherwise it outputs `false`.\n\n* `IN(source; s)`:\n\n  This builtin outputs `true` if any value in the source stream\n  appears in the second stream, otherwise it outputs `false`.",
  "JOIN/4": "jq provides a few SQL-style operators.\n\n* `INDEX(stream; index_expression)`:\n\n  This builtin produces an object whose keys are computed by\n  the given index expression applied to each value from the\n  given stream.\n\n* `JOIN($idx; stream; idx_expr; join_expr)`:\n\n  This builtin joins the values from the given stream to the\n  given index.  The index's keys are computed by applying the\n  given index expression to each value from the given stream.\n  An array of the value in the stream and the corresponding\n  value from the index is fed to the given join expression to\n  produce each result.\n\n* `JOIN($idx; stream; idx_expr)`:\n\n  Same as `JOIN($idx; stream; idx_expr; .)`.\n\n* `JOIN($idx; idx_expr)`:\n\n  This builtin joins the input `.` to the given index, applying\n  the given index expression to `.` to compute the index key.\n  The join operation is as described above.\n\n* `IN(s)`:\n\n  This builtin outputs `true` if `.` appears in the given\n  stream, otherwise it outputs `false`.\n\n* `IN(source; s)`:\n\n  This builtin outputs `true` if any value in the source stream\n  appears in the second stream, otherwise it outputs `false`.",
  "abs/0": "The builtin function `abs` is defined naively as: `if . < 0 then - . else . end`.\n\nFor numeric input, this is the absolute value.  See the\nsection on the identity filter for the implications of this\ndefinition for numeric input.\n\nTo compute the absolute value of a number as a floating point number, you may wish use `fabs`.",
  "acos/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "acosh/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "add/0": "The filter `add` takes as input an array, and produces as\noutput the elements of the array added together. This might\nmean summed, concatenated or merged depending on the types\nof the elements of the input array - the rules are the same\nas those for the `+` operator (described above).\n\nIf the input is an empty array, `add` returns `null`.\n\n`add(generator)` operates on the given generator rather than\nthe input.",
  "add/1": "The filter `add` takes as input an array, and produces as\noutput the elements of the array added together. This might\nmean summed, concatenated or merged depending on the types\nof the elements of the input array - the rules are the same\nas those for the `+` operator (described above).\n\nIf the input is an empty array, `add` returns `null`.\n\n`add(generator)` operates on the given generator rather than\nthe input.",
  "all/0": "The filter `all` takes as input an array of boolean values,\nand produces `true` as output if all of the elements of\nthe array are `true`.\n\nThe `all(condition)` form applies the given condition to the\nelements of the input array.\n\nThe `all(generator; condition)` form applies the given\ncondition to all the outputs of the given generator.\n\nIf the input is an empty array, `all` returns `true`.",
  "all/1": "The filter `all` takes as input an array of boolean values,\nand produces `true` as output if all of the elements of\nthe array are `true`.\n\nThe `all(condition)` form applies the given condition to the\nelements of the input array.\n\nThe `all(generator; condition)` form applies the given\ncondition to all the outputs of the given generator.\n\nIf the input is an empty array, `all` returns `true`.",
  "all/2": "The filter `all` takes as input an array of boolean values,\nand produces `true` as output if all of the elements of\nthe array are `true`.\n\nThe `all(condition)` form applies the given condition to the\nelements of the input array.\n\nThe `all(generator; condition)` form applies the given\ncondition to all the outputs of the given generator.\n\nIf the input is an empty array, `all` returns `true`.",
  "any/0": "The filter `any` takes as input an array of boolean values,\nand produces `true` as output if any of the elements of\nthe array are `true`.\n\nIf the input is an empty array, `any` returns `false`.\n\nThe `any(condition)` form applies the given condition to the\nelements of the input array.\n\nThe `any(generator; condition)` form applies the given\ncondition to all the outputs of the given generator.",
  "any/1": "The filter `any` takes as input an array of boolean values,\nand produces `true` as output if any of the elements of\nthe array are `true`.\n\nIf the input is an empty array, `any` returns `false`.\n\nThe `any(condition)` form applies the given condition to the\nelements of the input array.\n\nThe `any(generator; condition)` form applies the given\ncondition to all the outputs of the given generator.",
  "any/2": "The filter `any` takes as input an array of boolean values,\nand produces `true` as output if any of the elements of\nthe array are `true`.\n\nIf the input is an empty array, `any` returns `false`.\n\nThe `any(condition)` form applies the given condition to the\nelements of the input array.\n\nThe `any(generator; condition)` form applies the given\ncondition to all the outputs of the given generator.",
  "arrays/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "ascii_downcase/0": "Emit a copy of the input string with its alphabetic characters (a-z and A-Z)\nconverted to the specified case.",
  "ascii_upcase/0": "Emit a copy of the input string with its alphabetic characters (a-z and A-Z)\nconverted to the specified case.",
  "asin/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "asinh/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "atan/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "atan2` `copysign` `drem/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "atanh/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "booleans/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "bsearch/1": "`bsearch(x)` conducts a binary search for x in the input\narray.  If the input is sorted and contains x, then\n`bsearch(x)` will return its index in the array; otherwise, if\nthe array is sorted, it will return (-1 - ix) where ix is an\ninsertion point such that the array would still be sorted\nafter the insertion of x at ix.  If the array is not sorted,\n`bsearch(x)` will return an integer that is probably of no\ninterest.",
  "builtins/0": "Returns a list of all builtin functions in the format `name/arity`.\nSince functions with the same name but different arities are considered\nseparate functions, `all/0`, `all/1`, and `all/2` would all be present\nin the list.",
  "capture/1": "Collects the named captures in a JSON object, with the name\nof each capture as the key, and the matched string as the\ncorresponding value.",
  "capture/2": "Collects the named captures in a JSON object, with the name\nof each capture as the key, and the matched string as the\ncorresponding value.",
  "cbrt/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "ceil/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "combinations/0": "Outputs all combinations of the elements of the arrays in the\ninput array. If given an argument `n`, it outputs all combinations\nof `n` repetitions of the input array.",
  "combinations/1": "Outputs all combinations of the elements of the arrays in the\ninput array. If given an argument `n`, it outputs all combinations\nof `n` repetitions of the input array.",
  "contains/1": "The filter `contains(b)` will produce true if b is\ncompletely contained within the input. A string B is\ncontained in a string A if B is a substring of A. An array B\nis contained in an array A if all elements in B are\ncontained in any element in A. An object B is contained in\nobject A if all of the values in B are contained in the\nvalue in A with the same key. All other types are assumed to\nbe contained in each other if they are equal.",
  "cos/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "cosh/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "debug/0": "These two filters are like `.` but have as a side-effect the\nproduction of one or more messages on stderr.\n\nThe message produced by the `debug` filter has the form\n\n    [\"DEBUG:\",<input-value>]\n\nwhere `<input-value>` is a compact rendition of the input\nvalue.  This format may change in the future.\n\nThe `debug(msgs)` filter is defined as `(msgs | debug | empty), .`\nthus allowing great flexibility in the content of the message,\nwhile also allowing multi-line debugging statements to be created.\n\nFor example, the expression:\n\n    1 as $x | 2 | debug(\"Entering function foo with $x == \\($x)\", .) | (.+1)\n\nwould produce the value 3 but with the following two lines\nbeing written to stderr:\n\n    [\"DEBUG:\",\"Entering function foo with $x == 1\"]\n    [\"DEBUG:\",2]",
  "debug/1": "These two filters are like `.` but have as a side-effect the\nproduction of one or more messages on stderr.\n\nThe message produced by the `debug` filter has the form\n\n    [\"DEBUG:\",<input-value>]\n\nwhere `<input-value>` is a compact rendition of the input\nvalue.  This format may change in the future.\n\nThe `debug(msgs)` filter is defined as `(msgs | debug | empty), .`\nthus allowing great flexibility in the content of the message,\nwhile also allowing multi-line debugging statements to be created.\n\nFor example, the expression:\n\n    1 as $x | 2 | debug(\"Entering function foo with $x == \\($x)\", .) | (.+1)\n\nwould produce the value 3 but with the following two lines\nbeing written to stderr:\n\n    [\"DEBUG:\",\"Entering function foo with $x == 1\"]\n    [\"DEBUG:\",2]",
  "del/1": "The builtin function `del` removes a key and its corresponding\nvalue from an object.",
  "delpaths/1": "The builtin function `delpaths` deletes the `PATHS` in `.`.\n`PATHS` must be an array of paths, where each path is an array\nof strings and numbers.",
  "empty/0": "`empty` returns no results. None at all. Not even `null`.\n\nIt's useful on occasion. You'll know if you need it :)",
  "endswith/1": "Outputs `true` if . ends with the given string argument.",
  "env/0": "`$ENV` is an object representing the environment variables as\nset when the jq program started.\n\n`env` outputs an object representing jq's current environment.\n\nAt the moment there is no builtin for setting environment\nvariables.",
  "erf/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "erfc/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "error/0": "Produces an error with the input value, or with the message\ngiven as the argument. Errors can be caught with try/catch;\nsee below.",
  "error/1": "Produces an error with the input value, or with the message\ngiven as the argument. Errors can be caught with try/catch;\nsee below.",
  "exp/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "exp10/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "exp2/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "explode/0": "Converts an input string into an array of the string's\ncodepoint numbers.",
  "expm1/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "fabs/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "fdim/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "finites/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "first/0": "The `first` and `last` functions extract the first\nand last values from any array at `.`.\n\nThe `nth(n)` function extracts the nth value of any array at `.`.",
  "first/1": "The `first(expr)` and `last(expr)` functions extract the first\nand last values from `expr`, respectively.\n\nThe `nth(n; expr)` function extracts the nth value output by `expr`.\nNote that `nth(n; expr)` doesn't support negative values of `n`.",
  "flatten/0": "The filter `flatten` takes as input an array of nested arrays,\nand produces a flat array in which all arrays inside the original\narray have been recursively replaced by their values. You can pass\nan argument to it to specify how many levels of nesting to flatten.\n\n`flatten(2)` is like `flatten`, but going only up to two\nlevels deep.",
  "flatten/1": "The filter `flatten` takes as input an array of nested arrays,\nand produces a flat array in which all arrays inside the original\narray have been recursively replaced by their values. You can pass\nan argument to it to specify how many levels of nesting to flatten.\n\n`flatten(2)` is like `flatten`, but going only up to two\nlevels deep.",
  "floor/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "fma/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "fmax/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "fmin/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "fmod/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "foreach/0": "The `foreach` syntax is similar to `reduce`, but intended to\nallow the construction of `limit` and reducers that produce\nintermediate results.\n\nThe form is `foreach EXP as $var (INIT; UPDATE; EXTRACT)`.\nAs an example, we'll pass `[1,2,3]` to this expression:\n\n    foreach .[] as $item (0; . + $item; [$item, . * 2])\n\nLike the `reduce` syntax, `. + $item` is run for each result\nthat `.[]` produces, but `[$item, . * 2]` is run for each\nintermediate values. In this example, since the intermediate\nvalues are `1`, `3`, and `6`, the `foreach` expression produces\n`[1,2]`, `[2,6]`, and `[3,12]`. So the effect is similar\nto running something like this:\n\n    0 | 1 as $item | . + $item | [$item, . * 2],\n        2 as $item | . + $item | [$item, . * 2],\n        3 as $item | . + $item | [$item, . * 2]\n\nWhen `EXTRACT` is omitted, the identity filter is used.\nThat is, it outputs the intermediate values as they are.",
  "frexp/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "from_entries/0": "These functions convert between an object and an array of\nkey-value pairs. If `to_entries` is passed an object, then\nfor each `k: v` entry in the input, the output array\nincludes `{\"key\": k, \"value\": v}`.\n\n`from_entries` does the opposite conversion, and `with_entries(f)`\nis a shorthand for `to_entries | map(f) | from_entries`, useful for\ndoing some operation to all keys and values of an object.\n`from_entries` accepts `\"key\"`, `\"Key\"`, `\"name\"`, `\"Name\"`,\n`\"value\"`, and `\"Value\"` as keys.",
  "fromdate/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "fromdateiso8601/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "fromjson/0": "The `tojson` and `fromjson` builtins dump values as JSON texts\nor parse JSON texts into values, respectively.  The `tojson`\nbuiltin differs from `tostring` in that `tostring` returns strings\nunmodified, while `tojson` encodes strings as JSON strings.",
  "fromstream/1": "Outputs values corresponding to the stream expression's\noutputs.",
  "gamma/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "getpath/1": "The builtin function `getpath` outputs the values in `.` found\nat each path in `PATHS`.",
  "gmtime/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "group_by/1": "`group_by(.foo)` takes as input an array, groups the\nelements having the same `.foo` field into separate arrays,\nand produces all of these arrays as elements of a larger\narray, sorted by the value of the `.foo` field.\n\nAny jq expression, not just a field access, may be used in\nplace of `.foo`. The sorting order is the same as described\nin the `sort` function above.",
  "gsub/2": "`gsub` is like `sub` but all the non-overlapping occurrences of the regex are\nreplaced by `tostring`, after interpolation. If the second argument is a stream\nof jq strings, then `gsub` will produce a corresponding stream of JSON strings.",
  "gsub/3": "`gsub` is like `sub` but all the non-overlapping occurrences of the regex are\nreplaced by `tostring`, after interpolation. If the second argument is a stream\nof jq strings, then `gsub` will produce a corresponding stream of JSON strings.",
  "halt/0": "Stops the jq program with no further outputs.  jq will exit\nwith exit status `0`.",
  "halt_error/0": "Stops the jq program with no further outputs.  The input will\nbe printed on `stderr` as raw output (i.e., strings will not\nhave double quotes) with no decoration, not even a newline.\n\nThe given `exit_code` (defaulting to `5`) will be jq's exit\nstatus.\n\nFor example, `\"Error: something went wrong\\n\"|halt_error(1)`.",
  "halt_error/1": "Stops the jq program with no further outputs.  The input will\nbe printed on `stderr` as raw output (i.e., strings will not\nhave double quotes) with no decoration, not even a newline.\n\nThe given `exit_code` (defaulting to `5`) will be jq's exit\nstatus.\n\nFor example, `\"Error: something went wrong\\n\"|halt_error(1)`.",
  "has/1": "The builtin function `has` returns whether the input object\nhas the given key, or the input array has an element at the\ngiven index.\n\n`has($key)` has the same effect as checking whether `$key`\nis a member of the array returned by `keys`, although `has`\nwill be faster.",
  "have_decnum/0": "This builtin returns true if jq was built with \"decnum\",\nwhich is the current literal number preserving numeric\nbackend implementation for jq.",
  "have_literal_numbers/0": "This builtin returns true if jq's build configuration\nincludes support for preservation of input number literals.",
  "hypot/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "implode/0": "The inverse of explode.",
  "import RelativePathString as $NAME [<metadata>];/0": "Imports a JSON file found at the given path relative to a\ndirectory in a search path.  A `.json` suffix will be added to\nthe relative path string.  The file's data will be available\nas `$NAME::NAME`.\n\nThe optional metadata must be a constant jq expression.  It\nshould be an object with keys like `homepage` and so on.  At\nthis time jq only uses the `search` key/value of the metadata.\nThe metadata is also made available to users via the\n`modulemeta` builtin.\n\nThe `search` key in the metadata, if present, should have a\nstring or array value (array of strings); this is the search\npath to be prefixed to the top-level search path.",
  "import RelativePathString as NAME [<metadata>];/0": "Imports a module found at the given path relative to a\ndirectory in a search path.  A `.jq` suffix will be added to\nthe relative path string.  The module's symbols are prefixed\nwith `NAME::`.\n\nThe optional metadata must be a constant jq expression.  It\nshould be an object with keys like `homepage` and so on.  At\nthis time jq only uses the `search` key/value of the metadata.\nThe metadata is also made available to users via the\n`modulemeta` builtin.\n\nThe `search` key in the metadata, if present, should have a\nstring or array value (array of strings); this is the search\npath to be prefixed to the top-level search path.",
  "in/0": "The builtin function `in` returns whether or not the input key is in the\ngiven object, or the input index corresponds to an element\nin the given array. It is, essentially, an inversed version\nof `has`.",
  "include RelativePathString [<metadata>];/0": "Imports a module found at the given path relative to a\ndirectory in a search path as if it were included in place.  A\n`.jq` suffix will be added to the relative path string.  The\nmodule's symbols are imported into the caller's namespace as\nif the module's content had been included directly.\n\nThe optional metadata must be a constant jq expression.  It\nshould be an object with keys like `homepage` and so on.  At\nthis time jq only uses the `search` key/value of the metadata.\nThe metadata is also made available to users via the\n`modulemeta` builtin.",
  "index/1": "Outputs the index of the first (`index`) or last (`rindex`)\noccurrence of `s` in the input.",
  "indices/1": "Outputs an array containing the indices in `.` where `s`\noccurs.  The input may be an array, in which case if `s` is an\narray then the indices output will be those where all elements\nin `.` match those of `s`.",
  "infinite/0": "Some arithmetic operations can yield infinities and \"not a\nnumber\" (NaN) values.  The `isinfinite` builtin returns `true`\nif its input is infinite.  The `isnan` builtin returns `true`\nif its input is a NaN.  The `infinite` builtin returns a\npositive infinite value.  The `nan` builtin returns a NaN.\nThe `isnormal` builtin returns true if its input is a normal\nnumber.\n\nNote that division by zero raises an error.\n\nCurrently most arithmetic operations operating on infinities,\nNaNs, and sub-normals do not raise errors.",
  "input/0": "Outputs one new input.\n\nNote that when using `input` it is generally be necessary to\ninvoke jq with the `-n` command-line option, otherwise\nthe first entity will be lost.\n\n    echo 1 2 3 4 | jq '[., input]' # [1,2] [3,4]",
  "input_filename/0": "Returns the name of the file whose input is currently being\nfiltered.  Note that this will not work well unless jq is\nrunning in a UTF-8 locale.",
  "input_line_number/0": "Returns the line number of the input currently being filtered.",
  "inputs/0": "Outputs all remaining inputs, one by one.\n\nThis is primarily useful for reductions over a program's\ninputs.  Note that when using `inputs` it is generally necessary\nto invoke jq with the `-n` command-line option, otherwise\nthe first entity will be lost.\n\n    echo 1 2 3 | jq -n 'reduce inputs as $i (0; . + $i)' # 6",
  "inside/0": "The filter `inside(b)` will produce true if the input is\ncompletely contained within b. It is, essentially, an\ninversed version of `contains`.",
  "isempty/1": "Returns true if `exp` produces no outputs, false otherwise.",
  "isfinite/0": "Some arithmetic operations can yield infinities and \"not a\nnumber\" (NaN) values.  The `isinfinite` builtin returns `true`\nif its input is infinite.  The `isnan` builtin returns `true`\nif its input is a NaN.  The `infinite` builtin returns a\npositive infinite value.  The `nan` builtin returns a NaN.\nThe `isnormal` builtin returns true if its input is a normal\nnumber.\n\nNote that division by zero raises an error.\n\nCurrently most arithmetic operations operating on infinities,\nNaNs, and sub-normals do not raise errors.",
  "isinfinite/0": "Some arithmetic operations can yield infinities and \"not a\nnumber\" (NaN) values.  The `isinfinite` builtin returns `true`\nif its input is infinite.  The `isnan` builtin returns `true`\nif its input is a NaN.  The `infinite` builtin returns a\npositive infinite value.  The `nan` builtin returns a NaN.\nThe `isnormal` builtin returns true if its input is a normal\nnumber.\n\nNote that division by zero raises an error.\n\nCurrently most arithmetic operations operating on infinities,\nNaNs, and sub-normals do not raise errors.",
  "isnan/0": "Some arithmetic operations can yield infinities and \"not a\nnumber\" (NaN) values.  The `isinfinite` builtin returns `true`\nif its input is infinite.  The `isnan` builtin returns `true`\nif its input is a NaN.  The `infinite` builtin returns a\npositive infinite value.  The `nan` builtin returns a NaN.\nThe `isnormal` builtin returns true if its input is a normal\nnumber.\n\nNote that division by zero raises an error.\n\nCurrently most arithmetic operations operating on infinities,\nNaNs, and sub-normals do not raise errors.",
  "isnormal/0": "Some arithmetic operations can yield infinities and \"not a\nnumber\" (NaN) values.  The `isinfinite` builtin returns `true`\nif its input is infinite.  The `isnan` builtin returns `true`\nif its input is a NaN.  The `infinite` builtin returns a\npositive infinite value.  The `nan` builtin returns a NaN.\nThe `isnormal` builtin returns true if its input is a normal\nnumber.\n\nNote that division by zero raises an error.\n\nCurrently most arithmetic operations operating on infinities,\nNaNs, and sub-normals do not raise errors.",
  "iterables/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "j0/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "j1/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "jn/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "join/1": "Joins the array of elements given as input, using the\nargument as separator. It is the inverse of `split`: that is,\nrunning `split(\"foo\") | join(\"foo\")` over any input string\nreturns said input string.\n\nNumbers and booleans in the input are converted to strings.\nNull values are treated as empty strings. Arrays and objects\nin the input are not supported.",
  "keys/0": "The builtin function `keys`, when given an object, returns\nits keys in an array.\n\nThe keys are sorted \"alphabetically\", by unicode codepoint\norder. This is not an order that makes particular sense in\nany particular language, but you can count on it being the\nsame for any two objects with the same set of keys,\nregardless of locale settings.\n\nWhen `keys` is given an array, it returns the valid indices\nfor that array: the integers from 0 to length-1.\n\nThe `keys_unsorted` function is just like `keys`, but if\nthe input is an object then the keys will not be sorted,\ninstead the keys will roughly be in insertion order.",
  "keys_unsorted/0": "The builtin function `keys`, when given an object, returns\nits keys in an array.\n\nThe keys are sorted \"alphabetically\", by unicode codepoint\norder. This is not an order that makes particular sense in\nany particular language, but you can count on it being the\nsame for any two objects with the same set of keys,\nregardless of locale settings.\n\nWhen `keys` is given an array, it returns the valid indices\nfor that array: the integers from 0 to length-1.\n\nThe `keys_unsorted` function is just like `keys`, but if\nthe input is an object then the keys will not be sorted,\ninstead the keys will roughly be in insertion order.",
  "last/0": "The `first` and `last` functions extract the first\nand last values from any array at `.`.\n\nThe `nth(n)` function extracts the nth value of any array at `.`.",
  "last/1": "The `first(expr)` and `last(expr)` functions extract the first\nand last values from `expr`, respectively.\n\nThe `nth(n; expr)` function extracts the nth value output by `expr`.\nNote that `nth(n; expr)` doesn't support negative values of `n`.",
  "ldexp/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "length/0": "The builtin function `length` gets the length of various\ndifferent types of value:\n\n- The length of a **string** is the number of Unicode\n  codepoints it contains (which will be the same as its\n  JSON-encoded length in bytes if it's pure ASCII).\n\n- The length of a **number** is its absolute value.\n\n- The length of an **array** is the number of elements.\n\n- The length of an **object** is the number of key-value pairs.\n\n- The length of **null** is zero.\n\n- It is an error to use `length` on a **boolean**.",
  "lgamma/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "limit/2": "The `limit` function extracts up to `n` outputs from `expr`.",
  "localtime/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "log/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "log10/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "log1p/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "log2/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "logb/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "ltrim/0": "`trim` trims both leading and trailing whitespace.\n\n`ltrim` trims only leading (left side) whitespace.\n\n`rtrim` trims only trailing (right side) whitespace.\n\nWhitespace characters are the usual `\" \"`, `\"\\n\"` `\"\\t\"`, `\"\\r\"`\nand also all characters in the Unicode character database with the\nwhitespace property. Note that what considers whitespace might\nchange in the future.",
  "ltrimstr/1": "Outputs its input with the given prefix string removed, if it\nstarts with it.",
  "map/1": "For any filter `f`, `map(f)` and `map_values(f)` apply `f`\nto each of the values in the input array or object, that is,\nto the values of `.[]`.\n\nIn the absence of errors, `map(f)` always outputs an array\nwhereas `map_values(f)` outputs an array if given an array,\nor an object if given an object.\n\nWhen the input to `map_values(f)` is an object, the output\nobject has the same keys as the input object except for\nthose keys whose values when piped to `f` produce no values\nat all.\n\nThe key difference between `map(f)` and `map_values(f)` is\nthat the former simply forms an array from all the values of\n`($x|f)` for each value, `$x`, in the input array or object,\nbut `map_values(f)` only uses `first($x|f)`.\n\nSpecifically, for object inputs, `map_values(f)` constructs\nthe output object by examining in turn the value of\n`first(.[$k]|f)` for each key, `$k`, of the input.  If this\nexpression produces no values, then the corresponding key\nwill be dropped; otherwise, the output object will have that\nvalue at the key, `$k`.\n\nHere are some examples to clarify the behavior of `map` and\n`map_values` when applied to arrays. These examples assume the\ninput is `[1]` in all cases:\n\n    map(.+1)          #=>  [2]\n    map(., .)         #=>  [1,1]\n    map(empty)        #=>  []\n\n    map_values(.+1)   #=>  [2]\n    map_values(., .)  #=>  [1]\n    map_values(empty) #=>  []\n\n`map(f)` is equivalent to `[.[] | f]` and\n`map_values(f)` is equivalent to `.[] |= f`.\n\nIn fact, these are their implementations.",
  "map_values/1": "For any filter `f`, `map(f)` and `map_values(f)` apply `f`\nto each of the values in the input array or object, that is,\nto the values of `.[]`.\n\nIn the absence of errors, `map(f)` always outputs an array\nwhereas `map_values(f)` outputs an array if given an array,\nor an object if given an object.\n\nWhen the input to `map_values(f)` is an object, the output\nobject has the same keys as the input object except for\nthose keys whose values when piped to `f` produce no values\nat all.\n\nThe key difference between `map(f)` and `map_values(f)` is\nthat the former simply forms an array from all the values of\n`($x|f)` for each value, `$x`, in the input array or object,\nbut `map_values(f)` only uses `first($x|f)`.\n\nSpecifically, for object inputs, `map_values(f)` constructs\nthe output object by examining in turn the value of\n`first(.[$k]|f)` for each key, `$k`, of the input.  If this\nexpression produces no values, then the corresponding key\nwill be dropped; otherwise, the output object will have that\nvalue at the key, `$k`.\n\nHere are some examples to clarify the behavior of `map` and\n`map_values` when applied to arrays. These examples assume the\ninput is `[1]` in all cases:\n\n    map(.+1)          #=>  [2]\n    map(., .)         #=>  [1,1]\n    map(empty)        #=>  []\n\n    map_values(.+1)   #=>  [2]\n    map_values(., .)  #=>  [1]\n    map_values(empty) #=>  []\n\n`map(f)` is equivalent to `[.[] | f]` and\n`map_values(f)` is equivalent to `.[] |= f`.\n\nIn fact, these are their implementations.",
  "match/1": "**match** outputs an object for each match it finds.  Matches have\nthe following fields:\n\n* `offset` - offset in UTF-8 codepoints from the beginning of the input\n* `length` - length in UTF-8 codepoints of the match\n* `string` - the string that it matched\n* `captures` - an array of objects representing capturing groups.\n\nCapturing group objects have the following fields:\n\n* `offset` - offset in UTF-8 codepoints from the beginning of the input\n* `length` - length in UTF-8 codepoints of this capturing group\n* `string` - the string that was captured\n* `name` - the name of the capturing group (or `null` if it was unnamed)\n\nCapturing groups that did not match anything return an offset of -1",
  "match/2": "**match** outputs an object for each match it finds.  Matches have\nthe following fields:\n\n* `offset` - offset in UTF-8 codepoints from the beginning of the input\n* `length` - length in UTF-8 codepoints of the match\n* `string` - the string that it matched\n* `captures` - an array of objects representing capturing groups.\n\nCapturing group objects have the following fields:\n\n* `offset` - offset in UTF-8 codepoints from the beginning of the input\n* `length` - length in UTF-8 codepoints of this capturing group\n* `string` - the string that was captured\n* `name` - the name of the capturing group (or `null` if it was unnamed)\n\nCapturing groups that did not match anything return an offset of -1",
  "max/0": "Find the minimum or maximum element of the input array.\n\nThe `min_by(path_exp)` and `max_by(path_exp)` functions allow\nyou to specify a particular field or property to examine, e.g.\n`min_by(.foo)` finds the object with the smallest `foo` field.",
  "max_by/1": "Find the minimum or maximum element of the input array.\n\nThe `min_by(path_exp)` and `max_by(path_exp)` functions allow\nyou to specify a particular field or property to examine, e.g.\n`min_by(.foo)` finds the object with the smallest `foo` field.",
  "min/0": "Find the minimum or maximum element of the input array.\n\nThe `min_by(path_exp)` and `max_by(path_exp)` functions allow\nyou to specify a particular field or property to examine, e.g.\n`min_by(.foo)` finds the object with the smallest `foo` field.",
  "min_by/1": "Find the minimum or maximum element of the input array.\n\nThe `min_by(path_exp)` and `max_by(path_exp)` functions allow\nyou to specify a particular field or property to examine, e.g.\n`min_by(.foo)` finds the object with the smallest `foo` field.",
  "mktime/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "modf/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "module <metadata>;/0": "This directive is entirely optional.  It's not required for\nproper operation.  It serves only the purpose of providing\nmetadata that can be read with the `modulemeta` builtin.\n\nThe metadata must be a constant jq expression.  It should be\nan object with keys like `homepage`.  At this time jq doesn't\nuse this metadata, but it is made available to users via the\n`modulemeta` builtin.",
  "modulemeta/0": "Takes a module name as input and outputs the module's metadata\nas an object, with the module's imports (including metadata)\nas an array value for the `deps` key and the module's defined\nfunctions as an array value for the `defs` key.\n\nPrograms can use this to query a module's metadata, which they\ncould then use to, for example, search for, download, and\ninstall missing dependencies.",
  "nan/0": "Some arithmetic operations can yield infinities and \"not a\nnumber\" (NaN) values.  The `isinfinite` builtin returns `true`\nif its input is infinite.  The `isnan` builtin returns `true`\nif its input is a NaN.  The `infinite` builtin returns a\npositive infinite value.  The `nan` builtin returns a NaN.\nThe `isnormal` builtin returns true if its input is a normal\nnumber.\n\nNote that division by zero raises an error.\n\nCurrently most arithmetic operations operating on infinities,\nNaNs, and sub-normals do not raise errors.",
  "nearbyint/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "nextafter/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "nexttoward/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "normals/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "now/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "nth/1": "The `first` and `last` functions extract the first\nand last values from any array at `.`.\n\nThe `nth(n)` function extracts the nth value of any array at `.`.",
  "nth/2": "The `first(expr)` and `last(expr)` functions extract the first\nand last values from `expr`, respectively.\n\nThe `nth(n; expr)` function extracts the nth value output by `expr`.\nNote that `nth(n; expr)` doesn't support negative values of `n`.",
  "nulls/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "numbers/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "objects/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "path/1": "Outputs array representations of the given path expression\nin `.`.  The outputs are arrays of strings (object keys)\nand/or numbers (array indices).\n\nPath expressions are jq expressions like `.a`, but also `.[]`.\nThere are two types of path expressions: ones that can match\nexactly, and ones that cannot.  For example, `.a.b.c` is an\nexact match path expression, while `.a[].b` is not.\n\n`path(exact_path_expression)` will produce the array\nrepresentation of the path expression even if it does not\nexist in `.`, if `.` is `null` or an array or an object.\n\n`path(pattern)` will produce array representations of the\npaths matching `pattern` if the paths exist in `.`.\n\nNote that the path expressions are not different from normal\nexpressions.  The expression\n`path(..|select(type==\"boolean\"))` outputs all the paths to\nboolean values in `.`, and only those paths.",
  "paths/0": "`paths` outputs the paths to all the elements in its input\n(except it does not output the empty list, representing .\nitself).\n\n`paths(f)` outputs the paths to any values for which `f` is `true`.\nThat is, `paths(type == \"number\")` outputs the paths to all numeric\nvalues.",
  "paths/1": "`paths` outputs the paths to all the elements in its input\n(except it does not output the empty list, representing .\nitself).\n\n`paths(f)` outputs the paths to any values for which `f` is `true`.\nThat is, `paths(type == \"number\")` outputs the paths to all numeric\nvalues.",
  "pick/1": "Emit the projection of the input object or array defined by the\nspecified sequence of path expressions, such that if `p` is any\none of these specifications, then `(. | p)` will evaluate to the\nsame value as `(. | pick(pathexps) | p)`. For arrays, negative\nindices and `.[m:n]` specifications should not be used.",
  "pow/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "pow10/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "range/1": "The `range` function produces a range of numbers. `range(4; 10)`\nproduces 6 numbers, from 4 (inclusive) to 10 (exclusive). The numbers\nare produced as separate outputs. Use `[range(4; 10)]` to get a range as\nan array.\n\nThe one argument form generates numbers from 0 to the given\nnumber, with an increment of 1.\n\nThe two argument form generates numbers from `from` to `upto`\nwith an increment of 1.\n\nThe three argument form generates numbers `from` to `upto`\nwith an increment of `by`.",
  "range/2": "The `range` function produces a range of numbers. `range(4; 10)`\nproduces 6 numbers, from 4 (inclusive) to 10 (exclusive). The numbers\nare produced as separate outputs. Use `[range(4; 10)]` to get a range as\nan array.\n\nThe one argument form generates numbers from 0 to the given\nnumber, with an increment of 1.\n\nThe two argument form generates numbers from `from` to `upto`\nwith an increment of 1.\n\nThe three argument form generates numbers `from` to `upto`\nwith an increment of `by`.",
  "range/3": "The `range` function produces a range of numbers. `range(4; 10)`\nproduces 6 numbers, from 4 (inclusive) to 10 (exclusive). The numbers\nare produced as separate outputs. Use `[range(4; 10)]` to get a range as\nan array.\n\nThe one argument form generates numbers from 0 to the given\nnumber, with an increment of 1.\n\nThe two argument form generates numbers from `from` to `upto`\nwith an increment of 1.\n\nThe three argument form generates numbers `from` to `upto`\nwith an increment of `by`.",
  "recurse/0": "The `recurse(f)` function allows you to search through a\nrecursive structure, and extract interesting data from all\nlevels. Suppose your input represents a filesystem:\n\n    {\"name\": \"/\", \"children\": [\n      {\"name\": \"/bin\", \"children\": [\n        {\"name\": \"/bin/ls\", \"children\": []},\n        {\"name\": \"/bin/sh\", \"children\": []}]},\n      {\"name\": \"/home\", \"children\": [\n        {\"name\": \"/home/stephen\", \"children\": [\n          {\"name\": \"/home/stephen/jq\", \"children\": []}]}]}]}\n\nNow suppose you want to extract all of the filenames\npresent. You need to retrieve `.name`, `.children[].name`,\n`.children[].children[].name`, and so on. You can do this\nwith:\n\n    recurse(.children[]) | .name\n\nWhen called without an argument, `recurse` is equivalent to\n`recurse(.[]?)`.\n\n`recurse(f)` is identical to `recurse(f; true)` and can be\nused without concerns about recursion depth.\n\n`recurse(f; condition)` is a generator which begins by\nemitting . and then emits in turn .|f, .|f|f, .|f|f|f, ...  so long\nas the computed value satisfies the condition. For example,\nto generate all the integers, at least in principle, one\ncould write `recurse(.+1; true)`.\n\nThe recursive calls in `recurse` will not consume additional\nmemory whenever `f` produces at most a single output for each\ninput.",
  "recurse/1": "The `recurse(f)` function allows you to search through a\nrecursive structure, and extract interesting data from all\nlevels. Suppose your input represents a filesystem:\n\n    {\"name\": \"/\", \"children\": [\n      {\"name\": \"/bin\", \"children\": [\n        {\"name\": \"/bin/ls\", \"children\": []},\n        {\"name\": \"/bin/sh\", \"children\": []}]},\n      {\"name\": \"/home\", \"children\": [\n        {\"name\": \"/home/stephen\", \"children\": [\n          {\"name\": \"/home/stephen/jq\", \"children\": []}]}]}]}\n\nNow suppose you want to extract all of the filenames\npresent. You need to retrieve `.name`, `.children[].name`,\n`.children[].children[].name`, and so on. You can do this\nwith:\n\n    recurse(.children[]) | .name\n\nWhen called without an argument, `recurse` is equivalent to\n`recurse(.[]?)`.\n\n`recurse(f)` is identical to `recurse(f; true)` and can be\nused without concerns about recursion depth.\n\n`recurse(f; condition)` is a generator which begins by\nemitting . and then emits in turn .|f, .|f|f, .|f|f|f, ...  so long\nas the computed value satisfies the condition. For example,\nto generate all the integers, at least in principle, one\ncould write `recurse(.+1; true)`.\n\nThe recursive calls in `recurse` will not consume additional\nmemory whenever `f` produces at most a single output for each\ninput.",
  "recurse/2": "The `recurse(f)` function allows you to search through a\nrecursive structure, and extract interesting data from all\nlevels. Suppose your input represents a filesystem:\n\n    {\"name\": \"/\", \"children\": [\n      {\"name\": \"/bin\", \"children\": [\n        {\"name\": \"/bin/ls\", \"children\": []},\n        {\"name\": \"/bin/sh\", \"children\": []}]},\n      {\"name\": \"/home\", \"children\": [\n        {\"name\": \"/home/stephen\", \"children\": [\n          {\"name\": \"/home/stephen/jq\", \"children\": []}]}]}]}\n\nNow suppose you want to extract all of the filenames\npresent. You need to retrieve `.name`, `.children[].name`,\n`.children[].children[].name`, and so on. You can do this\nwith:\n\n    recurse(.children[]) | .name\n\nWhen called without an argument, `recurse` is equivalent to\n`recurse(.[]?)`.\n\n`recurse(f)` is identical to `recurse(f; true)` and can be\nused without concerns about recursion depth.\n\n`recurse(f; condition)` is a generator which begins by\nemitting . and then emits in turn .|f, .|f|f, .|f|f|f, ...  so long\nas the computed value satisfies the condition. For example,\nto generate all the integers, at least in principle, one\ncould write `recurse(.+1; true)`.\n\nThe recursive calls in `recurse` will not consume additional\nmemory whenever `f` produces at most a single output for each\ninput.",
  "reduce/0": "The `reduce` syntax allows you to combine all of the results of\nan expression by accumulating them into a single answer.\nThe form is `reduce EXP as $var (INIT; UPDATE)`.\nAs an example, we'll pass `[1,2,3]` to this expression:\n\n    reduce .[] as $item (0; . + $item)\n\nFor each result that `.[]` produces, `. + $item` is run to\naccumulate a running total, starting from 0 as the input value.\nIn this example, `.[]` produces the results `1`, `2`, and `3`,\nso the effect is similar to running something like this:\n\n    0 | 1 as $item | . + $item |\n        2 as $item | . + $item |\n        3 as $item | . + $item",
  "remainder/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "repeat/1": "The `repeat(exp)` function allows you to repeatedly\napply expression `exp` to `.` until an error is raised.\n\nNote that `repeat(exp)` is internally defined as a\nrecursive jq function.  Recursive calls within `repeat` will\nnot consume additional memory if `exp` produces at most one\noutput for each input.  See advanced topics below.",
  "reverse/0": "This function reverses an array.",
  "rindex/1": "Outputs the index of the first (`index`) or last (`rindex`)\noccurrence of `s` in the input.",
  "rint/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "round/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "rtrim/0": "`trim` trims both leading and trailing whitespace.\n\n`ltrim` trims only leading (left side) whitespace.\n\n`rtrim` trims only trailing (right side) whitespace.\n\nWhitespace characters are the usual `\" \"`, `\"\\n\"` `\"\\t\"`, `\"\\r\"`\nand also all characters in the Unicode character database with the\nwhitespace property. Note that what considers whitespace might\nchange in the future.",
  "rtrimstr/1": "Outputs its input with the given suffix string removed, if it\nends with it.",
  "scalars/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "scalb/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "scalbln/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "scan/1": "Emit a stream of the non-overlapping substrings of the input\nthat match the regex in accordance with the flags, if any\nhave been specified.  If there is no match, the stream is empty.\nTo capture all the matches for each input string, use the idiom\n`[ expr ]`, e.g. `[ scan(regex) ]`.  If the regex contains capturing\ngroups, the filter emits a stream of arrays, each of which contains\nthe captured strings.",
  "scan/2": "Emit a stream of the non-overlapping substrings of the input\nthat match the regex in accordance with the flags, if any\nhave been specified.  If there is no match, the stream is empty.\nTo capture all the matches for each input string, use the idiom\n`[ expr ]`, e.g. `[ scan(regex) ]`.  If the regex contains capturing\ngroups, the filter emits a stream of arrays, each of which contains\nthe captured strings.",
  "select/1": "The function `select(f)` produces its input unchanged if\n`f` returns true for that input, and produces no output\notherwise.\n\nIt's useful for filtering lists: `[1,2,3] | map(select(. >= 2))`\nwill give you `[2,3]`.",
  "setpath/2": "The builtin function `setpath` sets the `PATHS` in `.` to `VALUE`.",
  "significand/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "sin/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "sinh/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "skip/2": "The `skip` function skips the first `n` outputs from `expr`.",
  "sort/0": "The `sort` functions sorts its input, which must be an\narray. Values are sorted in the following order:\n\n* `null`\n* `false`\n* `true`\n* numbers\n* strings, in alphabetical order (by unicode codepoint value)\n* arrays, in lexical order\n* objects\n\nThe ordering for objects is a little complex: first they're\ncompared by comparing their sets of keys (as arrays in\nsorted order), and if their keys are equal then the values\nare compared key by key.\n\n`sort_by` may be used to sort by a particular field of an\nobject, or by applying any jq filter. `sort_by(f)` compares\ntwo elements by comparing the result of `f` on each element.\nWhen `f` produces multiple values, it firstly compares the\nfirst values, and the second values if the first values are\nequal, and so on.",
  "sort_by/1": "The `sort` functions sorts its input, which must be an\narray. Values are sorted in the following order:\n\n* `null`\n* `false`\n* `true`\n* numbers\n* strings, in alphabetical order (by unicode codepoint value)\n* arrays, in lexical order\n* objects\n\nThe ordering for objects is a little complex: first they're\ncompared by comparing their sets of keys (as arrays in\nsorted order), and if their keys are equal then the values\nare compared key by key.\n\n`sort_by` may be used to sort by a particular field of an\nobject, or by applying any jq filter. `sort_by(f)` compares\ntwo elements by comparing the result of `f` on each element.\nWhen `f` produces multiple values, it firstly compares the\nfirst values, and the second values if the first values are\nequal, and so on.",
  "split/1": "Splits an input string on the separator argument.\n\n`split` can also split on regex matches when called with\ntwo arguments (see the regular expressions section below).",
  "split/2": "Splits an input string on each regex match.\n\nFor backwards compatibility, when called with a single argument,\n`split` splits on a string, not a regex.",
  "splits/1": "These provide the same results as their `split` counterparts,\nbut as a stream instead of an array.",
  "splits/2": "These provide the same results as their `split` counterparts,\nbut as a stream instead of an array.",
  "sqrt/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "startswith/1": "Outputs `true` if . starts with the given string argument.",
  "stderr/0": "Prints its input in raw and compact mode to stderr with no\nadditional decoration, not even a newline.",
  "strflocaltime/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "strftime/1": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "strings/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "strptime/1": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "sub/2": "Emit the string obtained by replacing the first match of\nregex in the input string with `tostring`, after\ninterpolation.  `tostring` should be a jq string or a stream\nof such strings, each of which may contain references to\nnamed captures. The named captures are, in effect, presented\nas a JSON object (as constructed by `capture`) to\n`tostring`, so a reference to a captured variable named \"x\"\nwould take the form: `\"\\(.x)\"`.",
  "sub/3": "Emit the string obtained by replacing the first match of\nregex in the input string with `tostring`, after\ninterpolation.  `tostring` should be a jq string or a stream\nof such strings, each of which may contain references to\nnamed captures. The named captures are, in effect, presented\nas a JSON object (as constructed by `capture`) to\n`tostring`, so a reference to a captured variable named \"x\"\nwould take the form: `\"\\(.x)\"`.",
  "tan/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "tanh/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "test/1": "Like `match`, but does not return match objects, only `true` or `false`\nfor whether or not the regex matches the input.",
  "test/2": "Like `match`, but does not return match objects, only `true` or `false`\nfor whether or not the regex matches the input.",
  "tgamma/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "to_entries/0": "These functions convert between an object and an array of\nkey-value pairs. If `to_entries` is passed an object, then\nfor each `k: v` entry in the input, the output array\nincludes `{\"key\": k, \"value\": v}`.\n\n`from_entries` does the opposite conversion, and `with_entries(f)`\nis a shorthand for `to_entries | map(f) | from_entries`, useful for\ndoing some operation to all keys and values of an object.\n`from_entries` accepts `\"key\"`, `\"Key\"`, `\"name\"`, `\"Name\"`,\n`\"value\"`, and `\"Value\"` as keys.",
  "toboolean/0": "The `toboolean` function parses its input as a boolean. It\nwill convert correctly-formatted strings to their boolean\nequivalent, leave booleans alone, and give an error on all other input.",
  "todate/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "todateiso8601/0": "jq provides some basic date handling functionality, with some\nhigh-level and low-level builtins.  In all cases these\nbuiltins deal exclusively with time in UTC.\n\nThe `fromdateiso8601` builtin parses datetimes in the ISO 8601\nformat to a number of seconds since the Unix epoch\n(1970-01-01T00:00:00Z).  The `todateiso8601` builtin does the\ninverse.\n\nThe `fromdate` builtin parses datetime strings.  Currently\n`fromdate` only supports ISO 8601 datetime strings, but in the\nfuture it will attempt to parse datetime strings in more\nformats.\n\nThe `todate` builtin is an alias for `todateiso8601`.\n\nThe `now` builtin outputs the current time, in seconds since\nthe Unix epoch.\n\nLow-level jq interfaces to the C-library time functions are\nalso provided: `strptime`, `strftime`, `strflocaltime`,\n`mktime`, `gmtime`, and `localtime`.  Refer to your host\noperating system's documentation for the format strings used\nby `strptime` and `strftime`.  Note: these are not necessarily\nstable interfaces in jq, particularly as to their localization\nfunctionality.\n\nThe `gmtime` builtin consumes a number of seconds since the\nUnix epoch and outputs a \"broken down time\" representation of\nGreenwich Mean Time as an array of numbers representing\n(in this order): the year, the month (zero-based), the day of\nthe month (one-based), the hour of the day, the minute of the\nhour, the second of the minute, the day of the week, and the\nday of the year -- all one-based unless otherwise stated.  The\nday of the week number may be wrong on some systems for dates\nbefore March 1st 1900, or after December 31 2099.\n\nThe `localtime` builtin works like the `gmtime` builtin, but\nusing the local timezone setting.\n\nThe `mktime` builtin consumes \"broken down time\"\nrepresentations of time output by `gmtime` and `strptime`.\n\nThe `strptime(fmt)` builtin parses input strings matching the\n`fmt` argument.  The output is in the \"broken down time\"\nrepresentation consumed by `mktime` and output by `gmtime`.\n\nThe `strftime(fmt)` builtin formats a time (GMT) with the\ngiven format.  The `strflocaltime` does the same, but using\nthe local timezone setting.\n\nThe format strings for `strptime` and `strftime` are described\nin typical C library documentation.  The format string for ISO\n8601 datetime is `\"%Y-%m-%dT%H:%M:%SZ\"`.\n\njq may not support some or all of this date functionality on\nsome systems. In particular, the `%u` and `%j` specifiers for\n`strptime(fmt)` are not supported on macOS.",
  "tojson/0": "The `tojson` and `fromjson` builtins dump values as JSON texts\nor parse JSON texts into values, respectively.  The `tojson`\nbuiltin differs from `tostring` in that `tostring` returns strings\nunmodified, while `tojson` encodes strings as JSON strings.",
  "tonumber/0": "The `tonumber` function parses its input as a number. It\nwill convert correctly-formatted strings to their numeric\nequivalent, leave numbers alone, and give an error on all other input.",
  "tostream/0": "The `tostream` builtin outputs the streamed form of its input.",
  "tostring/0": "The `tostring` function prints its input as a\nstring. Strings are left unchanged, and all other values are\nJSON-encoded.",
  "transpose/0": "Transpose a possibly jagged matrix (an array of arrays).\nRows are padded with nulls so the result is always rectangular.",
  "trim/0": "`trim` trims both leading and trailing whitespace.\n\n`ltrim` trims only leading (left side) whitespace.\n\n`rtrim` trims only trailing (right side) whitespace.\n\nWhitespace characters are the usual `\" \"`, `\"\\n\"` `\"\\t\"`, `\"\\r\"`\nand also all characters in the Unicode character database with the\nwhitespace property. Note that what considers whitespace might\nchange in the future.",
  "trimstr/1": "Outputs its input with the given string removed at both ends, if it\nstarts or ends with it.",
  "trunc/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "truncate_stream/1": "Consumes a number as input and truncates the corresponding\nnumber of path elements from the left of the outputs of the\ngiven streaming expression.",
  "type/0": "The `type` function returns the type of its argument as a\nstring, which is one of null, boolean, number, string, array\nor object.",
  "unique/0": "The `unique` function takes as input an array and produces\nan array of the same elements, in sorted order, with\nduplicates removed.\n\nThe `unique_by(path_exp)` function will keep only one element\nfor each value obtained by applying the argument. Think of it\nas making an array by taking one element out of every group\nproduced by `group`.",
  "unique_by/1": "The `unique` function takes as input an array and produces\nan array of the same elements, in sorted order, with\nduplicates removed.\n\nThe `unique_by(path_exp)` function will keep only one element\nfor each value obtained by applying the argument. Think of it\nas making an array by taking one element out of every group\nproduced by `group`.",
  "until/2": "The `until(cond; next)` function allows you to repeatedly\napply the expression `next`, initially to `.` then to its own\noutput, until `cond` is true.  For example, this can be used\nto implement a factorial function (see below).\n\nNote that `until(cond; next)` is internally defined as a\nrecursive jq function.  Recursive calls within `until()` will\nnot consume additional memory if `next` produces at most one\noutput for each input.  See advanced topics below.",
  "utf8bytelength/0": "The builtin function `utf8bytelength` outputs the number of\nbytes used to encode a string in UTF-8.",
  "values/0": "These built-ins select only inputs that are arrays, objects,\niterables (arrays or objects), booleans, numbers, normal\nnumbers, finite numbers, strings, null, non-null values, and\nnon-iterables, respectively.",
  "walk/1": "The `walk(f)` function applies f recursively to every\ncomponent of the input entity.  When an array is\nencountered, f is first applied to its elements and then to\nthe array itself; when an object is encountered, f is first\napplied to all the values and then to the object.  In\npractice, f will usually test the type of its input, as\nillustrated in the following examples.  The first example\nhighlights the usefulness of processing the elements of an\narray of arrays before processing the array itself.  The second\nexample shows how all the keys of all the objects within the\ninput can be considered for alteration.",
  "while/2": "The `while(cond; update)` function allows you to repeatedly\napply an update to `.` until `cond` is false.\n\nNote that `while(cond; update)` is internally defined as a\nrecursive jq function.  Recursive calls within `while` will\nnot consume additional memory if `update` produces at most one\noutput for each input.  See advanced topics below.",
  "with_entries/1": "These functions convert between an object and an array of\nkey-value pairs. If `to_entries` is passed an object, then\nfor each `k: v` entry in the input, the output array\nincludes `{\"key\": k, \"value\": v}`.\n\n`from_entries` does the opposite conversion, and `with_entries(f)`\nis a shorthand for `to_entries | map(f) | from_entries`, useful for\ndoing some operation to all keys and values of an object.\n`from_entries` accepts `\"key\"`, `\"Key\"`, `\"name\"`, `\"Name\"`,\n`\"value\"`, and `\"Value\"` as keys.",
  "y0/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "y1/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these.",
  "yn/0": "jq currently only has IEEE754 double-precision (64-bit) floating\npoint number support.\n\nBesides simple arithmetic operators such as `+`, jq also has most\nstandard math functions from the C math library.  C math functions\nthat take a single input argument (e.g., `sin()`) are available as\nzero-argument jq functions.  C math functions that take two input\narguments (e.g., `pow()`) are available as two-argument jq\nfunctions that ignore `.`.  C math functions that take three input\narguments are available as three-argument jq functions that ignore\n`.`.\n\nAvailability of standard math functions depends on the\navailability of the corresponding math functions in your operating\nsystem and C math library.  Unavailable math functions will be\ndefined but will raise an error.\n\nOne-input C math functions: `acos` `acosh` `asin` `asinh` `atan`\n`atanh` `cbrt` `ceil` `cos` `cosh` `erf` `erfc` `exp` `exp10`\n`exp2` `expm1` `fabs` `floor` `gamma` `j0` `j1` `lgamma` `log`\n`log10` `log1p` `log2` `logb` `nearbyint` `rint` `round`\n`significand` `sin` `sinh` `sqrt` `tan` `tanh` `tgamma` `trunc`\n`y0` `y1`.\n\nTwo-input C math functions: `atan2` `copysign` `drem` `fdim`\n`fmax` `fmin` `fmod` `frexp` `hypot` `jn` `ldexp` `modf`\n`nextafter` `nexttoward` `pow` `remainder` `scalb` `scalbln` `yn`.\n\nThree-input C math functions: `fma`.\n\nSee your system's manual for more information on each of these."
}
;
