; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=ve-unknown-unknown -mattr=+vpu | FileCheck %s

declare void @llvm.experimental.vp.strided.store.v256f32.p0.i64(<256 x float> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)

define fastcc void @vp_strided_store_v256f32_rrm(<256 x float> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256f32_rrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vstu %v0, %s1, %s0, %vm1
; CHECK-NEXT:    b.l.t (, %s10)
  call void @llvm.experimental.vp.strided.store.v256f32.p0.i64(<256 x float> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256f32_rr(<256 x float> %val, ptr %ptr, i64 %stride, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256f32_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vstu %v0, %s1, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256f32.p0.i64(<256 x float> %val, ptr %ptr, i64 %stride, <256 x i1> %allones, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256f32_ri(<256 x float> %val, ptr %ptr, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256f32_ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s1, %s1, (32)0
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vstu %v0, 24, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256f32.p0.i64(<256 x float> %val, ptr %ptr, i64 24, <256 x i1> %allones, i32 %evl)
  ret void
}

declare void @llvm.experimental.vp.strided.store.v256i32.p0.i64(<256 x i32> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)

define fastcc void @vp_strided_store_v256i32_rrm(<256 x i32> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256i32_rrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vstl %v0, %s1, %s0, %vm1
; CHECK-NEXT:    b.l.t (, %s10)
  call void @llvm.experimental.vp.strided.store.v256i32.p0.i64(<256 x i32> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256i32_rr(<256 x i32> %val, ptr %ptr, i64 %stride, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256i32_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vstl %v0, %s1, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256i32.p0.i64(<256 x i32> %val, ptr %ptr, i64 %stride, <256 x i1> %allones, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256i32_ri(<256 x i32> %val, ptr %ptr, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256i32_ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s1, %s1, (32)0
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vstl %v0, 24, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256i32.p0.i64(<256 x i32> %val, ptr %ptr, i64 24, <256 x i1> %allones, i32 %evl)
  ret void
}

declare void @llvm.experimental.vp.strided.store.v256f64.p0.i64(<256 x double> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)

define fastcc void @vp_strided_store_v256f64_rrm(<256 x double> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256f64_rrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vst %v0, %s1, %s0, %vm1
; CHECK-NEXT:    b.l.t (, %s10)
  call void @llvm.experimental.vp.strided.store.v256f64.p0.i64(<256 x double> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256f64_rr(<256 x double> %val, ptr %ptr, i64 %stride, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256f64_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vst %v0, %s1, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256f64.p0.i64(<256 x double> %val, ptr %ptr, i64 %stride, <256 x i1> %allones, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256f64_ri(<256 x double> %val, ptr %ptr, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256f64_ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s1, %s1, (32)0
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vst %v0, 24, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256f64.p0.i64(<256 x double> %val, ptr %ptr, i64 24, <256 x i1> %allones, i32 %evl)
  ret void
}

declare void @llvm.experimental.vp.strided.store.v256i64.p0.i64(<256 x i64> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)

define fastcc void @vp_strided_store_v256i64_rrm(<256 x i64> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256i64_rrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vst %v0, %s1, %s0, %vm1
; CHECK-NEXT:    b.l.t (, %s10)
  call void @llvm.experimental.vp.strided.store.v256i64.p0.i64(<256 x i64> %val, ptr %ptr, i64 %stride, <256 x i1> %mask, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256i64_rr(<256 x i64> %val, ptr %ptr, i64 %stride, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256i64_rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s2, %s2, (32)0
; CHECK-NEXT:    lvl %s2
; CHECK-NEXT:    vst %v0, %s1, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256i64.p0.i64(<256 x i64> %val, ptr %ptr, i64 %stride, <256 x i1> %allones, i32 %evl)
  ret void
}

define fastcc void @vp_strided_store_v256i64_ri(<256 x i64> %val, ptr %ptr, i32 %evl) {
; CHECK-LABEL: vp_strided_store_v256i64_ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s1, %s1, (32)0
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vst %v0, 24, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %one = insertelement <256 x i1> undef, i1 1, i32 0
  %allones = shufflevector <256 x i1> %one, <256 x i1> undef, <256 x i32> zeroinitializer
  call void @llvm.experimental.vp.strided.store.v256i64.p0.i64(<256 x i64> %val, ptr %ptr, i64 24, <256 x i1> %allones, i32 %evl)
  ret void
}
