; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+v,+zvfbfmin -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+v,+zvfbfmin -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2f16(<2 x half>, metadata)
define <2 x float> @vfpext_v2f16_v2f32(<2 x half> %va) strictfp {
; CHECK-LABEL: vfpext_v2f16_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f16(<2 x half>, metadata)
define <2 x double> @vfpext_v2f16_v2f64(<2 x half> %va) strictfp {
; CHECK-LABEL: vfpext_v2f16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f16(<2 x half> %va, metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4f16(<4 x half>, metadata)
define <4 x float> @vfpext_v4f16_v4f32(<4 x half> %va) strictfp {
; CHECK-LABEL: vfpext_v4f16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4f16(<4 x half>, metadata)
define <4 x double> @vfpext_v4f16_v4f64(<4 x half> %va) strictfp {
; CHECK-LABEL: vfpext_v4f16_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4f16(<4 x half> %va, metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x float> @llvm.experimental.constrained.fpext.v8f32.v8f16(<8 x half>, metadata)
define <8 x float> @vfpext_v8f16_v8f32(<8 x half> %va) strictfp {
; CHECK-LABEL: vfpext_v8f16_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.fpext.v8f32.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8f16(<8 x half>, metadata)
define <8 x double> @vfpext_v8f16_v8f64(<8 x half> %va) strictfp {
; CHECK-LABEL: vfpext_v8f16_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8f16(<8 x half> %va, metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f32(<2 x float>, metadata)
define <2 x double> @vfpext_v2f32_v2f64(<2 x float> %va) strictfp {
; CHECK-LABEL: vfpext_v2f32_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f32(<2 x float> %va, metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4f32(<4 x float>, metadata)
define <4 x double> @vfpext_v4f32_v4f64(<4 x float> %va) strictfp {
; CHECK-LABEL: vfpext_v4f32_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4f32(<4 x float> %va, metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8f32(<8 x float>, metadata)
define <8 x double> @vfpext_v8f32_v8f64(<8 x float> %va) strictfp {
; CHECK-LABEL: vfpext_v8f32_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vfwcvt.f.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8f32(<8 x float> %va, metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2bf16(<2 x bfloat>, metadata)
define <2 x float> @vfpext_v2bf16_v2f32(<2 x bfloat> %va) strictfp {
; CHECK-LABEL: vfpext_v2bf16_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2bf16(<2 x bfloat> %va, metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2bf16(<2 x bfloat>, metadata)
define <2 x double> @vfpext_v2bf16_v2f64(<2 x bfloat> %va) strictfp {
; CHECK-LABEL: vfpext_v2bf16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2bf16(<2 x bfloat> %va, metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4bf16(<4 x bfloat>, metadata)
define <4 x float> @vfpext_v4bf16_v4f32(<4 x bfloat> %va) strictfp {
; CHECK-LABEL: vfpext_v4bf16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4bf16(<4 x bfloat> %va, metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4bf16(<4 x bfloat>, metadata)
define <4 x double> @vfpext_v4bf16_v4f64(<4 x bfloat> %va) strictfp {
; CHECK-LABEL: vfpext_v4bf16_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.fpext.v4f64.v4bf16(<4 x bfloat> %va, metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x float> @llvm.experimental.constrained.fpext.v8f32.v8bf16(<8 x bfloat>, metadata)
define <8 x float> @vfpext_v8bf16_v8f32(<8 x bfloat> %va) strictfp {
; CHECK-LABEL: vfpext_v8bf16_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.fpext.v8f32.v8bf16(<8 x bfloat> %va, metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8bf16(<8 x bfloat>, metadata)
define <8 x double> @vfpext_v8bf16_v8f64(<8 x bfloat> %va) strictfp {
; CHECK-LABEL: vfpext_v8bf16_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8bf16(<8 x bfloat> %va, metadata !"fpexcept.strict")
  ret <8 x double> %evec
}
