# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mattr=+rva23u64,+zbc,+zbkb,+zbkx -mcpu=generic-ooo -iterations=1 < %s | FileCheck %s

# Integer Register-Immediate Instructions
addi a0, a0, 1
addiw a0, a0, 1
slti a0, a0, 1
sltiu a0, a0, 1

andi a0, a0, 1
ori a0, a0, 1
xori a0, a0, 1

slli a0, a0, 1
srli a0, a0, 1
srai a0, a0, 1
slliw a0, a0, 1
srliw a0, a0, 1
sraiw a0, a0, 1

lui a0, 1
auipc a1, 1

# Integer Register-Register Operations

add a0, a0, a1
addw a0, a0, a0
slt a0, a0, a0
sltu a0, a0, a0

and a0, a0, a0
or a0, a0, a0
xor a0, a0, a0

sll a0, a0, a0
srl a0, a0, a0
sra a0, a0, a0
sllw a0, a0, a0
srlw a0, a0, a0
sraw a0, a0, a0

sub a0, a0, a0
subw a0, a0, a0

# Control Transfer Instructions

## Unconditional Jumps
jal a0, 1f
1:
jalr a0
beq a0, a0, 1f
1:
bne a0, a0, 1f
1:
blt a0, a0, 1f
1:
bltu a0, a0, 1f
1:
bge a0, a0, 1f
1:
bgeu a0, a0, 1f
1:
add a0, a0, a0

# Load and Store Instructions
lb t0, 0(a0)
lbu t0, 0(a0)
lh t0, 0(a0)
lhu t0, 0(a0)
lw t0, 0(a0)
lwu t0, 0(a0)
ld t0, 0(a0)

sb t0, 0(a0)
sh t0, 0(a0)
sw t0, 0(a0)
sd t0, 0(a0)

# Multiply/Division
mul a0, a0, a0
mulh a0, a0, a0
mulhu a0, a0, a0
mulhsu a0, a0, a0
mulw a0, a0, a0
div a0, a1, a2
divu a0, a1, a2
rem a0, a1, a2
remu a0, a1, a2
divw a0, a1, a2
divuw a0, a1, a2
remw a0, a1, a2
remuw a0, a1, a2

# Zicsr
csrrw t0, 0xfff, t1
csrrs s3, 0x001, s5
csrrc sp, 0x000, ra
csrrwi a5, 0x000, 0
csrrsi t2, 0xfff, 31
csrrci t1, 0x140, 5

# Zicond
czero.eqz a0, a1, a2
czero.nez a0, a1, a2

# Zicond
czero.eqz a0, a1, a2
czero.nez a0, a1, a2

# Zicbom/Zicbop/Zicboz
# cbo.clean 0(a0)
# cbo.flush 0(a0)
# cbo.inval 0(a0)

# cbo.zero 0(a0)

# prefetch.i 0(a0)
# prefetch.r 0(a0)
# prefetch.w 0(a0)

# Zba
add.uw a0, a0, a0
slli.uw a0, a0, 1
sh1add.uw a0, a0, a0
sh2add.uw a0, a0, a0
sh3add.uw a0, a0, a0
sh1add a0, a0, a0
sh2add a0, a0, a0
sh3add a0, a0, a0

# Zbb
andn a0, a0, a0
orn a0, a0, a0
xnor a0, a0, a0

clz a0, a0
clzw a0, a0
ctz a0, a0
ctzw a0, a0

cpop a0, a0
cpopw a0, a0

min a0, a0, a0
minu a0, a0, a0
max a0, a0, a0
maxu a0, a0, a0

sext.b a0, a0
sext.h a0, a0
zext.h a0, a0

rol a0, a0, a0
rolw a0, a0, a0
ror a0, a0, a0
rorw a0, a0, a0
rori a0, a0, 1
roriw a0, a0, 1

orc.b a0, a0

rev8 a0, a0

# Zbc
clmul  a0, a1, a2
clmulh a0, a1, a2
clmulr a0, a1, a2

# Zbs
bclr a0, a1, a2
bclri a0, a1, 1
bext a0, a1, a2
bexti a0, a1, 1
binv a0, a1, a2
binvi a0, a1, 1
bset a0, a1, a2
bseti a0, a1, 1

# Zbkb
pack a0, a1, a2
packh a0, a1, a2
brev8 a0, a1

# Zbkx
xperm8 a0, a1, a2
xperm4 a0, a1, a2

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      121
# CHECK-NEXT: Total Cycles:      153
# CHECK-NEXT: Total uOps:        121

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    0.79
# CHECK-NEXT: IPC:               0.79
# CHECK-NEXT: Block RThroughput: 141.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        addi	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        addiw	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        slti	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        seqz	a0, a0
# CHECK-NEXT:  1      1     0.25                        andi	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        ori	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        xori	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        slli	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        srli	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        srai	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        slliw	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        srliw	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        sraiw	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        lui	a0, 1
# CHECK-NEXT:  1      1     0.25                        auipc	a1, 1
# CHECK-NEXT:  1      1     0.25                        add	a0, a0, a1
# CHECK-NEXT:  1      1     0.25                        addw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        slt	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sltu	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        and	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        or	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        xor	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sll	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        srl	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sra	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sllw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        srlw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sraw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sub	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        subw	a0, a0, a0
# CHECK-NEXT:  1      1     1.00                        jal	a0, .Ltmp0
# CHECK-NEXT:  1      1     1.00                        jalr	a0
# CHECK-NEXT:  1      1     1.00                        beq	a0, a0, .Ltmp1
# CHECK-NEXT:  1      1     1.00                        bne	a0, a0, .Ltmp2
# CHECK-NEXT:  1      1     1.00                        blt	a0, a0, .Ltmp3
# CHECK-NEXT:  1      1     1.00                        bltu	a0, a0, .Ltmp4
# CHECK-NEXT:  1      1     1.00                        bge	a0, a0, .Ltmp5
# CHECK-NEXT:  1      1     1.00                        bgeu	a0, a0, .Ltmp6
# CHECK-NEXT:  1      1     0.25                        add	a0, a0, a0
# CHECK-NEXT:  1      4     0.50    *                   lb	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   lbu	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   lh	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   lhu	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   lw	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   lwu	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   ld	t0, 0(a0)
# CHECK-NEXT:  1      1     0.50           *            sb	t0, 0(a0)
# CHECK-NEXT:  1      1     0.50           *            sh	t0, 0(a0)
# CHECK-NEXT:  1      1     0.50           *            sw	t0, 0(a0)
# CHECK-NEXT:  1      1     0.50           *            sd	t0, 0(a0)
# CHECK-NEXT:  1      4     1.00                        mul	a0, a0, a0
# CHECK-NEXT:  1      4     1.00                        mulh	a0, a0, a0
# CHECK-NEXT:  1      4     1.00                        mulhu	a0, a0, a0
# CHECK-NEXT:  1      4     1.00                        mulhsu	a0, a0, a0
# CHECK-NEXT:  1      4     1.00                        mulw	a0, a0, a0
# CHECK-NEXT:  1      21    21.00                       div	a0, a1, a2
# CHECK-NEXT:  1      21    21.00                       divu	a0, a1, a2
# CHECK-NEXT:  1      21    21.00                       rem	a0, a1, a2
# CHECK-NEXT:  1      21    21.00                       remu	a0, a1, a2
# CHECK-NEXT:  1      13    13.00                       divw	a0, a1, a2
# CHECK-NEXT:  1      13    13.00                       divuw	a0, a1, a2
# CHECK-NEXT:  1      13    13.00                       remw	a0, a1, a2
# CHECK-NEXT:  1      13    13.00                       remuw	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                  U     csrrw	t0, 4095, t1
# CHECK-NEXT:  1      1     0.25                  U     csrrs	s3, fflags, s5
# CHECK-NEXT:  1      1     0.25                  U     csrrc	sp, 0, ra
# CHECK-NEXT:  1      1     0.25                  U     csrrwi	a5, 0, 0
# CHECK-NEXT:  1      1     0.25                  U     csrrsi	t2, 4095, 31
# CHECK-NEXT:  1      1     0.25                  U     csrrci	t1, sscratch, 5
# CHECK-NEXT:  1      1     0.25                        czero.eqz	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        czero.nez	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        czero.eqz	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        czero.nez	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        add.uw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        slli.uw	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        sh1add.uw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sh2add.uw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sh3add.uw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sh1add	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sh2add	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sh3add	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        andn	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        orn	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        xnor	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        clz	a0, a0
# CHECK-NEXT:  1      1     0.25                        clzw	a0, a0
# CHECK-NEXT:  1      1     0.25                        ctz	a0, a0
# CHECK-NEXT:  1      1     0.25                        ctzw	a0, a0
# CHECK-NEXT:  1      1     0.25                        cpop	a0, a0
# CHECK-NEXT:  1      1     0.25                        cpopw	a0, a0
# CHECK-NEXT:  1      1     0.25                        min	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        minu	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        max	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        maxu	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        sext.b	a0, a0
# CHECK-NEXT:  1      1     0.25                        sext.h	a0, a0
# CHECK-NEXT:  1      1     0.25                        zext.h	a0, a0
# CHECK-NEXT:  1      1     0.25                        rol	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        rolw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        ror	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        rorw	a0, a0, a0
# CHECK-NEXT:  1      1     0.25                        rori	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        roriw	a0, a0, 1
# CHECK-NEXT:  1      1     0.25                        orc.b	a0, a0
# CHECK-NEXT:  1      1     0.25                        rev8	a0, a0
# CHECK-NEXT:  1      1     0.25                        clmul	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        clmulh	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        clmulr	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        bclr	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        bclri	a0, a1, 1
# CHECK-NEXT:  1      1     0.25                        bext	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        bexti	a0, a1, 1
# CHECK-NEXT:  1      1     0.25                        binv	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        binvi	a0, a1, 1
# CHECK-NEXT:  1      1     0.25                        bset	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        bseti	a0, a1, 1
# CHECK-NEXT:  1      1     0.25                        pack	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        packh	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        brev8	a0, a1
# CHECK-NEXT:  1      1     0.25                        xperm8	a0, a1, a2
# CHECK-NEXT:  1      1     0.25                        xperm4	a0, a1, a2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - GenericOOOBranch
# CHECK-NEXT: [1]   - GenericOOOFMulDiv
# CHECK-NEXT: [2]   - GenericOOOFloat
# CHECK-NEXT: [3.0] - GenericOOOInt
# CHECK-NEXT: [3.1] - GenericOOOInt
# CHECK-NEXT: [4.0] - GenericOOOLSU
# CHECK-NEXT: [4.1] - GenericOOOLSU
# CHECK-NEXT: [5]   - GenericOOOMulDiv

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]
# CHECK-NEXT: 23.00   -      -     34.00  35.00  5.00   6.00   146.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   addi	a0, a0, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     addiw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     slti	a0, a0, 1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   seqz	a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     andi	a0, a0, 1
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     ori	a0, a0, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     xori	a0, a0, 1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   slli	a0, a0, 1
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   srli	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     srai	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     slliw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     srliw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sraiw	a0, a0, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     lui	a0, 1
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     auipc	a1, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     add	a0, a0, a1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     addw	a0, a0, a0
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   slt	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sltu	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     and	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     or	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     xor	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     sll	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     srl	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     sra	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sllw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     srlw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sraw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sub	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     subw	a0, a0, a0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     jal	a0, .Ltmp0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     jalr	a0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     beq	a0, a0, .Ltmp1
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     bne	a0, a0, .Ltmp2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     blt	a0, a0, .Ltmp3
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     bltu	a0, a0, .Ltmp4
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     bge	a0, a0, .Ltmp5
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     bgeu	a0, a0, .Ltmp6
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lb	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     lbu	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lh	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lhu	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     lw	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lwu	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     ld	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     sb	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     sh	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     sw	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     sd	t0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   mul	a0, a0, a0
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   mulh	a0, a0, a0
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   mulhu	a0, a0, a0
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   mulhsu	a0, a0, a0
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00   mulw	a0, a0, a0
# CHECK-NEXT:  -      -      -      -      -      -      -     21.00  div	a0, a1, a2
# CHECK-NEXT:  -      -      -      -      -      -      -     21.00  divu	a0, a1, a2
# CHECK-NEXT:  -      -      -      -      -      -      -     21.00  rem	a0, a1, a2
# CHECK-NEXT:  -      -      -      -      -      -      -     21.00  remu	a0, a1, a2
# CHECK-NEXT:  -      -      -      -      -      -      -     13.00  divw	a0, a1, a2
# CHECK-NEXT:  -      -      -      -      -      -      -     13.00  divuw	a0, a1, a2
# CHECK-NEXT:  -      -      -      -      -      -      -     13.00  remw	a0, a1, a2
# CHECK-NEXT:  -      -      -      -      -      -      -     13.00  remuw	a0, a1, a2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     csrrw	t0, 4095, t1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     csrrs	s3, fflags, s5
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     csrrc	sp, 0, ra
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     csrrwi	a5, 0, 0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     csrrsi	t2, 4095, 31
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     csrrci	t1, sscratch, 5
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     czero.eqz	a0, a1, a2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     czero.nez	a0, a1, a2
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     czero.eqz	a0, a1, a2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     czero.nez	a0, a1, a2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     slli.uw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh1add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh2add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh3add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh1add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh2add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh3add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     andn	a0, a0, a0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     orn	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     xnor	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     clz	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     clzw	a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     ctz	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     ctzw	a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     cpop	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     cpopw	a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     min	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     minu	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     max	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     maxu	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     sext.b	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sext.h	a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     zext.h	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     rol	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     rolw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     ror	a0, a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     rorw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     rori	a0, a0, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     roriw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     orc.b	a0, a0
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     rev8	a0, a0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     clmul	a0, a1, a2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     clmulh	a0, a1, a2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     clmulr	a0, a1, a2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     bclr	a0, a1, a2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     bclri	a0, a1, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     bext	a0, a1, a2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     bexti	a0, a1, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     binv	a0, a1, a2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     binvi	a0, a1, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     bset	a0, a1, a2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     bseti	a0, a1, 1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     pack	a0, a1, a2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     packh	a0, a1, a2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     brev8	a0, a1
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     xperm8	a0, a1, a2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -     xperm4	a0, a1, a2
