AS_INIT

# $Id: bus-device-auto.sh,v 1.3 2009/08/29 17:52:04 fredette Exp $

# generic/bus-device-auto.sh - automatically generates C code for
# generic bus device support:

#
# Copyright (c) 2004 Matt Fredette
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by Matt Fredette.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

header=false

for option
do
    case $option in
    --header) header=true ;;
    esac
done

PROG=`basename $0`
cat <<EOF
/* automatically generated by $PROG, do not edit! */
_TME_RCSID("\$Id: bus-device-auto.sh,v 1.3 2009/08/29 17:52:04 fredette Exp $");
EOF

if $header; then :; else
    cat <<EOF

/* this gives the number of entries that must be in a generic bus
   router array for a device with a bus size of 8 * (2 ^ siz_lg2)
   bits: */
#define TME_BUS_ROUTER_INIT_SIZE(siz_lg2)                       \\
  TME_BUS_ROUTER_INIT_INDEX(siz_lg2, (1 << (siz_lg2)) + 1, 0)

EOF
fi

# permute over initiator bus port width:
#
i_width=8
while test ${i_width} != 32; do
    i_width=`expr ${i_width} \* 2`

    # permute over initiator endianness:
    #
    for endian in b l; do
	if test ${endian} = b; then endian_what=big; else endian_what=little; fi

	# start the array:
	#
	AS_ECHO([""])
	AS_ECHO(["/* the ${i_width}-bit ${endian_what}-endian bus master bus router: */"])
	what="const tme_bus_lane_t tme_bus_device_router_${i_width}e${endian}"
	if $header; then
	    AS_ECHO(["extern ${what}[[]];"])
	    continue
	fi
	AS_ECHO(["${what}[[TME_BUS_ROUTER_INIT_SIZE(TME_BUS${i_width}_LOG2)]] = {"])

	# permute over initiator maximum cycle size:
	#
	i_size=0
	while test `expr ${i_size} \< ${i_width}` = 1; do
	    i_size=`expr ${i_size} + 8`

	    # permute over initiator address offset:
	    #
	    i_offset=0
	    while test `expr ${i_offset} \< ${i_width}` = 1; do

		# calculate the initiator least and greatest lanes:
		#
		placeholder=false
		if test ${endian} = b; then
		    i_lane_greatest=`expr 0 - 8 + ${i_width} - ${i_offset}`
		    i_lane_least=`expr 8 + \( ${i_lane_greatest} \) - ${i_size}`
		    if test `expr \( ${i_lane_least} \) \< 0` = 1; then
			placeholder=true
		    fi
		else
		    i_lane_least=$i_offset
		    i_lane_greatest=`expr 0 - 8 + ${i_offset} + ${i_size}`
		    if test `expr \( ${i_lane_greatest} \) \>= ${i_width}` = 1; then
			placeholder=true
		    fi
		fi

		# permute over responder bus port width:
		#
		r_width=4
		while test `expr ${r_width} \< ${i_width}` = 1; do
		    r_width=`expr ${r_width} \* 2`

		    # permute over responder bus port least lane:
		    #
		    r_lane_least=0
		    while test `expr ${r_lane_least} \< ${i_width}` = 1; do
			r_lane_greatest=`expr 0 - 8 + ${r_lane_least} + ${r_width}`

			# emit the initiator information:
			#
			AS_ECHO([""])
			AS_ECHO(["  /* initiator maximum cycle size: ${i_size} bits"])
			AS_ECHO(["     initiator address offset: ${i_offset} bits"])
			if $placeholder; then
			    AS_ECHO(["     (a ${i_width}-bit initiator cannot request ${i_size} bits at an ${i_offset}-bit offset - this is an array placeholder)"])
			fi

			# emit the responder information:
			#
			AS_ECHO(["     responder bus port size: ${r_width} bits"])
			AS_ECHO_N(["     responder port least lane: D"`expr ${r_lane_least} + 7`"-D${r_lane_least}"])

			# if the responder bus port greatest lane is
			# greater than the initiator bus port width,
			# part of the responder's port is outside of
			# the initiator's port:
			#
			if test `expr \( ${r_lane_greatest} \) \>= ${i_width}` = 1; then
			    AS_ECHO([""])
			    AS_ECHO_N(["     (responder port not correctly positioned for this initiator)"])
			fi
			AS_ECHO([": */"])

			# permute over the lanes:
			#
			lane=0
			if test ${endian} = b; then
			    route=`expr ${i_size} / 8`
			    route_increment=-1
			else
			    route=-1
			    route_increment=1
			fi
			while test `expr ${lane} \< ${i_width}` = 1; do
			    AS_ECHO_N(["  /* D"`expr ${lane} + 7`"-D${lane} */	"])

			    # see if this lane is on in the responder:
			    #
			    if test `expr ${lane} \>= ${r_lane_least}` = 1 \
			       && test `expr ${lane} \<= \( ${r_lane_greatest} \)` = 1; then
				r_lane_on=true
			    else
				r_lane_on=false
			    fi

			    # see if this lane is on in the initiator:
			    #
			    if test `expr ${lane} \>= \( ${i_lane_least} \)` = 1 \
			       && test `expr ${lane} \<= \( ${i_lane_greatest} \)` = 1; then
			        i_lane_on=true
				route=`expr \( ${route} + ${route_increment} \)`
			    else
				i_lane_on=false
			    fi

			    # if this is a placeholder entry:
			    #
			    if $placeholder; then
				AS_ECHO_N(["TME_BUS_LANE_ABORT"])

			    # otherwise, this is a real entry:
			    #
			    else
				if $i_lane_on; then
				    AS_ECHO_N(["TME_BUS_LANE_ROUTE(${route})"])
				    if $r_lane_on; then :; else
					AS_ECHO_N([" | TME_BUS_LANE_WARN"])
				    fi
				else
				    AS_ECHO_N(["TME_BUS_LANE_UNDEF"])
				fi
			    fi

			    AS_ECHO([","])
			    lane=`expr ${lane} + 8`
			done

			r_lane_least=`expr ${r_lane_least} + 8`
		    done
		done

		i_offset=`expr ${i_offset} + 8`
	    done
	done

	# finish the array:
	#
	AS_ECHO(["};"])
    done

    # permute over read/write:
    #
    for name in read write; do
	capname=`AS_ECHO([$name | tr a-z A-Z`])
	if test $name = read; then
	    naming="reading"
	    from="from"
	    constbuffer=""
	else
	    naming="writing"
	    from="to"
	    constbuffer="const "
	fi

	AS_ECHO([""])
	AS_ECHO(["/* the ${i_width}-bit bus master DMA ${name} function: */"])
	if $header; then
	    AS_ECHO(["int tme_bus_device_dma_${name}_${i_width} _TME_P((struct tme_bus_device *,"])
	    AS_ECHO(["                                       tme_bus_addr_t,"])
	    AS_ECHO(["                                       tme_bus_addr_t,"])
	    AS_ECHO(["                                       ${constbuffer}tme_uint8_t *,"])
	    AS_ECHO(["                                       unsigned int));"])
	    continue
	fi
	AS_ECHO(["int"])
	AS_ECHO(["tme_bus_device_dma_${name}_${i_width}(struct tme_bus_device *bus_device,"])
	AS_ECHO(["                           tme_bus_addr_t address_init,"])
	AS_ECHO(["                           tme_bus_addr_t size,"])
	AS_ECHO(["                           ${constbuffer}tme_uint8_t *buffer,"])
	AS_ECHO(["                           unsigned int locks)"])
	AS_ECHO(["{"])
	AS_ECHO(["  struct tme_bus_tlb *tlb, tlb_local;"])
	AS_ECHO(["  struct tme_bus_connection *conn_bus;"])
	AS_ECHO(["  tme_bus_addr_t count_minus_one, count;"])
	AS_ECHO(["  struct tme_bus_cycle cycle;"])
	AS_ECHO(["  tme_bus_addr_t address_resp;"])
	AS_ECHO(["  int shift;"])
	AS_ECHO(["  int err;"])
	AS_ECHO([""])
	AS_ECHO(["  /* assume no error: */"])
	AS_ECHO(["  err = TME_OK;"])
	AS_ECHO([""])
	AS_ECHO(["  /* loop while we have more bytes to ${name}: */"])
	AS_ECHO(["  for (; err == TME_OK && size > 0; ) {"])
	AS_ECHO([""])
	AS_ECHO(["    /* hash this address into a TLB entry: */"])
	AS_ECHO(["    tlb = (*bus_device->tme_bus_device_tlb_hash)"])
	AS_ECHO(["            (bus_device,"])
	AS_ECHO(["             address_init,"])
	AS_ECHO(["             TME_BUS_CYCLE_${capname});"])
	AS_ECHO([""])
	AS_ECHO(["    /* busy this TLB entry: */"])
	AS_ECHO(["    tme_bus_tlb_busy(tlb);"])
	AS_ECHO([""])
	AS_ECHO(["    /* if this TLB entry is invalid, doesn't cover this address, or if it doesn't"])
	AS_ECHO(["       allow ${naming}, reload it: */"])
	AS_ECHO(["    if (tme_bus_tlb_is_invalid(tlb)"])
	AS_ECHO(["        || address_init < tlb->tme_bus_tlb_addr_first"])
	AS_ECHO(["        || address_init > tlb->tme_bus_tlb_addr_last"])
	AS_ECHO(["        || (tlb->tme_bus_tlb_emulator_off_${name} == TME_EMULATOR_OFF_UNDEF"])
	AS_ECHO(["            && !(tlb->tme_bus_tlb_cycles_ok & TME_BUS_CYCLE_${capname}))) {"])
	AS_ECHO([""])
	AS_ECHO(["      /* unbusy this TLB entry for filling: */"])
	AS_ECHO(["      tme_bus_tlb_unbusy_fill(tlb);"])
	AS_ECHO([""])
	AS_ECHO(["      /* pass this TLB's token: */"])
	AS_ECHO(["      tlb_local.tme_bus_tlb_token = tlb->tme_bus_tlb_token;"])
	AS_ECHO([""])
	AS_ECHO(["      /* get our bus connection: */"])
	AS_ECHO(["      conn_bus = tme_memory_atomic_pointer_read(struct tme_bus_connection *,"])
	AS_ECHO(["                                                bus_device->tme_bus_device_connection,"])
	AS_ECHO(["                                                &bus_device->tme_bus_device_connection_rwlock);"])
	AS_ECHO([""])
	AS_ECHO(["      /* unlock the device: */"])
	AS_ECHO(["      (*bus_device->tme_bus_device_unlock)(bus_device, locks);"])
	AS_ECHO([""])
	AS_ECHO(["      /* reload the TLB entry: */"])
	AS_ECHO(["      err = (*conn_bus->tme_bus_tlb_fill)"])
	AS_ECHO(["              (conn_bus,"])
	AS_ECHO(["               &tlb_local,"])
	AS_ECHO(["               address_init,"])
	AS_ECHO(["               TME_BUS_CYCLE_${capname});"])
	AS_ECHO([""])
	AS_ECHO(["      /* lock the device: */"])
	AS_ECHO(["      (*bus_device->tme_bus_device_lock)(bus_device, locks);"])
	AS_ECHO([""])
	AS_ECHO(["      /* return if we couldn't fill the TLB entry: */"])
	AS_ECHO(["      if (err != TME_OK) {"])
	AS_ECHO(["        return (err);"])
	AS_ECHO(["      }"])
	AS_ECHO([""])
	AS_ECHO(["      /* store the TLB entry: */"])
	AS_ECHO(["      *tlb = tlb_local;"])
	AS_ECHO([""])
	AS_ECHO(["      /* loop to check the newly filled TLB entry: */"])
	AS_ECHO(["      continue;"])
	AS_ECHO(["    }"])
	AS_ECHO([""])
	AS_ECHO(["    /* if this TLB entry allows fast ${naming}: */"])
	AS_ECHO(["    if (tlb->tme_bus_tlb_emulator_off_${name} != TME_EMULATOR_OFF_UNDEF) {"])
	AS_ECHO([""])
	AS_ECHO(["      /* see how many bytes we can fast ${name} ${from} this TLB entry,"])
	AS_ECHO(["         starting at this address: */"])
	AS_ECHO(["      count_minus_one = (tlb->tme_bus_tlb_addr_last - address_init);"])
	AS_ECHO([""])
	AS_ECHO(["      /* ${name} that many bytes or size bytes, whichever is smaller: */"])
	AS_ECHO(["      count_minus_one = TME_MIN(count_minus_one,"])
	AS_ECHO(["                                (size - 1));"])
	AS_ECHO(["      count = count_minus_one + 1;"])
	AS_ECHO(["      assert (count != 0);"])
	AS_ECHO([""])
	AS_ECHO(["      /* do the bus ${name}: */"])
	AS_ECHO(["      tme_memory_bus_${name}_buffer((tlb->tme_bus_tlb_emulator_off_${name} + address_init), buffer, count, tlb->tme_bus_tlb_rwlock, sizeof(tme_uint8_t), sizeof(tme_uint${i_width}_t));"])
	AS_ECHO([""])
	AS_ECHO(["      /* unbusy this TLB entry: */"])
	AS_ECHO(["      tme_bus_tlb_unbusy(tlb);"])
	AS_ECHO(["    }"])
	AS_ECHO([""])
	AS_ECHO(["    /* otherwise, we have to do a slow ${name}: */"])
	AS_ECHO(["    else {"])
	AS_ECHO([""])
	AS_ECHO(["      /* get the size of this bus cycle: */"])
	AS_ECHO(["      count = (1 << TME_BUS${i_width}_LOG2);"])
	AS_ECHO(["      count -= (address_init & (count - 1));"])
	AS_ECHO(["      count = TME_MIN(count, size);"])
	AS_ECHO([""])
	AS_ECHO(["      /* fill the cycle structure: */"])
	AS_ECHO(["      cycle.tme_bus_cycle_type = TME_BUS_CYCLE_${capname};"])
	AS_ECHO(["      cycle.tme_bus_cycle_size = count;"])
	AS_ECHO(["      cycle.tme_bus_cycle_buffer = (tme_uint8_t *) buffer; /* XXX this breaks const */"])
	AS_ECHO(["      cycle.tme_bus_cycle_buffer_increment = 1;"])
	AS_ECHO(["      cycle.tme_bus_cycle_lane_routing"])
	AS_ECHO(["        = (bus_device->tme_bus_device_router"])
	AS_ECHO(["           + TME_BUS_ROUTER_INIT_INDEX(TME_BUS${i_width}_LOG2, count, address_init));"])
	AS_ECHO([""])
	AS_ECHO(["      /* XXX this should come from a socket configuration: */"])
	AS_ECHO(["      cycle.tme_bus_cycle_port = TME_BUS_CYCLE_PORT(0, TME_BUS${i_width}_LOG2);"])
	AS_ECHO([""])
	AS_ECHO(["      /* form the physical address for the bus cycle handler: */"])
	AS_ECHO(["      address_resp = tlb->tme_bus_tlb_addr_offset + address_init;"])
	AS_ECHO(["      shift = tlb->tme_bus_tlb_addr_shift;"])
	AS_ECHO(["      if (shift < 0) {"])
	AS_ECHO(["        address_resp <<= (0 - shift);"])
	AS_ECHO(["      }"])
	AS_ECHO(["      else if (shift > 0) {"])
	AS_ECHO(["        address_resp >>= shift;"])
	AS_ECHO(["      }"])
	AS_ECHO(["      cycle.tme_bus_cycle_address = address_resp;"])
	AS_ECHO([""])
	AS_ECHO(["      /* unbusy this TLB entry: */"])
	AS_ECHO(["      tme_bus_tlb_unbusy(tlb);"])
	AS_ECHO([""])
	AS_ECHO(["      /* unlock the device: */"])
	AS_ECHO(["      (*bus_device->tme_bus_device_unlock)(bus_device, locks);"])
	AS_ECHO([""])
	AS_ECHO(["      /* run the bus cycle: */"])
	AS_ECHO(["      err = (*tlb->tme_bus_tlb_cycle)"])
	AS_ECHO(["           (tlb->tme_bus_tlb_cycle_private, &cycle);"])
	AS_ECHO([""])
	AS_ECHO(["      /* if the TLB entry was invalidated before the ${name}: */"])
	AS_ECHO(["      if (err == EBADF"])
	AS_ECHO(["          && tme_bus_tlb_is_invalid(tlb)) {"])
	AS_ECHO(["        count = 0;"])
	AS_ECHO(["      }"])
	AS_ECHO([""])
	AS_ECHO(["      /* otherwise, any other error might be a bus error: */"])
	AS_ECHO(["      else if (err != TME_OK) {"])
	AS_ECHO(["        err = tme_bus_tlb_fault(tlb, &cycle, err);"])
	AS_ECHO(["        assert (err != TME_OK);"])
	AS_ECHO(["      }"])
	AS_ECHO([""])
	AS_ECHO(["      /* lock the device: */"])
	AS_ECHO(["      (*bus_device->tme_bus_device_lock)(bus_device, locks);"])
	AS_ECHO(["    }"])
	AS_ECHO([""])
	AS_ECHO(["    /* update the address, buffer, and size and continue: */"])
	AS_ECHO(["    address_init += count;"])
	AS_ECHO(["    buffer += count;"])
	AS_ECHO(["    size -= count;"])
	AS_ECHO(["  }"])
	AS_ECHO([""])
	AS_ECHO(["  return (err);"])
	AS_ECHO(["}"])
    done

done

# done:
#
exit 0
