/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/PRGn.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 0, 68, 27, 255, 27, 120, 55, 255, 90, 174, 97, 255, 166, 219, 160, 255, 217, 240, 211, 255, 247, 247, 247, 255, 231, 212, 232, 255, 194, 165, 207, 255, 153, 112, 171, 255, 118, 42, 131, 255, 64, 0, 75, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PRGn_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 68, 27, 7, 0, 68, 27, 14, 0, 69, 27, 22, 0, 69, 28, 29, 0, 70, 28, 37, 0, 70, 28, 44, 1, 71, 28, 52, 1, 71, 29, 59, 1, 72, 29, 67, 1, 72, 29, 74, 1, 73, 29, 82, 1, 73, 30, 89, 2, 74, 30, 97, 2, 74, 30, 104, 2, 75, 30, 112, 2, 75, 31, 119, 2, 76, 31, 127, 3, 76, 31, 134, 3, 77, 32, 141, 3, 77, 32, 149, 3, 78, 32, 156, 3, 78, 32, 164, 4, 79, 33, 171, 4, 79, 33, 179, 4, 80, 33, 186, 4, 80, 33, 194, 5, 81, 34, 201, 5, 81, 34, 209, 5, 82, 34, 216, 5, 82, 35, 224, 5, 83, 35, 231, 6, 83, 35, 239, 6, 84, 35, 246, 6, 84, 36, 254, 7, 85, 36, 255, 7, 85, 36, 255, 7, 86, 36, 255, 7, 86, 37, 255, 8, 87, 37, 255, 8, 87, 37, 255, 8, 88, 37, 255, 9, 88, 38, 255, 9, 89, 38, 255, 9, 89, 38, 255, 9, 90, 39, 255, 10, 90, 39, 255, 10, 91, 39, 255, 10, 91, 39, 255, 11, 92, 40, 255, 11, 92, 40, 255, 11, 93, 40, 255, 12, 93, 40, 255, 12, 94, 41, 255, 12, 94, 41, 255, 12, 95, 41, 255, 13, 95, 42, 255, 13, 96, 42, 255, 13, 96, 42, 255, 14, 97, 42, 255, 14, 97, 43, 255, 14, 98, 43, 255, 15, 98, 43, 255, 15, 99, 44, 255, 15, 99, 44, 255, 15, 100, 44, 255, 16, 100, 44, 255, 16, 101, 45, 255, 16, 101, 45, 255, 17, 102, 45, 255, 17, 103, 45, 255, 17, 103, 46, 255, 18, 104, 46, 255, 18, 104, 46, 255, 18, 105, 47, 255, 18, 105, 47, 255, 19, 106, 47, 255, 19, 106, 47, 255, 19, 107, 48, 255, 20, 107, 48, 255, 20, 108, 48, 255, 20, 108, 49, 255, 20, 109, 49, 255, 21, 109, 49, 255, 21, 110, 49, 255, 21, 110, 50, 255, 22, 111, 50, 255, 22, 111, 50, 255, 22, 112, 50, 255, 23, 112, 51, 255, 23, 113, 51, 255, 23, 113, 51, 255, 23, 114, 52, 255, 24, 115, 52, 255, 24, 115, 52, 255, 24, 116, 52, 255, 25, 116, 53, 255, 25, 117, 53, 255, 25, 117, 53, 255, 25, 118, 54, 255, 26, 118, 54, 255, 26, 119, 54, 255, 26, 119, 54, 255, 27, 120, 55, 255, 28, 120, 55, 255, 28, 121, 56, 255, 29, 121, 56, 255, 30, 122, 56, 255, 31, 122, 57, 255, 31, 123, 57, 255, 32, 123, 58, 255, 33, 124, 58, 255, 34, 124, 58, 255, 34, 125, 59, 255, 35, 125, 59, 255, 36, 126, 60, 255, 36, 126, 60, 255, 37, 127, 60, 255, 38, 128, 61, 255, 38, 128, 61, 255, 39, 129, 61, 255, 40, 129, 62, 255, 40, 130, 62, 255, 41, 130, 63, 255, 42, 131, 63, 255, 42, 131, 64, 255, 43, 132, 64, 255, 44, 132, 64, 255, 44, 133, 65, 255, 45, 133, 65, 255, 46, 134, 66, 255, 46, 134, 66, 255, 47, 135, 66, 255, 47, 135, 67, 255, 48, 136, 67, 255, 49, 136, 68, 255, 49, 137, 68, 255, 50, 137, 68, 255, 50, 138, 69, 255, 51, 138, 69, 255, 52, 139, 70, 255, 52, 139, 70, 255, 53, 140, 70, 255, 54, 141, 71, 255, 54, 141, 71, 255, 55, 142, 72, 255, 55, 142, 72, 255, 56, 143, 72, 255, 57, 143, 73, 255, 57, 144, 73, 255, 58, 144, 74, 255, 58, 145, 74, 255, 59, 145, 74, 255, 60, 146, 75, 255, 60, 146, 75, 255, 61, 147, 76, 255, 61, 147, 76, 255, 62, 148, 77, 255, 63, 148, 77, 255, 63, 149, 77, 255, 64, 150, 78, 255, 64, 150, 78, 255, 65, 151, 79, 255, 65, 151, 79, 255, 66, 152, 79, 255, 67, 152, 80, 255, 67, 153, 80, 255, 68, 153, 81, 255, 68, 154, 81, 255, 69, 154, 81, 255, 70, 155, 82, 255, 70, 155, 82, 255, 71, 156, 83, 255, 71, 156, 83, 255, 72, 157, 84, 255, 72, 157, 84, 255, 73, 158, 84, 255, 74, 159, 85, 255, 74, 159, 85, 255, 75, 160, 86, 255, 75, 160, 86, 255, 76, 161, 86, 255, 76, 161, 87, 255, 77, 162, 87, 255, 78, 162, 88, 255, 78, 163, 88, 255, 79, 163, 89, 255, 79, 164, 89, 255, 80, 164, 89, 255, 80, 165, 90, 255, 81, 166, 90, 255, 82, 166, 91, 255, 82, 167, 91, 255, 83, 167, 92, 255, 83, 168, 92, 255, 84, 168, 92, 255, 84, 169, 93, 255, 85, 169, 93, 255, 86, 170, 94, 255, 86, 170, 94, 255, 87, 171, 94, 255, 87, 171, 95, 255, 88, 172, 95, 255, 88, 173, 96, 255, 89, 173, 96, 255, 90, 174, 97, 255, 90, 174, 97, 255, 91, 174, 98, 255, 92, 175, 98, 255, 93, 175, 99, 255, 94, 176, 100, 255, 94, 176, 100, 255, 95, 177, 101, 255, 96, 177, 101, 255, 97, 178, 102, 255, 98, 178, 103, 255, 98, 178, 103, 255, 99, 179, 104, 255, 100, 179, 104, 255, 101, 180, 105, 255, 102, 180, 106, 255, 102, 181, 106, 255, 103, 181, 107, 255, 104, 181, 107, 255, 105, 182, 108, 255, 105, 182, 109, 255, 106, 183, 109, 255, 107, 183, 110, 255, 108, 184, 110, 255, 109, 184, 111, 255, 109, 184, 112, 255, 110, 185, 112, 255, 111, 185, 113, 255, 112, 186, 113, 255, 112, 186, 114, 255, 113, 187, 115, 255, 114, 187, 115, 255, 115, 188, 116, 255, 115, 188, 116, 255, 116, 188, 117, 255, 117, 189, 118, 255, 118, 189, 118, 255, 118, 190, 119, 255, 119, 190, 119, 255, 120, 191, 120, 255, 121, 191, 121, 255, 121, 192, 121, 255, 122, 192, 122, 255, 123, 192, 122, 255, 124, 193, 123, 255, 124, 193, 124, 255, 125, 194, 124, 255, 126, 194, 125, 255, 127, 195, 125, 255, 127, 195, 126, 255, 128, 195, 127, 255, 129, 196, 127, 255, 129, 196, 128, 255, 130, 197, 129, 255, 131, 197, 129, 255, 132, 198, 130, 255, 132, 198, 130, 255, 133, 199, 131, 255, 134, 199, 132, 255, 135, 199, 132, 255, 135, 200, 133, 255, 136, 200, 133, 255, 137, 201, 134, 255, 137, 201, 135, 255, 138, 202, 135, 255, 139, 202, 136, 255, 140, 202, 137, 255, 140, 203, 137, 255, 141, 203, 138, 255, 142, 204, 138, 255, 143, 204, 139, 255, 143, 205, 140, 255, 144, 205, 140, 255, 145, 206, 141, 255, 145, 206, 142, 255, 146, 206, 142, 255, 147, 207, 143, 255, 148, 207, 143, 255, 148, 208, 144, 255, 149, 208, 145, 255, 150, 209, 145, 255, 150, 209, 146, 255, 151, 210, 147, 255, 152, 210, 147, 255, 153, 210, 148, 255, 153, 211, 149, 255, 154, 211, 149, 255, 155, 212, 150, 255, 155, 212, 150, 255, 156, 213, 151, 255, 157, 213, 152, 255, 158, 214, 152, 255, 158, 214, 153, 255, 159, 214, 154, 255, 160, 215, 154, 255, 160, 215, 155, 255, 161, 216, 156, 255, 162, 216, 156, 255, 163, 217, 157, 255, 163, 217, 157, 255, 164, 218, 158, 255, 165, 218, 159, 255, 165, 218, 159, 255, 166, 219, 160, 255, 166, 219, 160, 255, 167, 219, 161, 255, 167, 219, 161, 255, 168, 219, 162, 255, 169, 220, 162, 255, 169, 220, 163, 255, 170, 220, 163, 255, 170, 220, 164, 255, 171, 221, 164, 255, 171, 221, 165, 255, 172, 221, 165, 255, 172, 221, 166, 255, 173, 221, 166, 255, 173, 222, 167, 255, 174, 222, 167, 255, 174, 222, 168, 255, 175, 222, 168, 255, 175, 222, 169, 255, 176, 223, 169, 255, 176, 223, 170, 255, 177, 223, 170, 255, 177, 223, 171, 255, 178, 223, 171, 255, 178, 224, 172, 255, 179, 224, 172, 255, 179, 224, 173, 255, 180, 224, 173, 255, 180, 224, 174, 255, 181, 225, 174, 255, 181, 225, 174, 255, 182, 225, 175, 255, 182, 225, 175, 255, 183, 225, 176, 255, 183, 226, 176, 255, 184, 226, 177, 255, 184, 226, 177, 255, 185, 226, 178, 255, 185, 226, 178, 255, 186, 227, 179, 255, 186, 227, 179, 255, 187, 227, 180, 255, 187, 227, 180, 255, 188, 228, 181, 255, 188, 228, 181, 255, 189, 228, 182, 255, 189, 228, 182, 255, 190, 228, 183, 255, 190, 229, 183, 255, 191, 229, 184, 255, 191, 229, 184, 255, 192, 229, 185, 255, 192, 229, 185, 255, 193, 230, 186, 255, 193, 230, 186, 255, 194, 230, 187, 255, 194, 230, 187, 255, 195, 230, 188, 255, 195, 231, 188, 255, 196, 231, 189, 255, 196, 231, 189, 255, 197, 231, 190, 255, 197, 231, 190, 255, 198, 232, 191, 255, 198, 232, 191, 255, 199, 232, 192, 255, 199, 232, 192, 255, 200, 232, 193, 255, 200, 233, 193, 255, 201, 233, 194, 255, 201, 233, 194, 255, 202, 233, 195, 255, 202, 233, 195, 255, 203, 234, 196, 255, 203, 234, 196, 255, 204, 234, 197, 255, 204, 234, 197, 255, 205, 234, 198, 255, 205, 235, 198, 255, 206, 235, 199, 255, 206, 235, 199, 255, 207, 235, 200, 255, 207, 235, 200, 255, 208, 236, 201, 255, 208, 236, 201, 255, 209, 236, 202, 255, 209, 236, 203, 255, 209, 237, 203, 255, 210, 237, 204, 255, 210, 237, 204, 255, 211, 237, 205, 255, 211, 237, 205, 255, 212, 238, 206, 255, 212, 238, 206, 255, 213, 238, 207, 255, 213, 238, 207, 255, 214, 238, 208, 255, 214, 239, 208, 255, 215, 239, 209, 255, 215, 239, 209, 255, 216, 239, 210, 255, 216, 239, 210, 255, 217, 239, 210, 255, 218, 239, 210, 255, 219, 239, 210, 255, 220, 239, 210, 255, 221, 239, 210, 255, 222, 239, 210, 255, 223, 239, 210, 255, 225, 239, 210, 255, 226, 239, 210, 255, 227, 239, 209, 255, 228, 238, 210, 255, 229, 238, 210, 255, 230, 238, 210, 255, 230, 238, 210, 255, 231, 238, 210, 255, 232, 238, 210, 255, 233, 238, 210, 255, 234, 238, 210, 255, 235, 238, 210, 255, 236, 238, 211, 255, 237, 238, 211, 255, 237, 237, 211, 255, 238, 237, 211, 255, 239, 237, 212, 255, 240, 237, 212, 255, 240, 237, 212, 255, 241, 237, 212, 255, 242, 237, 213, 255, 243, 237, 213, 255, 243, 237, 214, 255, 244, 237, 214, 255, 244, 237, 214, 255, 245, 237, 215, 255, 246, 237, 215, 255, 246, 237, 216, 255, 247, 237, 216, 255, 247, 237, 217, 255, 248, 237, 217, 255, 248, 237, 218, 255, 249, 237, 218, 255, 249, 237, 219, 255, 250, 237, 219, 255, 250, 237, 220, 255, 250, 237, 220, 255, 251, 237, 221, 255, 251, 237, 221, 255, 251, 237, 222, 255, 252, 237, 222, 255, 252, 237, 223, 255, 252, 237, 223, 255, 252, 237, 224, 255, 253, 237, 225, 255, 253, 237, 225, 255, 253, 237, 226, 255, 253, 237, 226, 255, 253, 238, 227, 255, 253, 238, 227, 255, 253, 238, 228, 255, 253, 238, 229, 255, 254, 238, 229, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 231, 255, 254, 238, 231, 255, 254, 239, 232, 255, 254, 239, 233, 255, 254, 239, 233, 255, 254, 239, 234, 255, 253, 239, 234, 255, 253, 239, 235, 255, 253, 240, 235, 255, 253, 240, 236, 255, 253, 240, 236, 255, 253, 240, 237, 255, 253, 240, 237, 255, 253, 240, 238, 255, 252, 241, 238, 255, 252, 241, 239, 255, 252, 241, 239, 255, 252, 241, 240, 255, 252, 241, 240, 255, 251, 242, 241, 255, 251, 242, 241, 255, 251, 242, 241, 255, 251, 242, 242, 255, 251, 243, 242, 255, 250, 243, 243, 255, 250, 243, 243, 255, 250, 243, 243, 255, 250, 243, 244, 255, 249, 244, 244, 255, 249, 244, 244, 255, 249, 244, 244, 255, 249, 244, 245, 255, 248, 245, 245, 255, 248, 245, 245, 255, 248, 245, 245, 255, 248, 245, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 247, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 245, 246, 255, 246, 245, 245, 255, 246, 245, 245, 255, 246, 244, 245, 255, 246, 244, 245, 255, 246, 244, 244, 255, 246, 243, 244, 255, 246, 243, 244, 255, 246, 243, 244, 255, 246, 242, 243, 255, 246, 242, 243, 255, 246, 241, 243, 255, 246, 241, 243, 255, 246, 241, 242, 255, 246, 240, 242, 255, 246, 240, 242, 255, 245, 240, 242, 255, 245, 239, 241, 255, 245, 239, 241, 255, 245, 239, 241, 255, 245, 238, 241, 255, 245, 238, 241, 255, 245, 237, 240, 255, 245, 237, 240, 255, 245, 237, 240, 255, 245, 236, 240, 255, 245, 236, 239, 255, 245, 236, 239, 255, 244, 235, 239, 255, 244, 235, 239, 255, 244, 235, 239, 255, 244, 234, 239, 255, 244, 234, 238, 255, 244, 234, 238, 255, 244, 233, 238, 255, 244, 233, 238, 255, 244, 232, 238, 255, 243, 232, 237, 255, 243, 232, 237, 255, 243, 231, 237, 255, 243, 231, 237, 255, 243, 231, 237, 255, 243, 230, 237, 255, 243, 230, 236, 255, 243, 230, 236, 255, 242, 229, 236, 255, 242, 229, 236, 255, 242, 229, 236, 255, 242, 228, 236, 255, 242, 228, 236, 255, 242, 228, 235, 255, 242, 227, 235, 255, 241, 227, 235, 255, 241, 227, 235, 255, 241, 226, 235, 255, 241, 226, 235, 255, 241, 226, 235, 255, 241, 225, 235, 255, 240, 225, 234, 255, 240, 225, 234, 255, 240, 224, 234, 255, 240, 224, 234, 255, 240, 224, 234, 255, 239, 223, 234, 255, 239, 223, 234, 255, 239, 223, 234, 255, 239, 222, 234, 255, 239, 222, 233, 255, 238, 222, 233, 255, 238, 221, 233, 255, 238, 221, 233, 255, 238, 221, 233, 255, 238, 220, 233, 255, 237, 220, 233, 255, 237, 220, 233, 255, 237, 219, 233, 255, 237, 219, 233, 255, 236, 219, 233, 255, 236, 218, 233, 255, 236, 218, 233, 255, 236, 218, 232, 255, 236, 217, 232, 255, 235, 217, 232, 255, 235, 217, 232, 255, 235, 216, 232, 255, 235, 216, 232, 255, 234, 216, 232, 255, 234, 215, 232, 255, 234, 215, 232, 255, 233, 215, 232, 255, 233, 214, 232, 255, 233, 214, 232, 255, 233, 214, 232, 255, 232, 213, 232, 255, 232, 213, 232, 255, 232, 213, 232, 255, 232, 213, 232, 255, 231, 212, 232, 255, 231, 212, 232, 255, 231, 212, 232, 255, 230, 211, 231, 255, 230, 211, 231, 255, 230, 210, 231, 255, 229, 210, 231, 255, 229, 209, 230, 255, 229, 209, 230, 255, 228, 208, 230, 255, 228, 208, 229, 255, 228, 207, 229, 255, 227, 207, 229, 255, 227, 206, 229, 255, 227, 206, 228, 255, 226, 206, 228, 255, 226, 205, 228, 255, 226, 205, 228, 255, 225, 204, 227, 255, 225, 204, 227, 255, 225, 203, 227, 255, 224, 203, 227, 255, 224, 202, 226, 255, 224, 202, 226, 255, 223, 201, 226, 255, 223, 201, 226, 255, 223, 200, 225, 255, 222, 200, 225, 255, 222, 199, 225, 255, 221, 199, 225, 255, 221, 198, 224, 255, 221, 198, 224, 255, 220, 198, 224, 255, 220, 197, 224, 255, 220, 197, 223, 255, 219, 196, 223, 255, 219, 196, 223, 255, 219, 195, 223, 255, 218, 195, 222, 255, 218, 194, 222, 255, 218, 194, 222, 255, 217, 193, 222, 255, 217, 193, 221, 255, 217, 192, 221, 255, 216, 192, 221, 255, 216, 192, 221, 255, 216, 191, 220, 255, 215, 191, 220, 255, 215, 190, 220, 255, 214, 190, 220, 255, 214, 189, 219, 255, 214, 189, 219, 255, 213, 188, 219, 255, 213, 188, 219, 255, 213, 187, 218, 255, 212, 187, 218, 255, 212, 186, 218, 255, 212, 186, 218, 255, 211, 186, 217, 255, 211, 185, 217, 255, 210, 185, 217, 255, 210, 184, 217, 255, 210, 184, 216, 255, 209, 183, 216, 255, 209, 183, 216, 255, 209, 182, 216, 255, 208, 182, 215, 255, 208, 181, 215, 255, 208, 181, 215, 255, 207, 181, 215, 255, 207, 180, 215, 255, 206, 180, 214, 255, 206, 179, 214, 255, 206, 179, 214, 255, 205, 178, 214, 255, 205, 178, 213, 255, 205, 177, 213, 255, 204, 177, 213, 255, 204, 176, 213, 255, 203, 176, 212, 255, 203, 176, 212, 255, 203, 175, 212, 255, 202, 175, 212, 255, 202, 174, 211, 255, 202, 174, 211, 255, 201, 173, 211, 255, 201, 173, 211, 255, 200, 172, 211, 255, 200, 172, 210, 255, 200, 172, 210, 255, 199, 171, 210, 255, 199, 171, 210, 255, 198, 170, 209, 255, 198, 170, 209, 255, 198, 169, 209, 255, 197, 169, 209, 255, 197, 168, 208, 255, 197, 168, 208, 255, 196, 168, 208, 255, 196, 167, 208, 255, 195, 167, 208, 255, 195, 166, 207, 255, 195, 166, 207, 255, 194, 165, 207, 255, 194, 165, 207, 255, 193, 164, 206, 255, 193, 164, 206, 255, 193, 163, 206, 255, 192, 163, 205, 255, 192, 162, 205, 255, 191, 162, 205, 255, 191, 161, 204, 255, 191, 161, 204, 255, 190, 160, 204, 255, 190, 160, 203, 255, 189, 159, 203, 255, 189, 159, 203, 255, 189, 158, 202, 255, 188, 158, 202, 255, 188, 157, 201, 255, 187, 156, 201, 255, 187, 156, 201, 255, 187, 155, 200, 255, 186, 155, 200, 255, 186, 154, 200, 255, 185, 154, 199, 255, 185, 153, 199, 255, 185, 153, 199, 255, 184, 152, 198, 255, 184, 152, 198, 255, 183, 151, 198, 255, 183, 151, 197, 255, 183, 150, 197, 255, 182, 150, 197, 255, 182, 149, 196, 255, 181, 149, 196, 255, 181, 148, 195, 255, 181, 148, 195, 255, 180, 147, 195, 255, 180, 147, 194, 255, 179, 146, 194, 255, 179, 146, 194, 255, 179, 145, 193, 255, 178, 144, 193, 255, 178, 144, 193, 255, 177, 143, 192, 255, 177, 143, 192, 255, 176, 142, 192, 255, 176, 142, 191, 255, 176, 141, 191, 255, 175, 141, 191, 255, 175, 140, 190, 255, 174, 140, 190, 255, 174, 139, 189, 255, 174, 139, 189, 255, 173, 138, 189, 255, 173, 138, 188, 255, 172, 137, 188, 255, 172, 137, 188, 255, 172, 136, 187, 255, 171, 136, 187, 255, 171, 135, 187, 255, 170, 135, 186, 255, 170, 134, 186, 255, 170, 134, 186, 255, 169, 133, 185, 255, 169, 133, 185, 255, 168, 132, 185, 255, 168, 132, 184, 255, 168, 131, 184, 255, 167, 131, 184, 255, 167, 130, 183, 255, 166, 129, 183, 255, 166, 129, 182, 255, 166, 128, 182, 255, 165, 128, 182, 255, 165, 127, 181, 255, 165, 127, 181, 255, 164, 126, 181, 255, 164, 126, 180, 255, 163, 125, 180, 255, 163, 125, 180, 255, 163, 124, 179, 255, 162, 124, 179, 255, 162, 123, 179, 255, 161, 123, 178, 255, 161, 122, 178, 255, 161, 122, 178, 255, 160, 121, 177, 255, 160, 121, 177, 255, 159, 120, 177, 255, 159, 120, 176, 255, 159, 119, 176, 255, 158, 119, 175, 255, 158, 118, 175, 255, 157, 118, 175, 255, 157, 117, 174, 255, 157, 117, 174, 255, 156, 116, 174, 255, 156, 116, 173, 255, 155, 115, 173, 255, 155, 115, 173, 255, 155, 114, 172, 255, 154, 114, 172, 255, 154, 113, 172, 255, 153, 113, 171, 255, 153, 112, 171, 255, 153, 112, 171, 255, 152, 111, 170, 255, 152, 110, 170, 255, 151, 110, 169, 255, 151, 109, 169, 255, 151, 108, 169, 255, 150, 108, 168, 255, 150, 107, 168, 255, 150, 106, 168, 255, 149, 106, 167, 255, 149, 105, 167, 255, 149, 105, 167, 255, 148, 104, 166, 255, 148, 103, 166, 255, 148, 103, 165, 255, 147, 102, 165, 255, 147, 101, 165, 255, 147, 101, 164, 255, 146, 100, 164, 255, 146, 99, 164, 255, 145, 99, 163, 255, 145, 98, 163, 255, 145, 97, 162, 255, 144, 97, 162, 255, 144, 96, 162, 255, 144, 96, 161, 255, 143, 95, 161, 255, 143, 94, 161, 255, 143, 94, 160, 255, 142, 93, 160, 255, 142, 92, 159, 255, 142, 92, 159, 255, 141, 91, 159, 255, 141, 90, 158, 255, 141, 90, 158, 255, 140, 89, 157, 255, 140, 88, 157, 255, 140, 88, 157, 255, 139, 87, 156, 255, 139, 86, 156, 255, 139, 86, 156, 255, 138, 85, 155, 255, 138, 84, 155, 255, 137, 84, 154, 255, 137, 83, 154, 255, 137, 82, 154, 255, 136, 82, 153, 255, 136, 81, 153, 255, 136, 80, 152, 255, 135, 80, 152, 255, 135, 79, 152, 255, 135, 78, 151, 255, 134, 78, 151, 255, 134, 77, 150, 255, 134, 76, 150, 255, 133, 76, 150, 255, 133, 75, 149, 255, 133, 74, 149, 255, 132, 74, 149, 255, 132, 73, 148, 255, 132, 72, 148, 255, 131, 72, 147, 255, 131, 71, 147, 255, 131, 70, 147, 255, 130, 70, 146, 255, 130, 69, 146, 255, 130, 68, 145, 255, 129, 68, 145, 255, 129, 67, 145, 255, 129, 66, 144, 255, 128, 66, 144, 255, 128, 65, 143, 255, 128, 64, 143, 255, 127, 63, 143, 255, 127, 63, 142, 255, 127, 62, 142, 255, 126, 61, 141, 255, 126, 61, 141, 255, 126, 60, 141, 255, 125, 59, 140, 255, 125, 59, 140, 255, 125, 58, 139, 255, 124, 57, 139, 255, 124, 56, 139, 255, 124, 56, 138, 255, 123, 55, 138, 255, 123, 54, 137, 255, 123, 53, 137, 255, 122, 53, 136, 255, 122, 52, 136, 255, 122, 51, 136, 255, 121, 51, 135, 255, 121, 50, 135, 255, 121, 49, 134, 255, 120, 48, 134, 255, 120, 47, 134, 255, 120, 47, 133, 255, 119, 46, 133, 255, 119, 45, 132, 255, 119, 44, 132, 255, 118, 44, 132, 255, 118, 43, 131, 255, 118, 42, 131, 255, 117, 41, 130, 255, 117, 41, 130, 255, 116, 41, 129, 255, 116, 40, 129, 255, 115, 40, 128, 255, 115, 39, 127, 255, 114, 39, 127, 255, 113, 39, 126, 255, 113, 38, 126, 255, 112, 38, 125, 255, 112, 37, 125, 255, 111, 37, 124, 255, 111, 37, 123, 255, 110, 36, 123, 255, 110, 36, 122, 255, 109, 35, 122, 255, 109, 35, 121, 255, 108, 35, 121, 255, 107, 34, 120, 255, 107, 34, 119, 255, 106, 33, 119, 255, 106, 33, 118, 255, 105, 33, 118, 255, 105, 32, 117, 255, 104, 32, 117, 255, 104, 31, 116, 255, 103, 31, 116, 255, 103, 31, 115, 255, 102, 30, 114, 255, 102, 30, 114, 255, 101, 29, 113, 255, 100, 29, 113, 255, 100, 29, 112, 255, 99, 28, 112, 255, 99, 28, 111, 255, 98, 27, 111, 255, 98, 27, 110, 255, 97, 26, 109, 255, 97, 26, 109, 255, 96, 26, 108, 255, 96, 25, 108, 255, 95, 25, 107, 255, 95, 24, 107, 255, 94, 24, 106, 255, 94, 24, 106, 255, 93, 23, 105, 255, 92, 23, 104, 255, 92, 22, 104, 255, 91, 22, 103, 255, 91, 22, 103, 255, 90, 21, 102, 255, 90, 21, 102, 255, 89, 20, 101, 255, 89, 20, 101, 255, 88, 19, 100, 255, 88, 19, 100, 255, 87, 19, 99, 255, 87, 18, 98, 255, 86, 18, 98, 255, 86, 17, 97, 255, 85, 17, 97, 255, 85, 16, 96, 255, 84, 16, 96, 255, 84, 16, 95, 255, 83, 15, 95, 255, 82, 15, 94, 255, 82, 14, 94, 255, 81, 14, 93, 255, 81, 13, 92, 255, 80, 13, 92, 255, 80, 12, 91, 255, 79, 12, 91, 255, 79, 11, 90, 255, 78, 11, 90, 255, 78, 11, 89, 255, 77, 10, 89, 255, 77, 10, 88, 255, 76, 9, 88, 255, 76, 9, 87, 255, 75, 8, 87, 255, 75, 8, 86, 255, 74, 7, 86, 255, 74, 7, 85, 255, 73, 6, 84, 255, 73, 6, 84, 255, 72, 5, 83, 255, 72, 5, 83, 255, 71, 5, 82, 255, 71, 4, 82, 255, 70, 4, 81, 255, 70, 4, 81, 255, 69, 3, 80, 255, 69, 3, 80, 255, 68, 2, 79, 255, 68, 2, 79, 255, 67, 2, 78, 255, 67, 1, 78, 255, 66, 1, 77, 255, 66, 1, 77, 255, 65, 0, 76, 255, 65, 0, 76, 255, 64, 0, 75, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PRGn_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 68, 27, 7, 0, 68, 27, 14, 0, 69, 27, 22, 0, 69, 27, 29, 0, 69, 28, 37, 0, 70, 28, 44, 0, 70, 28, 52, 0, 71, 28, 59, 1, 71, 28, 67, 1, 71, 29, 74, 1, 72, 29, 82, 1, 72, 29, 89, 1, 73, 29, 97, 1, 73, 29, 104, 1, 73, 30, 112, 2, 74, 30, 119, 2, 74, 30, 127, 2, 75, 30, 134, 2, 75, 31, 141, 2, 75, 31, 149, 2, 76, 31, 156, 3, 76, 31, 164, 3, 76, 31, 171, 3, 77, 32, 179, 3, 77, 32, 186, 3, 78, 32, 194, 4, 78, 32, 201, 4, 78, 32, 209, 4, 79, 33, 216, 4, 79, 33, 224, 4, 80, 33, 231, 4, 80, 33, 239, 5, 80, 34, 246, 5, 81, 34, 254, 5, 81, 34, 255, 5, 82, 34, 255, 6, 82, 34, 255, 6, 82, 35, 255, 6, 83, 35, 255, 6, 83, 35, 255, 6, 84, 35, 255, 7, 84, 36, 255, 7, 84, 36, 255, 7, 85, 36, 255, 7, 85, 36, 255, 8, 86, 36, 255, 8, 86, 37, 255, 8, 87, 37, 255, 8, 87, 37, 255, 9, 87, 37, 255, 9, 88, 37, 255, 15, 99, 43, 255, 15, 99, 44, 255, 15, 99, 44, 255, 15, 100, 44, 255, 16, 100, 44, 255, 16, 101, 44, 255, 16, 101, 45, 255, 16, 101, 45, 255, 16, 102, 45, 255, 17, 102, 45, 255, 17, 103, 45, 255, 17, 103, 46, 255, 17, 103, 46, 255, 18, 104, 46, 255, 18, 104, 46, 255, 18, 105, 47, 255, 18, 105, 47, 255, 19, 106, 47, 255, 19, 106, 47, 255, 19, 106, 47, 255, 19, 107, 48, 255, 20, 107, 48, 255, 20, 108, 48, 255, 20, 108, 48, 255, 20, 108, 49, 255, 21, 109, 49, 255, 21, 109, 49, 255, 21, 110, 49, 255, 21, 110, 49, 255, 21, 110, 50, 255, 22, 111, 50, 255, 22, 111, 50, 255, 22, 112, 50, 255, 22, 112, 51, 255, 23, 113, 51, 255, 23, 113, 51, 255, 23, 113, 51, 255, 23, 114, 51, 255, 24, 114, 52, 255, 24, 115, 52, 255, 24, 115, 52, 255, 24, 116, 52, 255, 25, 116, 53, 255, 25, 116, 53, 255, 25, 117, 53, 255, 25, 117, 53, 255, 25, 118, 54, 255, 26, 118, 54, 255, 26, 118, 54, 255, 26, 119, 54, 255, 26, 119, 54, 255, 27, 120, 55, 255, 27, 120, 55, 255, 28, 121, 55, 255, 29, 121, 56, 255, 29, 121, 56, 255, 30, 122, 56, 255, 30, 122, 57, 255, 31, 123, 57, 255, 32, 123, 57, 255, 32, 123, 58, 255, 33, 124, 58, 255, 33, 124, 58, 255, 34, 125, 59, 255, 34, 125, 59, 255, 35, 126, 59, 255, 35, 126, 59, 255, 36, 126, 60, 255, 37, 127, 60, 255, 37, 127, 60, 255, 38, 128, 61, 255, 38, 128, 61, 255, 39, 128, 61, 255, 39, 129, 62, 255, 40, 129, 62, 255, 40, 130, 62, 255, 41, 130, 63, 255, 41, 130, 63, 255, 42, 131, 63, 255, 42, 131, 64, 255, 43, 132, 64, 255, 43, 132, 64, 255, 44, 133, 65, 255, 44, 133, 65, 255, 45, 133, 65, 255, 45, 134, 66, 255, 46, 134, 66, 255, 46, 135, 66, 255, 47, 135, 67, 255, 47, 135, 67, 255, 48, 136, 67, 255, 48, 136, 68, 255, 49, 137, 68, 255, 49, 137, 68, 255, 50, 138, 69, 255, 50, 138, 69, 255, 51, 138, 69, 255, 51, 139, 69, 255, 52, 139, 70, 255, 52, 140, 70, 255, 52, 140, 70, 255, 53, 141, 71, 255, 66, 152, 80, 255, 66, 152, 80, 255, 67, 153, 80, 255, 67, 153, 81, 255, 68, 153, 81, 255, 68, 154, 81, 255, 69, 154, 82, 255, 69, 155, 82, 255, 70, 155, 82, 255, 70, 156, 82, 255, 71, 156, 83, 255, 71, 156, 83, 255, 72, 157, 83, 255, 72, 157, 84, 255, 73, 158, 84, 255, 73, 158, 84, 255, 74, 159, 85, 255, 74, 159, 85, 255, 74, 159, 85, 255, 75, 160, 86, 255, 75, 160, 86, 255, 76, 161, 86, 255, 76, 161, 87, 255, 77, 162, 87, 255, 77, 162, 87, 255, 78, 162, 88, 255, 78, 163, 88, 255, 79, 163, 88, 255, 79, 164, 89, 255, 80, 164, 89, 255, 80, 165, 89, 255, 80, 165, 90, 255, 81, 165, 90, 255, 81, 166, 90, 255, 82, 166, 91, 255, 82, 167, 91, 255, 83, 167, 91, 255, 83, 168, 92, 255, 84, 168, 92, 255, 84, 168, 93, 255, 85, 169, 93, 255, 85, 169, 93, 255, 85, 170, 94, 255, 86, 170, 94, 255, 86, 171, 94, 255, 87, 171, 95, 255, 87, 171, 95, 255, 88, 172, 95, 255, 88, 172, 96, 255, 89, 173, 96, 255, 89, 173, 96, 255, 90, 174, 97, 255, 90, 174, 97, 255, 91, 174, 98, 255, 92, 175, 98, 255, 92, 175, 98, 255, 93, 175, 99, 255, 93, 176, 99, 255, 94, 176, 100, 255, 95, 176, 100, 255, 95, 177, 101, 255, 96, 177, 101, 255, 97, 177, 102, 255, 97, 178, 102, 255, 98, 178, 103, 255, 99, 178, 103, 255, 99, 179, 104, 255, 100, 179, 104, 255, 100, 180, 105, 255, 101, 180, 105, 255, 102, 180, 106, 255, 102, 181, 106, 255, 103, 181, 107, 255, 104, 181, 107, 255, 104, 182, 108, 255, 105, 182, 108, 255, 105, 182, 109, 255, 106, 183, 109, 255, 107, 183, 109, 255, 107, 183, 110, 255, 108, 184, 110, 255, 108, 184, 111, 255, 109, 184, 111, 255, 110, 185, 112, 255, 110, 185, 112, 255, 111, 185, 113, 255, 111, 186, 113, 255, 112, 186, 114, 255, 113, 186, 114, 255, 113, 187, 115, 255, 114, 187, 115, 255, 114, 188, 116, 255, 115, 188, 116, 255, 116, 188, 117, 255, 116, 189, 117, 255, 117, 189, 118, 255, 117, 189, 118, 255, 118, 190, 119, 255, 119, 190, 119, 255, 119, 190, 120, 255, 120, 191, 120, 255, 120, 191, 121, 255, 136, 200, 134, 255, 137, 201, 134, 255, 137, 201, 135, 255, 138, 201, 135, 255, 138, 202, 136, 255, 139, 202, 136, 255, 140, 203, 137, 255, 140, 203, 137, 255, 141, 203, 138, 255, 141, 204, 138, 255, 142, 204, 139, 255, 143, 204, 139, 255, 143, 205, 140, 255, 144, 205, 140, 255, 144, 205, 141, 255, 145, 206, 141, 255, 145, 206, 142, 255, 146, 206, 142, 255, 147, 207, 143, 255, 147, 207, 143, 255, 148, 207, 144, 255, 148, 208, 144, 255, 149, 208, 145, 255, 149, 209, 145, 255, 150, 209, 146, 255, 151, 209, 146, 255, 151, 210, 147, 255, 152, 210, 147, 255, 152, 210, 148, 255, 153, 211, 148, 255, 153, 211, 149, 255, 154, 211, 149, 255, 155, 212, 150, 255, 155, 212, 150, 255, 156, 212, 151, 255, 156, 213, 151, 255, 157, 213, 152, 255, 157, 213, 152, 255, 158, 214, 153, 255, 159, 214, 153, 255, 159, 215, 154, 255, 160, 215, 154, 255, 160, 215, 155, 255, 161, 216, 155, 255, 161, 216, 156, 255, 162, 216, 156, 255, 163, 217, 157, 255, 163, 217, 157, 255, 164, 217, 158, 255, 164, 218, 158, 255, 165, 218, 159, 255, 165, 218, 159, 255, 166, 219, 160, 255, 166, 219, 160, 255, 167, 219, 161, 255, 167, 219, 161, 255, 168, 219, 161, 255, 168, 219, 162, 255, 168, 220, 162, 255, 169, 220, 163, 255, 169, 220, 163, 255, 170, 220, 163, 255, 170, 220, 164, 255, 170, 220, 164, 255, 171, 221, 164, 255, 171, 221, 165, 255, 172, 221, 165, 255, 172, 221, 166, 255, 172, 221, 166, 255, 173, 221, 166, 255, 173, 222, 167, 255, 174, 222, 167, 255, 174, 222, 168, 255, 175, 222, 168, 255, 175, 222, 168, 255, 175, 222, 169, 255, 176, 223, 169, 255, 176, 223, 170, 255, 177, 223, 170, 255, 177, 223, 170, 255, 177, 223, 171, 255, 178, 223, 171, 255, 178, 224, 171, 255, 179, 224, 172, 255, 179, 224, 172, 255, 179, 224, 173, 255, 180, 224, 173, 255, 180, 224, 173, 255, 181, 225, 174, 255, 181, 225, 174, 255, 181, 225, 175, 255, 182, 225, 175, 255, 182, 225, 175, 255, 183, 225, 176, 255, 183, 226, 176, 255, 183, 226, 177, 255, 184, 226, 177, 255, 184, 226, 177, 255, 185, 226, 178, 255, 185, 226, 178, 255, 185, 227, 179, 255, 186, 227, 179, 255, 186, 227, 179, 255, 197, 231, 190, 255, 197, 231, 190, 255, 198, 232, 191, 255, 198, 232, 191, 255, 198, 232, 192, 255, 199, 232, 192, 255, 199, 232, 192, 255, 200, 232, 193, 255, 200, 233, 193, 255, 200, 233, 194, 255, 201, 233, 194, 255, 201, 233, 194, 255, 202, 233, 195, 255, 202, 233, 195, 255, 202, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 204, 234, 197, 255, 204, 234, 197, 255, 204, 234, 198, 255, 205, 234, 198, 255, 205, 235, 198, 255, 205, 235, 199, 255, 206, 235, 199, 255, 206, 235, 200, 255, 207, 235, 200, 255, 207, 235, 200, 255, 207, 236, 201, 255, 208, 236, 201, 255, 208, 236, 202, 255, 209, 236, 202, 255, 209, 236, 202, 255, 209, 236, 203, 255, 210, 237, 203, 255, 210, 237, 204, 255, 211, 237, 204, 255, 211, 237, 205, 255, 211, 237, 205, 255, 212, 237, 205, 255, 212, 238, 206, 255, 212, 238, 206, 255, 213, 238, 207, 255, 213, 238, 207, 255, 214, 238, 207, 255, 214, 238, 208, 255, 214, 239, 208, 255, 215, 239, 209, 255, 215, 239, 209, 255, 216, 239, 209, 255, 216, 239, 210, 255, 216, 239, 210, 255, 217, 239, 210, 255, 218, 239, 210, 255, 219, 239, 210, 255, 220, 239, 210, 255, 220, 239, 210, 255, 221, 239, 210, 255, 222, 239, 210, 255, 223, 239, 210, 255, 224, 239, 210, 255, 225, 239, 210, 255, 225, 239, 210, 255, 226, 239, 210, 255, 227, 239, 210, 255, 228, 238, 210, 255, 228, 238, 210, 255, 229, 238, 210, 255, 230, 238, 210, 255, 231, 238, 210, 255, 231, 238, 210, 255, 232, 238, 211, 255, 233, 238, 211, 255, 233, 238, 211, 255, 234, 238, 211, 255, 235, 238, 211, 255, 235, 238, 212, 255, 236, 238, 212, 255, 236, 238, 212, 255, 237, 238, 212, 255, 237, 238, 213, 255, 238, 238, 213, 255, 238, 237, 213, 255, 239, 237, 214, 255, 239, 237, 214, 255, 240, 237, 214, 255, 240, 237, 215, 255, 241, 237, 215, 255, 241, 237, 215, 255, 241, 237, 216, 255, 242, 237, 216, 255, 242, 237, 217, 255, 243, 237, 217, 255, 243, 237, 217, 255, 243, 237, 218, 255, 244, 237, 218, 255, 244, 237, 219, 255, 244, 237, 219, 255, 244, 237, 219, 255, 245, 237, 220, 255, 245, 238, 220, 255, 245, 238, 221, 255, 245, 238, 221, 255, 251, 239, 229, 255, 251, 239, 229, 255, 252, 239, 230, 255, 252, 239, 230, 255, 252, 239, 231, 255, 252, 239, 231, 255, 252, 239, 232, 255, 252, 240, 232, 255, 252, 240, 233, 255, 252, 240, 233, 255, 252, 240, 234, 255, 252, 240, 234, 255, 252, 240, 234, 255, 252, 240, 235, 255, 252, 240, 235, 255, 252, 240, 236, 255, 252, 241, 236, 255, 252, 241, 237, 255, 252, 241, 237, 255, 252, 241, 238, 255, 252, 241, 238, 255, 252, 241, 238, 255, 252, 241, 239, 255, 251, 241, 239, 255, 251, 242, 240, 255, 251, 242, 240, 255, 251, 242, 240, 255, 251, 242, 241, 255, 251, 242, 241, 255, 251, 242, 241, 255, 250, 243, 242, 255, 250, 243, 242, 255, 250, 243, 242, 255, 250, 243, 243, 255, 250, 243, 243, 255, 250, 243, 243, 255, 249, 244, 244, 255, 249, 244, 244, 255, 249, 244, 244, 255, 249, 244, 244, 255, 249, 244, 245, 255, 248, 245, 245, 255, 248, 245, 245, 255, 248, 245, 245, 255, 248, 245, 245, 255, 248, 245, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 247, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 245, 246, 255, 246, 245, 245, 255, 246, 245, 245, 255, 246, 244, 245, 255, 246, 244, 245, 255, 246, 244, 245, 255, 246, 244, 244, 255, 246, 243, 244, 255, 246, 243, 244, 255, 246, 243, 244, 255, 246, 242, 244, 255, 246, 242, 243, 255, 246, 242, 243, 255, 246, 242, 243, 255, 246, 241, 243, 255, 246, 241, 243, 255, 246, 241, 242, 255, 246, 240, 242, 255, 245, 240, 242, 255, 245, 240, 242, 255, 245, 240, 242, 255, 245, 239, 242, 255, 245, 239, 241, 255, 245, 239, 241, 255, 245, 238, 241, 255, 245, 238, 241, 255, 245, 238, 241, 255, 245, 238, 241, 255, 245, 237, 240, 255, 245, 237, 240, 255, 245, 237, 240, 255, 245, 236, 240, 255, 244, 236, 240, 255, 244, 236, 240, 255, 244, 236, 240, 255, 244, 235, 239, 255, 244, 235, 239, 255, 244, 235, 239, 255, 244, 234, 239, 255, 244, 234, 239, 255, 244, 234, 239, 255, 244, 234, 239, 255, 243, 233, 238, 255, 243, 233, 238, 255, 243, 233, 238, 255, 243, 232, 238, 255, 243, 232, 238, 255, 243, 232, 238, 255, 240, 225, 235, 255, 239, 224, 235, 255, 239, 224, 235, 255, 239, 224, 234, 255, 239, 224, 234, 255, 239, 223, 234, 255, 239, 223, 234, 255, 239, 223, 234, 255, 239, 222, 234, 255, 238, 222, 234, 255, 238, 222, 234, 255, 238, 222, 234, 255, 238, 221, 234, 255, 238, 221, 233, 255, 238, 221, 233, 255, 238, 221, 233, 255, 237, 220, 233, 255, 237, 220, 233, 255, 237, 220, 233, 255, 237, 220, 233, 255, 237, 219, 233, 255, 237, 219, 233, 255, 236, 219, 233, 255, 236, 218, 233, 255, 236, 218, 233, 255, 236, 218, 233, 255, 236, 218, 233, 255, 235, 217, 232, 255, 235, 217, 232, 255, 235, 217, 232, 255, 235, 217, 232, 255, 235, 216, 232, 255, 235, 216, 232, 255, 234, 216, 232, 255, 234, 216, 232, 255, 234, 215, 232, 255, 234, 215, 232, 255, 234, 215, 232, 255, 233, 215, 232, 255, 233, 214, 232, 255, 233, 214, 232, 255, 233, 214, 232, 255, 232, 214, 232, 255, 232, 213, 232, 255, 232, 213, 232, 255, 232, 213, 232, 255, 232, 213, 232, 255, 231, 212, 232, 255, 231, 212, 232, 255, 231, 212, 232, 255, 231, 212, 232, 255, 230, 211, 231, 255, 230, 211, 231, 255, 230, 211, 231, 255, 230, 210, 231, 255, 229, 210, 231, 255, 229, 209, 230, 255, 229, 209, 230, 255, 228, 209, 230, 255, 228, 208, 230, 255, 228, 208, 229, 255, 228, 207, 229, 255, 227, 207, 229, 255, 227, 207, 229, 255, 227, 206, 229, 255, 227, 206, 228, 255, 226, 206, 228, 255, 226, 205, 228, 255, 226, 205, 228, 255, 225, 204, 228, 255, 225, 204, 227, 255, 225, 204, 227, 255, 225, 203, 227, 255, 224, 203, 227, 255, 224, 203, 227, 255, 224, 202, 226, 255, 224, 202, 226, 255, 223, 201, 226, 255, 223, 201, 226, 255, 223, 201, 226, 255, 222, 200, 225, 255, 222, 200, 225, 255, 222, 200, 225, 255, 222, 199, 225, 255, 221, 199, 225, 255, 221, 198, 224, 255, 221, 198, 224, 255, 220, 198, 224, 255, 220, 197, 224, 255, 220, 197, 224, 255, 220, 197, 223, 255, 219, 196, 223, 255, 219, 196, 223, 255, 219, 196, 223, 255, 219, 195, 223, 255, 218, 195, 222, 255, 218, 194, 222, 255, 218, 194, 222, 255, 217, 194, 222, 255, 217, 193, 222, 255, 217, 193, 221, 255, 217, 193, 221, 255, 209, 183, 216, 255, 209, 182, 216, 255, 208, 182, 216, 255, 208, 182, 215, 255, 208, 181, 215, 255, 207, 181, 215, 255, 207, 181, 215, 255, 207, 180, 215, 255, 206, 180, 214, 255, 206, 180, 214, 255, 206, 179, 214, 255, 206, 179, 214, 255, 205, 178, 214, 255, 205, 178, 213, 255, 205, 178, 213, 255, 204, 177, 213, 255, 204, 177, 213, 255, 204, 177, 213, 255, 204, 176, 213, 255, 203, 176, 212, 255, 203, 176, 212, 255, 203, 175, 212, 255, 202, 175, 212, 255, 202, 174, 212, 255, 202, 174, 211, 255, 201, 174, 211, 255, 201, 173, 211, 255, 201, 173, 211, 255, 201, 173, 211, 255, 200, 172, 210, 255, 200, 172, 210, 255, 200, 172, 210, 255, 199, 171, 210, 255, 199, 171, 210, 255, 199, 170, 210, 255, 198, 170, 209, 255, 198, 170, 209, 255, 198, 169, 209, 255, 197, 169, 209, 255, 197, 169, 209, 255, 197, 168, 208, 255, 197, 168, 208, 255, 196, 168, 208, 255, 196, 167, 208, 255, 196, 167, 208, 255, 195, 167, 208, 255, 195, 166, 207, 255, 195, 166, 207, 255, 194, 165, 207, 255, 194, 165, 207, 255, 194, 165, 207, 255, 193, 164, 206, 255, 193, 164, 206, 255, 193, 164, 206, 255, 192, 163, 206, 255, 192, 163, 205, 255, 192, 162, 205, 255, 191, 162, 205, 255, 191, 161, 204, 255, 191, 161, 204, 255, 191, 161, 204, 255, 190, 160, 204, 255, 190, 160, 203, 255, 190, 159, 203, 255, 189, 159, 203, 255, 189, 159, 202, 255, 189, 158, 202, 255, 188, 158, 202, 255, 188, 157, 202, 255, 188, 157, 201, 255, 187, 156, 201, 255, 187, 156, 201, 255, 187, 156, 201, 255, 186, 155, 200, 255, 186, 155, 200, 255, 186, 154, 200, 255, 185, 154, 199, 255, 185, 153, 199, 255, 185, 153, 199, 255, 184, 153, 199, 255, 184, 152, 198, 255, 184, 152, 198, 255, 183, 151, 198, 255, 183, 151, 197, 255, 183, 151, 197, 255, 182, 150, 197, 255, 182, 150, 197, 255, 182, 149, 196, 255, 182, 149, 196, 255, 181, 148, 196, 255, 181, 148, 195, 255, 181, 148, 195, 255, 180, 147, 195, 255, 180, 147, 195, 255, 180, 146, 194, 255, 179, 146, 194, 255, 179, 146, 194, 255, 179, 145, 193, 255, 178, 145, 193, 255, 178, 144, 193, 255, 178, 144, 193, 255, 177, 144, 192, 255, 169, 132, 185, 255, 168, 132, 185, 255, 168, 132, 184, 255, 168, 131, 184, 255, 168, 131, 184, 255, 167, 130, 183, 255, 167, 130, 183, 255, 167, 130, 183, 255, 166, 129, 183, 255, 166, 129, 182, 255, 166, 128, 182, 255, 165, 128, 182, 255, 165, 128, 181, 255, 165, 127, 181, 255, 164, 127, 181, 255, 164, 126, 181, 255, 164, 126, 180, 255, 163, 125, 180, 255, 163, 125, 180, 255, 163, 125, 180, 255, 162, 124, 179, 255, 162, 124, 179, 255, 162, 123, 179, 255, 161, 123, 178, 255, 161, 123, 178, 255, 161, 122, 178, 255, 161, 122, 178, 255, 160, 121, 177, 255, 160, 121, 177, 255, 160, 121, 177, 255, 159, 120, 176, 255, 159, 120, 176, 255, 159, 119, 176, 255, 158, 119, 176, 255, 158, 119, 175, 255, 158, 118, 175, 255, 157, 118, 175, 255, 157, 117, 174, 255, 157, 117, 174, 255, 156, 116, 174, 255, 156, 116, 174, 255, 156, 116, 173, 255, 155, 115, 173, 255, 155, 115, 173, 255, 155, 114, 173, 255, 154, 114, 172, 255, 154, 114, 172, 255, 154, 113, 172, 255, 154, 113, 171, 255, 153, 112, 171, 255, 153, 112, 171, 255, 153, 112, 171, 255, 152, 111, 170, 255, 152, 111, 170, 255, 152, 110, 170, 255, 151, 110, 169, 255, 151, 109, 169, 255, 151, 109, 169, 255, 151, 108, 168, 255, 150, 107, 168, 255, 150, 107, 168, 255, 150, 106, 168, 255, 149, 106, 167, 255, 149, 105, 167, 255, 149, 105, 167, 255, 149, 104, 166, 255, 148, 104, 166, 255, 148, 103, 166, 255, 148, 103, 166, 255, 147, 102, 165, 255, 147, 102, 165, 255, 147, 101, 165, 255, 147, 101, 164, 255, 146, 100, 164, 255, 146, 100, 164, 255, 146, 99, 163, 255, 145, 99, 163, 255, 145, 98, 163, 255, 145, 98, 163, 255, 145, 97, 162, 255, 144, 97, 162, 255, 144, 96, 162, 255, 144, 96, 161, 255, 144, 95, 161, 255, 143, 95, 161, 255, 143, 94, 160, 255, 143, 94, 160, 255, 142, 93, 160, 255, 142, 92, 159, 255, 142, 92, 159, 255, 142, 91, 159, 255, 141, 91, 159, 255, 141, 90, 158, 255, 141, 90, 158, 255, 140, 89, 158, 255, 140, 89, 157, 255, 140, 88, 157, 255, 140, 88, 157, 255, 139, 87, 156, 255, 139, 87, 156, 255, 139, 86, 156, 255, 139, 86, 155, 255, 138, 85, 155, 255, 131, 71, 147, 255, 131, 70, 146, 255, 130, 69, 146, 255, 130, 69, 146, 255, 130, 68, 146, 255, 130, 68, 145, 255, 129, 67, 145, 255, 129, 67, 145, 255, 129, 66, 144, 255, 129, 66, 144, 255, 128, 65, 144, 255, 128, 65, 143, 255, 128, 64, 143, 255, 128, 64, 143, 255, 127, 63, 142, 255, 127, 62, 142, 255, 127, 62, 142, 255, 126, 61, 141, 255, 126, 61, 141, 255, 126, 60, 141, 255, 126, 60, 140, 255, 125, 59, 140, 255, 125, 59, 140, 255, 125, 58, 140, 255, 125, 57, 139, 255, 124, 57, 139, 255, 124, 56, 139, 255, 124, 56, 138, 255, 124, 55, 138, 255, 123, 55, 138, 255, 123, 54, 137, 255, 123, 53, 137, 255, 122, 53, 137, 255, 122, 52, 136, 255, 122, 52, 136, 255, 122, 51, 136, 255, 121, 51, 135, 255, 121, 50, 135, 255, 121, 49, 135, 255, 121, 49, 134, 255, 120, 48, 134, 255, 120, 48, 134, 255, 120, 47, 133, 255, 120, 46, 133, 255, 119, 46, 133, 255, 119, 45, 132, 255, 119, 44, 132, 255, 118, 44, 132, 255, 118, 43, 131, 255, 118, 43, 131, 255, 118, 42, 131, 255, 117, 41, 130, 255, 117, 41, 130, 255, 116, 41, 129, 255, 116, 40, 129, 255, 116, 40, 128, 255, 115, 40, 128, 255, 115, 39, 128, 255, 114, 39, 127, 255, 114, 39, 127, 255, 113, 38, 126, 255, 113, 38, 126, 255, 113, 38, 125, 255, 112, 38, 125, 255, 112, 37, 124, 255, 111, 37, 124, 255, 111, 37, 123, 255, 110, 36, 123, 255, 110, 36, 123, 255, 109, 36, 122, 255, 109, 35, 122, 255, 109, 35, 121, 255, 108, 35, 121, 255, 108, 34, 120, 255, 107, 34, 120, 255, 107, 34, 119, 255, 106, 33, 119, 255, 106, 33, 119, 255, 106, 33, 118, 255, 105, 32, 118, 255, 105, 32, 117, 255, 104, 32, 117, 255, 104, 31, 116, 255, 103, 31, 116, 255, 103, 31, 115, 255, 103, 30, 115, 255, 102, 30, 115, 255, 102, 30, 114, 255, 101, 29, 114, 255, 101, 29, 113, 255, 100, 29, 113, 255, 100, 29, 112, 255, 100, 28, 112, 255, 99, 28, 111, 255, 99, 28, 111, 255, 98, 27, 111, 255, 98, 27, 110, 255, 97, 27, 110, 255, 97, 26, 109, 255, 97, 26, 109, 255, 96, 26, 108, 255, 96, 25, 108, 255, 85, 16, 96, 255, 84, 16, 96, 255, 84, 16, 95, 255, 83, 15, 95, 255, 83, 15, 95, 255, 82, 15, 94, 255, 82, 14, 94, 255, 82, 14, 93, 255, 81, 14, 93, 255, 81, 13, 92, 255, 80, 13, 92, 255, 80, 13, 91, 255, 80, 12, 91, 255, 79, 12, 91, 255, 79, 12, 90, 255, 78, 11, 90, 255, 78, 11, 89, 255, 77, 11, 89, 255, 77, 10, 88, 255, 77, 10, 88, 255, 76, 9, 88, 255, 76, 9, 87, 255, 75, 9, 87, 255, 75, 8, 86, 255, 75, 8, 86, 255, 74, 8, 85, 255, 74, 7, 85, 255, 73, 7, 85, 255, 73, 6, 84, 255, 72, 6, 84, 255, 72, 6, 83, 255, 72, 5, 83, 255, 71, 5, 82, 255, 71, 5, 82, 255, 70, 4, 82, 255, 70, 4, 81, 255, 70, 4, 81, 255, 69, 3, 80, 255, 69, 3, 80, 255, 68, 3, 80, 255, 68, 2, 79, 255, 68, 2, 79, 255, 67, 2, 78, 255, 67, 2, 78, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 65, 0, 76, 255, 65, 0, 76, 255, 64, 0, 75, 255, 64, 0, 75, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PRGn_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 1, 71, 29, 24, 2, 75, 31, 49, 4, 79, 33, 74, 6, 83, 35, 99, 8, 87, 37, 124, 16, 101, 45, 149, 18, 105, 47, 174, 21, 109, 49, 199, 23, 113, 51, 224, 25, 117, 53, 249, 28, 120, 55, 255, 33, 124, 58, 255, 38, 128, 61, 255, 43, 132, 64, 255, 47, 135, 67, 255, 51, 139, 70, 255, 68, 153, 81, 255, 72, 157, 84, 255, 76, 161, 86, 255, 80, 164, 89, 255, 83, 168, 92, 255, 87, 171, 95, 255, 92, 175, 98, 255, 97, 177, 102, 255, 102, 180, 106, 255, 107, 183, 110, 255, 111, 186, 113, 255, 116, 189, 117, 255, 121, 191, 121, 255, 140, 203, 137, 255, 145, 206, 141, 255, 149, 208, 145, 255, 153, 211, 149, 255, 158, 214, 152, 255, 162, 216, 156, 255, 166, 219, 160, 255, 169, 220, 163, 255, 172, 221, 165, 255, 175, 222, 168, 255, 178, 223, 171, 255, 180, 224, 174, 255, 183, 226, 176, 255, 186, 227, 179, 255, 199, 232, 192, 255, 201, 233, 195, 255, 204, 234, 197, 255, 207, 235, 200, 255, 209, 236, 203, 255, 212, 237, 205, 255, 214, 238, 208, 255, 217, 239, 210, 255, 222, 239, 210, 255, 227, 239, 210, 255, 231, 238, 210, 255, 235, 238, 212, 255, 239, 237, 213, 255, 241, 237, 216, 255, 243, 237, 218, 255, 245, 238, 221, 255, 252, 239, 230, 255, 252, 240, 233, 255, 252, 240, 236, 255, 252, 241, 238, 255, 251, 242, 240, 255, 250, 243, 242, 255, 249, 244, 244, 255, 248, 245, 245, 255, 247, 246, 246, 255, 246, 246, 246, 255, 246, 244, 245, 255, 246, 243, 244, 255, 246, 241, 243, 255, 245, 240, 242, 255, 245, 238, 241, 255, 245, 237, 240, 255, 244, 235, 239, 255, 244, 234, 239, 255, 243, 233, 238, 255, 239, 224, 235, 255, 239, 223, 234, 255, 238, 222, 234, 255, 237, 220, 233, 255, 237, 219, 233, 255, 236, 218, 233, 255, 235, 217, 232, 255, 234, 216, 232, 255, 233, 214, 232, 255, 232, 213, 232, 255, 231, 212, 232, 255, 230, 211, 231, 255, 229, 209, 230, 255, 228, 208, 229, 255, 227, 206, 228, 255, 225, 204, 228, 255, 224, 203, 227, 255, 223, 201, 226, 255, 222, 200, 225, 255, 221, 198, 224, 255, 220, 197, 223, 255, 219, 195, 223, 255, 218, 194, 222, 255, 216, 192, 221, 255, 208, 182, 215, 255, 207, 180, 215, 255, 206, 179, 214, 255, 205, 177, 213, 255, 203, 176, 212, 255, 202, 175, 212, 255, 201, 173, 211, 255, 200, 172, 210, 255, 199, 171, 210, 255, 198, 170, 209, 255, 197, 168, 208, 255, 196, 167, 208, 255, 195, 166, 207, 255, 194, 165, 207, 255, 193, 163, 206, 255, 191, 162, 205, 255, 190, 160, 204, 255, 189, 159, 203, 255, 188, 158, 202, 255, 187, 156, 201, 255, 186, 155, 200, 255, 185, 154, 199, 255, 184, 152, 198, 255, 183, 151, 198, 255, 182, 150, 197, 255, 181, 149, 196, 255, 180, 147, 195, 255, 179, 146, 194, 255, 178, 145, 193, 255, 178, 144, 193, 255, 168, 132, 184, 255, 167, 131, 184, 255, 167, 130, 183, 255, 166, 128, 182, 255, 165, 127, 181, 255, 164, 126, 181, 255, 163, 125, 180, 255, 162, 124, 179, 255, 161, 123, 178, 255, 161, 122, 178, 255, 160, 121, 177, 255, 159, 120, 176, 255, 158, 119, 175, 255, 157, 118, 175, 255, 157, 117, 174, 255, 156, 116, 173, 255, 155, 115, 173, 255, 154, 114, 172, 255, 153, 113, 171, 255, 153, 112, 171, 255, 152, 111, 170, 255, 151, 109, 169, 255, 151, 108, 169, 255, 150, 107, 168, 255, 149, 106, 167, 255, 149, 105, 167, 255, 148, 104, 166, 255, 148, 102, 165, 255, 147, 101, 165, 255, 146, 100, 164, 255, 146, 99, 163, 255, 145, 98, 163, 255, 145, 97, 162, 255, 144, 96, 161, 255, 143, 95, 161, 255, 143, 94, 160, 255, 142, 93, 160, 255, 142, 92, 159, 255, 141, 91, 158, 255, 141, 90, 158, 255, 140, 89, 157, 255, 140, 88, 157, 255, 139, 87, 156, 255, 139, 86, 156, 255, 131, 71, 147, 255, 131, 70, 146, 255, 130, 69, 146, 255, 130, 68, 145, 255, 129, 67, 145, 255, 129, 66, 144, 255, 128, 65, 144, 255, 128, 64, 143, 255, 127, 63, 143, 255, 127, 62, 142, 255, 127, 61, 142, 255, 126, 61, 141, 255, 126, 60, 140, 255, 125, 59, 140, 255, 125, 58, 139, 255, 124, 57, 139, 255, 124, 56, 138, 255, 124, 55, 138, 255, 123, 54, 138, 255, 123, 54, 137, 255, 122, 53, 137, 255, 122, 52, 136, 255, 122, 51, 136, 255, 121, 50, 135, 255, 121, 49, 135, 255, 121, 49, 134, 255, 120, 48, 134, 255, 120, 47, 133, 255, 119, 46, 133, 255, 119, 45, 132, 255, 119, 44, 132, 255, 118, 44, 132, 255, 118, 43, 131, 255, 118, 42, 131, 255, 117, 41, 130, 255, 117, 41, 130, 255, 116, 41, 129, 255, 116, 40, 129, 255, 115, 40, 128, 255, 115, 39, 127, 255, 114, 39, 127, 255, 114, 39, 126, 255, 113, 38, 126, 255, 113, 38, 125, 255, 112, 38, 125, 255, 112, 37, 124, 255, 111, 37, 124, 255, 111, 36, 123, 255, 110, 36, 123, 255, 110, 36, 122, 255, 109, 35, 122, 255, 109, 35, 121, 255, 108, 35, 121, 255, 108, 34, 121, 255, 107, 34, 120, 255, 107, 34, 120, 255, 107, 34, 119, 255, 106, 33, 119, 255, 106, 33, 118, 255, 105, 33, 118, 255, 105, 32, 117, 255, 105, 32, 117, 255, 104, 32, 117, 255, 104, 31, 116, 255, 103, 31, 116, 255, 103, 31, 115, 255, 103, 31, 115, 255, 102, 30, 115, 255, 102, 30, 114, 255, 102, 30, 114, 255, 101, 29, 114, 255, 101, 29, 113, 255, 100, 29, 113, 255, 100, 29, 112, 255, 100, 28, 112, 255, 99, 28, 112, 255, 99, 28, 111, 255, 99, 28, 111, 255, 98, 27, 111, 255, 98, 27, 110, 255, 98, 27, 110, 255, 98, 27, 110, 255, 97, 26, 109, 255, 97, 26, 109, 255, 97, 26, 109, 255, 96, 26, 108, 255, 96, 25, 108, 255, 96, 25, 108, 255, 95, 25, 108, 255, 84, 16, 96, 255, 84, 16, 96, 255, 84, 16, 96, 255, 84, 16, 95, 255, 83, 15, 95, 255, 83, 15, 95, 255, 83, 15, 94, 255, 82, 15, 94, 255, 82, 15, 94, 255, 82, 14, 94, 255, 82, 14, 93, 255, 81, 14, 93, 255, 81, 14, 93, 255, 81, 14, 93, 255, 81, 13, 92, 255, 81, 13, 92, 255, 80, 13, 92, 255, 80, 13, 92, 255, 80, 13, 91, 255, 80, 12, 91, 255, 79, 12, 91, 255, 79, 12, 91, 255, 79, 12, 90, 255, 79, 12, 90, 255, 79, 12, 90, 255, 78, 11, 90, 255, 78, 11, 90, 255, 78, 11, 89, 255, 78, 11, 89, 255, 78, 11, 89, 255, 77, 10, 89, 255, 77, 10, 89, 255, 77, 10, 88, 255, 77, 10, 88, 255, 77, 10, 88, 255, 76, 10, 88, 255, 76, 9, 88, 255, 76, 9, 87, 255, 76, 9, 87, 255, 76, 9, 87, 255, 76, 9, 87, 255, 75, 9, 87, 255, 75, 9, 87, 255, 75, 8, 86, 255, 75, 8, 86, 255, 75, 8, 86, 255, 75, 8, 86, 255, 74, 8, 86, 255, 74, 8, 86, 255, 74, 8, 85, 255, 74, 7, 85, 255, 74, 7, 85, 255, 74, 7, 85, 255, 73, 7, 85, 255, 73, 7, 85, 255, 73, 7, 85, 255, 73, 7, 84, 255, 73, 6, 84, 255, 73, 6, 84, 255, 73, 6, 84, 255, 73, 6, 84, 255, 72, 6, 84, 255, 72, 6, 84, 255, 72, 6, 83, 255, 72, 6, 83, 255, 72, 6, 83, 255, 72, 5, 83, 255, 72, 5, 83, 255, 72, 5, 83, 255, 71, 5, 83, 255, 71, 5, 83, 255, 71, 5, 82, 255, 71, 5, 82, 255, 71, 5, 82, 255, 71, 5, 82, 255, 71, 5, 82, 255, 71, 4, 82, 255, 71, 4, 82, 255, 70, 4, 82, 255, 70, 4, 82, 255, 70, 4, 81, 255, 70, 4, 81, 255, 70, 4, 81, 255, 70, 4, 81, 255, 70, 4, 81, 255, 70, 4, 81, 255, 70, 4, 81, 255, 70, 4, 81, 255, 69, 4, 81, 255, 69, 3, 81, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 69, 3, 80, 255, 68, 3, 80, 255, 68, 3, 80, 255, 68, 3, 79, 255, 68, 3, 79, 255, 68, 3, 79, 255, 68, 3, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 68, 2, 79, 255, 67, 2, 79, 255, 67, 2, 79, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 2, 78, 255, 67, 1, 78, 255, 67, 1, 78, 255, 67, 1, 78, 255, 67, 1, 78, 255, 66, 1, 78, 255, 66, 1, 78, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 66, 1, 77, 255, 65, 1, 77, 255, 65, 1, 77, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 1, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 65, 0, 76, 255, 64, 0, 76, 255, 64, 0, 76, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 64, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255, 63, 0, 75, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PRGn_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
