/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#undef NDEBUG  // get assert in release mode

#include <array>
#include <atomic>
#include <cassert>
#include <future>
#include <iostream>

#include "../sh4lt/ipcs/sysv-sem.hpp"
#include "../sh4lt/logger/console.hpp"

using namespace sh4lt;

auto main() -> int {
  using namespace sh4lt;
  logger::Console log;
  {
    sysVSem sem(4312, &log, /* owner = */ true);
    assert(sem);
  }
  {
    sysVSem sem(4312, &log, /* owner = */ true);
    assert(sem);
    auto i = 65535;
    auto val = 0;
    while (0 != i--){
      {
        // one writer, two readers
        {
          WriteLock wlock(&sem);
          // expecting two readers
          wlock.commit_readers(2);
          assert(wlock);
          val = i;
        }
        {  // first reader
          ReadLock rlock(&sem);
          assert(rlock);
          assert (val == i);
        }
        {  // second reader
          ReadLock rlock(&sem);
          assert(rlock);
          assert (val == i);
        }
      }
    }
  }
  return 0;
}

