Chrono FSI module tutorials {#tutorial_table_of_content_chrono_fsi}
===========================

The Chrono distribution includes several demos for simulation of fluid-solid interaction problems with the [FSI module](group__fsi.html).

- Poiseuille flow (demo_FSI_Poiseuilleflow.cpp): This demo shows how to build a simple fluid model, add static/solid boundaries, and apply periodic boundary conditions.

- Compressibility (demo_FSI_Compressibility.cpp): This demo shows how to measure the amount of compressibility (density error) of an SPH solver using a static tank model.

- Dam Break (demo_FSI_DamBreak.cpp): Classical dam break problem modeled with SPH method.

- Flexible Shell (demo_FSI_Flexible_Shell.cpp): This demo shows interaction of fluid with a flexible plate modeled via ANCF shell elements. The fluid model is similar to the dam break problem.

- Cylinder Drop (demo_FSI_CylinderDrop.cpp): This demo shows interaction of fluid with a rigid cylinder that is dropped into a tank of static water.
