/* ============================================================================
 * Freetype GL - A C OpenGL Freetype engine
 * Platform:    Any
 * WWW:         http://code.google.com/p/freetype-gl/
 * ----------------------------------------------------------------------------
 * Copyright 2011,2012 Nicolas P. Rougier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NICOLAS P. ROUGIER ''AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL NICOLAS P. ROUGIER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of Nicolas P. Rougier.
 * ===============================================================================
 */
#include <stddef.h>
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  wchar_t charcode;
  float kerning;
} kerning_t;

typedef struct {
  wchar_t charcode;
  int width, height;
  int offset_x, offset_y;
  float advance_x, advance_y;
  float s0, t0, s1, t1;
  size_t kerning_count;
  kerning_t kerning[1];
} texture_glyph_t;

typedef struct {
  size_t tex_width;
  size_t tex_height;
  size_t tex_depth;
  unsigned char tex_data[65536];
  float size;
  float height;
  float linegap;
  float ascender;
  float descender;
  size_t glyphs_count;
  texture_glyph_t glyphs[96];
} texture_font_t;

texture_font_t font_data = {
    256, 256, 1,
    {0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255,
     255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   20,  255, 255, 255, 156, 0,   0,   0,   120, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  10,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   63,  171, 230, 250, 239, 196, 126, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  255, 255, 255, 255, 255, 255, 30,  0,   0,   0,   0,   0,   0,   89,  255, 255, 255,
     169, 0,   167, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 255, 255, 255, 93,  0,   9,   124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 5,   0,   164, 255, 255,
     255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  254, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   20,
     255, 255, 255, 156, 0,   0,   0,   120, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  168,
     237, 245, 197, 72,  0,   0,   0,   0,   0,   0,   0,   0,   152, 238, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   144, 255, 255, 255, 255, 255, 255, 255, 248, 135, 10,  0,   0,   0,
     0,   0,   0,   0,   26,  255, 255, 255, 255, 255, 255, 12,  0,   0,   0,   0,   0,   12,  229, 255, 255, 252, 38,  0,   35,  250, 255, 255, 234, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   80,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   240, 255,
     255, 255, 255, 226, 4,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 12,  0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   164, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   12,  255, 255, 255, 255,
     68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   20,  255, 255, 255, 156, 0,   0,   0,   120, 255, 255, 255, 32,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  231, 255, 255, 255, 255, 254, 84,  0,   0,   0,   0,   0,   0,   20,  246, 255, 113, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 19,  0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 255, 249, 0,   0,   0,   0,   0,   0,
     139, 255, 255, 255, 157, 0,   0,   0,   151, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 255, 255, 255, 114, 0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     12,  0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  252, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,
     0,   0,   0,   0,   20,  255, 255, 255, 156, 0,   0,   0,   120, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   73,  111, 65,  18,  0,
     0,   0,   163, 255, 240, 85,  59,  201, 255, 232, 9,   0,   0,   0,   0,   0,   126, 255, 240, 13,  0,   0,   0,   0,   0,   0,   0,   0,   12,  245, 255, 255, 255, 205, 134, 146, 224, 255, 255,
     255, 154, 0,   0,   0,   0,   0,   0,   0,   0,   247, 255, 255, 255, 255, 232, 0,   0,   0,   0,   0,   27,  248, 255, 255, 249, 31,  0,   0,   0,   26,  246, 255, 255, 250, 30,  0,   0,   0,
     0,   0,   31,  33,  0,   0,   0,   80,  255, 255, 255, 255, 0,   0,   0,   0,   57,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   155, 255, 255, 255, 255, 240, 13,  0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 12,  0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   154, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   20,  255, 255, 255, 156, 0,   0,   0,   120, 255, 255, 255, 32,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  131, 244, 255, 255, 244, 107, 26,  168, 255, 255, 253, 14,  0,   12,  248, 255, 113, 0,   0,   35,  254, 255, 84,  0,   0,   0,   0,   7,   233,
     255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 204, 3,   0,   0,   4,   113, 245, 202, 7,   0,   0,   0,   0,   0,   0,   0,   0,   229, 255, 255, 255, 255, 214, 0,
     0,   0,   0,   0,   144, 255, 255, 255, 152, 0,   0,   0,   0,   0,   146, 255, 255, 255, 144, 0,   0,   0,   0,   0,   143, 254, 194, 100, 15,  80,  255, 255, 255, 255, 0,   35,  127, 219, 255,
     74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   233, 255, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  249, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255,
     255, 255, 255, 72,  0,   0,   0,   0,   0,   20,  255, 255, 255, 156, 0,   0,   0,   120, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   54,  207, 255, 255, 255, 255, 255, 255, 255, 251,
     246, 255, 255, 210, 0,   0,   66,  255, 255, 30,  0,   0,   0,   207, 255, 145, 0,   0,   0,   0,   100, 255, 251, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255, 255, 255, 171, 0,
     0,   0,   0,   0,   38,  29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   212, 255, 255, 255, 255, 196, 0,   0,   0,   0,   21,  245, 255, 255, 253, 36,  0,   0,   0,   0,   0,   32,  251, 255,
     255, 243, 17,  0,   0,   0,   0,   224, 255, 255, 255, 247, 206, 255, 255, 255, 255, 198, 255, 255, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   62,  255, 255, 255, 255, 249, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   20,  255, 255, 255, 156, 0,   0,   0,
     120, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   77,  248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 151, 0,   0,   103, 255, 245, 0,   0,   0,   0,   166, 255, 181, 0,
     0,   0,   1,   214, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 243, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255,
     255, 255, 255, 177, 0,   0,   0,   0,   117, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 255, 119, 0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 235, 3,   0,   44,  124, 124, 124, 124, 124, 124, 235, 255, 255, 245, 124, 124, 124, 124, 124, 124, 44,  0,   0,   144, 255, 255, 255, 255, 158, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  245, 255, 255, 210, 1,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255,
     216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   20,  255, 255, 255, 156, 0,   0,   0,   120, 255, 255, 255, 32,  0,   0,   0,   0,   0,   33,  243, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 98,  0,   0,   118, 255, 228, 0,   0,   0,   0,   149, 255, 196, 0,   0,   0,   75,  255, 255, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     203, 255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 255, 159, 0,   0,   0,   0,   214, 255, 255, 255, 55,  0,   0,   0,   0,
     0,   0,   0,   48,  255, 255, 255, 215, 0,   0,   0,   116, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 51,  0,   92,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   225, 255, 255, 255, 254, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   73,  124, 124, 124, 134, 255, 255,
     255, 204, 124, 124, 124, 185, 255, 255, 255, 140, 124, 124, 69,  0,   0,   153, 255, 255, 255, 247, 143, 50,  18,  5,   29,  104, 239, 255, 255, 255, 112, 0,   0,   118, 255, 227, 0,   0,   0,
     0,   148, 255, 198, 0,   0,   0,   190, 255, 190, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  254, 255, 255, 244, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   159, 255, 255, 255, 255, 141, 0,   0,   0,   49,  255, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 52,  0,   0,   0,   29,  97,  165, 231, 255,
     255, 255, 255, 255, 255, 255, 255, 215, 147, 79,  14,  0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   52,  255, 255, 255, 255, 180, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  152, 216, 242, 242, 215, 151, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  240, 255, 255,
     218, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,
     60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   231, 255,
     255, 255, 75,  0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 147, 0,   0,   105, 255, 242, 0,   0,   0,   0,   162, 255, 184, 0,   0,   49,  255, 255, 75,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   169, 255, 255, 255, 193, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 255, 123, 0,   0,   0,   123, 255, 255, 255, 114,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   1,   185, 255, 255, 255, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   92,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   134, 255, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   5,   148, 254, 255, 255, 255, 255, 255, 255, 254,
     149, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   152, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   9,   255, 255, 255, 230, 0,   0,   0,   0,   0,   0,   0,   2,   236, 255, 255, 177, 0,   0,   71,
     255, 255, 23,  0,   0,   0,   198, 255, 151, 0,   0,   164, 255, 215, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   120, 251, 255, 255, 255, 255, 118, 0,   0,   0,   126, 255,
     255, 255, 255, 255, 144, 0,   0,   0,   124, 255, 255, 255, 255, 105, 0,   0,   0,   194, 255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  255, 255, 255, 196, 0,   0,   0,
     0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 247, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   215, 255,
     255, 255, 202, 0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  235, 255, 255, 225, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255,
     255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255, 255, 72,  0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     144, 0,   9,   255, 255, 255, 234, 0,   0,   0,   0,   0,   0,   0,   0,   106, 95,  44,  3,   0,   0,   18,  252, 255, 98,  0,   0,   20,  250, 255, 95,  0,   28,  250, 255, 101, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 255, 255, 255, 255, 249, 46,  0,   0,   206, 255, 255, 255, 255, 255, 144, 0,   0,   0,   107, 255, 255, 255, 255, 87,  0,   0,   3,
     246, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   230, 255, 255, 249, 4,   0,   0,   0,   0,   70,  252, 255, 255, 255, 224, 251, 255, 255, 255, 227, 23,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 255, 220,
     142, 142, 218, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   60,  255, 255, 255, 255, 216, 0,   0,   204, 255, 255, 255,
     255, 72,  0,   0,   0,   0,   0,   152, 255, 255, 255, 12,  0,   0,   20,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   234, 255, 255, 255, 115, 1,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   179, 255, 227, 45,  18,  173, 255, 243, 17,  0,   138, 255, 234, 8,   0,   60,  191, 244, 237, 167, 28,  0,   0,   0,   0,   121, 255, 255, 255, 255, 211, 255, 255, 255,
     209, 6,   39,  255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   89,  255, 255, 255, 255, 69,  0,   0,   40,  255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   188, 255,
     255, 255, 41,  0,   0,   0,   36,  238, 255, 255, 255, 252, 54,  130, 255, 255, 255, 255, 196, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,
     0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   6,   224, 255, 255, 255, 168, 4,   0,   0,   3,   163, 255, 255, 255, 229, 9,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   7,   229, 255, 255, 231, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 12,  0,   0,   20,  255, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 209, 110, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  244, 255, 255, 255, 255, 255, 113, 0,   13,  240, 255,
     127, 0,   65,  251, 255, 255, 255, 255, 227, 22,  0,   0,   26,  248, 255, 255, 255, 119, 6,   214, 255, 255, 255, 138, 135, 255, 255, 255, 155, 124, 124, 69,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   77,  255, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 255, 78,  0,   0,   0,   122, 255, 255, 255, 255, 134, 0,   5,   206, 255, 255,
     255, 245, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   76,  255,
     255, 255, 225, 11,  0,   0,   0,   0,   9,   222, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 12,  0,   0,   20,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   28,  236, 255, 255, 255, 255, 255, 255, 208,
     136, 62,  1,   0,   0,   0,   0,   0,   0,   0,   0,   57,  208, 255, 255, 234, 111, 0,   0,   113, 255, 247, 21,  3,   219, 255, 210, 62,  85,  242, 255, 152, 0,   0,   111, 255, 255, 255, 176,
     0,   0,   60,  254, 255, 255, 253, 241, 255, 255, 242, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   137, 255, 255, 255, 95,  0,   0,   0,   0,   83,  237, 255, 211, 6,   0,   0,   44,  249, 255, 207, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236,
     0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 167, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   4,   222, 255, 255, 237, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 12,
     0,   0,   20,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   40,  202, 255, 255, 255, 255, 255, 255, 255, 255, 219, 114, 9,   0,   0,   0,   0,   0,   0,   0,   0,   21,  29,  3,   0,
     0,   3,   224, 255, 153, 0,   68,  255, 255, 47,  0,   0,   118, 255, 244, 7,   0,   162, 255, 255, 255, 79,  0,   0,   0,   154, 255, 255, 255, 255, 255, 255, 165, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 107, 0,   0,   0,   0,   0,   28,  186, 50,  0,
     0,   0,   0,   118, 142, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,
     0,   0,   0,   215, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   35,  255, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 127, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 12,  0,   0,   20,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   1,   95,
     217, 255, 255, 255, 255, 255, 255, 255, 255, 221, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255, 254, 40,  0,   133, 255, 217, 0,   0,   0,   34,  255, 255, 62,  0,
     179, 255, 255, 255, 61,  0,   0,   0,   16,  231, 255, 255, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 135, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   137, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   5,   251, 255, 255, 235, 0,   0,   0,   0,   0,   0,   0,   0,   234, 255,
     255, 254, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   213, 255, 255, 242, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   62,  152, 222, 255, 255, 255, 255, 255, 255, 254, 98,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   202, 255, 179, 0,   0,   173, 255, 173, 0,   0,   0,   0,   246, 255, 100, 0,   162, 255, 255, 255, 107, 0,   0,   0,   0,   86,  255, 255, 255, 255, 200, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 80,  0,   0,   0,   0,
     0,   0,   0,   13,  104, 207, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   63,  149, 206, 233, 249, 231, 187, 115, 16,  0,   0,   0,   0,   0,   164, 255, 255, 255,
     255, 164, 0,   0,   0,   0,   0,   37,  255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 255, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 255, 136,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  121, 218, 255, 255, 255, 255, 245, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 64,  0,   0,   193, 255, 151, 0,   0,   0,
     0,   225, 255, 120, 0,   105, 255, 255, 255, 228, 26,  0,   0,   0,   89,  253, 255, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  255, 255,
     255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 255, 42,  0,   0,   0,   0,   0,   51,  154, 243, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   60,  207, 255, 255, 255, 255, 255, 255, 255, 255, 241, 100, 0,   0,   0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   52,  255, 255, 255, 177, 0,   0,   0,   0,   0,
     0,   0,   0,   178, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 246, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   4,   42,  0,   0,   0,   0,   0,   0,   0,   1,   85,  244, 255, 255, 255,
     98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 205, 0,   0,   0,   201, 255, 145, 0,   0,   0,   0,   218, 255, 129, 0,   17,  237, 255, 255, 255, 236, 152, 133, 197, 255, 255, 255,
     255, 255, 255, 146, 124, 124, 124, 124, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   252, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   226, 255, 255, 250,
     5,   0,   0,   12,  102, 204, 255, 255, 255, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   1,   134, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   72,
     255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  124, 124, 144, 255, 255, 255, 194, 124, 124, 124, 212, 255, 255, 251, 124,
     124, 124, 124, 69,  0,   70,  191, 245, 251, 11,  0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   38,  253, 255, 90,  0,   0,   0,   193,
     255, 151, 0,   0,   0,   0,   224, 255, 120, 0,   0,   85,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   203, 255, 255, 255, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 197, 0,   0,   41,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 64,  0,   0,   0,
     0,   0,   0,   0,   0,   153, 255, 255, 255, 255, 253, 184, 146, 131, 169, 245, 255, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 168,
     0,   0,   0,   0,   0,   0,   0,   0,   169, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 250, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 136, 0,   0,   0,   172, 255, 255, 248, 0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,
     0,   114, 255, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 226, 4,   0,   0,   0,   173, 255, 173, 0,   0,   0,   0,   245, 255, 99,  0,   0,   0,   93,  247, 255, 255, 255,
     255, 255, 255, 252, 127, 149, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     102, 255, 255, 255, 133, 0,   0,   5,   242, 255, 255, 255, 255, 202, 185, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 211, 37,  0,   0,   0,   0,   21,  182,
     255, 255, 255, 241, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 255, 60,  0,   0,   0,   0,
     0,   0,   0,   62,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 136, 0,   0,   0,
     172, 255, 255, 248, 0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   11,  210, 255, 255, 255, 83,  0,   0,   0,   0,   0,   0,   0,   20,  246, 255, 116,
     0,   0,   0,   0,   132, 255, 218, 0,   0,   0,   32,  255, 255, 61,  0,   0,   0,   0,   31,  144, 217, 247, 243, 217, 147, 43,  0,   17,  235, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 56,  0,   0,   0,   172, 255, 242, 151, 48,  0,   120, 255, 255,
     255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   5,   202, 255, 255, 255, 101, 0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,
     43,  255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 255, 46,  0,   0,   0,   0,   0,   0,   0,   185, 255, 255, 252, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 60,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 136, 0,   0,   0,   172, 255, 255, 248, 0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 164, 56,
     14,  2,   9,   39,  103, 217, 255, 255, 255, 230, 10,  0,   0,   0,   0,   0,   0,   0,   125, 255, 242, 15,  0,   0,   0,   0,   67,  255, 255, 45,  0,   0,   115, 255, 244, 7,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   225, 255, 255, 255, 46,  0,   0,   0,
     0,   0,   0,   0,   36,  254, 255, 255, 225, 1,   0,   0,   0,   72,  101, 11,  0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 4,   0,   0,
     0,   0,   0,   0,   0,   89,  255, 255, 255, 157, 0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   13,  255, 255, 255, 235, 0,   0,   0,   0,   0,   0,   0,   0,   234, 255, 255, 255,
     13,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255,
     255, 136, 0,   0,   0,   172, 255, 255, 248, 0,   0,   0,   0,   0,   0,   4,   248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 78,  0,   0,   0,   0,   0,   0,   0,
     7,   232, 255, 142, 0,   0,   0,   0,   0,   3,   218, 255, 206, 60,  85,  241, 255, 151, 0,   0,   0,   0,   0,   0,   5,   79,  166, 215, 242, 246, 222, 167, 77,  2,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   54,  64,  64,  64,  1,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 177, 0,   164, 255, 255, 255, 255, 164,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   35,  255, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 254, 44,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   25,  240, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 136, 0,   0,   0,   172, 255, 255, 248, 0,   0,   0,   0,   0,   0,   56,  255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 87,  0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 252, 31,  0,   0,   0,   0,   0,   0,   65,  251, 255, 255, 255, 255, 228,
     22,  0,   0,   0,   0,   0,   88,  221, 255, 255, 255, 255, 255, 255, 255, 255, 199, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  249, 255,
     255, 251, 29,  0,   0,   0,   0,   0,   26,  248, 255, 255, 248, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 154, 0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,
     114, 255, 255, 255, 167, 0,   0,   0,   0,   0,   0,   43,  254, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   40,  255, 255, 255, 136, 0,   0,   0,   172, 255, 255, 248, 0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 219, 255, 255, 255, 255, 255, 255, 255, 238, 151, 29,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   186, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   61,  192, 245, 238, 168, 28,  0,   0,   0,   0,   26,  184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     232, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 142, 0,   0,   0,   0,   0,   140, 255, 255, 255, 156, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   205, 255, 255, 255, 101, 0,   164,
     255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 225, 10,  0,   0,   0,   0,   9,   222, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 52,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 136, 0,   0,   0,   172, 255, 255, 248, 0,   0,   0,
     0,   0,   0,   18,  84,  150, 171, 0,   13,  49,  232, 255, 255, 235, 43,  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   122, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 237, 168, 135, 146, 200, 255, 255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   41,  254, 255, 255, 246, 25,  0,   0,   0,   21,  243, 255, 255, 253, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   170, 255, 255, 255, 245, 16,  0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   9,   230, 255, 255, 255, 167,
     4,   0,   0,   3,   162, 255, 255, 255, 229, 9,   0,   0,   0,   0,   0,   35,  252, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  229, 255, 255, 255, 255, 255, 104, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 136, 0,   0,   0,   172, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   211, 255, 225, 97,  4,   0,   0,
     0,   0,   91,  254, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 149, 0,   0,   0,   146, 255, 255, 255, 151,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  207, 255, 255, 255,
     255, 114, 0,   0,   164, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 255, 219, 141, 141, 217, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   154, 255,
     255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  128, 128, 128, 68,  0,   0,   0,   86,  128,
     128, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  160, 13,  0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  236, 255, 255, 249, 32,  0,   34,  250, 255, 255, 236, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  241, 255, 255, 255, 255, 162, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     1,   162, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 1,   0,   0,   0,   0,   0,   27,  249, 255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  254, 255, 255, 253, 255, 255, 255,
     104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255,
     255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 164, 0,   167,
     255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   149, 255,
     255, 255, 255, 254, 132, 1,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 0,   0,   0,   0,   5,   148, 254, 255, 255, 255, 255, 255, 255, 255, 150, 6,   0,   0,   0,   0,
     0,   0,   144, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   216, 255, 255, 253, 147, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   180, 255, 255, 255, 87,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  205, 255, 255, 255, 255, 233, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255,
     255, 255, 0,   0,   0,   0,   0,   0,   54,  152, 217, 243, 243, 217, 153, 56,  0,   0,   0,   0,   0,   0,   0,   21,  245, 255, 255, 205, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255,
     147, 92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  113, 176, 211, 230, 249, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 251, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 31,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   109, 255, 255, 255, 249, 22,  0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     84,  241, 255, 255, 255, 255, 190, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  250, 255, 255, 227, 13,  92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   80,
     201, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     204, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   128, 140, 171, 229, 255, 255, 255, 255, 134,
     0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 254, 255, 255, 255, 253, 127, 2,   0,   1,   8,   8,   8,   5,   0,   0,   0,   0,
     0,   72,  255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  78,  0,   0,   0,   0,   0,   0,   0,   0,   5,   90,  171, 224, 246, 246, 224, 172,
     92,  5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   95,  176, 228, 248, 236, 206, 133, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
     200, 255, 255, 255, 79,  0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   17,  179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   92,  255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 187, 3,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   1,   140, 255, 255, 255, 255, 241, 68,  0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   85,  246, 248, 65,  0,   0,   0,   0,   0,   0,   56,  219, 255, 255, 255, 255, 255, 255, 255, 255, 221, 59,  0,   0,   0,   0,   0,   0,   0,   49,  219, 255, 255, 255, 255, 255,
     255, 255, 249, 127, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 174, 0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,
     0,   31,  222, 255, 255, 255, 255, 255, 234, 180, 141, 130, 152, 192, 85,  0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255,
     255, 255, 255, 241, 86,  0,   0,   0,   124, 255, 255, 255, 161, 124, 124, 124, 124, 124, 124, 124, 124, 241, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 255, 227, 44,  0,   0,   0,   0,   32,  255, 255, 255,
     164, 0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 254, 255, 255, 242, 50,  0,   0,   0,   0,   71,  248, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 249, 74,  0,   0,   0,   0,   0,   59,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 155, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   30,  243, 255, 255, 241, 26,  0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   11,  209, 255, 255, 255, 248, 153, 60,  2,   0,   0,   0,   0,   0,   0,   0,   0,
     92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 254, 80,  0,   0,   124, 255, 255, 255, 72,  0,   0,   0,   0,
     0,   0,   0,   41,  255, 255, 255, 243, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 64,  0,   0,
     0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 255, 210, 27,  0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   6,   161, 255, 255, 255, 255, 206, 27,  0,   0,   0,   23,  238, 255, 255, 255, 255, 192, 145, 141, 185, 254, 255, 255, 255, 240, 26,  0,   0,   0,   17,  234, 255, 255,
     255, 247, 167, 130, 148, 221, 255, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 255, 107, 0,   0,   0,   92,  255, 255, 255, 104, 0,
     0,   0,   0,   0,   0,   157, 255, 255, 255, 212, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
     44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 251, 156, 212, 244, 255, 242, 218, 160, 76,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   8,   35,  100, 218, 255, 255, 255, 240, 15,  0,   124, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   38,  124, 124, 124, 124, 124, 124, 185, 255, 255, 255, 157, 124, 124, 124, 124, 124, 114, 0,   66,  252, 255, 255, 255, 251, 139, 124, 124, 124, 124, 124,
     124, 140, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  193, 255, 255, 255, 255, 176, 11,  0,   0,   0,   0,   131,
     255, 255, 255, 232, 61,  0,   0,   0,   0,   49,  222, 255, 255, 255, 138, 0,   0,   0,   135, 255, 255, 255, 219, 35,  0,   0,   0,   3,   129, 255, 255, 255, 245, 30,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 199, 2,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   38,  252, 255, 255, 228, 22,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 206, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  201, 255, 255, 255, 111, 0,   94,  196, 196, 196,
     55,  0,   0,   0,   0,   0,   0,   1,   223, 255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   39,  219, 255, 255, 255, 255, 140, 2,   0,   0,   0,   0,   0,   202, 255, 255, 255, 79,  0,   0,   0,   0,   0,   0,   58,  255, 255, 255, 209, 0,   0,
     0,   222, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  234, 255, 255, 250, 44,  0,   0,   0,   0,   92,
     255, 255, 255, 104, 0,   0,   0,   0,   0,   157, 255, 255, 255, 89,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  255, 255, 255, 226, 2,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   132, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  238, 255, 255, 255, 251, 101, 0,   0,   0,
     0,   0,   0,   0,   228, 255, 255, 255, 8,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 235, 0,   0,   16,  255, 255, 255, 221, 0,   0,   0,   0,   0,   0,   0,   20,  251, 255, 255, 233,
     1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 213, 124, 124, 124, 124, 124, 171, 255, 255, 255, 177, 124, 124, 124, 0,   1,   233, 255, 255, 240, 6,   3,   55,  101,
     118, 103, 62,  4,   0,   0,   0,   0,   0,   0,   44,  124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255,
     255, 255, 252, 193, 142, 128, 149, 213, 255, 255, 255, 255, 238, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  255, 255, 255, 196,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  250, 255, 255, 255, 239, 67,  0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   15,  253,
     255, 255, 220, 0,   0,   34,  255, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   45,  255, 255, 255, 174, 95,  225, 255, 255, 255, 255, 255, 233, 106, 1,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  213, 243, 130, 22,  0,   0,   0,   0,   0,   89,  244, 255, 255, 255, 161, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   236, 255, 255, 255, 41,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   138, 255, 255, 255, 255, 219, 39,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 163, 0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 165, 0,   0,   18,  255, 255, 255, 231, 0,   0,   0,   0,   0,   0,   0,
     0,   195, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   94,  255, 255, 255,
     236, 255, 255, 255, 255, 255, 255, 255, 255, 255, 171, 6,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   1,   16,  0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 255, 248, 11,  0,   0,   0,   0,   0,   0,   0,   4,   117, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     160, 255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   78,  255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   71,  61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   2,   50,  113, 175, 218, 244, 251, 235, 200, 135, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   125, 255, 255, 255, 255, 255, 137, 0,   0,   0,   11,  175, 255, 255, 255, 255, 193, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  252, 255, 255, 255, 192, 68,  20,
     17,  61,  179, 255, 255, 255, 253, 57,  0,   0,   0,   227, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 153, 0,   0,   0,   92,  255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   207, 255,
     255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   90,  255, 235, 125, 21,  0,   0,   0,   0,   0,   10,  144, 255, 255, 255, 254, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   169,
     255, 255, 255, 110, 0,   0,   0,   0,   0,   57,  245, 249, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   150, 232, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 141,
     6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   207, 255, 255, 255, 255, 249, 26,  0,   0,   27,  205, 255, 255, 255,
     255, 160, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 119, 0,   0,   0,   0,   143, 255, 255, 255, 229, 43,
     0,   0,   0,   2,   108, 253, 255, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   0,
     0,   134, 255, 255, 255, 255, 255, 233, 108, 31,  7,   47,  172, 255, 255, 255, 255, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   206, 255, 255, 255, 251, 189, 136,
     124, 133, 169, 239, 255, 255, 255, 255, 154, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  246, 255, 255, 250, 21,  0,   0,   0,   0,   42,  238, 255, 255, 255, 131, 1,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 188, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   33,  255, 255, 255, 255, 255, 158, 0,   0,   38,  228, 255, 255, 255, 254, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 0,   0,   0,   0,   0,   24,  241, 255, 255, 255, 249, 170, 130, 151, 218, 255, 255, 255, 255, 255, 255, 134, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   124, 124, 124, 124, 171, 255, 255, 255, 177, 124, 124, 124, 0,   136, 255, 255, 255, 255, 227, 30,  0,   0,   0,   0,   0,   166, 255, 255, 255,
     175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  108, 177, 215, 236, 250, 234, 214, 166, 103, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   151, 255, 255, 255, 90,  0,   0,   0,   0,   0,   0,   27,  235, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 185, 7,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   96,  255, 255, 255, 178, 0,   0,   0,   0,   0,   23,  200, 255, 255, 255, 255, 169, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 255, 234, 161, 126, 133,
     165, 226, 255, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 254, 41,  0,   0,   6,
     172, 255, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 90,  0,   0,   0,   0,   0,
     75,  252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 0,   120, 255, 255, 255, 253, 57,  0,   0,   0,   0,   0,   0,   29,  254, 255, 255, 243, 3,   0,   0,   0,   0,   0,   0,   34,  161, 252, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 245, 146, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   199, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   16,  135,
     243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 129, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   8,   168, 255,
     255, 255, 255, 200, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 214, 4,   0,   0,   0,   0,   6,   114, 253, 255, 255, 253, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   197, 255, 255, 255, 255, 179, 0,   0,   0,   0,   3,   160, 255, 255, 255, 255, 137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   55,  250, 255, 255, 255, 249, 177, 133, 133, 178, 250, 255, 255, 255, 250, 55,  0,   0,   0,   0,   0,   69,  234, 255, 255, 255, 255, 255, 255, 255, 216, 185, 255, 255, 255, 94,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   96,  255, 255, 255, 173, 0,   0,   0,   0,   0,   0,
     0,   0,   218, 255, 255, 255, 23,  0,   0,   0,   0,   0,   78,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 54,  0,   0,   0,   0,   0,   46,  110, 3,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 244, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  99,  167, 213, 239, 251, 245, 227, 182, 116, 21,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   26,  253, 255, 255, 238, 7,   0,   0,   0,   0,   0,   0,   0,   1,   131, 255, 255, 255, 255, 224, 44,  0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255,
     208, 0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  253, 255, 255, 255, 255,
     61,  0,   0,   0,   0,   0,   1,   148, 255, 255, 255, 255, 151, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 197, 30,  0,   0,   0,   0,   32,  200, 255, 255, 255,
     205, 0,   0,   0,   0,   0,   0,   13,  118, 197, 237, 250, 233, 184, 100, 6,   199, 255, 255, 255, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   44,  255, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 255, 32,  0,   0,   0,   0,   100, 253, 255, 255, 255, 255,
     232, 169, 142, 128, 143, 175, 232, 255, 255, 255, 255, 241, 48,  0,   0,   0,   0,   146, 255, 211, 92,  10,  0,   0,   0,   0,   0,   1,   83,  240, 255, 255, 255, 154, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 152, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   92,  248, 255, 255, 255, 242, 73,  0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 166, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 255, 164, 4,   0,   0,
     0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 230, 14,  0,   0,   0,   0,   0,   0,   16,  232, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  252,
     255, 255, 235, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   235, 255, 255, 254, 33,
     0,   0,   0,   0,   0,   0,   0,   231, 255, 255, 255, 9,   0,   0,   0,   59,  250, 255, 255, 255, 203, 70,  0,   0,   0,   0,   0,   0,   2,   74,  209, 255, 255, 255, 230, 14,  0,   0,   6,
     236, 255, 255, 255, 241, 182, 145, 129, 132, 159, 221, 255, 255, 255, 255, 233, 21,  0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 238, 198, 129, 30,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   206, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  235, 255, 255, 255, 252, 108, 0,   0,   0,   0,
     0,   0,   7,   8,   8,   6,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   186,
     255, 255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 175, 7,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 149, 0,   0,   0,   0,   0,   0,
     0,   0,   152, 255, 255, 255, 83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,
     98,  172, 215, 238, 252, 237, 194, 119, 28,  0,   124, 110, 62,  14,  0,   0,   0,   140, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   71,  255, 255, 255, 208, 0,   0,   0,   6,   224, 255,
     255, 255, 153, 4,   0,   0,   84,  196, 244, 224, 88,  255, 255, 192, 161, 255, 255, 255, 139, 0,   0,   70,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 48,  0,
     0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 249, 133, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  255, 255, 255, 219, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  214, 255, 255, 255, 255, 147, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 255,
     160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  250, 255, 255, 255, 218, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 254,
     255, 255, 255, 187, 11,  0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   41,  245, 255, 255, 253, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   124, 242, 255, 255, 255, 255, 255, 255, 255, 255, 248, 132, 235, 255, 255, 203, 0,   0,   0,
     33,  246, 255, 255, 255, 145, 6,   0,   0,   0,   43,  229, 255, 255, 255, 117, 0,   0,   0,   103, 255, 255, 255, 176, 1,   0,   1,   151, 255, 255, 255, 255, 255, 255, 255, 118, 3,   195, 255,
     255, 243, 7,   0,   0,   64,  187, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 179, 27,  0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  186, 255, 255,
     255, 255, 183, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  231, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   94,  255, 255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  252, 255, 255, 255, 197, 15,  0,   0,   0,   0,   0,   58,  255, 255, 255, 227, 11,
     0,   0,   0,   0,   0,   0,   12,  229, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  233, 255, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   26,  205, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 161, 0,   0,   0,   0,   117, 255, 255, 255, 255, 226, 149, 129, 169, 249, 255, 255, 255, 223, 9,   0,
     0,   0,   212, 255, 255, 244, 19,  0,   0,   129, 255, 255, 255, 239, 255, 255, 255, 255, 51,  0,   56,  255, 255, 255, 72,  0,   0,   0,   0,   25,  105, 161, 207, 233, 248, 247, 230, 193, 134,
     43,  0,   0,   0,   0,   0,   0,   104, 124, 124, 208, 255, 255, 255, 140, 124, 124, 124, 125, 137, 178, 246, 255, 255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   223,
     255, 255, 254, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   152, 255, 255, 255, 255, 211, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  126,
     243, 255, 255, 255, 236, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 233, 8,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   84,  250, 255, 255, 255, 206, 21,  0,   0,   0,   0,   3,   232, 255, 255, 255, 190, 34,  0,   0,   0,   0,   34,  191, 255, 255, 255, 228, 1,   0,   0,   0,   0,   0,
     0,   0,   0,   5,   74,  174, 254, 255, 255, 255, 213, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  226, 255, 255, 255, 255, 247, 182, 144, 129, 147, 197, 252, 255, 255, 255, 255,
     255, 119, 0,   0,   0,   0,   2,   160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 45,  0,   0,   0,   26,  255, 255, 255, 145, 0,   0,   51,  252, 255, 250, 79,  1,   194, 255, 255,
     237, 2,   0,   0,   230, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,
     0,   0,   0,   0,   24,  203, 255, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   113, 253, 255, 255, 255, 233, 44,  0,   0,   0,   0,   0,   2,   57,  117, 179, 249, 255, 255, 255, 255, 251, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  246, 255, 255, 255, 214, 27,  0,   0,   0,   0,
     101, 255, 255, 255, 255, 250, 181, 142, 142, 180, 250, 255, 255, 255, 255, 95,  0,   0,   0,   59,  124, 124, 124, 141, 182, 240, 255, 255, 255, 255, 255, 226, 35,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   6,   199, 255, 255, 255, 252, 138, 15,  0,   0,   0,   0,   0,   44,  217, 255, 255, 255, 255, 77,  0,   0,   0,   0,   0,   2,   130, 250, 255, 255, 255, 255, 255, 255, 255,
     211, 39,  0,   0,   0,   0,   89,  255, 255, 255, 70,  0,   0,   177, 255, 255, 148, 0,   0,   140, 255, 255, 172, 0,   0,   0,   195, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   50,  255, 255, 255, 217, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   151, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 255, 255, 181, 8,   0,   0,   0,   0,   0,   28,
     255, 255, 255, 255, 255, 255, 255, 224, 67,  0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 255, 255, 255, 255, 255, 255, 221, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  243, 255, 255, 255, 222, 30,  0,   0,   0,   0,   150, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 145, 0,   0,
     0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 185, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 249, 79,  0,   0,   0,   0,   0,   0,   0,
     0,   38,  250, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   38,  135, 208, 238, 249, 228, 176, 90,  2,   0,   0,   0,   0,   0,   118, 255, 255, 255, 15,  0,   19,  253, 255, 244, 23,
     0,   0,   167, 255, 255, 104, 0,   0,   0,   193, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255,
     255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   2,   253, 255, 255, 237, 0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   236, 255, 255, 247, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 255, 169, 5,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 255, 255, 246, 145, 12,  0,   0,   0,   0,   0,   0,   0,   0,   84,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  238, 255, 255,
     197, 11,  0,   0,   0,   0,   1,   107, 243, 255, 255, 255, 255, 255, 255, 255, 255, 242, 104, 0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 205, 86,  2,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   13,  237, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 249, 0,   0,   79,  255, 255, 166, 0,   0,   0,   230, 255, 255, 37,  0,   0,   0,   224, 255, 255, 125, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 255, 224, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 255, 157, 2,   0,   0,   0,
     0,   0,   0,   0,   28,  255, 255, 255, 232, 115, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  232, 208, 16,  0,   0,   0,   0,   0,   0,   0,   16,  111, 181, 228, 247, 247, 228, 181, 111,
     16,  0,   0,   0,   0,   0,   0,   110, 255, 255, 249, 232, 213, 178, 117, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 210, 1,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 241, 0,   0,
     109, 255, 255, 104, 0,   0,   72,  255, 255, 227, 0,   0,   0,   44,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   154, 255, 255, 255, 255, 144, 1,   0,   0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   40,  124, 124, 124, 124, 148, 255, 255, 255, 255, 255, 251, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   37,  22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   249, 255, 255, 212, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 254, 3,   0,   114, 255, 255, 78,  0,   4,   207, 255, 255, 178, 0,   0,   0,   165, 255, 255, 234,
     8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   12,  52,  143, 253, 255,
     255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   167, 255, 255, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 255, 255, 255, 122,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 250, 237, 212, 170, 91,  9,   0,   0,   0,   0,   0,   0,   0,   0,   63,  124, 124, 124, 124, 124, 124, 124, 124, 15,  0,   0,   0,   0,   0,   0,   0,   0,   226, 255, 255, 255,
     32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   162, 145, 92,  37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107,
     255, 255, 255, 38,  0,   81,  255, 255, 146, 21,  162, 255, 255, 255, 230, 38,  19,  136, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   179, 255, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  100, 100, 100, 65,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   224, 255, 255, 255, 255, 255, 255, 223, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 229, 75,  0,   0,   0,   0,   0,   0,   0,
     132, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   249, 255, 255, 242, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 102, 0,   16,  239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 181, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 253, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  189, 255, 255, 255,
     254, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 255,
     207, 194, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   92,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,
     13,  255, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   4,   243, 255, 255, 206, 0,   0,   105, 255, 255, 255, 255, 216, 59,  207, 255, 255, 255, 255, 254, 155, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  199, 255, 255, 255, 251, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 108, 98,  255, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   44,  124, 124, 140, 255, 255, 255, 208, 124, 124, 124, 125, 134, 158, 207, 255, 255, 255, 255, 255, 84,
     0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   6,   255, 255, 255, 226, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 98,  0,   0,   75,  164, 165, 100, 7,
     0,   7,   103, 166, 167, 129, 45,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255,
     140, 124, 124, 124, 126, 134, 154, 190, 245, 255, 255, 255, 250, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  208,
     255, 255, 255, 248, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     27,  252, 255, 255, 247, 16,  13,  245, 255, 255, 251, 26,  0,   0,   0,   0,   0,   0,   0,   0,   85,  124, 124, 124, 124, 124, 124, 231, 255, 255, 249, 124, 124, 124, 124, 124, 124, 89,  0,
     0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   46,  212, 255, 255, 255, 235, 18,  0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   243, 255, 255, 245, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  253, 255, 255, 246, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  162, 205, 2,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   13,  145, 255, 255, 255, 206, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  216, 255, 255, 255, 245, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 164, 0,   0,   162, 255, 255, 255, 125, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,
     22,  231, 255, 255, 255, 126, 0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 255, 39,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 251, 137,
     19,  0,   0,   0,   0,   0,   0,   15,  90,  198, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   1,   204, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   8,   191, 255, 255, 240, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   3,   227, 255, 255, 255, 64,  0,   0,   66,  255, 255, 255, 225, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 217, 0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   185, 255, 255, 255, 255, 250, 193, 148, 129, 139, 160, 201, 252, 255, 255, 255, 255, 246, 93,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 255,
     255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  202, 235, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 219, 1,   0,   0,   1,   224, 255, 255, 255,
     75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   4,   231, 255, 255, 255, 33,  0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 219, 3,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     8,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 202, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   179, 255, 255, 255, 121, 0,   0,   0,   0,   130, 255, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255,
     255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 95,  0,   0,   0,   132, 255,
     255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   223, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  202, 70,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 81,  1,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   198, 255, 255, 255, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  252, 255, 255, 255, 147, 124, 124, 124,
     124, 153, 255, 255, 255, 252, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255,
     255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 121, 0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     103, 255, 255, 255, 251, 88,  0,   0,   0,   0,   0,   0,   0,   0,   1,   102, 242, 255, 239, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   4,   77,  147, 205, 229, 249, 240, 217, 186, 120, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   10,  137, 255, 255, 255, 240, 10,  0,   80,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8,   0,   224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 124, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 145,
     0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   184, 255, 255, 255, 253, 142, 15,  0,   0,   0,   0,   0,   56,  193, 255, 255,
     255, 255, 211, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 124, 124, 208, 255, 255, 255, 140, 124,
     124, 124, 125, 132, 151, 187, 242, 255, 255, 255, 255, 133, 0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8,   0,   224, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   228, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 227, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 180, 0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   20,  218, 255, 255, 255, 255, 247, 180, 141, 129, 153, 213, 255, 255, 255, 255, 255, 229, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  116, 193, 225, 249,
     244, 224, 179, 100, 8,   0,   106, 96,  52,  10,  0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 196, 5,   0,   0,   80,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8,   0,   224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 78,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     64,  255, 255, 255, 170, 0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  199, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 165, 20,  0,   0,   0,   0,   0,   0,   0,   0,   10,  135, 250, 255, 255, 255, 255, 255, 255, 255, 255, 222, 71,  225, 255, 255, 226, 0,   0,   0,   255, 255, 255, 255,
     255, 255, 255, 255, 255, 112, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 151, 8,   0,   0,   0,   38,  124, 124, 134, 255, 255, 255, 214, 124, 124, 124, 124, 124, 124, 124, 124, 124, 198, 255, 255,
     255, 8,   0,   108, 124, 124, 208, 255, 255, 255, 140, 124, 124, 124, 124, 124, 124, 124, 124, 138, 255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     182, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 154, 0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   120, 241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 197, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  209, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 255, 255, 185, 0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 245, 231, 197, 136, 39,  0,   0,   0,
     0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 8,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,
     0,   0,   28,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  253, 255, 255, 245, 16,  0,   0,   0,   0,   0,   0,   0,   0,   10,  239, 255, 255,
     253, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   119, 255, 255, 255, 132, 0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  97,
     173, 217, 239, 251, 236, 198, 139, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  219, 255, 255, 255, 255, 239, 170, 138, 134, 169, 236, 255, 255, 255, 255, 255, 255, 142, 0,   0,
     0,   124, 124, 144, 255, 255, 255, 204, 124, 124, 54,  0,   0,   44,  124, 124, 198, 255, 255, 255, 150, 124, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   144, 255, 255, 255, 8,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   132, 255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 255, 82,  0,   0,   0,   132, 255, 255, 255,
     64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     1,   185, 255, 255, 255, 245, 116, 6,   0,   0,   0,   0,   7,   107, 244, 255, 255, 255, 255, 99,  0,   0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144,
     255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 8,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  124, 124, 232, 255, 255, 255, 159, 124, 124, 63,  0,   0,   0,   0,   85,
     124, 124, 154, 255, 255, 255, 231, 124, 124, 19,  0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  247, 255, 255, 255, 27,  0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 255, 242, 60,  0,   0,   0,   0,   0,   0,   0,   0,   58,  249, 255,
     255, 255, 94,  0,   0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,
     0,   152, 255, 255, 255, 0,   0,   144, 255, 255, 255, 8,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   60,  255, 255, 255, 92,  0,   28,  255, 255, 255, 124, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,
     0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 199, 0,   0,   0,
     0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   6,   229, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 134, 0,   0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,
     0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   152, 255, 255, 255, 0,   0,   144, 255, 255, 255, 8,   0,   0,   0,   0,   164,
     255, 255, 255, 32,  0,   0,   60,  255, 255, 255, 92,  0,   28,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 132,
     0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   64,  247, 255, 255, 255, 92,  0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   44,  255, 255, 255, 175, 0,   0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   124, 124, 124, 124, 124, 124, 124, 165, 255, 255, 255, 183, 124, 124, 124, 124, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255,
     255, 255, 176, 0,   0,   0,   152, 255, 255, 255, 0,   0,   56,  100, 100, 100, 3,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   60,  255, 255, 255, 92,  0,   10,  100, 100, 100, 48,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 40,  0,   0,
     0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   8,   118, 245, 255, 255, 255,
     204, 5,   0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  124, 124, 124, 175, 255, 255, 255, 173, 124, 124, 124, 124, 15,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   235, 255, 255, 215, 0,   0,   0,   0,   0,   40,  255, 255, 255,
     156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   44,  124, 124, 140, 255, 255, 255, 208, 124, 124, 124, 128, 147, 183, 245, 255, 255, 255, 255, 244, 40,  0,   0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   231, 255, 255, 254, 19,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  93,  55,  16,  0,   0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,
     0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 28,  0,   248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   85,  124, 124, 124, 124, 124, 124, 231, 255, 255, 249, 124, 124, 124, 124, 124, 124, 89,  0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 233, 53,  0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   255, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255,
     116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     28,  0,   248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 184, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 159, 29,  0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 64,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  255, 255, 255,
     206, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 214, 124, 124, 124, 202, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 140, 124, 124, 154,
     255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 28,  0,   248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 251, 234, 215, 173, 108, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255,
     255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 203, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 92,  0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   152,
     255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   60,  255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   5,   124, 124, 124, 231, 255,
     255, 249, 124, 124, 124, 13,  0,   120, 124, 206, 255, 255, 255, 255, 210, 124, 124, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132,
     255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   13,  255, 255, 255, 221, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   40,  255, 255, 255, 204, 124, 124, 124, 124, 124, 124,
     124, 124, 198, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   152, 255, 255, 255, 0,   0,   75,  240, 240, 240, 67,  0,   0,   0,   0,   164, 255, 255,
     255, 32,  0,   0,   60,  255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 255, 185, 14,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255,
     255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   210, 255, 255, 255, 255, 255, 255, 255, 32,  0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   246, 255, 255, 250, 11,  0,   0,   0,   0,   0,   32,  255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255,
     176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   5,   161, 255, 255, 255, 255, 155, 4,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 239, 20,  0,   0,   0,   0,   172, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   45,  255, 255, 255, 255, 255, 255,
     255, 255, 32,  0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 73,  0,   0,   0,   0,   0,   15,  124, 124, 124, 124, 124, 154, 255, 255, 255, 194, 124, 44,  0,   0,   0,   40,  255, 255, 255, 156, 0,
     0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   37,  120, 120, 120, 33,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,
     0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   16,  190, 255, 255, 255, 254, 120,
     0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 148, 0,   0,   0,   0,   172, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   40,
     255, 255, 255, 255, 255, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   132, 255, 255, 255, 157, 124, 124, 124, 124, 15,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 182, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 136, 0,   0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255,
     255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   32,  214, 255, 255, 255, 247, 86,  0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 251, 41,
     0,   0,   0,   172, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   19,  124, 124, 249, 255, 255, 255, 255, 255, 127, 0,   0,   0,   0,   0,   1,   225, 255,
     255, 255, 255, 255, 198, 124, 124, 15,  0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,
     0,   0,   0,   0,   46,  148, 148, 148, 41,  0,   0,   0,   30,  250, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 136, 0,   0,   0,   0,   0,   40,
     255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 116, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255,
     255, 255, 72,  0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   53,  232, 255, 255,
     255, 235, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  124, 124, 175, 255, 255, 255, 255, 255, 182, 0,   0,   0,   83,  124, 124, 124, 192, 255, 255, 255, 157, 124, 124, 11,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 218, 0,   0,   0,   0,   0,   62,  255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255,
     255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   153, 255, 255, 255,
     241, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 136, 0,   0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,
     0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   38,  124, 124, 134, 255, 255, 255, 214, 124, 124, 124, 124, 124, 124, 124, 124, 124, 165, 255, 255, 255, 72,  0,   108, 124, 124, 208, 255, 255, 255, 140, 124, 124, 124, 124, 9,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 80,  245, 255, 255, 255, 218, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255,
     255, 255, 255, 255, 255, 71,  0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 247, 255, 255, 255, 54,  0,   0,
     0,   0,   154, 255, 255, 247, 255, 255, 255, 144, 0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255,
     96,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   19,  223, 255, 255, 255, 251, 141, 24,  0,   0,   0,   0,   0,   0,   25,  141, 255, 255, 255, 136, 0,
     0,   0,   0,   0,   40,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   87,
     255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 72,  0,   224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 254,
     253, 255, 255, 255, 251, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 212, 3,   0,   0,   0,   0,   0,   132, 255, 255, 255, 64,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 218, 255, 255, 146, 0,   0,   0,   6,   238, 255, 255, 169, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,
     0,   0,   46,  241, 255, 255, 255, 255, 252, 202, 153, 133, 124, 141, 196, 253, 255, 255, 255, 255, 136, 0,   0,   0,   124, 124, 144, 255, 255, 255, 204, 124, 124, 54,  0,   0,   44,  124, 124,
     198, 255, 255, 255, 150, 124, 124, 0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   224, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   100, 255, 255, 255, 253, 255, 255, 255, 105, 0,   0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 127,
     255, 255, 233, 3,   0,   0,   80,  255, 255, 253, 79,  255, 255, 255, 144, 0,   0,   0,   0,   19,  124, 124, 124, 124, 124, 124, 124, 124, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   41,  218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 131, 0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   80,  255, 255, 255, 72,  0,   0,   0,   0,
     0,   0,   0,   0,   130, 255, 255, 255, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 249, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 157, 255, 255, 255, 234, 15,  0,   0,   0,   0,
     132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 35,  255, 255, 255, 73,  0,   0,   171, 255, 255, 188, 52,  255, 255, 255, 144, 0,   0,
     0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255,
     255, 72,  0,   0,   0,   0,   0,   0,   0,   14,  131, 241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 188, 81,  3,   0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 255, 112,
     0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   80,  255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 251, 13,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 192, 151, 255, 255, 255, 190, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  168, 255, 255, 255, 139, 0,   0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     244, 255, 255, 208, 0,   199, 255, 255, 164, 0,   14,  247, 255, 255, 96,  52,  255, 255, 255, 144, 0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  92,  160, 211, 232, 250,
     244, 229, 199, 152, 96,  20,  0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   80,  255, 255, 255,
     255, 156, 20,  0,   0,   0,   0,   0,   78,  255, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  103, 180, 219, 243, 243, 219, 181, 106, 24,  0,   0,   0,
     0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 247, 237, 211, 169, 95,  7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 197, 12,  12,  227, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  29,  246, 255, 255,
     249, 35,  0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   108, 255, 255, 244, 11,  98,  255, 255, 246, 13,  52,  255,
     255, 255, 144, 0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,
     0,   0,   80,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  250, 255, 255, 255, 255, 249, 188, 146, 128, 140, 192, 255, 255, 255, 255, 94,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   8,   123, 244, 255, 255, 255, 255, 255, 255, 255, 255, 245, 128, 9,   0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 228, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 248, 14,  0,   0,   80,  255, 255, 255,
     233, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   127, 255, 255, 255, 173, 0,   0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   20,  251, 255, 255, 91,  189, 255, 255, 167, 0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144,
     0,   0,   0,   0,   0,   0,   0,   38,  124, 124, 124, 175, 255, 255, 255, 173, 124, 124, 124, 124, 124, 124, 124, 124, 165, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   9,   85,  166,
     214, 238, 247, 223, 191, 118, 35,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 249, 234, 201, 133, 27,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   54,  222, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 207, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  199, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 203, 21,  0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 91,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   176, 255, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255,
     96,  0,   9,   225, 255, 255, 255, 62,  0,   0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   0,   180, 255, 255, 204, 253, 255,
     255, 75,  0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   87,  226, 255, 255, 255, 255, 255, 255, 255, 255, 252, 148, 18,  0,   0,   0,   0,   0,   0,   216, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  118, 234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 207, 27,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  214, 255, 255, 255, 255, 244, 173, 137, 137, 172, 243, 255, 255, 255, 255, 218, 18,  0,   0,   0,   60,  124, 124, 157, 255, 255, 255, 192,
     124, 124, 125, 135, 158, 204, 254, 255, 255, 255, 245, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,
     0,   0,   28,  243, 255, 255, 254, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   87,  255, 255, 255, 205, 1,   0,   132, 255, 255, 255, 64,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   0,   89,  255, 255, 255, 255, 255, 234, 4,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   2,
     151, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 37,  0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 68,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  80,  152, 207, 231, 250, 240, 220, 166, 89,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 253, 139, 11,
     0,   0,   0,   0,   10,  133, 252, 255, 255, 255, 179, 1,   0,   0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   35,  192, 255, 255, 255, 188, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   112, 255, 255, 255, 208, 4,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   100, 255, 255, 255, 96,  0,   0,   0,   194, 255, 255, 255, 96,  0,   132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   0,   10,
     242, 255, 255, 255, 255, 147, 0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   163, 255, 255, 255, 255, 252, 187, 143, 133, 163, 234, 255, 255, 255, 255, 233, 37,  0,
     0,   0,   0,   104, 124, 124, 208, 255, 255, 255, 140, 124, 124, 124, 128, 147, 197, 254, 255, 255, 255, 223, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255, 255, 255, 253, 95,  0,   0,   0,   0,   0,   0,   0,   0,   86,  252, 255, 255, 255, 95,  0,   0,   0,   0,   0,
     64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   12,  230, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208,
     255, 255, 244, 0,   0,   0,   0,   0,   3,   205, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   48,  253, 255, 255, 229, 11,  132, 255,
     255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   0,   0,   161, 255, 255, 255, 255, 54,  0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   107, 255, 255, 255, 255, 180, 29,  0,   0,   0,   0,   4,   111, 245, 255, 255, 255, 205, 6,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,
     59,  241, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  2,   0,   0,   0,   0,   0,   0,   0,   1,   209, 255, 255,
     255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 216, 2,   0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255,
     96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   124, 124, 124, 231, 255, 255, 249, 124, 124, 124, 13,  0,   0,   51,  252, 255, 255, 243, 125, 124, 124,
     124, 98,  0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   154, 255, 255, 255, 130, 132, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255,
     255, 208, 0,   0,   0,   70,  255, 255, 255, 217, 0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   31,  247, 255, 255, 255, 155, 1,   0,   0,   0,   0,   0,   0,   0,   62,
     244, 255, 255, 255, 129, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,
     142, 202, 234, 251, 243, 217, 167, 90,  7,   193, 241, 187, 129, 1,   0,   0,   0,   0,   60,  255, 255, 255, 235, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   227, 255, 255, 255,
     70,  0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 28,  0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 204, 0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   21,  240,
     255, 255, 246, 161, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   0,   0,   3,   230, 255, 255, 126, 0,   0,   0,   52,  255, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 72,  0,   0,   145, 255, 255, 255, 202, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 239, 13,  0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,
     0,   0,   0,   0,   0,   0,   74,  255, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   30,  182, 255, 255, 255, 255, 255, 255, 255, 255, 255, 231, 245, 255, 255, 214, 0,   0,   0,   0,
     0,   129, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 137, 0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   124, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 28,  0,   0,   0,   12,  227,
     255, 255, 255, 255, 255, 255, 204, 0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   113, 255, 255, 255, 252, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   244, 255, 255, 208, 0,   0,   0,   0,   97,  156, 156, 31,  0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,
     0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   9,   244, 255, 255, 255, 51,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   199, 255, 255, 255, 106, 0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,
     0,   54,  238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 155, 0,   0,   0,   0,   0,   188, 255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   55,  255, 255, 255, 198, 0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 28,  0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 204, 0,   0,   0,   0,   100, 255, 255, 255, 96,  0,
     0,   0,   0,   0,   5,   215, 255, 255, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 171, 124, 124, 124, 124, 239, 255, 255,
     241, 124, 124, 124, 124, 165, 255, 255, 255, 72,  0,   68,  255, 255, 255, 198, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 175, 0,   0,   0,   0,   0,   164,
     255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 129, 0,   0,   0,   0,   0,   0,   27,  239, 255, 255, 255, 255, 221, 166, 134, 134, 162, 230, 255, 255, 255, 255, 255,
     96,  0,   0,   0,   0,   0,   215, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 225, 0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   88,  255, 255, 255, 243, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 255, 64,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   19,  124, 124, 249, 255, 255, 231, 124, 124, 124, 120, 0,   0,   0,   48,  124, 124, 124, 150, 255, 255, 255, 198, 124, 124, 15,  0,   0,   0,   0,   0,   0,   52,  255,
     255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 92,  0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   130, 255, 255, 255, 125, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  254, 255, 255, 237, 0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   52,  238, 255, 255, 255, 60,  0,
     0,   0,   0,   0,   0,   165, 255, 255, 255, 231, 83,  2,   0,   0,   0,   0,   5,   163, 255, 255, 255, 255, 36,  0,   0,   0,   0,   0,   234, 255, 255, 254, 2,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 245, 0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   3,   11,  27,  69,  154, 252, 255, 255, 255, 147, 0,   0,   124, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 8,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  124, 124, 175,
     255, 255, 255, 173, 124, 124, 124, 69,  0,   0,   0,   180, 255, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 0,
     0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 92,  0,   0,
     0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   162, 255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   221, 255, 255, 255, 13,
     0,   0,   0,   0,   164, 255, 255, 255, 140, 124, 124, 124, 127, 144, 193, 253, 255, 255, 255, 191, 0,   0,   0,   0,   0,   0,   10,  247, 255, 255, 252, 44,  0,   0,   0,   0,   0,   0,   0,
     15,  247, 255, 255, 255, 16,  0,   0,   0,   0,   0,   234, 255, 255, 254, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   245, 255, 255, 246, 0,   0,   0,   0,   64,  255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 13,  0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   37,  249, 255, 255, 255, 255,
     64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,
     0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 92,  0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   181,
     255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 255, 32,  0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 204, 23,  0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 255, 45,  0,   0,   0,   0,   0,   215, 255, 255, 255, 20,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 226, 0,   0,   0,   0,   64,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 215, 35,  0,   0,   0,
     124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   139, 255, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 248, 0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   60,  255,
     255, 255, 92,  0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   192, 255, 255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     193, 255, 255, 255, 42,  0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 157, 10,  0,   0,   0,   0,   0,   0,   0,   51,  255, 255, 255, 192, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 74,  0,   0,   0,   0,   0,   190, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 201, 0,
     0,   0,   0,   64,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 132, 13,  0,   0,   0,   0,   60,  124, 124, 208, 255, 255, 255, 134, 124, 124, 124, 3,   0,   79,  124, 124, 124,
     214, 255, 255, 255, 134, 124, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,
     14,  232, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 92,  0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   80,  255,
     255, 255, 72,  0,   180, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   211, 255, 255, 255, 24,  0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 219, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  252, 255, 255, 251, 47,  0,   0,   0,   0,   0,   0,   0,   0,   93,  228, 228, 228, 91,  0,   0,   0,   0,   0,   131,
     255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 141, 0,   0,   0,   0,   64,  255, 255, 255, 192, 124, 123, 120, 114, 103, 82,  41,  2,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   60,  255, 255, 255, 92,  0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   80,  255, 255, 255, 72,  0,   153, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   3,   243, 255, 255, 253, 6,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   106, 255, 255, 255, 251, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255,
     255, 255, 239, 113, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 236, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   229,
     255, 255, 255, 74,  0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 20,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   176, 255, 255, 255, 20,  0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 40,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   54,  232, 232, 232, 83,  0,   0,   0,   0,   224, 255, 255, 228, 0,
     0,   0,   0,   72,  232, 232, 232, 65,  0,   107, 255, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  255, 255, 255, 208, 0,   0,   0,   0,   0,   164, 255, 255,
     255, 32,  0,   0,   2,   203, 255, 255, 255, 202, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  241, 255, 255, 255, 255, 254, 219, 179, 154, 139, 117, 86,  36,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   1,   214, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 221, 3,   0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 20,  0,   0,   0,   52,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 241, 12,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 147, 0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   52,  253, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   54,  238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 63,  0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 254, 98,  0,   0,   0,   0,   0,   0,
     0,   0,   88,  252, 255, 255, 255, 102, 0,   0,   0,   0,   0,   64,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255,
     20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 20,  0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   124, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  124, 124, 159, 255, 255, 255, 220, 124, 124, 124, 0,   0,   0,   0,   94,  124, 124, 162,
     255, 255, 255, 216, 124, 124, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   210, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  243, 255, 255, 255, 55,  0,   0,   0,
     0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   149, 255, 255, 255, 243, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  172, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 253, 115, 0,   0,   0,   0,   0,   0,   0,   1,   180, 255, 255, 255, 254, 140, 12,  0,   0,   0,   0,   10,  133, 252, 255, 255, 255, 186, 2,   0,   0,   0,   0,   0,   64,  255, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 20,  0,   0,
     0,   25,  124, 146, 255, 255, 255, 202, 124, 124, 124, 34,  0,   0,   0,   0,   60,  124, 124, 124, 202, 255, 255, 255, 150, 124, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   10,  242, 255, 255, 245, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255,
     255, 255, 249, 53,  0,   0,   0,   0,   0,   0,   0,   0,   5,   189, 255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   16,  232, 255, 255, 255, 176,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  111, 165, 205, 234, 254, 255, 255, 255, 255, 255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   18,  219, 255, 255, 255, 255,
     244, 172, 137, 136, 171, 242, 255, 255, 255, 255, 223, 22,  0,   0,   0,   60,  124, 124, 157, 255, 255, 255, 192, 124, 124, 124, 124, 124, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   164, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 20,  0,   0,   0,   0,   0,   19,  255, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   177, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 94,  0,   0,   0,   0,   0,
     0,   0,   0,   2,   229, 255, 255, 249, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   201, 255, 255, 255, 237, 59,  0,   0,   0,   0,   0,   0,   14,  176, 255, 255, 255, 252,
     55,  0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,
     8,   43,  89,  154, 242, 255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   22,  203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 207, 25,  0,   0,   0,   0,   124, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255,
     255, 255, 20,  0,   0,   0,   0,   0,   0,   242, 255, 255, 206, 0,   0,   0,   0,   203, 255, 255, 221, 0,   0,   0,   0,   210, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   39,  238, 255, 255, 255, 253, 157, 62,  18,  9,   38,  114, 227, 255, 255, 255, 255, 131, 0,   0,   0,   0,   104, 124, 124, 208, 255, 255, 255, 140, 124, 124, 89,  0,   0,
     0,   191, 255, 255, 255, 228, 124, 124, 124, 98,  0,   26,  141, 190, 237, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  247, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,
     0,   9,   128, 245, 255, 255, 255, 255, 255, 255, 255, 255, 246, 132, 11,  0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   209, 255, 255, 238, 0,   0,   0,   25,
     254, 255, 255, 255, 40,  0,   0,   0,   242, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   224, 255, 255, 252,
     25,  0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 151, 1,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   41,  250, 255, 255, 255, 255, 255, 255, 204, 0,   24,  255, 255, 255, 198, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  106, 182, 221, 244, 244, 221, 183, 108, 25,  0,   0,   0,   0,
     0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   176, 255, 255, 255, 20,  0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 13,  0,   0,   102, 255, 255, 255, 255, 115, 0,   0,   19,  255, 255, 255, 175, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   6,   238, 255, 255, 233, 4,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  209, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 119, 1,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 184, 0,   0,   0,   0,   135, 255, 255, 255, 255, 255, 255, 204, 0,   0,   227, 255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 44,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 255, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 255, 19,  0,   0,   0,   0,   0,   0,   143, 255, 255,
     255, 44,  0,   0,   179, 255, 255, 255, 255, 190, 0,   0,   52,  255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   37,  255, 255, 255, 207, 0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  124, 124, 124, 124, 150, 255, 255, 255, 144, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   199, 255, 255, 255,
     255, 255, 255, 255, 242, 155, 39,  0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   0,   10,  224, 255, 255, 255, 255, 255, 204, 0,   0,
     173, 255, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  250, 255, 255, 248, 11,  0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   0,   184, 255, 255, 255, 255,
     255, 255, 255, 255, 224, 0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 255, 39,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 15,  0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 76,  0,   9,   246, 255, 255, 255, 255, 250, 14,  0,   84,  255, 255, 255, 105,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 255, 43,  0,   0,   0,   0,   0,   167, 255, 255, 255, 46,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255,
     255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  253, 255, 255, 255, 255, 255, 181, 54,  9,   0,   0,   0,   30,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 255, 155, 15,  0,   0,   0,   0,   0,   0,   61,  222, 255, 255,
     255, 171, 0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   0,   184, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 5,   0,   0,   0,   0,
     0,   0,   77,  255, 255, 255, 107, 0,   78,  255, 255, 252, 253, 255, 255, 84,  0,   117, 255, 255, 255, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 136, 0,   0,   0,   0,   11,  245, 255, 255, 207, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255,
     255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  124, 124, 124, 124, 239, 255, 255, 241, 124, 124, 124, 124, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   95,
     246, 255, 255, 255, 255, 255, 255, 255, 185, 55,  5,   53,  164, 251, 70,  0,   0,   0,   0,   0,   0,   0,   7,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 245, 183, 142, 128, 132, 158, 214, 255, 255, 255, 255, 245, 35,  0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   0,
     184, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   132,
     255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   5,   244, 255, 255, 238, 0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 138, 0,   155, 255, 255, 196, 200, 255, 255, 159, 0,
     149, 255, 255, 255, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  248, 255, 255, 226, 1,   0,   0,   0,   89,
     255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   26,  179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 39,  0,
     0,   0,   0,   23,  128, 233, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 246, 69,  0,   0,   0,   0,   98,  124, 125, 240, 255, 255, 255, 223, 124, 114, 0,   0,   89,  124, 207, 255, 255, 255, 247, 128, 124, 108, 0,   0,   32,  255, 255, 255, 185,
     124, 124, 124, 124, 124, 124, 124, 127, 246, 255, 255, 255, 219, 12,  0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 198,
     0,   0,   0,   0,   0,   0,   0,   11,  255, 255, 255, 170, 1,   230, 255, 255, 121, 129, 255, 255, 232, 1,   182, 255, 255, 251, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 255, 64,  0,   0,   0,   179, 255, 255, 250, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,
     0,   0,   20,  238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   26,  248, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 249, 181, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 197, 43,  0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255,
     255, 77,  0,   0,   0,   0,   53,  250, 255, 255, 255, 105, 0,   0,   0,   0,   0,   32,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 250, 53,  0,   0,   0,   0,
     0,   0,   0,   0,   34,  255, 255, 255, 236, 12,  0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   234, 255, 255, 201, 54,  255, 255, 255, 45,
     57,  255, 255, 255, 53,  214, 255, 255, 222, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255,
     157, 0,   0,   18,  250, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   75,  255, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 254, 176, 72,  18,  8,   41,  108, 192, 253, 255, 255, 255,
     255, 215, 87,  0,   0,   0,   0,   0,   185, 255, 255, 255, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   162, 215, 249, 218, 0,   61,  149,
     201, 234, 248, 250, 234, 202, 146, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 236, 27,  0,   0,   14,  221, 255, 255, 255, 173, 0,   0,   0,   0,   0,   0,
     32,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   56,  251, 255, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   197, 255, 255, 255, 173, 13,  0,   0,   0,   0,   0,   95,
     253, 255, 255, 254, 39,  0,   0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 233, 131, 255, 255, 225, 0,   3,   238, 255, 255, 129, 246, 255, 255, 187, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   233, 255, 255, 240, 8,   0,   101, 255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   202, 255, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   2,   141, 47,  0,   0,   0,   0,   0,   0,   0,   23,  82,  114, 109, 57,  0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 189, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   11,  217, 255, 255, 255, 191, 2,   0,   167, 255, 255, 255, 225, 17,  0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 120, 0,   0,   0,   0,   0,   13,  221, 255, 255, 255, 190, 2,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  254, 255, 255, 255, 240, 169, 137, 132, 154, 218, 255, 255, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255,
     216, 255, 255, 150, 0,   0,   170, 255, 255, 224, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   144, 255, 255, 255, 86,  0,   191, 255, 255, 236, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   205, 255, 255, 255, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  249, 255, 255, 255, 124, 100, 255, 255, 255, 252, 59,  0,   0,
     0,   0,   0,   0,   0,   32,  255, 255, 255, 120, 0,   0,   0,   0,   0,   162, 255, 255, 255, 237, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 197, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 255, 255, 255, 74,  0,   0,   98,  255, 255, 255, 255, 255, 255, 117, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  255, 255, 255, 178, 26,  253, 255, 255, 147, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 255, 255, 255, 255, 187, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 20,  0,   0,
     0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   37,  2,   0,   0,   0,   0,   0,   0,   88,  255, 255,
     255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  128, 128, 128, 128, 128, 125, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 252, 246, 255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 120, 0,   0,   0,   0,   88,  255, 255,
     255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  232, 255, 255, 255, 255, 255, 255, 255, 255, 253, 149, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   102, 255, 255, 255, 255, 255, 246, 9,   0,   0,   27,  255, 255, 255, 255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   211, 255, 255, 250, 133, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  255, 255, 255, 255, 255, 255, 255, 255, 58,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 20,  0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,
     4,   86,  157, 213, 236, 251, 239, 202, 136, 48,  45,  255, 246, 204, 105, 0,   0,   0,   0,   3,   223, 255, 255, 252, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
     117, 247, 255, 255, 255, 255, 207, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   183, 255, 255, 255, 255, 255, 255,
     191, 2,   0,   0,   0,   0,   0,   0,   0,   0,   10,  84,  84,  84,  39,  0,   0,   0,   30,  240, 255, 255, 255, 154, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   8,   95,  171, 220, 246, 252, 237, 198, 132, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 255, 255, 179, 0,   0,   0,   0,   211, 255, 255, 255, 255,
     255, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 252, 255, 255, 212, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   197, 255, 255, 255, 247, 247, 255, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 20,  0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   88,  223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 255, 255, 255, 119, 0,   0,
     0,   0,   0,   109, 255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  201, 255, 255, 255, 255, 216, 28,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  232, 255, 255, 255, 255, 235, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2,   194, 255, 255, 255, 216, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   36,  255, 255, 255, 255, 255, 103, 0,   0,   0,   0,   139, 255, 255, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  252, 255, 255, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 255, 139, 141,
     255, 255, 255, 255, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  124, 124, 176, 255, 255, 255, 247, 126, 124, 9,   0,   0,   0,   118, 126, 246, 255, 255, 255, 178, 124, 124, 34,  0,
     0,   0,   3,   151, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 67,  0,   0,   0,   0,   0,   11,  237, 255, 255, 245, 19,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   3,   120, 248, 255, 255, 255, 223, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118,
     255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 249, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   21,  99,  159, 211, 233, 250, 243, 219, 168, 87,  5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   253, 255, 255, 255, 255, 28,  0,   0,   0,   0,
     67,  255, 255, 255, 255, 233, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 255, 252, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 240, 18,  20,  242, 255, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     12,  229, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 232, 14,  0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 255, 254, 203, 149, 129, 138, 180, 248, 255, 255, 255,
     255, 255, 17,  0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  203, 255, 255, 255, 230, 43,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  235, 255, 255, 255, 255, 242, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   55,  251, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   74,  181, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 58,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   226, 255, 255, 255, 208, 0,   0,   0,   0,   0,   7,   244, 255, 255, 255, 198, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255,
     255, 255, 123, 0,   0,   129, 255, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 236, 18,  0,   0,   0,   0,   15,  233, 255, 255, 255, 96,
     0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 255, 194, 45,  0,   0,   0,   0,   0,   24,  189, 255, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   22,  247, 255, 255, 234, 8,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   124, 249, 255, 255, 236, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   2,   190, 255, 255, 255, 255, 255, 255, 203, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  220, 255, 255, 255, 186, 1,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   161, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 133,
     0,   0,   0,   0,   0,   0,   180, 255, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   9,   241, 255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 232, 11,  0,   0,   14,  236, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255, 152, 0,   0,   0,   0,   142, 255, 255, 255, 200, 1,   0,   0,   0,   0,   0,   7,   227, 255, 255, 255, 171, 3,   0,   0,   0,   0,   0,
     0,   0,   11,  226, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     45,  205, 255, 255, 241, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 242, 243, 255, 255, 255, 139, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 235, 25,  0,   0,   0,   0,   48,  240, 240, 240, 93,  0,   0,   0,   82,  255, 255, 255, 255, 238, 175, 132, 124, 136, 177, 248, 255,
     255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 57,  0,   0,   0,   0,   0,   0,   108, 255, 255, 255, 129, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  252, 255, 255, 253, 51,  0,   0,   40,  250,
     255, 255, 254, 53,  0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 227, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   36,  253,
     255, 255, 220, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   58,  252, 255, 255, 255, 93,  95,  255, 255, 255, 254, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 255, 255, 77,  0,   0,   0,   0,
     0,   52,  255, 255, 255, 100, 0,   0,   0,   2,   222, 253, 175, 71,  3,   0,   0,   0,   0,   0,   38,  238, 255, 255, 254, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   224, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 199, 1,   0,   185, 255, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 119, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   51,  255, 249, 218, 110, 0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   37,  124, 190, 226, 247, 245, 227, 190, 129, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  224, 255, 255, 255, 163, 0,   0,   167, 255, 255, 255,
     232, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  239, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 100, 0,   0,   0,   0,   72,  43,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   145, 255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   224, 255, 255, 255, 255,
     255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  235, 255, 255,
     255, 98,  78,  255, 255, 255, 240, 22,  0,   0,   0,   0,   0,   0,   0,   180, 255, 255, 255, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   29,  2,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   55,  255, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  165, 252, 255, 255, 255, 255, 255, 255, 255, 255, 254, 172, 22,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 255, 219, 13,  0,   0,   15,  223, 255, 255, 255, 184, 1,   0,   0,   0,   0,   0,   0,   0,   2,   193, 255, 255, 255, 212, 8,
     0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   12,  60,  91,  111, 119, 118, 103, 78,  144, 255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,   224, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 234, 221, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   198, 255,
     255, 255, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   54,  229, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 250, 52,  0,   0,
     0,   0,   58,  252, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 248, 45,  0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 100, 0,   0,   0,   0,   0,   72,
     189, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 176, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 104, 0,
     108, 124, 124, 208, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   1,   202, 255, 255, 255, 255, 255, 255, 214, 4,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   75,  255, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  238, 255, 255, 255, 255, 223, 165, 137, 138, 165, 221, 255,
     255, 255, 255, 223, 19,  0,   0,   0,   0,   0,   0,   0,   0,   43,  246, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 250, 51,  0,   0,   0,   0,   0,   54,  251, 255,
     255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 100, 0,   0,   0,   12,  179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   124, 124, 124, 124, 134, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  254, 255, 255, 255, 255, 255, 69,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   152, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   212, 255, 255, 254, 43,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   3,   211, 255, 255, 255, 233, 76,  2,   0,   0,   0,   0,   1,   73,  233, 255, 255, 255, 144, 0,   0,   0,   0,   0,   44,  124, 124, 214, 255, 255, 255,
     241, 125, 124, 98,  0,   0,   89,  124, 127, 246, 255, 255, 255, 220, 124, 124, 40,  0,   12,  219, 255, 255, 255, 240, 124, 124, 124, 124, 124, 124, 124, 124, 124, 150, 255, 255, 255, 100, 0,
     0,   9,   195, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,
     255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   94,  171, 220, 239, 251, 242, 226, 189, 143, 67,  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255,
     255, 244, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 255, 255, 174, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 255, 225, 8,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   7,   161, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 232, 32,  0,   0,   0,
     0,   0,   0,   0,   0,   35,  241, 255, 255, 248, 12,  0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 0,   0,   184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 84,
     0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   131, 255, 255, 255, 255, 179, 88,  36,  10,  1,   0,   0,   0,   115, 255, 255,
     255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  201, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 244, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  242, 255, 255, 250, 32,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   10,  233, 255, 255, 255, 165, 2,   0,   0,   0,   0,   0,   0,   0,   0,   42,  201, 255, 235, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,
     228, 255, 255, 250, 27,  0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 77,  0,   0,   0,   0,   92,  255,
     255, 255, 255, 255, 255, 255, 255, 255, 204, 0,   0,   184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 84,  0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 100, 0,   1,   235, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   255, 255, 255, 255, 244, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  1,   78,  165, 225, 246, 244, 221, 170, 94,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 255, 186, 37,  0,
     0,   0,   0,   0,   21,  136, 250, 255, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   10,  251, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 123, 0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255, 204, 0,   0,   184, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 84,  0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   30,  255, 255, 255, 218, 0,   0,   0,   0,   0,   0,   0,
     0,   13,  193, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   85,  163, 219, 242, 248, 227, 178, 86,  4,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   231, 255, 255, 255, 206, 144, 130, 150, 172, 206, 249, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 244, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255,
     87,  207, 255, 255, 255, 255, 255, 255, 255, 255, 224, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255,
     255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   169, 255, 255, 255, 255, 252, 194, 143, 128, 143, 191, 251, 255, 255, 255, 255, 236, 74,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   14,  241, 255, 255, 241, 14,  0,   0,   0,   0,   0,   0,   37,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 145, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  255, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   35,  209, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   62,  213,
     255, 255, 255, 255, 255, 255, 255, 255, 217, 89,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   39,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   7,   63,  33,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 244, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   169,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 185, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 255, 118, 0,   0,   0,   0,   0,   0,
     54,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   61,  143, 206, 233, 251, 235, 180, 86,  4,   160, 255,
     255, 255, 255, 255, 255, 84,  0,   20,  255, 255, 255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   233, 255, 255, 255, 117, 0,
     0,   0,   0,   6,   107, 241, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   100, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,
     0,   0,   0,   0,   0,   78,  255, 255, 255, 89,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 244, 0,   0,   0,   0,   0,
     0,   164, 255, 255, 255, 255, 255, 255, 244, 174, 134, 139, 186, 251, 255, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 232, 255, 255, 255, 255, 255, 255, 255, 255, 255, 212, 74,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  249, 255, 255, 229, 6,   0,   0,   0,   0,   0,   38,  255, 255, 255, 230, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
     124, 124, 124, 75,  0,   0,   0,   0,   0,   40,  192, 255, 255, 255, 255, 255, 255, 255, 255, 224, 214, 255, 255, 255, 255, 255, 255, 84,  0,   20,  255, 255, 255, 255, 255, 255, 236, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 255, 208, 145, 129, 161, 233, 255, 255, 255, 255, 255, 255, 255, 171, 124, 124, 124, 0,   0,
     0,   80,  254, 255, 255, 255, 252, 189, 140, 132, 167, 238, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 167, 21,  0,   0,   0,   0,   38,  199, 255, 255,
     255, 253, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   9,   96,  167, 219, 241, 252, 238, 202, 146, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 255, 97,
     0,   0,   0,   0,   0,   12,  253, 255, 255, 251, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  242, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 84,  0,   20,  255, 255, 255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,
     200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 255, 255, 255, 255, 255, 255, 255, 0,   0,   23,  242, 255, 255, 255, 205, 42,  0,   0,   0,   0,   13,  149, 255, 255, 255, 255,
     255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   9,   198, 255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   73,  124, 124, 124, 124, 235, 255, 255, 245, 124, 124, 124, 124, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  254, 255, 255, 213, 1,   0,   0,   0,   0,   0,   196, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   11,  59,  0,   0,   0,   0,   0,   57,  247, 255, 255, 255, 253, 189, 138, 135, 181, 250, 255, 255, 255, 255, 255, 255, 140, 124, 124, 40,  0,   9,   124, 124, 124, 235,
     255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  171, 255, 255, 255, 255, 255, 255, 255, 255, 241, 123, 110, 255, 255, 255, 255,
     255, 255, 255, 0,   0,   146, 255, 255, 255, 210, 12,  0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 255, 176, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 164, 0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 223, 6,   0,   0,   0,   0,   0,
     0,   0,   0,   31,  249, 255, 255, 255, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   180, 255, 255, 255, 76,  0,   0,   0,   0,   0,   106, 255, 255, 255, 250, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  204, 223, 6,   0,   0,   0,   7,   225, 255, 255, 255, 218,
     48,  0,   0,   0,   0,   38,  206, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   61,  160, 220, 246, 250, 227, 175, 104, 16,  0,   104, 255, 255, 255, 255, 255, 255, 255, 0,   3,   238, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,
     0,   4,   220, 255, 255, 255, 176, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 255, 99,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255,
     184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 194, 0,   0,   0,   0,   0,   5,   218, 255, 255, 255, 240,
     89,  2,   0,   0,   0,   0,   0,   22,  127, 244, 255, 255, 106, 0,   0,   0,   112, 255, 255, 255, 229, 23,  0,   0,   0,   0,   0,   0,   15,  218, 255, 255, 255, 255, 32,  0,   0,   0,   0,
     0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 202, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 176, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   9,   124, 124, 124, 124, 124, 124, 124, 124, 124, 134, 255, 255, 255, 176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 56,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   201, 255, 255, 255, 55,  0,   0,   0,   0,   0,   49,  242, 255, 255, 255, 255, 227, 164, 133, 131, 155, 196, 253, 255, 255, 255, 255, 218, 0,   0,   0,   202,
     255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 146, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 176, 0,   0,   0,   0,   94,  124, 124, 124, 183, 255, 255, 255, 165, 124, 124, 124, 124, 124, 124, 124, 79,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 149, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     52,  255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 173, 0,   0,   0,   0,   0,
     0,   60,  231, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 198, 36,  0,   0,   14,  254, 255, 255, 239, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   226, 255, 255, 255,
     32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   1,   71,  152, 213, 239, 245, 218, 150, 48,  0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255,
     255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  255, 255, 255, 176, 0,   0,   0,   0,   0,
     0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   164,
     255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 104, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   219, 255, 255, 253, 36,  0,   0,   0,   0,   0,   0,   22,  163, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 97,  3,
     0,   0,   0,   40,  255, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 59,  207, 255, 255,
     255, 255, 255, 255, 255, 252, 122, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255,
     255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255,
     255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   29,  115, 177, 221, 240, 250, 231, 206, 148, 72,  4,   0,   0,   0,   0,   0,   54,  255, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   165, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   63,  124, 124,
     124, 124, 124, 235, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 176,
     0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,
     0,   0,   0,   0,   164, 255, 255, 255, 220, 5,   0,   0,   0,   0,   0,   0,   0,   0,   28,  247, 255, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255,
     255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   234, 255, 255, 247, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   34,  255, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255,
     255, 255, 255, 255, 228, 165, 133, 137, 209, 255, 255, 255, 228, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   6,   242, 255, 255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   4,   219, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,
     7,   193, 255, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  124, 124, 171, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   125, 255, 252, 170, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   244, 255, 255, 253, 26,  0,   0,   0,
     0,   0,   0,   0,   0,   17,  248, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 220, 82,  2,   0,   0,   0,   5,   206, 255, 255, 255, 55,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 210, 12,  0,   0,   0,   0,   0,   0,   0,   139,
     255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,
     255, 255, 255, 176, 0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 161, 18,  0,   0,   0,   0,   35,  195, 255, 255, 255, 254, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 255, 255, 255, 255, 255, 172, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  138, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,
     0,   0,   216, 255, 255, 255, 156, 10,  0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   30,  247, 255, 255, 255, 205, 41,  0,   0,   0,   0,   13,  148, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255,
     80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   108, 124, 124, 208, 255, 255, 255, 255, 255, 255, 243,
     172, 133, 137, 184, 250, 255, 255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 255, 255, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  255, 255,
     255, 255, 106, 0,   0,   0,   0,   0,   0,   95,  254, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255,
     255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 255, 252, 188, 138,
     132, 166, 238, 255, 255, 255, 255, 255, 255, 214, 124, 124, 108, 0,   0,   0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 255, 255, 255, 255,
     255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 248, 2,   118, 216, 247, 225, 146, 26,  0,   76,  194, 236, 246, 209, 122, 10,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 255, 255, 170, 61,  12,  10,  56,  162, 254, 255, 255, 255, 255, 255, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   0,
     0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   224, 255, 255, 255, 255, 255,
     255, 118, 229, 255, 255, 255, 255, 255, 255, 255, 255, 234, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   20,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   114, 124, 124, 124, 124, 136, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255,
     255, 248, 155, 255, 255, 255, 255, 255, 232, 153, 255, 255, 255, 255, 255, 255, 212, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   12,  208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,
     0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,
     227, 255, 255, 255, 255, 255, 255, 255, 255, 209, 77,  255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   224, 255, 255, 255, 255, 255, 255, 32,  8,   100, 172, 222, 243, 249, 228, 184, 107, 13,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  183, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244,
     255, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   102, 181, 227, 249, 245, 216, 161, 75,  1,   20,  255, 255, 255, 255, 255, 255,
     224, 0,   0,   0,   0,   0,   116, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255,
     255, 104, 0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,
     19,  124, 124, 229, 255, 255, 255, 255, 200, 133, 191, 255, 255, 255, 255, 255, 225, 137, 163, 255, 255, 255, 251, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   90,  214, 255, 255, 255, 255, 255, 255, 200, 75,  165, 255, 255, 255, 26,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,
     0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   75,  124, 124, 124, 183, 255, 255, 255, 165, 124, 124, 124, 124, 124, 124,
     124, 77,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 176, 0,   20,  255, 255, 255, 255, 255, 255, 236, 0,   5,   87,  168, 216, 237, 249, 224, 160, 55,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   9,   124, 124, 179, 255, 255, 255, 239, 188, 188, 188, 44,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 115, 0,   0,   4,   221, 255, 255, 255, 166, 9,
     0,   0,   162, 255, 255, 255, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  91,  113, 115,
     90,  34,  0,   0,   179, 255, 255, 255, 17,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  118, 185, 225, 245, 245, 224, 184, 117, 27,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  255, 255,
     255, 173, 0,   20,  255, 255, 255, 255, 255, 255, 236, 92,  226, 255, 255, 255, 255, 255, 255, 255, 254, 137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   4,   130, 252, 255, 255, 190, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   168, 255, 255, 255, 52,  0,   0,   0,   105, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 252, 3,   0,   0,   0,   0,   0,   0,   0,   0,
     216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   13,  151, 249, 255, 255, 255, 255, 255, 255, 255, 255, 248, 146, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  255, 255, 255, 167, 0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   39,  203, 255, 255, 248, 115, 1,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   149,
     255, 255, 255, 52,  0,   0,   0,   86,  255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  11,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   12,  249, 255, 255, 223, 0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 210, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   57,  255, 255, 255, 154, 0,   9,   124, 124, 124, 235, 255, 255, 255, 255, 255, 255, 219, 160, 131, 137, 209, 255, 255, 255, 239, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 1,   108, 246, 255, 255, 210, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255,
     255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 115, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   246, 236, 131, 43,  0,   0,   0,   0,   0,   0,   2,   141, 255, 255, 255, 151, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   21,  221, 255, 255, 255, 255, 235, 168, 135, 135, 168, 236, 255, 255, 255, 255, 213, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 130, 0,   0,   0,   0,   0,   216, 255, 255, 255, 255,
     190, 58,  0,   0,   0,   0,   5,   206, 255, 255, 255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 130, 185, 255, 255, 253, 140,
     7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248,
     0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   65,  255, 255, 255, 255, 221, 170, 138, 127, 133, 158, 222, 255, 255, 255, 248, 42,  0,   0,   0,   0,   0,   9,   124, 124, 124, 235, 255, 255, 245, 124, 124, 124, 15,  0,   63,  124, 124,
     167, 255, 255, 255, 181, 124, 124, 85,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 255, 251, 120, 8,   0,   0,
     0,   0,   9,   125, 252, 255, 255, 255, 161, 0,   0,   212, 255, 255, 255, 255, 255, 255, 32,  0,   68,  156, 213, 243, 249, 226, 182, 104, 10,  0,   0,   0,   0,   0,   0,   0,   4,   15,  0,
     0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 89,  0,   0,   0,   0,   0,   216, 255, 255, 250, 93,  0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 93,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 234, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 116,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 101,
     0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   216,
     255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 253, 81,  0,   0,   0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 253, 44,  0,   212, 255, 255, 255, 255, 255,
     255, 86,  201, 255, 255, 255, 255, 255, 255, 255, 255, 228, 82,  0,   0,   0,   0,   0,   0,   57,  233, 104, 10,  0,   0,   0,   0,   0,   87,  253, 255, 255, 249, 17,  0,   0,   0,   0,   0,
     216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255,
     255, 255, 255, 255, 226, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   204, 255, 255, 248, 0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   16,  109, 206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 78,  0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     32,  0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 155,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 134, 0,   212, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 119, 0,   0,   0,
     0,   0,   120, 255, 255, 242, 175, 136, 128, 147, 205, 255, 255, 255, 255, 157, 0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 111,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 251, 141, 242, 255, 255, 255, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,
     80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  107, 175, 216, 241, 252, 247, 229,
     183, 113, 13,  0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,
     0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  255, 255, 255, 202, 0,   102,
     124, 124, 212, 255, 255, 255, 255, 255, 255, 241, 170, 133, 139, 185, 250, 255, 255, 255, 255, 95,  0,   0,   0,   0,   183, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 16,  0,
     0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     92,  255, 255, 255, 118, 0,   56,  240, 255, 255, 255, 221, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 172, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     245, 255, 255, 245, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   254, 255, 255, 232, 0,   0,   0,   0,   172, 255, 255, 255, 255, 255, 158, 17,  0,   0,   0,   0,   36,  197, 255,
     255, 255, 247, 32,  0,   0,   0,   127, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 21,  0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,
     84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   52,  238, 255, 255, 255, 219, 26,  0,   0,   0,
     0,   0,   0,   0,   0,   5,   124, 124, 124, 124, 124, 124, 136, 255, 255, 255, 212, 124, 124, 124, 124, 124, 124, 38,  0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   144, 255, 255,
     255, 52,  0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   11,  104, 183, 226, 249, 243, 213, 156, 66,  0,   32,  255, 255, 255, 255, 255, 255, 212, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  123, 67,  14,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   6,   255, 255, 255, 229, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   241,
     255, 255, 250, 0,   0,   0,   0,   172, 255, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   8,   203, 255, 255, 255, 159, 0,   0,   0,   0,   10,  86,  158, 212, 243, 252, 239, 214, 155,
     70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   49,  236, 255, 255, 255, 216, 24,  0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   204, 255, 255, 248, 0,   0,   0,   0,   144, 255, 255, 255, 52,  0,   0,   0,   80,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,
     84,  229, 255, 255, 255, 255, 255, 255, 255, 255, 197, 79,  255, 255, 255, 255, 255, 255, 212, 0,   144, 255, 255, 255, 255, 255, 255, 255, 244, 0,   0,   0,   58,  152, 213, 243, 255, 254, 137,
     0,   0,   0,   0,   0,   3,   76,  159, 210, 238, 252, 247, 221, 163, 89,  65,  255, 255, 253, 81,  0,   0,   0,   0,   89,  124, 124, 124, 124, 124, 124, 235, 255, 255, 245, 124, 124, 124, 124,
     124, 124, 89,  0,   0,   245, 255, 255, 246, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   254, 255, 255, 233, 0,   0,   0,   0,   172, 255, 255, 255, 227, 7,   0,   0,   0,   0,
     0,   0,   0,   0,   42,  253, 255, 255, 246, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,
     0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 104, 0,   0,   0,   0,   45,  233, 255,
     255, 255, 214, 22,  0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   19,  124, 124, 229, 255, 255, 251, 124, 124,
     94,  0,   144, 255, 255, 255, 150, 124, 56,  0,   80,  255, 255, 255, 183, 124, 25,  0,   0,   0,   0,   123, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255,
     255, 212, 0,   144, 255, 255, 255, 255, 255, 255, 255, 244, 0,   28,  178, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   53,  210, 255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 255,
     255, 255, 43,  0,   0,   0,   0,   184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   216, 255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   60,  255, 255, 255, 204, 0,   0,   0,   0,   172, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   73,  124, 124, 171, 255, 255, 255, 104, 0,   0,   0,   25,  124, 165, 255, 255, 255, 255, 212, 124, 124, 124, 25,  0,   0,   12,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 196, 0,   144, 255, 255, 255, 255, 255, 116, 0,   80,  255, 255, 255, 255, 255, 52,
     0,   0,   0,   99,  255, 255, 255, 255, 250, 186, 139, 133, 170, 240, 255, 255, 255, 255, 255, 255, 208, 124, 124, 102, 0,   144, 255, 255, 255, 255, 255, 255, 255, 244, 47,  234, 255, 255, 255,
     255, 255, 255, 255, 144, 0,   0,   0,   61,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 3,   0,   0,   0,   0,   184, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   147, 255, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   169, 255, 255, 255, 135, 0,   0,   0,   0,   172, 255, 255, 255, 74,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255,
     255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 104, 0,   0,
     0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255,
     255, 255, 255, 255, 255, 196, 0,   144, 255, 255, 255, 255, 255, 116, 0,   80,  255, 255, 255, 255, 255, 52,  0,   0,   35,  248, 255, 255, 255, 198, 37,  0,   0,   0,   0,   16,  158, 255, 255,
     255, 255, 255, 164, 0,   0,   0,   0,   69,  124, 124, 124, 124, 231, 255, 255, 251, 238, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   4,   224, 255, 255, 255, 255, 199, 149, 128, 135,
     163, 223, 255, 255, 255, 255, 231, 0,   0,   0,   0,   0,   184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   54,  255, 255, 255, 254, 84,  0,
     0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 253, 45,  0,   0,   0,   0,   172, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 118, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 112, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 104, 0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,
     196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 255, 255, 255, 196, 0,   144, 255, 255, 255, 255, 255, 116, 0,   80,  255,
     255, 255, 255, 255, 52,  0,   0,   162, 255, 255, 255, 202, 8,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255,
     255, 255, 255, 207, 101, 34,  1,   10,  38,  34,  0,   0,   68,  255, 255, 255, 231, 49,  0,   0,   0,   0,   0,   1,   98,  252, 255, 255, 255, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 255, 251, 121, 8,   0,   0,   0,   0,   9,   126, 253, 255, 255, 255, 162, 0,   0,   0,   0,   0,
     172, 255, 255, 255, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,
     124, 124, 124, 235, 255, 255, 245, 124, 124, 124, 15,  0,   63,  124, 124, 167, 255, 255, 255, 181, 124, 124, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255,
     255, 255, 104, 0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   247, 255, 255, 253, 41,  0,   0,   0,   0,   0,
     0,   0,   0,   7,   228, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 240, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 136,
     0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,
     218, 255, 255, 255, 255, 235, 167, 134, 134, 168, 236, 255, 255, 255, 255, 214, 16,  0,   0,   0,   0,   0,   172, 255, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255,
     255, 255, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   132, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   204, 255, 255, 255,
     255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 190, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   208, 255, 255, 255, 224, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 199, 9,   0,   0,   0,   0,   0,   0,   0,   93,  220, 176, 132, 36,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  212, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 210, 31,  0,
     0,   0,   0,   0,   0,   172, 255, 255, 255, 227, 7,   0,   0,   0,   0,   0,   0,   0,   0,   39,  253, 255, 255, 246, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 134, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   75,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 251, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     34,  255, 255, 255, 255, 235, 172, 128, 96,  68,  42,  17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   11,  148, 248, 255, 255, 255, 255, 255, 255, 255, 255, 249, 148, 10,  0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,
     0,   7,   199, 255, 255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 32,  0,
     132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,
     0,   204, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 164, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 226, 177, 100, 16,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  117, 185, 226, 246, 246, 226, 186, 118,
     28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 255, 255, 158, 16,  0,   0,   0,   0,   34,  195, 255, 255, 255, 248, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  124, 124, 140, 255, 255, 255, 152, 0,   0,   0,   0,   0,   98,  124, 124, 208, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   102,
     255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   4,   136, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 249, 139, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 255, 255, 255,
     241, 169, 133, 137, 183, 250, 255, 255, 255, 255, 94,  0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   236, 255, 255, 255, 255, 255, 255, 255, 255, 216, 0,
     0,   228, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   60,  255, 255, 255, 194, 124, 124, 124, 124, 124, 124, 175,
     255, 255, 255, 255, 217, 20,  0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   71,  255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255,
     255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  134, 210, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 128, 0,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 114, 0,   0,   0,   0,   216, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   236, 255, 255, 255, 255, 255, 255, 255, 255, 216, 0,   0,   228, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0,   12,  255, 255, 255, 255,
     255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   60,  255, 255, 255, 136, 0,   0,   0,   0,   0,   38,  235, 255, 255, 255, 230, 32,  0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,
     0,   0,   0,   0,   10,  247, 255, 255, 253, 41,  0,   0,   0,   0,   0,   0,   0,   0,   6,   226, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   40,  76,  93,  0,   0,   20,  57,  80,  90,  96,  106, 131, 206, 255, 255, 255, 234, 2,   0,   20,  255, 255, 255, 255, 255, 255, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 255, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255,
     255, 255, 105, 220, 255, 255, 255, 255, 255, 255, 255, 255, 220, 72,  0,   0,   0,   0,   0,   216, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   236, 255, 255, 255, 255, 255,
     255, 255, 255, 216, 0,   0,   228, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0,   12,  255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   60,  255, 255, 255, 136, 0,   0,
     0,   0,   25,  223, 255, 255, 255, 240, 46,  0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   32,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 255, 201, 8,   0,   0,   0,   0,   0,   0,
     0,   147, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   197, 255, 255, 248, 10,  0,   0,
     0,   0,   0,   0,   0,   0,   4,   229, 255, 255, 255, 24,  0,   20,  255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 255, 255, 255, 255, 255, 32,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 32,  7,   98,  177, 229, 249, 245, 222, 170, 91,  5,   0,   0,   0,   0,
     0,   0,   104, 124, 124, 186, 255, 255, 255, 217, 124, 124, 25,  0,   0,   0,   114, 124, 180, 255, 255, 255, 213, 124, 124, 104, 0,   0,   110, 124, 124, 225, 255, 255, 255, 255, 171, 93,  0,
     5,   124, 210, 255, 255, 255, 255, 190, 124, 124, 79,  0,   0,   0,   0,   60,  255, 255, 255, 136, 0,   0,   0,   14,  208, 255, 255, 255, 248, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     98,  124, 124, 225, 255, 255, 255, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255,
     255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   34,  249, 255, 255, 255, 198, 36,  0,   0,   0,   0,   15,  155, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208,
     255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   1,   224, 255, 255, 255, 27,  0,   9,   124, 141, 255,
     255, 255, 228, 124, 124, 69,  0,   84,  248, 248, 176, 0,   13,  124, 124, 185, 255, 255, 255, 178, 124, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   172, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  253, 255, 255, 247, 20,  0,   0,   0,   0,   0,   0,
     0,   197, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   36,  230, 255, 255, 255, 235, 43,  0,   0,   96,  254, 255, 255, 255, 192, 9,   0,   0,   0,   0,   0,   0,   0,   8,   36,
     36,  36,  19,  0,   0,   6,   190, 255, 255, 255, 253, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 255, 250,
     185, 137, 133, 168, 240, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255,
     255, 255, 247, 94,  1,   0,   0,   0,   0,   0,   13,  150, 255, 255, 255, 234, 2,   0,   0,   0,   1,   233, 255, 255, 247, 9,   0,   0,   0,   167, 255, 255, 248, 13,  0,   0,   0,   173, 255,
     255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 222, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  234,
     255, 255, 255, 231, 38,  86,  252, 255, 255, 255, 202, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   168, 255, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 164, 0,   0,   0,   0,   94,
     124, 124, 124, 124, 231, 255, 255, 249, 124, 124, 124, 124, 124, 124, 124, 48,  0,   0,   0,   0,   107, 255, 255, 255, 255, 255, 226, 165, 135, 128, 147, 179, 247, 255, 255, 255, 255, 126, 0,
     0,   0,   0,   0,   162, 255, 255, 255, 72,  0,   0,   6,   241, 255, 255, 255, 86,  0,   0,   4,   240, 255, 255, 234, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 255, 233, 7,
     0,   0,   0,   0,   0,   172, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  238, 255, 255, 255, 232, 250, 255, 255, 255, 211, 18,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   75,  221, 255, 255, 255, 255, 255, 255, 255, 255, 219, 100, 255, 255, 255, 164, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,
     0,   0,   0,   160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 182, 4,   0,   0,   0,   0,   0,   89,  255, 255, 255, 144, 0,   0,   72,  255, 255, 255, 255, 166,
     0,   0,   60,  255, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 124, 124, 212, 255, 255, 255, 140, 124, 124, 124, 124,
     124, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 99,  0,   0,   0,   0,   34,  253, 255, 255, 238, 11,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   54,  242, 255, 255, 255, 255, 255, 255, 220, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 255, 156, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  255, 255, 255, 155, 0,
     0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   92,  170, 222, 245, 249, 229, 176, 88,  6,   32,  255, 255, 255, 164,
     0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   220, 255, 255, 244, 215, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     247, 130, 4,   0,   0,   0,   0,   0,   0,   19,  253, 255, 255, 215, 0,   0,   153, 255, 255, 255, 255, 240, 5,   0,   132, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     76,  255, 255, 255, 212, 0,   0,   0,   0,   147, 255, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  245, 255, 255, 255, 255, 227, 31,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 255, 178, 3,   0,   0,   10,  52,  52,  52,  29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 32,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 100, 0,   0,   0,   8,   183, 216, 246, 211, 3,   83,  163, 218, 246, 254, 245, 226, 181, 113, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 255, 31,  2,   232,
     255, 255, 255, 255, 255, 70,  0,   204, 255, 255, 254, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   213, 255, 255, 255, 72,  0,   0,   17,  244, 255, 255, 249, 24,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  240, 255, 255, 255, 255, 208, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  251, 255, 255, 255, 198,
     9,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,
     254, 255, 255, 230, 2,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 103, 59,  255, 255, 255, 255, 255, 255, 151, 21,  254, 255, 255, 207, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 187, 0,   0,   121, 255, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  235, 255, 255, 255, 255, 255,
     255, 199, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  244, 255, 255, 255, 214, 18,  0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   195, 255, 255, 255, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   217, 255, 255, 255, 114, 0,   0,   0,   0,   26,  165, 255, 255, 255, 255, 255, 32,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   62,
     105, 121, 120, 22,  0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  255,
     255, 255, 174, 139, 255, 255, 255, 255, 255, 255, 229, 92,  255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   230, 255, 255, 255, 46,  6,   230, 255, 255, 254,
     43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  229, 255, 255, 255, 244, 253, 255, 255, 255, 192, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  234, 255,
     255, 255, 228, 29,  0,   0,   0,   0,   0,   52,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  134,
     0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 192, 134, 133, 181, 250, 255, 255, 255, 255, 255, 255, 140, 124, 124, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,
     124, 124, 124, 124, 124, 140, 255, 255, 255, 208, 124, 124, 108, 0,   0,   0,   0,   0,   2,   115, 234, 255, 255, 255, 255, 52,  0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  12,  0,   0,   0,   0,   0,   0,   0,   2,   235, 255, 255, 241, 221, 255, 255, 245, 179, 255, 255, 255, 213, 255, 255, 255, 65,  0,
     0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 136, 0,   0,   0,   0,   212, 255, 255, 255, 255, 255, 255, 255, 255, 44,  0,   25,  124, 121, 105, 64,  8,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 160, 96,  255, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  223, 255, 255,
     255, 246, 62,  101, 254, 255, 255, 255, 184, 6,   0,   0,   0,   0,   0,   0,   0,   0,   24,  222, 255, 255, 255, 255, 167, 124, 124, 124, 124, 124, 124, 150, 255, 255, 255, 144, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   181, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   32,  164, 254, 196, 0,   0,   0,   0,   0,   9,   214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   0,
     1,   165, 255, 255, 255, 255, 255, 255, 52,  0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   21,  151, 230, 250, 224, 162, 81,  6,   0,   0,   0,   0,   46,  246, 194, 11,  0,   0,   0,
     0,   0,   0,   0,   165, 255, 255, 255, 255, 255, 255, 175, 90,  255, 255, 255, 255, 255, 255, 243, 6,   0,   0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 136, 0,   0,   0,
     0,   212, 255, 255, 255, 255, 255, 255, 255, 255, 44,  0,   52,  255, 255, 255, 255, 237, 120, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  242, 255, 255, 249,
     219, 255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  216, 255, 255, 255, 249, 72,  0,   0,   109, 255, 255, 255, 255, 175, 4,   0,   0,   0,   0,   0,   0,
     0,   147, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 154, 0,   0,   0,   0,   0,   43,
     144, 248, 255, 255, 196, 0,   0,   0,   0,   0,   0,   23,  195, 255, 255, 255, 255, 255, 255, 255, 255, 191, 184, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   0,   95,  255, 255, 255, 255, 255, 255, 255, 52,  0,   32,  255, 255, 255, 255, 28,  0,
     0,   0,   23,  221, 255, 255, 255, 255, 255, 255, 235, 144, 56,  8,   55,  226, 255, 255, 191, 6,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 94,  16,  251, 255, 255, 255,
     255, 255, 178, 0,   0,   0,   0,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 136, 0,   0,   0,   0,   212, 255, 255, 255, 255, 255, 255, 255, 255, 44,  0,   52,  255, 255, 255, 255,
     255, 255, 171, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 255, 255, 255, 205, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,
     208, 255, 255, 255, 252, 82,  0,   0,   0,   0,   119, 255, 255, 255, 255, 167, 2,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 255, 194, 134, 136, 165, 211, 255, 255, 255, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   1,   82,  171, 226, 248,
     244, 216, 159, 66,  0,   152, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     224, 0,   0,   0,   0,   200, 255, 255, 255, 155, 46,  15,  4,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   6,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 186, 0,   0,   0,   0,   0,   0,   0,   21,  254, 255, 255, 255, 255, 251, 18,  0,   188, 255, 255, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   118, 124, 124, 242, 255, 255, 255, 164,
     124, 65,  0,   0,   0,   0,   102, 124, 212, 255, 255, 255, 166, 124, 124, 21,  0,   52,  255, 255, 255, 255, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   28,  250, 255, 255, 255, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  124, 124, 203, 255, 255, 255, 255, 201, 124, 48,  0,   0,   65,  124, 220, 255, 255, 255, 255, 175,
     124, 124, 63,  0,   0,   0,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 166, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   249, 255, 255, 247, 4,   0,   0,   0,   0,   0,   32,  255,
     255, 255, 255, 28,  0,   0,   136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 214, 17,  0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 189, 0,
     0,   109, 255, 255, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   20,  245, 255, 255, 231, 9,   0,   0,   0,   0,
     0,   4,   16,  47,  161, 255, 255, 255, 197, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 255, 225, 4,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   137, 252, 255, 255, 255, 255, 255, 255, 255, 255, 180, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   255, 255, 255, 233, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   4,   217, 255, 255, 239, 71,  7,   30,  100, 199, 255, 255,
     255, 255, 255, 255, 230, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 255, 109, 0,   0,   31,  255, 255, 255, 255, 221, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     14,  236, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   250, 255, 255, 245, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   45,  255, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   136, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   42,  140, 208, 238, 248, 225, 194, 122, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   239, 255, 255, 253, 5,   0,   0,
     0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   32,  227, 254, 76,  0,   0,   0,   0,   0,   43,  143, 219, 250, 237, 168, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255,
     255, 255, 255, 29,  0,   0,   0,   207, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 187, 0,   0,   0,   0,   0,   16,  241, 255, 255, 231, 9,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   237, 255, 255, 254, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 240, 13,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 54,  0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   39,  138, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   237, 255, 255, 204, 0,   0,   0,   0,   128, 255, 255, 255, 79,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   9,   230, 255, 255, 255, 63,  0,   0,   0,   0,   126, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   254, 255, 255, 235, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255,
     255, 255, 109, 0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 196, 0,   0,   0,   12,  237,
     255, 255, 231, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  255, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 157, 0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   222, 255, 255, 255, 73,  0,   0,   118, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255,
     255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   52,  255, 255, 255, 187, 0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255,
     204, 0,   9,   232, 255, 255, 231, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 193, 0,   0,   0,   0,   0,   32,  255, 255, 255,
     255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   214, 255, 255, 255, 82,  110, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   179, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   10,  49,  188, 255, 255, 255, 148, 0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   83,  255, 255, 255, 212, 227, 255, 255, 231, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   185, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 246, 36,  0,   0,   0,   0,
     0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   205, 255, 255, 255, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 195, 62,  19,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 230, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  248, 255, 255, 255, 255, 255, 112, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 176,
     0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255, 255, 111, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  135, 178, 252, 255, 255, 255, 76,  0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 230, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   184, 255, 255, 255,
     255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   117, 255, 255, 255, 148, 0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255,
     255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 255, 255, 208, 151, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 165, 0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  249, 255, 255, 230, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     167, 255, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 146, 0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   138, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 107, 0,   0,   0,   0,   0,   32,
     255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  241, 255, 255, 229, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   168, 255, 255, 255, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 59,  0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   231, 255, 255, 255, 14,  0,
     0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 255, 255, 255, 255, 255, 229, 8,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   253, 255, 255, 240, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   8,   255, 255, 255, 255, 255, 255, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   251, 255, 255, 239, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   255,
     255, 255, 233, 0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   124, 124, 124, 124, 124, 124, 124, 124, 123, 8,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   221, 255, 255, 255, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   231, 255, 255, 255, 46,  0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   207,
     255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   156, 255, 255, 255, 240, 168, 136, 126, 25,  0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  247, 255, 255, 250, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  242, 255, 255, 255, 255, 255, 255, 52,  0,   32,  255, 255,
     255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,
     126, 136, 165, 235, 255, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  234, 255, 255, 255, 255, 255, 52,  0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 255, 249, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  123, 198, 238, 253, 252,
     49,  0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   52,  255, 255, 255, 255, 255, 240, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  252, 253, 239, 200, 129, 25,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
    40.000000f, 39.279999f, 5.999998f, 26.440001f, -6.840000f, 96, {{L'\0', 0, 0, 0, 0, 0.000000f, 0.000000f, 0.011719f, 0.011719f, 0.015625f, 0.015625f, 0, {}},
                                                                    {L' ', 0, 0, 0, 0, 24.000000f, 0.000000f, 0.023438f, 0.003906f, 0.023438f, 0.003906f, 0, {}},
                                                                    {L'!', 6, 24, 9, 24, 24.000000f, 0.000000f, 0.027344f, 0.003906f, 0.050781f, 0.097656f, 0, {}},
                                                                    {L'"', 14, 13, 5, 24, 24.000000f, 0.000000f, 0.054688f, 0.003906f, 0.109375f, 0.054688f, 0, {}},
                                                                    {L'#', 20, 30, 2, 26, 24.000000f, 0.000000f, 0.113281f, 0.003906f, 0.191406f, 0.121094f, 0, {}},
                                                                    {L'$', 18, 33, 3, 28, 24.000000f, 0.000000f, 0.195312f, 0.003906f, 0.265625f, 0.132812f, 0, {}},
                                                                    {L'%', 24, 28, 0, 27, 24.000000f, 0.000000f, 0.269531f, 0.003906f, 0.363281f, 0.113281f, 0, {}},
                                                                    {L'&', 21, 23, 2, 23, 24.000000f, 0.000000f, 0.367188f, 0.003906f, 0.449219f, 0.093750f, 0, {}},
                                                                    {L'\'', 8, 13, 8, 24, 24.000000f, 0.000000f, 0.453125f, 0.003906f, 0.484375f, 0.054688f, 0, {}},
                                                                    {L'(', 10, 31, 10, 27, 24.000000f, 0.000000f, 0.488281f, 0.003906f, 0.527344f, 0.125000f, 0, {}},
                                                                    {L')', 10, 31, 4, 27, 24.000000f, 0.000000f, 0.531250f, 0.003906f, 0.570312f, 0.125000f, 0, {}},
                                                                    {L'*', 18, 16, 3, 24, 24.000000f, 0.000000f, 0.574219f, 0.003906f, 0.644531f, 0.066406f, 0, {}},
                                                                    {L'+', 18, 16, 3, 20, 24.000000f, 0.000000f, 0.648438f, 0.003906f, 0.718750f, 0.066406f, 0, {}},
                                                                    {L',', 10, 11, 6, 7, 24.000000f, 0.000000f, 0.722656f, 0.003906f, 0.761719f, 0.046875f, 0, {}},
                                                                    {L'-', 12, 4, 6, 14, 24.000000f, 0.000000f, 0.765625f, 0.003906f, 0.812500f, 0.019531f, 0, {}},
                                                                    {L'.', 6, 7, 9, 7, 24.000000f, 0.000000f, 0.816406f, 0.003906f, 0.839844f, 0.031250f, 0, {}},
                                                                    {L'/', 20, 32, 2, 28, 24.000000f, 0.000000f, 0.843750f, 0.003906f, 0.921875f, 0.128906f, 0, {}},
                                                                    {L'0', 18, 24, 3, 24, 24.000000f, 0.000000f, 0.765625f, 0.035156f, 0.835938f, 0.128906f, 0, {}},
                                                                    {L'1', 18, 24, 3, 24, 24.000000f, 0.000000f, 0.574219f, 0.070312f, 0.644531f, 0.164062f, 0, {}},
                                                                    {L'2', 18, 24, 2, 24, 24.000000f, 0.000000f, 0.648438f, 0.070312f, 0.718750f, 0.164062f, 0, {}},
                                                                    {L'3', 18, 24, 3, 24, 24.000000f, 0.000000f, 0.367188f, 0.097656f, 0.437500f, 0.191406f, 0, {}},
                                                                    {L'4', 18, 24, 2, 24, 24.000000f, 0.000000f, 0.023438f, 0.101562f, 0.093750f, 0.195312f, 0, {}},
                                                                    {L'5', 19, 24, 2, 24, 24.000000f, 0.000000f, 0.269531f, 0.117188f, 0.343750f, 0.210938f, 0, {}},
                                                                    {L'6', 18, 25, 3, 25, 24.000000f, 0.000000f, 0.097656f, 0.125000f, 0.167969f, 0.222656f, 0, {}},
                                                                    {L'7', 18, 24, 3, 24, 24.000000f, 0.000000f, 0.441406f, 0.128906f, 0.511719f, 0.222656f, 0, {}},
                                                                    {L'8', 18, 24, 3, 24, 24.000000f, 0.000000f, 0.839844f, 0.132812f, 0.910156f, 0.226562f, 0, {}},
                                                                    {L'9', 18, 24, 3, 24, 24.000000f, 0.000000f, 0.914062f, 0.132812f, 0.984375f, 0.226562f, 0, {}},
                                                                    {L':', 6, 17, 9, 17, 24.000000f, 0.000000f, 0.722656f, 0.050781f, 0.746094f, 0.117188f, 0, {}},
                                                                    {L';', 10, 23, 6, 19, 24.000000f, 0.000000f, 0.722656f, 0.121094f, 0.761719f, 0.210938f, 0, {}},
                                                                    {L'<', 17, 25, 4, 24, 24.000000f, 0.000000f, 0.765625f, 0.132812f, 0.832031f, 0.230469f, 0, {}},
                                                                    {L'=', 18, 10, 3, 17, 24.000000f, 0.000000f, 0.171875f, 0.136719f, 0.242188f, 0.175781f, 0, {}},
                                                                    {L'>', 17, 25, 3, 24, 24.000000f, 0.000000f, 0.515625f, 0.167969f, 0.582031f, 0.265625f, 0, {}},
                                                                    {L'?', 16, 24, 4, 24, 24.000000f, 0.000000f, 0.585938f, 0.167969f, 0.648438f, 0.261719f, 0, {}},
                                                                    {L'@', 24, 24, 0, 24, 24.000000f, 0.000000f, 0.171875f, 0.179688f, 0.265625f, 0.273438f, 0, {}},
                                                                    {L'A', 26, 24, -1, 24, 24.000000f, 0.000000f, 0.652344f, 0.214844f, 0.753906f, 0.308594f, 0, {}},
                                                                    {L'B', 22, 24, 1, 24, 24.000000f, 0.000000f, 0.347656f, 0.195312f, 0.433594f, 0.289062f, 0, {}},
                                                                    {L'C', 23, 24, 1, 24, 24.000000f, 0.000000f, 0.003906f, 0.199219f, 0.093750f, 0.292969f, 0, {}},
                                                                    {L'D', 23, 24, 0, 24, 24.000000f, 0.000000f, 0.835938f, 0.230469f, 0.925781f, 0.324219f, 0, {}},
                                                                    {L'E', 22, 24, 1, 24, 24.000000f, 0.000000f, 0.437500f, 0.269531f, 0.523438f, 0.363281f, 0, {}},
                                                                    {L'F', 21, 24, 2, 24, 24.000000f, 0.000000f, 0.527344f, 0.269531f, 0.609375f, 0.363281f, 0, {}},
                                                                    {L'G', 24, 24, 0, 24, 24.000000f, 0.000000f, 0.097656f, 0.277344f, 0.191406f, 0.371094f, 0, {}},
                                                                    {L'H', 22, 24, 1, 24, 24.000000f, 0.000000f, 0.195312f, 0.277344f, 0.281250f, 0.371094f, 0, {}},
                                                                    {L'I', 18, 24, 3, 24, 24.000000f, 0.000000f, 0.757812f, 0.234375f, 0.828125f, 0.328125f, 0, {}},
                                                                    {L'J', 23, 24, 1, 24, 24.000000f, 0.000000f, 0.285156f, 0.292969f, 0.375000f, 0.386719f, 0, {}},
                                                                    {L'K', 24, 24, 0, 24, 24.000000f, 0.000000f, 0.613281f, 0.312500f, 0.707031f, 0.406250f, 0, {}},
                                                                    {L'L', 22, 24, 1, 24, 24.000000f, 0.000000f, 0.003906f, 0.296875f, 0.089844f, 0.390625f, 0, {}},
                                                                    {L'M', 26, 24, -1, 24, 24.000000f, 0.000000f, 0.832031f, 0.328125f, 0.933594f, 0.421875f, 0, {}},
                                                                    {L'N', 25, 24, 0, 24, 24.000000f, 0.000000f, 0.710938f, 0.332031f, 0.808594f, 0.425781f, 0, {}},
                                                                    {L'O', 22, 24, 1, 24, 24.000000f, 0.000000f, 0.378906f, 0.367188f, 0.464844f, 0.460938f, 0, {}},
                                                                    {L'P', 21, 24, 2, 24, 24.000000f, 0.000000f, 0.468750f, 0.367188f, 0.550781f, 0.460938f, 0, {}},
                                                                    {L'Q', 23, 30, 2, 24, 24.000000f, 0.000000f, 0.093750f, 0.375000f, 0.183594f, 0.492188f, 0, {}},
                                                                    {L'R', 23, 24, 1, 24, 24.000000f, 0.000000f, 0.187500f, 0.375000f, 0.277344f, 0.468750f, 0, {}},
                                                                    {L'S', 21, 26, 1, 25, 24.000000f, 0.000000f, 0.281250f, 0.390625f, 0.363281f, 0.492188f, 0, {}},
                                                                    {L'T', 22, 24, 1, 24, 24.000000f, 0.000000f, 0.003906f, 0.394531f, 0.089844f, 0.488281f, 0, {}},
                                                                    {L'U', 24, 24, 0, 24, 24.000000f, 0.000000f, 0.554688f, 0.410156f, 0.648438f, 0.503906f, 0, {}},
                                                                    {L'V', 26, 24, -1, 24, 24.000000f, 0.000000f, 0.812500f, 0.425781f, 0.914062f, 0.519531f, 0, {}},
                                                                    {L'W', 26, 24, -1, 24, 24.000000f, 0.000000f, 0.652344f, 0.429688f, 0.753906f, 0.523438f, 0, {}},
                                                                    {L'X', 24, 24, 0, 24, 24.000000f, 0.000000f, 0.367188f, 0.464844f, 0.460938f, 0.558594f, 0, {}},
                                                                    {L'Y', 24, 24, 0, 24, 24.000000f, 0.000000f, 0.003906f, 0.496094f, 0.097656f, 0.589844f, 0, {}},
                                                                    {L'Z', 20, 24, 2, 24, 24.000000f, 0.000000f, 0.464844f, 0.464844f, 0.542969f, 0.558594f, 0, {}},
                                                                    {L'[', 10, 31, 11, 27, 24.000000f, 0.000000f, 0.937500f, 0.230469f, 0.976562f, 0.351562f, 0, {}},
                                                                    {L'\\', 20, 36, 2, 30, 24.000000f, 0.000000f, 0.187500f, 0.472656f, 0.265625f, 0.613281f, 0, {}},
                                                                    {L']', 10, 31, 3, 27, 24.000000f, 0.000000f, 0.937500f, 0.355469f, 0.976562f, 0.476562f, 0, {}},
                                                                    {L'^', 14, 10, 5, 24, 24.000000f, 0.000000f, 0.917969f, 0.480469f, 0.972656f, 0.519531f, 0, {}},
                                                                    {L'_', 28, 4, -2, -6, 24.000000f, 0.000000f, 0.757812f, 0.523438f, 0.867188f, 0.539062f, 0, {}},
                                                                    {L'`', 14, 7, 5, 28, 24.000000f, 0.000000f, 0.269531f, 0.496094f, 0.324219f, 0.523438f, 0, {}},
                                                                    {L'a', 22, 19, 1, 19, 24.000000f, 0.000000f, 0.546875f, 0.507812f, 0.632812f, 0.582031f, 0, {}},
                                                                    {L'b', 23, 26, 0, 26, 24.000000f, 0.000000f, 0.871094f, 0.523438f, 0.960938f, 0.625000f, 0, {}},
                                                                    {L'c', 21, 20, 2, 20, 24.000000f, 0.000000f, 0.101562f, 0.496094f, 0.183594f, 0.574219f, 0, {}},
                                                                    {L'd', 23, 26, 1, 26, 24.000000f, 0.000000f, 0.636719f, 0.527344f, 0.726562f, 0.628906f, 0, {}},
                                                                    {L'e', 21, 19, 1, 19, 24.000000f, 0.000000f, 0.269531f, 0.527344f, 0.351562f, 0.601562f, 0, {}},
                                                                    {L'f', 18, 26, 3, 26, 24.000000f, 0.000000f, 0.730469f, 0.542969f, 0.800781f, 0.644531f, 0, {}},
                                                                    {L'g', 23, 26, 1, 19, 24.000000f, 0.000000f, 0.355469f, 0.562500f, 0.445312f, 0.664062f, 0, {}},
                                                                    {L'h', 24, 26, 0, 26, 24.000000f, 0.000000f, 0.449219f, 0.562500f, 0.542969f, 0.664062f, 0, {}},
                                                                    {L'i', 19, 27, 3, 27, 24.000000f, 0.000000f, 0.101562f, 0.578125f, 0.175781f, 0.683594f, 0, {}},
                                                                    {L'j', 15, 33, 2, 26, 24.000000f, 0.000000f, 0.804688f, 0.542969f, 0.863281f, 0.671875f, 0, {}},
                                                                    {L'k', 23, 26, 1, 26, 24.000000f, 0.000000f, 0.003906f, 0.593750f, 0.093750f, 0.695312f, 0, {}},
                                                                    {L'l', 18, 26, 3, 26, 24.000000f, 0.000000f, 0.546875f, 0.585938f, 0.617188f, 0.687500f, 0, {}},
                                                                    {L'm', 26, 19, -1, 19, 24.000000f, 0.000000f, 0.179688f, 0.617188f, 0.281250f, 0.691406f, 0, {}},
                                                                    {L'n', 24, 19, 0, 19, 24.000000f, 0.000000f, 0.867188f, 0.628906f, 0.960938f, 0.703125f, 0, {}},
                                                                    {L'o', 21, 19, 1, 19, 24.000000f, 0.000000f, 0.621094f, 0.632812f, 0.703125f, 0.707031f, 0, {}},
                                                                    {L'p', 23, 26, 0, 19, 24.000000f, 0.000000f, 0.707031f, 0.648438f, 0.796875f, 0.750000f, 0, {}},
                                                                    {L'q', 23, 26, 1, 19, 24.000000f, 0.000000f, 0.285156f, 0.667969f, 0.375000f, 0.769531f, 0, {}},
                                                                    {L'r', 19, 20, 2, 20, 24.000000f, 0.000000f, 0.378906f, 0.667969f, 0.453125f, 0.746094f, 0, {}},
                                                                    {L's', 20, 21, 2, 20, 24.000000f, 0.000000f, 0.457031f, 0.667969f, 0.535156f, 0.750000f, 0, {}},
                                                                    {L't', 19, 24, 3, 24, 24.000000f, 0.000000f, 0.097656f, 0.687500f, 0.171875f, 0.781250f, 0, {}},
                                                                    {L'u', 24, 19, 0, 19, 24.000000f, 0.000000f, 0.175781f, 0.695312f, 0.269531f, 0.769531f, 0, {}},
                                                                    {L'v', 24, 19, 0, 19, 24.000000f, 0.000000f, 0.800781f, 0.707031f, 0.894531f, 0.781250f, 0, {}},
                                                                    {L'w', 26, 19, -1, 19, 24.000000f, 0.000000f, 0.539062f, 0.710938f, 0.640625f, 0.785156f, 0, {}},
                                                                    {L'x', 24, 19, 0, 19, 24.000000f, 0.000000f, 0.898438f, 0.707031f, 0.992188f, 0.781250f, 0, {}},
                                                                    {L'y', 24, 25, 0, 19, 24.000000f, 0.000000f, 0.644531f, 0.753906f, 0.738281f, 0.851562f, 0, {}},
                                                                    {L'z', 18, 19, 3, 19, 24.000000f, 0.000000f, 0.003906f, 0.699219f, 0.074219f, 0.773438f, 0, {}},
                                                                    {L'{', 12, 31, 8, 27, 24.000000f, 0.000000f, 0.378906f, 0.750000f, 0.425781f, 0.871094f, 0, {}},
                                                                    {L'|', 6, 33, 9, 26, 24.000000f, 0.000000f, 0.429688f, 0.750000f, 0.453125f, 0.878906f, 0, {}},
                                                                    {L'}', 12, 31, 4, 27, 24.000000f, 0.000000f, 0.742188f, 0.753906f, 0.789062f, 0.875000f, 0, {}},
                                                                    {L'~', 20, 8, 2, 16, 24.000000f, 0.000000f, 0.457031f, 0.753906f, 0.535156f, 0.785156f, 0, {}}, }};
#ifdef __cplusplus
}
#endif
