/* automatically generated by float-auto.sh, do not edit! */

#include <tme/common.h>
_TME_RCSID("$Id: float-auto.sh,v 1.2 2007/08/24 00:55:33 fredette Exp $");

/* includes: */
#include <tme/generic/float.h>


/* if possible, this returns a positive or negative infinity
   float, otherwise, this returns the float value
   closest to that infinity: */
float
tme_float_infinity_float(int negative)
{
  static int inf_set_float;
  static float inf_float[2];
  float inf_test;
  int negative_i;

  /* make sure that negative can index the inf_float array: */
  negative = !!negative;

  /* if the float infinities have already been set: */
  if (__tme_predict_true(inf_set_float)) {
    return (inf_float[negative]);
  }

  /* the float infinities will be set now: */
  inf_set_float = TRUE;

  /* set the positive and negative infinities: */
  for (negative_i = 0; negative_i < 2; negative_i++) {

    /* start with the limit maximum positive value or limit minimum
       negative value.  double this value until either it doesn't
       change or it isn't closer to the desired infinity, and then
       use the previous value: */
    inf_test = FLOAT_MAX_FLOAT;
    if (negative_i) {
      inf_test = -inf_test;
    }
    do {
      memcpy((char *) &inf_float[negative_i], (char *) &inf_test, sizeof(inf_test));
      inf_test *= 2;
    } while (memcmp((char *) &inf_float[negative_i], (char *) &inf_test, sizeof(inf_test)) != 0
             && (negative_i
                 ? inf_test < inf_float[negative_i]
                 : inf_test > inf_float[negative_i]));

    /* try to generate the actual infinity by dividing one or negative
       one by zero.  if this value is closer to the desired infinity,
       use it: */
    inf_test = (negative_i ? -1.0 : 1.0) / 0.0;
    if (negative_i
        ? inf_test < inf_float[negative_i]
        : inf_test > inf_float[negative_i]) {
      inf_float[negative_i] = inf_test;
    }
  }

  /* return the desired infinity: */
  return (inf_float[negative]);
}

/* if possible, this returns a negative zero float.
   otherwise, this returns the negative float value closest
   to zero: */
float
tme_float_negative_zero_float(void)
{
  static int nzero_set_float;
  static float nzero_float;
  float constant_pzero;
  float constant_nzero;
  float nzero_test;

  /* if the float negative zero has already been set: */
  if (__tme_predict_true(nzero_set_float)) {
    return (nzero_float);
  }

  /* the float negative zero will be set now: */
  nzero_set_float = TRUE;

  /* make a +0.0 and a -0.0, that we can do bit-for-bit comparisons with.
     NB that sizeof(float) may cover more bits than are actually
     used by a float: */
  memset((char *) &constant_pzero, 0, sizeof(constant_pzero));
  memset((char *) &constant_nzero, 0, sizeof(constant_nzero));
  constant_pzero = +0.0;
  constant_nzero = -0.0;

  /* if -0.0 * -0.0 is bit-for-bit different from -0.0 and is
     bit-for-bit identical to +0.0, use -0.0: */
  memset((char *) &nzero_test, 0, sizeof(nzero_test));
  nzero_test = constant_nzero * constant_nzero;
  if (memcmp((char *) &constant_nzero, (char *) &nzero_test, sizeof(nzero_test)) != 0
      && memcmp((char *) &constant_pzero, (char *) &nzero_test, sizeof(nzero_test)) == 0) {
    return (nzero_float = constant_nzero);
  }

  /* otherwise, start with the limit maximum negative value (which is
     zero minus the limit minimum positive value).  halve this value
     until either it doesn't change or it becomes positive zero, and
     then use the previous value: */
  nzero_test = 0 - FLOAT_MIN_FLOAT;
  do {
    memcpy((char *) &nzero_float, (char *) &nzero_test, sizeof(nzero_test));
    nzero_test = nzero_test / 2;
  } while (memcmp((char *) &nzero_float, (char *) &nzero_test, sizeof(nzero_test)) != 0
	   && memcmp((char *) &constant_pzero, (char *) &nzero_test, sizeof(nzero_test)) != 0);
  return (nzero_float);
}

/* a series of float values of the form 2^x, where x is a power of two: */
static const float _tme_float_radix2_exponent_bits_float_pos[] = {

  /* 2^1: */
  (1 * ((float) ((tme_uint32_t) 2))),

  /* 2^2: */
  (1 * ((float) ((tme_uint32_t) 4))),

  /* 2^4: */
  (1 * ((float) ((tme_uint32_t) 16))),

  /* 2^8: */
  (1 * ((float) ((tme_uint32_t) 256))),

  /* 2^16: */
  (1 * ((float) ((tme_uint32_t) 65536))),

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 2^32: */
  ((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 256))),

  /* 2^64: */
  (((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 65536))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 2^128: */
  ((((((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 256))),

  /* 2^256: */
  (((((((((((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 65536))),

  /* 2^512: */
  ((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 2^1024: */
  (((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 65536))),

  /* 2^2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 256))),

  /* 2^4096: */
  (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 65536))),

  /* 2^8192: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 16777216))) * ((float) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* a series of float values of the form 2^-x, where x is a power of two: */
static const float _tme_float_radix2_exponent_bits_float_neg[] = {

  /* 2^-1: */
  (1 / ((float) ((tme_uint32_t) 2))),

  /* 2^-2: */
  (1 / ((float) ((tme_uint32_t) 4))),

  /* 2^-4: */
  (1 / ((float) ((tme_uint32_t) 16))),

  /* 2^-8: */
  (1 / ((float) ((tme_uint32_t) 256))),

  /* 2^-16: */
  (1 / ((float) ((tme_uint32_t) 65536))),

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 2^-32: */
  ((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 256))),

  /* 2^-64: */
  (((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 65536))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 2^-128: */
  ((((((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 256))),

  /* 2^-256: */
  (((((((((((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 65536))),

  /* 2^-512: */
  ((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 2^-1024: */
  (((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 65536))),

  /* 2^-2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 256))),

  /* 2^-4096: */
  (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 65536))),

  /* 2^-8192: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 16777216))) / ((float) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* this returns the radix 2 mantissa and exponent of an in-range float.
   the mantissa is either zero, or in the range incl 1 to 2 excl: */
float
tme_float_radix2_mantissa_exponent_float(float value, tme_int32_t *_exponent)
{
  tme_int32_t exponent;
  tme_uint32_t exponent_bit;
  int negate;

  /* start with an exponent of zero: */
  exponent = 0;

  /* if the value is positive or negative zero, return the value: */
  if (value == 0.0
      || -value == 0.0) {
    *_exponent = exponent;
    return (value);
  }

  /* take the magnitude of the value, but remember if it was negative: */
  negate = (value < 0);
  if (negate) {
    value = 0 - value;
  }

  /* while the value is less than one: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_float_neg) - 1;
  for (; value < 1; ) {

    /* if value is less than or equal to 2^-(2^exponent_bit),
       divide value by 2^-(2^exponent_bit), and subtract 2^exponent_bit
       from exponent: */
    if (value <= _tme_float_radix2_exponent_bits_float_neg[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix2_exponent_bits_float_neg[exponent_bit];
      exponent -= (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* while the value is greater than or equal to 2: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_float_pos) - 1;
  for (; value >= 2; ) {

    /* if value is greater than or equal to 2^(2^exponent_bit),
       divide value by 2^(2^exponent_bit), and add 2^exponent_bit
       to exponent: */
    if (value >= _tme_float_radix2_exponent_bits_float_pos[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix2_exponent_bits_float_pos[exponent_bit];
      exponent += (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* done: */
  *_exponent = exponent;
  return (negate ? 0 - value : value);
}

/* this scales a value by adding n to its exponent: */
float
tme_float_radix2_scale_float(float value, tme_int32_t _n)
{
  tme_uint32_t exponent_bit, exponent;
  tme_uint32_t n;

  /* start with the most significant exponent bit: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_float_pos) - 1;
  exponent = (1 << exponent_bit);

  /* if n is negative: */
  if (_n < 0) {

    for (n = 0 - _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value /= _tme_float_radix2_exponent_bits_float_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  /* otherwise, n is positive: */
  else {
    for (n = _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value *= _tme_float_radix2_exponent_bits_float_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  return (value);
}

/* a series of float values of the form 10^x, where x is a power of two: */
static const float _tme_float_radix10_exponent_bits_float_pos[] = {

  /* 10^1: */
  (1 * ((float) ((tme_uint32_t) 10))),

  /* 10^2: */
  (1 * ((float) ((tme_uint32_t) 100))),

  /* 10^4: */
  (1 * ((float) ((tme_uint32_t) 10000))),

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 10^8: */
  ((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

  /* 10^16: */
  ((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 10^32: */
  ((((((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

  /* 10^64: */
  ((((((((((((((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

  /* 10^128: */
  ((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 10^256: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

  /* 10^512: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

  /* 10^1024: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

  /* 10^2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))) * ((float) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* a series of float values of the form 10^-x, where x is a power of two: */
static const float _tme_float_radix10_exponent_bits_float_neg[] = {

  /* 10^-1: */
  (1 / ((float) ((tme_uint32_t) 10))),

  /* 10^-2: */
  (1 / ((float) ((tme_uint32_t) 100))),

  /* 10^-4: */
  (1 / ((float) ((tme_uint32_t) 10000))),

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 10^-8: */
  ((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

  /* 10^-16: */
  ((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 10^-32: */
  ((((((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

  /* 10^-64: */
  ((((((((((((((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

  /* 10^-128: */
  ((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 10^-256: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

  /* 10^-512: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

  /* 10^-1024: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

  /* 10^-2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))) / ((float) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_FLOAT & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* this returns the radix 10 mantissa and exponent of an in-range float.
   the mantissa is either zero, or in the range incl 1 to 10 excl: */
float
tme_float_radix10_mantissa_exponent_float(float value, tme_int32_t *_exponent)
{
  tme_int32_t exponent;
  tme_uint32_t exponent_bit;
  int negate;

  /* start with an exponent of zero: */
  exponent = 0;

  /* if the value is positive or negative zero, return the value: */
  if (value == 0.0
      || -value == 0.0) {
    *_exponent = exponent;
    return (value);
  }

  /* take the magnitude of the value, but remember if it was negative: */
  negate = (value < 0);
  if (negate) {
    value = 0 - value;
  }

  /* while the value is less than one: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_float_neg) - 1;
  for (; value < 1; ) {

    /* if value is less than or equal to 10^-(2^exponent_bit),
       divide value by 10^-(2^exponent_bit), and subtract 2^exponent_bit
       from exponent: */
    if (value <= _tme_float_radix10_exponent_bits_float_neg[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix10_exponent_bits_float_neg[exponent_bit];
      exponent -= (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* while the value is greater than or equal to 10: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_float_pos) - 1;
  for (; value >= 10; ) {

    /* if value is greater than or equal to 10^(2^exponent_bit),
       divide value by 10^(2^exponent_bit), and add 2^exponent_bit
       to exponent: */
    if (value >= _tme_float_radix10_exponent_bits_float_pos[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix10_exponent_bits_float_pos[exponent_bit];
      exponent += (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* done: */
  *_exponent = exponent;
  return (negate ? 0 - value : value);
}

/* this scales a value by adding n to its exponent: */
float
tme_float_radix10_scale_float(float value, tme_int32_t _n)
{
  tme_uint32_t exponent_bit, exponent;
  tme_uint32_t n;

  /* start with the most significant exponent bit: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_float_pos) - 1;
  exponent = (1 << exponent_bit);

  /* if n is negative: */
  if (_n < 0) {

    for (n = 0 - _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value /= _tme_float_radix10_exponent_bits_float_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  /* otherwise, n is positive: */
  else {
    for (n = _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value *= _tme_float_radix10_exponent_bits_float_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  return (value);
}

/* if possible, this returns a positive or negative infinity
   double, otherwise, this returns the double value
   closest to that infinity: */
double
tme_float_infinity_double(int negative)
{
  static int inf_set_double;
  static double inf_double[2];
  double inf_test;
  int negative_i;

  /* make sure that negative can index the inf_double array: */
  negative = !!negative;

  /* if the double infinities have already been set: */
  if (__tme_predict_true(inf_set_double)) {
    return (inf_double[negative]);
  }

  /* the double infinities will be set now: */
  inf_set_double = TRUE;

  /* set the positive and negative infinities: */
  for (negative_i = 0; negative_i < 2; negative_i++) {

    /* start with the limit maximum positive value or limit minimum
       negative value.  double this value until either it doesn't
       change or it isn't closer to the desired infinity, and then
       use the previous value: */
    inf_test = FLOAT_MAX_DOUBLE;
    if (negative_i) {
      inf_test = -inf_test;
    }
    do {
      memcpy((char *) &inf_double[negative_i], (char *) &inf_test, sizeof(inf_test));
      inf_test *= 2;
    } while (memcmp((char *) &inf_double[negative_i], (char *) &inf_test, sizeof(inf_test)) != 0
             && (negative_i
                 ? inf_test < inf_double[negative_i]
                 : inf_test > inf_double[negative_i]));

    /* try to generate the actual infinity by dividing one or negative
       one by zero.  if this value is closer to the desired infinity,
       use it: */
    inf_test = (negative_i ? -1.0 : 1.0) / 0.0;
    if (negative_i
        ? inf_test < inf_double[negative_i]
        : inf_test > inf_double[negative_i]) {
      inf_double[negative_i] = inf_test;
    }
  }

  /* return the desired infinity: */
  return (inf_double[negative]);
}

/* if possible, this returns a negative zero double.
   otherwise, this returns the negative double value closest
   to zero: */
double
tme_float_negative_zero_double(void)
{
  static int nzero_set_double;
  static double nzero_double;
  double constant_pzero;
  double constant_nzero;
  double nzero_test;

  /* if the double negative zero has already been set: */
  if (__tme_predict_true(nzero_set_double)) {
    return (nzero_double);
  }

  /* the double negative zero will be set now: */
  nzero_set_double = TRUE;

  /* make a +0.0 and a -0.0, that we can do bit-for-bit comparisons with.
     NB that sizeof(double) may cover more bits than are actually
     used by a double: */
  memset((char *) &constant_pzero, 0, sizeof(constant_pzero));
  memset((char *) &constant_nzero, 0, sizeof(constant_nzero));
  constant_pzero = +0.0;
  constant_nzero = -0.0;

  /* if -0.0 * -0.0 is bit-for-bit different from -0.0 and is
     bit-for-bit identical to +0.0, use -0.0: */
  memset((char *) &nzero_test, 0, sizeof(nzero_test));
  nzero_test = constant_nzero * constant_nzero;
  if (memcmp((char *) &constant_nzero, (char *) &nzero_test, sizeof(nzero_test)) != 0
      && memcmp((char *) &constant_pzero, (char *) &nzero_test, sizeof(nzero_test)) == 0) {
    return (nzero_double = constant_nzero);
  }

  /* otherwise, start with the limit maximum negative value (which is
     zero minus the limit minimum positive value).  halve this value
     until either it doesn't change or it becomes positive zero, and
     then use the previous value: */
  nzero_test = 0 - FLOAT_MIN_DOUBLE;
  do {
    memcpy((char *) &nzero_double, (char *) &nzero_test, sizeof(nzero_test));
    nzero_test = nzero_test / 2;
  } while (memcmp((char *) &nzero_double, (char *) &nzero_test, sizeof(nzero_test)) != 0
	   && memcmp((char *) &constant_pzero, (char *) &nzero_test, sizeof(nzero_test)) != 0);
  return (nzero_double);
}

/* a series of double values of the form 2^x, where x is a power of two: */
static const double _tme_float_radix2_exponent_bits_double_pos[] = {

  /* 2^1: */
  (1 * ((double) ((tme_uint32_t) 2))),

  /* 2^2: */
  (1 * ((double) ((tme_uint32_t) 4))),

  /* 2^4: */
  (1 * ((double) ((tme_uint32_t) 16))),

  /* 2^8: */
  (1 * ((double) ((tme_uint32_t) 256))),

  /* 2^16: */
  (1 * ((double) ((tme_uint32_t) 65536))),

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 2^32: */
  ((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 256))),

  /* 2^64: */
  (((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 65536))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 2^128: */
  ((((((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 256))),

  /* 2^256: */
  (((((((((((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 65536))),

  /* 2^512: */
  ((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 2^1024: */
  (((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 65536))),

  /* 2^2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 256))),

  /* 2^4096: */
  (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 65536))),

  /* 2^8192: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 16777216))) * ((double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* a series of double values of the form 2^-x, where x is a power of two: */
static const double _tme_float_radix2_exponent_bits_double_neg[] = {

  /* 2^-1: */
  (1 / ((double) ((tme_uint32_t) 2))),

  /* 2^-2: */
  (1 / ((double) ((tme_uint32_t) 4))),

  /* 2^-4: */
  (1 / ((double) ((tme_uint32_t) 16))),

  /* 2^-8: */
  (1 / ((double) ((tme_uint32_t) 256))),

  /* 2^-16: */
  (1 / ((double) ((tme_uint32_t) 65536))),

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 2^-32: */
  ((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 256))),

  /* 2^-64: */
  (((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 65536))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 2^-128: */
  ((((((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 256))),

  /* 2^-256: */
  (((((((((((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 65536))),

  /* 2^-512: */
  ((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 2^-1024: */
  (((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 65536))),

  /* 2^-2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 256))),

  /* 2^-4096: */
  (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 65536))),

  /* 2^-8192: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 16777216))) / ((double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* this returns the radix 2 mantissa and exponent of an in-range double.
   the mantissa is either zero, or in the range incl 1 to 2 excl: */
double
tme_float_radix2_mantissa_exponent_double(double value, tme_int32_t *_exponent)
{
  tme_int32_t exponent;
  tme_uint32_t exponent_bit;
  int negate;

  /* start with an exponent of zero: */
  exponent = 0;

  /* if the value is positive or negative zero, return the value: */
  if (value == 0.0
      || -value == 0.0) {
    *_exponent = exponent;
    return (value);
  }

  /* take the magnitude of the value, but remember if it was negative: */
  negate = (value < 0);
  if (negate) {
    value = 0 - value;
  }

  /* while the value is less than one: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_double_neg) - 1;
  for (; value < 1; ) {

    /* if value is less than or equal to 2^-(2^exponent_bit),
       divide value by 2^-(2^exponent_bit), and subtract 2^exponent_bit
       from exponent: */
    if (value <= _tme_float_radix2_exponent_bits_double_neg[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix2_exponent_bits_double_neg[exponent_bit];
      exponent -= (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* while the value is greater than or equal to 2: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_double_pos) - 1;
  for (; value >= 2; ) {

    /* if value is greater than or equal to 2^(2^exponent_bit),
       divide value by 2^(2^exponent_bit), and add 2^exponent_bit
       to exponent: */
    if (value >= _tme_float_radix2_exponent_bits_double_pos[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix2_exponent_bits_double_pos[exponent_bit];
      exponent += (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* done: */
  *_exponent = exponent;
  return (negate ? 0 - value : value);
}

/* this scales a value by adding n to its exponent: */
double
tme_float_radix2_scale_double(double value, tme_int32_t _n)
{
  tme_uint32_t exponent_bit, exponent;
  tme_uint32_t n;

  /* start with the most significant exponent bit: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_double_pos) - 1;
  exponent = (1 << exponent_bit);

  /* if n is negative: */
  if (_n < 0) {

    for (n = 0 - _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value /= _tme_float_radix2_exponent_bits_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  /* otherwise, n is positive: */
  else {
    for (n = _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value *= _tme_float_radix2_exponent_bits_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  return (value);
}

/* a series of double values of the form 10^x, where x is a power of two: */
static const double _tme_float_radix10_exponent_bits_double_pos[] = {

  /* 10^1: */
  (1 * ((double) ((tme_uint32_t) 10))),

  /* 10^2: */
  (1 * ((double) ((tme_uint32_t) 100))),

  /* 10^4: */
  (1 * ((double) ((tme_uint32_t) 10000))),

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 10^8: */
  ((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

  /* 10^16: */
  ((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 10^32: */
  ((((((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

  /* 10^64: */
  ((((((((((((((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

  /* 10^128: */
  ((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 10^256: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

  /* 10^512: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

  /* 10^1024: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

  /* 10^2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))) * ((double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* a series of double values of the form 10^-x, where x is a power of two: */
static const double _tme_float_radix10_exponent_bits_double_neg[] = {

  /* 10^-1: */
  (1 / ((double) ((tme_uint32_t) 10))),

  /* 10^-2: */
  (1 / ((double) ((tme_uint32_t) 100))),

  /* 10^-4: */
  (1 / ((double) ((tme_uint32_t) 10000))),

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 10^-8: */
  ((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

  /* 10^-16: */
  ((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 10^-32: */
  ((((((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

  /* 10^-64: */
  ((((((((((((((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

  /* 10^-128: */
  ((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 10^-256: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

  /* 10^-512: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

  /* 10^-1024: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

  /* 10^-2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))) / ((double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* this returns the radix 10 mantissa and exponent of an in-range double.
   the mantissa is either zero, or in the range incl 1 to 10 excl: */
double
tme_float_radix10_mantissa_exponent_double(double value, tme_int32_t *_exponent)
{
  tme_int32_t exponent;
  tme_uint32_t exponent_bit;
  int negate;

  /* start with an exponent of zero: */
  exponent = 0;

  /* if the value is positive or negative zero, return the value: */
  if (value == 0.0
      || -value == 0.0) {
    *_exponent = exponent;
    return (value);
  }

  /* take the magnitude of the value, but remember if it was negative: */
  negate = (value < 0);
  if (negate) {
    value = 0 - value;
  }

  /* while the value is less than one: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_double_neg) - 1;
  for (; value < 1; ) {

    /* if value is less than or equal to 10^-(2^exponent_bit),
       divide value by 10^-(2^exponent_bit), and subtract 2^exponent_bit
       from exponent: */
    if (value <= _tme_float_radix10_exponent_bits_double_neg[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix10_exponent_bits_double_neg[exponent_bit];
      exponent -= (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* while the value is greater than or equal to 10: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_double_pos) - 1;
  for (; value >= 10; ) {

    /* if value is greater than or equal to 10^(2^exponent_bit),
       divide value by 10^(2^exponent_bit), and add 2^exponent_bit
       to exponent: */
    if (value >= _tme_float_radix10_exponent_bits_double_pos[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix10_exponent_bits_double_pos[exponent_bit];
      exponent += (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* done: */
  *_exponent = exponent;
  return (negate ? 0 - value : value);
}

/* this scales a value by adding n to its exponent: */
double
tme_float_radix10_scale_double(double value, tme_int32_t _n)
{
  tme_uint32_t exponent_bit, exponent;
  tme_uint32_t n;

  /* start with the most significant exponent bit: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_double_pos) - 1;
  exponent = (1 << exponent_bit);

  /* if n is negative: */
  if (_n < 0) {

    for (n = 0 - _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value /= _tme_float_radix10_exponent_bits_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  /* otherwise, n is positive: */
  else {
    for (n = _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value *= _tme_float_radix10_exponent_bits_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  return (value);
}

#ifdef _TME_HAVE_LONG_DOUBLE

/* if possible, this returns a positive or negative infinity
   long double, otherwise, this returns the long double value
   closest to that infinity: */
long double
tme_float_infinity_long_double(int negative)
{
  static int inf_set_long_double;
  static long double inf_long_double[2];
  long double inf_test;
  int negative_i;

  /* make sure that negative can index the inf_long_double array: */
  negative = !!negative;

  /* if the long double infinities have already been set: */
  if (__tme_predict_true(inf_set_long_double)) {
    return (inf_long_double[negative]);
  }

  /* the long double infinities will be set now: */
  inf_set_long_double = TRUE;

  /* set the positive and negative infinities: */
  for (negative_i = 0; negative_i < 2; negative_i++) {

    /* start with the limit maximum positive value or limit minimum
       negative value.  double this value until either it doesn't
       change or it isn't closer to the desired infinity, and then
       use the previous value: */
    inf_test = FLOAT_MAX_LONG_DOUBLE;
    if (negative_i) {
      inf_test = -inf_test;
    }
    do {
      memcpy((char *) &inf_long_double[negative_i], (char *) &inf_test, sizeof(inf_test));
      inf_test *= 2;
    } while (memcmp((char *) &inf_long_double[negative_i], (char *) &inf_test, sizeof(inf_test)) != 0
             && (negative_i
                 ? inf_test < inf_long_double[negative_i]
                 : inf_test > inf_long_double[negative_i]));

    /* try to generate the actual infinity by dividing one or negative
       one by zero.  if this value is closer to the desired infinity,
       use it: */
    inf_test = (negative_i ? -1.0 : 1.0) / 0.0;
    if (negative_i
        ? inf_test < inf_long_double[negative_i]
        : inf_test > inf_long_double[negative_i]) {
      inf_long_double[negative_i] = inf_test;
    }
  }

  /* return the desired infinity: */
  return (inf_long_double[negative]);
}

/* if possible, this returns a negative zero long double.
   otherwise, this returns the negative long double value closest
   to zero: */
long double
tme_float_negative_zero_long_double(void)
{
  static int nzero_set_long_double;
  static long double nzero_long_double;
  long double constant_pzero;
  long double constant_nzero;
  long double nzero_test;

  /* if the long double negative zero has already been set: */
  if (__tme_predict_true(nzero_set_long_double)) {
    return (nzero_long_double);
  }

  /* the long double negative zero will be set now: */
  nzero_set_long_double = TRUE;

  /* make a +0.0 and a -0.0, that we can do bit-for-bit comparisons with.
     NB that sizeof(long double) may cover more bits than are actually
     used by a long double: */
  memset((char *) &constant_pzero, 0, sizeof(constant_pzero));
  memset((char *) &constant_nzero, 0, sizeof(constant_nzero));
  constant_pzero = +0.0;
  constant_nzero = -0.0;

  /* if -0.0 * -0.0 is bit-for-bit different from -0.0 and is
     bit-for-bit identical to +0.0, use -0.0: */
  memset((char *) &nzero_test, 0, sizeof(nzero_test));
  nzero_test = constant_nzero * constant_nzero;
  if (memcmp((char *) &constant_nzero, (char *) &nzero_test, sizeof(nzero_test)) != 0
      && memcmp((char *) &constant_pzero, (char *) &nzero_test, sizeof(nzero_test)) == 0) {
    return (nzero_long_double = constant_nzero);
  }

  /* otherwise, start with the limit maximum negative value (which is
     zero minus the limit minimum positive value).  halve this value
     until either it doesn't change or it becomes positive zero, and
     then use the previous value: */
  nzero_test = 0 - FLOAT_MIN_LONG_DOUBLE;
  do {
    memcpy((char *) &nzero_long_double, (char *) &nzero_test, sizeof(nzero_test));
    nzero_test = nzero_test / 2;
  } while (memcmp((char *) &nzero_long_double, (char *) &nzero_test, sizeof(nzero_test)) != 0
	   && memcmp((char *) &constant_pzero, (char *) &nzero_test, sizeof(nzero_test)) != 0);
  return (nzero_long_double);
}

/* a series of long double values of the form 2^x, where x is a power of two: */
static const long double _tme_float_radix2_exponent_bits_long_double_pos[] = {

  /* 2^1: */
  (1 * ((long double) ((tme_uint32_t) 2))),

  /* 2^2: */
  (1 * ((long double) ((tme_uint32_t) 4))),

  /* 2^4: */
  (1 * ((long double) ((tme_uint32_t) 16))),

  /* 2^8: */
  (1 * ((long double) ((tme_uint32_t) 256))),

  /* 2^16: */
  (1 * ((long double) ((tme_uint32_t) 65536))),

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 2^32: */
  ((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 256))),

  /* 2^64: */
  (((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 65536))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 2^128: */
  ((((((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 256))),

  /* 2^256: */
  (((((((((((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 65536))),

  /* 2^512: */
  ((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 2^1024: */
  (((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 65536))),

  /* 2^2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 256))),

  /* 2^4096: */
  (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 65536))),

  /* 2^8192: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 16777216))) * ((long double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* a series of long double values of the form 2^-x, where x is a power of two: */
static const long double _tme_float_radix2_exponent_bits_long_double_neg[] = {

  /* 2^-1: */
  (1 / ((long double) ((tme_uint32_t) 2))),

  /* 2^-2: */
  (1 / ((long double) ((tme_uint32_t) 4))),

  /* 2^-4: */
  (1 / ((long double) ((tme_uint32_t) 16))),

  /* 2^-8: */
  (1 / ((long double) ((tme_uint32_t) 256))),

  /* 2^-16: */
  (1 / ((long double) ((tme_uint32_t) 65536))),

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 2^-32: */
  ((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 256))),

  /* 2^-64: */
  (((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 65536))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 2^-128: */
  ((((((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 256))),

  /* 2^-256: */
  (((((((((((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 65536))),

  /* 2^-512: */
  ((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 2^-1024: */
  (((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 65536))),

  /* 2^-2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 256))),

  /* 2^-4096: */
  (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 65536))),

  /* 2^-8192: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 16777216))) / ((long double) ((tme_uint32_t) 256))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* this returns the radix 2 mantissa and exponent of an in-range long double.
   the mantissa is either zero, or in the range incl 1 to 2 excl: */
long double
tme_float_radix2_mantissa_exponent_long_double(long double value, tme_int32_t *_exponent)
{
  tme_int32_t exponent;
  tme_uint32_t exponent_bit;
  int negate;

  /* start with an exponent of zero: */
  exponent = 0;

  /* if the value is positive or negative zero, return the value: */
  if (value == 0.0
      || -value == 0.0) {
    *_exponent = exponent;
    return (value);
  }

  /* take the magnitude of the value, but remember if it was negative: */
  negate = (value < 0);
  if (negate) {
    value = 0 - value;
  }

  /* while the value is less than one: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_long_double_neg) - 1;
  for (; value < 1; ) {

    /* if value is less than or equal to 2^-(2^exponent_bit),
       divide value by 2^-(2^exponent_bit), and subtract 2^exponent_bit
       from exponent: */
    if (value <= _tme_float_radix2_exponent_bits_long_double_neg[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix2_exponent_bits_long_double_neg[exponent_bit];
      exponent -= (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* while the value is greater than or equal to 2: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_long_double_pos) - 1;
  for (; value >= 2; ) {

    /* if value is greater than or equal to 2^(2^exponent_bit),
       divide value by 2^(2^exponent_bit), and add 2^exponent_bit
       to exponent: */
    if (value >= _tme_float_radix2_exponent_bits_long_double_pos[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix2_exponent_bits_long_double_pos[exponent_bit];
      exponent += (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* done: */
  *_exponent = exponent;
  return (negate ? 0 - value : value);
}

/* this scales a value by adding n to its exponent: */
long double
tme_float_radix2_scale_long_double(long double value, tme_int32_t _n)
{
  tme_uint32_t exponent_bit, exponent;
  tme_uint32_t n;

  /* start with the most significant exponent bit: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix2_exponent_bits_long_double_pos) - 1;
  exponent = (1 << exponent_bit);

  /* if n is negative: */
  if (_n < 0) {

    for (n = 0 - _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value /= _tme_float_radix2_exponent_bits_long_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  /* otherwise, n is positive: */
  else {
    for (n = _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value *= _tme_float_radix2_exponent_bits_long_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  return (value);
}

/* a series of long double values of the form 10^x, where x is a power of two: */
static const long double _tme_float_radix10_exponent_bits_long_double_pos[] = {

  /* 10^1: */
  (1 * ((long double) ((tme_uint32_t) 10))),

  /* 10^2: */
  (1 * ((long double) ((tme_uint32_t) 100))),

  /* 10^4: */
  (1 * ((long double) ((tme_uint32_t) 10000))),

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 10^8: */
  ((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

  /* 10^16: */
  ((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 10^32: */
  ((((((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

  /* 10^64: */
  ((((((((((((((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

  /* 10^128: */
  ((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 10^256: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

  /* 10^512: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

  /* 10^1024: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

  /* 10^2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))) * ((long double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* a series of long double values of the form 10^-x, where x is a power of two: */
static const long double _tme_float_radix10_exponent_bits_long_double_neg[] = {

  /* 10^-1: */
  (1 / ((long double) ((tme_uint32_t) 10))),

  /* 10^-2: */
  (1 / ((long double) ((tme_uint32_t) 100))),

  /* 10^-4: */
  (1 / ((long double) ((tme_uint32_t) 10000))),

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0)

  /* 10^-8: */
  ((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

  /* 10^-16: */
  ((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE | TME_FLOAT_FORMAT_IEEE754_SINGLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0)

  /* 10^-32: */
  ((((((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

  /* 10^-64: */
  ((((((((((((((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

  /* 10^-128: */
  ((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80 | TME_FLOAT_FORMAT_IEEE754_DOUBLE)) != 0) */

#if ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0)

  /* 10^-256: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

  /* 10^-512: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

  /* 10^-1024: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

  /* 10^-2048: */
  ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1 / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))) / ((long double) ((tme_uint32_t) 10000))),

#endif /* ((TME_FLOAT_FORMAT_LONG_DOUBLE & (TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) != 0) */
};

/* this returns the radix 10 mantissa and exponent of an in-range long double.
   the mantissa is either zero, or in the range incl 1 to 10 excl: */
long double
tme_float_radix10_mantissa_exponent_long_double(long double value, tme_int32_t *_exponent)
{
  tme_int32_t exponent;
  tme_uint32_t exponent_bit;
  int negate;

  /* start with an exponent of zero: */
  exponent = 0;

  /* if the value is positive or negative zero, return the value: */
  if (value == 0.0
      || -value == 0.0) {
    *_exponent = exponent;
    return (value);
  }

  /* take the magnitude of the value, but remember if it was negative: */
  negate = (value < 0);
  if (negate) {
    value = 0 - value;
  }

  /* while the value is less than one: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_long_double_neg) - 1;
  for (; value < 1; ) {

    /* if value is less than or equal to 10^-(2^exponent_bit),
       divide value by 10^-(2^exponent_bit), and subtract 2^exponent_bit
       from exponent: */
    if (value <= _tme_float_radix10_exponent_bits_long_double_neg[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix10_exponent_bits_long_double_neg[exponent_bit];
      exponent -= (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* while the value is greater than or equal to 10: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_long_double_pos) - 1;
  for (; value >= 10; ) {

    /* if value is greater than or equal to 10^(2^exponent_bit),
       divide value by 10^(2^exponent_bit), and add 2^exponent_bit
       to exponent: */
    if (value >= _tme_float_radix10_exponent_bits_long_double_pos[exponent_bit]
        || exponent_bit == 0) {
      value /= _tme_float_radix10_exponent_bits_long_double_pos[exponent_bit];
      exponent += (1 << exponent_bit);
    }

    /* otherwise, move to the next exponent bit: */
    else {
      exponent_bit--;
    }
  }

  /* done: */
  *_exponent = exponent;
  return (negate ? 0 - value : value);
}

/* this scales a value by adding n to its exponent: */
long double
tme_float_radix10_scale_long_double(long double value, tme_int32_t _n)
{
  tme_uint32_t exponent_bit, exponent;
  tme_uint32_t n;

  /* start with the most significant exponent bit: */
  exponent_bit = TME_ARRAY_ELS(_tme_float_radix10_exponent_bits_long_double_pos) - 1;
  exponent = (1 << exponent_bit);

  /* if n is negative: */
  if (_n < 0) {

    for (n = 0 - _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value /= _tme_float_radix10_exponent_bits_long_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  /* otherwise, n is positive: */
  else {
    for (n = _n; n > 0;) {
      if (n >= exponent || exponent == 1) {
        value *= _tme_float_radix10_exponent_bits_long_double_pos[exponent_bit];
        n -= exponent;
      }
      else {
        exponent >>= 1;
        exponent_bit--;
      }
    }
  }

  return (value);
}

#endif /* _TME_HAVE_LONG_DOUBLE */
