# kustomize

> Easily deploy resources for Kubernetes.
> More information: <https://github.com/kubernetes-sigs/kustomize/blob/master/site/content/en/docs/Reference/CLI/_index.md>.

- Create a kustomization file with resources and namespace:

`kustomize create --resources {{deployment.yaml,service.yaml}} --namespace {{staging}}`

- Build a kustomization file and deploy it with `kubectl`:

`kustomize build . | kubectl apply {{[-f|--filename]}} -`

- Set an image in the kustomization file:

`kustomize edit set image {{busybox=alpine:3.6}}`

- Search for Kubernetes resources in the current directory to be added to the kustomization file:

`kustomize create --autodetect`
