# phar

> Создать, обновить или извлечь PHP-архивы (PHAR).
> Больше информации: <https://manned.org/phar>.

- Добавить один или несколько файлов или каталогов в Phar-файл:

`phar add -f {{путь/к/phar_файлу}} {{путь/к/файлу_или_каталогу1 путь/к/файлу_или_каталогу2 ...}}`

- Показать содержимое Phar-файла:

`phar list -f {{путь/к/phar_файлу}}`

- Удалить указанный файл или каталог из Phar-файла:

`phar delete -f {{путь/к/phar_файлу}} -e {{файл_или_каталог}}`

- Сжать или распаковать файлы и каталоги в Phar-файле:

`phar compress -f {{путь/к/phar_файлу}} -c {{алгоритм}}`

- Получить информацию о Phar-файле:

`phar info -f {{путь/к/phar_файлу}}`

- Подписать Phar-файл с использованием указанного алгоритма хеширования:

`phar sign -f {{путь/к/phar_файлу}} -h {{алгоритм}}`

- Подписать Phar-файл с использованием приватного ключа OpenSSL:

`phar sign -f {{путь/к/phar_файлу}} -h openssl -y {{путь/к/приватному_ключу}}`

- Показать справку и доступные алгоритмы хеширования/сжатия:

`phar help`
