/**
Check if your code is running as an [npm](https://docs.npmjs.com/misc/scripts) script.

@example
```
import {isNpm} from 'is-npm';

if (isNpm) {
	console.log('Running as an npm script!');
}
```
*/
export const isNpm: boolean;

/**
Check if your code is running as a [yarn](https://yarnpkg.com/cli/run) script.

@example
```
import {isYarn} from 'is-npm';

if (isYarn) {
	console.log('Running as a yarn script!');
}
```
*/
export const isYarn: boolean;

/**
Check if your code is running as a [pnpm](https://pnpm.io) script.

@example
```
import {isPnpm} from 'is-npm';

if (isPnpm) {
	console.log('Running as a pnpm script!');
}
```
*/
export const isPnpm: boolean;

/**
Check if your code is running as a [bun](https://bun.sh) script.

@example
```
import {isBun} from 'is-npm';

if (isBun) {
	console.log('Running as a bun script!');
}
```
*/
export const isBun: boolean;

/**
Check if your code is running as a package manager script (npm, yarn, pnpm, or bun).

@example
```
import {isPackageManager} from 'is-npm';

if (isPackageManager) {
	console.log('Running as a package manager script!');
}
```
*/
export const isPackageManager: boolean;

// TODO: Add `@deprecated Use `isPackageManager` instead for detecting any package manager (npm, yarn, pnpm, bun).` in next major.
/**
Check if your code is running as an [npm](https://docs.npmjs.com/misc/scripts) or [yarn](https://yarnpkg.com/cli/run) script.

@example
```
import {isNpmOrYarn} from 'is-npm';

if (isNpmOrYarn) {
	console.log('Running as an npm or yarn script!');
}
```
*/
export const isNpmOrYarn: boolean;
