/* livechart.vapi generated by valac 0.56.18, do not modify. */

namespace LiveChart {
	namespace Static {
		[CCode (cheader_filename = "livechart.h")]
		public class StaticChart : Gtk.DrawingArea {
			public LiveChart.Config config;
			public LiveChart.Static.StaticSeries series;
			public StaticChart (LiveChart.Config config = new LiveChart.Config ());
			public void add_serie (LiveChart.Static.StaticSerie serie);
			public void set_categories (Gee.ArrayList<string> categories);
			public void to_png (string filename) throws GLib.Error;
			public LiveChart.Background background { get; set; }
			public LiveChart.Static.StaticGrid grid { get; set; }
			public LiveChart.Legend legend { get; set; }
		}
		[CCode (cheader_filename = "livechart.h")]
		public class StaticGrid : LiveChart.Drawable, GLib.Object {
			protected LiveChart.BoundingBox bounding_box;
			public const int ABSCISSA_TIME_PADDING;
			public StaticGrid ();
			protected void debug (Cairo.Context ctx);
			protected void render_abscissa (Cairo.Context ctx, LiveChart.Config config);
			protected void render_grid (Cairo.Context ctx, LiveChart.Config config);
			protected void render_hgrid (Cairo.Context ctx, LiveChart.Config config);
			protected void render_ordinate (Cairo.Context ctx, LiveChart.Config config);
			protected void render_vgrid (Cairo.Context ctx, LiveChart.Config config);
			protected void restore (Cairo.Context ctx);
			protected void update_bounding_box (LiveChart.Config config);
			public Gdk.RGBA main_color { get; set; }
		}
		[CCode (cheader_filename = "livechart.h")]
		public class StaticLine : LiveChart.Static.StaticSerieRenderer {
			public StaticLine (LiveChart.Static.StaticValues values = new LiveChart.Static.StaticValues ());
			public override void draw (Cairo.Context ctx, LiveChart.Config config);
			protected void draw_line (LiveChart.Static.StaticPoints points, Cairo.Context ctx, LiveChart.Config config);
		}
		[CCode (cheader_filename = "livechart.h")]
		public class StaticPoints : GLib.Object {
			public StaticPoints ();
			public void add (LiveChart.Point point);
			public LiveChart.Point after (int at);
			public static LiveChart.Static.StaticPoints create (LiveChart.Static.StaticValues values, LiveChart.Config config);
			public LiveChart.Point first ();
			public new LiveChart.Point @get (int at);
			public LiveChart.Point last ();
			public LiveChart.Bounds bounds { get; set construct; }
			public double realtime_delta { get; set; }
			public int size { get; }
		}
		[CCode (cheader_filename = "livechart.h")]
		public class StaticSerie : LiveChart.Colorable, LiveChart.Drawable, GLib.Object {
			public StaticSerie (string name, LiveChart.Static.StaticSerieRenderer renderer = new LiveChart.Static.StaticLine (new LiveChart.Static.StaticValues ()));
			public void add (string name, double value);
			public void clear ();
			public LiveChart.Static.StaticValues get_values ();
			public LiveChart.Path line { get; set; }
			public string name { get; set; }
			public signal void value_added (double value);
		}
		[CCode (cheader_filename = "livechart.h")]
		public abstract class StaticSerieRenderer : LiveChart.Drawable, GLib.Object {
			protected LiveChart.BoundingBox bounding_box;
			protected LiveChart.Static.StaticValues values;
			protected StaticSerieRenderer ();
			protected void debug (Cairo.Context ctx);
			public abstract void draw (Cairo.Context ctx, LiveChart.Config config);
			public LiveChart.Static.StaticValues get_values ();
			protected bool is_out_of_area (LiveChart.Point point);
			public LiveChart.Path line { get; set; }
		}
		[CCode (cheader_filename = "livechart.h")]
		public class StaticSeries : GLib.Object {
			public StaticSeries (LiveChart.Static.StaticChart chart);
			public new LiveChart.Static.StaticSerie @get (int index) throws LiveChart.ChartError;
			public LiveChart.Static.StaticSerie get_by_name (string name) throws LiveChart.ChartError;
			public Gee.Iterator<LiveChart.Static.StaticSerie> iterator ();
			public LiveChart.Static.StaticSerie register (LiveChart.Static.StaticSerie serie);
		}
		[CCode (cheader_filename = "livechart.h")]
		public class StaticValues : Gee.LinkedList<LiveChart.Static.NamedValue?> {
			public StaticValues ();
			public new void add (LiveChart.Static.NamedValue value);
			public LiveChart.Bounds bounds { get; set construct; }
		}
		[CCode (cheader_filename = "livechart.h")]
		public struct NamedValue {
			public string name;
			public double value;
		}
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Area : LiveChart.Drawable, GLib.Object {
		public Area (LiveChart.Points points, Gdk.RGBA color, double alpha);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Background : LiveChart.Drawable, GLib.Object {
		public Background ();
		public Gdk.RGBA color { get; set; }
		[Version (deprecated = true, deprecated_since = "1.8.0", replacement = "Background.color")]
		public Gdk.RGBA main_color { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Bar : LiveChart.SerieRenderer {
		public Bar (LiveChart.Values values = new LiveChart.Values (1000));
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class BezierIntersector : LiveChart.Intersector<LiveChart.BezierCurve?> {
		public BezierIntersector (LiveChart.Region region, LiveChart.Config config);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Bounds : GLib.Object {
		public Bounds (double lower = double.NAN, double upper = double.NAN);
		public bool has_lower ();
		public bool has_upper ();
		public bool update (double value);
		public double lower { get; private set; }
		public double upper { get; private set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Chart : Gtk.DrawingArea {
		public LiveChart.Config config;
		public LiveChart.Series series;
		public Chart (LiveChart.Config config = new LiveChart.Config ());
		public void add_serie (LiveChart.Serie serie);
		public void add_unaware_timestamp_collection (LiveChart.Serie serie, Gee.Collection<double?> collection, int timespan_between_value);
		public void add_unaware_timestamp_collection_by_index (int serie_index, Gee.Collection<double?> collection, int timespan_between_value) throws LiveChart.ChartError;
		[Version (deprecated = true, deprecated_since = "1.7.0", replacement = "Retrieve the Serie from Chart.series (or from the serie you created) and add the value using serie.add")]
		public void add_value (LiveChart.Serie serie, double value);
		[Version (deprecated = true, deprecated_since = "1.7.0", replacement = "Retrieve the Serie from Chart.series and add the value using serie.add")]
		public void add_value_by_index (int serie_index, double value) throws LiveChart.ChartError;
		public void refresh_every (int ms, double play_ratio = 1.0);
		public void remove_all_series ();
		public void remove_serie (LiveChart.Serie serie);
		public void to_png (string filename) throws GLib.Error;
		public LiveChart.Background background { get; set; }
		public LiveChart.Grid grid { get; set; }
		public LiveChart.Legend legend { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Config {
		public LiveChart.Padding padding;
		public LiveChart.TimeSeek time;
		public LiveChart.XAxis x_axis;
		public LiveChart.YAxis y_axis;
		public Config ();
		public LiveChart.Boundaries boundaries ();
		public void configure (Cairo.Context ctx, LiveChart.Legend? legend);
		public int height { get; set; }
		public int width { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class CrossRegionResolver : GLib.Object {
		public CrossRegionResolver (double floor, double ceil);
		public bool has_at_least_one_point_within (LiveChart.Point previous, LiveChart.Point current);
		public bool is_entering_by_the_bottom (LiveChart.Point previous, LiveChart.Point current);
		public bool is_entering_by_the_top (LiveChart.Point previous, LiveChart.Point current);
		public bool is_leaving_by_the_bottom (LiveChart.Point previous, LiveChart.Point current);
		public bool is_leaving_by_the_top (LiveChart.Point previous, LiveChart.Point current);
		public bool is_within (LiveChart.Point previous, LiveChart.Point current);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Font {
		public Font ();
		public void configure (Cairo.Context ctx);
		public Gdk.RGBA color { get; set; }
		public string face { get; set; }
		public uint8 size { get; set; }
		public Cairo.FontSlant slant { get; set; }
		public Cairo.FontWeight weight { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Grid : LiveChart.Drawable, GLib.Object {
		protected LiveChart.BoundingBox bounding_box;
		public const int ABSCISSA_TIME_PADDING;
		public Grid ();
		protected void debug (Cairo.Context ctx);
		protected void render_abscissa (Cairo.Context ctx, LiveChart.Config config);
		protected void render_grid (Cairo.Context ctx, LiveChart.Config config);
		protected void render_hgrid (Cairo.Context ctx, LiveChart.Config config);
		protected void render_ordinate (Cairo.Context ctx, LiveChart.Config config);
		protected void render_vgrid (Cairo.Context ctx, LiveChart.Config config);
		protected void restore (Cairo.Context ctx);
		protected void update_bounding_box (LiveChart.Config config);
		public Gdk.RGBA main_color { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class HorizontalLegend : LiveChart.Legend {
		public HorizontalLegend ();
		protected void debug (Cairo.Context ctx);
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Intersection : GLib.Object {
		public double? entered_at;
		public double? exited_at;
		public Intersection (LiveChart.Region region, double start_x, double entered_at);
		public void close (double x, double exited_at);
		public bool is_closed ();
		public bool is_open ();
		public void update (double x);
		public Intersection.without_entry_point (LiveChart.Region region, double start_x);
		public double end_x { get; private set; }
		public LiveChart.Region region { get; set construct; }
		public double start_x { get; private set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Intersections : GLib.Object {
		public Intersections ();
		public void close (double x, double exited_at);
		public void @foreach (Gee.ForallFunc<LiveChart.Intersection?> f);
		public new LiveChart.Intersection @get (int index);
		public LiveChart.Region get_current_region ();
		public bool has_an_opened_intersection ();
		public void open (LiveChart.Region region, double x, double entered_at);
		public void open_without_entrypoint (LiveChart.Region region, double x);
		public int size ();
		public void update (double x);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Labels {
		public Labels ();
		public Cairo.TextExtents extents { get; set; }
		public LiveChart.Font font { get; set; }
		public bool visible { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public abstract class Legend : LiveChart.Drawable, GLib.Object {
		protected LiveChart.BoundingBox bounding_box;
		public LiveChart.Labels labels;
		protected Gee.ArrayList<LiveChart.Serie> series;
		protected Legend ();
		public void add_legend (LiveChart.Serie serie);
		public abstract void draw (Cairo.Context ctx, LiveChart.Config config);
		public void remove_all_legend ();
		public void remove_legend (LiveChart.Serie serie);
		public Gdk.RGBA main_color { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Line : LiveChart.SerieRenderer {
		public Line (LiveChart.Values values = new LiveChart.Values (1000));
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
		protected LiveChart.Points draw_line (LiveChart.Points points, Cairo.Context ctx, LiveChart.Config config);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class LineArea : LiveChart.Line {
		public LineArea (LiveChart.Values values = new LiveChart.Values (1000));
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
		public double area_alpha { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class MaxBoundLine : LiveChart.SerieRenderer {
		public MaxBoundLine ();
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
		public MaxBoundLine.from_serie (LiveChart.Serie serie);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class MinBoundLine : LiveChart.SerieRenderer {
		public MinBoundLine (LiveChart.Values values = new LiveChart.Values (1000));
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
		public MinBoundLine.from_serie (LiveChart.Serie serie);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class NoopLegend : LiveChart.Legend {
		public NoopLegend ();
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Path : GLib.Object {
		public LiveChart.Dash? dash;
		public Path (double width = 0.5, Gdk.RGBA color = { 1.0f, 1.0f, 1.0f, 1.0f }, bool visible = true, LiveChart.Dash? dash = null);
		public void configure (Cairo.Context ctx);
		public Gdk.RGBA color { get; set; }
		public bool visible { get; set; }
		public double width { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Points : GLib.Object {
		public Points ();
		public void add (LiveChart.Point point);
		public LiveChart.Point after (int at);
		public static LiveChart.Points create (LiveChart.Values values, LiveChart.Config config);
		public LiveChart.Point first ();
		public new LiveChart.Point @get (int at);
		public LiveChart.Point last ();
		public LiveChart.Bounds bounds { get; set construct; }
		public double realtime_delta { get; set; }
		public int size { get; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Region {
		public Region (double floor, double ceil);
		public Region.between (double above, double below);
		public void handle (LiveChart.Intersections intersections, LiveChart.Point previous, LiveChart.Point current, LiveChart.GetIntersection get_intersection);
		public LiveChart.Region with_area_color (Gdk.RGBA color);
		public LiveChart.Region with_line_color (Gdk.RGBA color);
		public Gdk.RGBA area_color { get; set; }
		public Gdk.RGBA line_color { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Serie : LiveChart.Colorable, LiveChart.Drawable, GLib.Object {
		public Serie (string name, LiveChart.SerieRenderer renderer = new LiveChart.Line (new LiveChart.Values (1000)));
		public void add (double value);
		public void add_with_timestamp (double value, int64 timestamp);
		public void clear ();
		[Version (deprecated = true, deprecated_since = "1.7.1", replacement = "Serie.main_color property instead")]
		public Gdk.RGBA get_main_color ();
		public LiveChart.Values get_values ();
		[Version (deprecated = true, deprecated_since = "1.7.1", replacement = "Serie.main_color property instead")]
		public void set_main_color (Gdk.RGBA color);
		public LiveChart.Path line { get; set; }
		public string name { get; set; }
		public signal void value_added (double value);
	}
	[CCode (cheader_filename = "livechart.h")]
	public abstract class SerieRenderer : LiveChart.Drawable, GLib.Object {
		protected LiveChart.BoundingBox bounding_box;
		protected LiveChart.Values values;
		protected SerieRenderer ();
		protected void debug (Cairo.Context ctx);
		public abstract void draw (Cairo.Context ctx, LiveChart.Config config);
		public LiveChart.Values get_values ();
		protected bool is_out_of_area (LiveChart.Point point);
		public LiveChart.Path line { get; set; }
		[Version (deprecated = true, deprecated_since = "1.8.0", replacement = "Serie.renderer.line.color")]
		public Gdk.RGBA main_color { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Series : GLib.Object {
		public Series (LiveChart.Chart chart);
		public new LiveChart.Serie @get (int index) throws LiveChart.ChartError;
		public LiveChart.Serie get_by_name (string name) throws LiveChart.ChartError;
		public Gee.Iterator<LiveChart.Serie> iterator ();
		public LiveChart.Serie register (LiveChart.Serie serie);
		public void remove_all ();
		public void remove_serie (LiveChart.Serie serie);
	}
	[CCode (cheader_filename = "livechart.h")]
	public class SmoothLine : LiveChart.SerieRenderer {
		protected LiveChart.Intersections intersections;
		public SmoothLine (LiveChart.Values values = new LiveChart.Values (1000));
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
		protected void draw_regions_on_line (Cairo.Context ctx, LiveChart.Config config);
		public Cairo.Path draw_smooth_line (LiveChart.Points points, Cairo.Context ctx, LiveChart.Config config);
		public LiveChart.Region? region { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class SmoothLineArea : LiveChart.SmoothLine {
		public SmoothLineArea (LiveChart.Values values = new LiveChart.Values (1000));
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
		protected void draw_regions_on_area (Cairo.Context ctx, LiveChart.Config config);
		public double area_alpha { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class ThresholdLine : LiveChart.SerieRenderer {
		public ThresholdLine (double value);
		public override void draw (Cairo.Context ctx, LiveChart.Config config);
		public double value { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class TimeSeek {
		public int64 current;
		public TimeSeek ();
		public string get_time_str (int64 time, bool show_fraction);
		public void set_range (string unit_sec);
		public int64 conv_sec { get; private set; }
		public int64 conv_us { get; private set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class Values : Gee.LinkedList<LiveChart.TimestampedValue?> {
		public Values (int buffer_size = 1000);
		public new void add (LiveChart.TimestampedValue value);
		public LiveChart.Bounds bounds { get; set construct; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class XAxis {
		public LiveChart.Path axis;
		public LiveChart.Labels labels;
		public LiveChart.Path lines;
		public bool show_fraction;
		public bool slide_timeline;
		public XAxis ();
		public double get_ratio ();
		public float tick_interval { get; set; }
		public float tick_length { get; set; }
		public bool visible { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public class YAxis {
		public LiveChart.Path axis;
		public double? fixed_max;
		public LiveChart.Labels labels;
		public LiveChart.Path lines;
		[Version (deprecated = true, deprecated_since = "1.0.0b7", replacement = "ratio is always smart ;)")]
		public bool smart_ratio;
		public LiveChart.Ticks ticks;
		public YAxis (string unit = "");
		public LiveChart.Bounds get_bounds ();
		public string get_max_displayed_value ();
		public double get_ratio ();
		public LiveChart.Ticks get_ticks ();
		public void update (int area_height);
		public bool update_bounds (double value);
		public float ratio_threshold { get; set; }
		public float tick_interval { get; set; }
		[Version (deprecated = true, deprecated_since = "1.0.0b7")]
		public float tick_length { get; set; }
		public string unit { get; set; }
		public bool visible { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public interface Colorable : GLib.Object {
		[Version (deprecated = true, deprecated_since = "1.8.0", replacement = "Serie.line.color")]
		public abstract Gdk.RGBA main_color { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public interface Drawable : GLib.Object {
		public abstract void draw (Cairo.Context ctx, LiveChart.Config config);
		public abstract LiveChart.BoundingBox get_bounding_box ();
		public abstract bool visible { get; set; }
	}
	[CCode (cheader_filename = "livechart.h")]
	public interface Intersector<T> {
		public abstract void intersect (LiveChart.Intersections intersections, LiveChart.Point previous, LiveChart.Point current, T path);
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct BezierCurve {
		public LiveChart.Coord c0;
		public LiveChart.Coord c1;
		public LiveChart.Coord c2;
		public LiveChart.Coord c3;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Boundaries {
		public LiveChart.Boundary x;
		public LiveChart.Boundary y;
		public int width;
		public int height;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Boundary {
		public int min;
		public int max;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct BoundingBox {
		public double x;
		public double y;
		public double width;
		public double height;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Coord {
		public double x;
		public double y;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Dash {
		public double[]? dashes;
		public double offset;
		public Dash ();
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Padding {
		public LiveChart.AutoPadding smart;
		public int top;
		public int right;
		public int bottom;
		public int left;
		public Padding ();
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Point {
		public double x;
		public double y;
		public double height;
		public LiveChart.TimestampedValue data;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct RegionHandleResult {
		public LiveChart.RegionHandleStatus status;
		public double at_value;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Segment {
		public LiveChart.Coord from;
		public LiveChart.Coord to;
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct Ticks {
		public Gee.List<float?> values;
		public Ticks ();
	}
	[CCode (cheader_filename = "livechart.h")]
	public struct TimestampedValue {
		public double timestamp;
		public double value;
	}
	[CCode (cheader_filename = "livechart.h")]
	[Flags]
	public enum AutoPadding {
		NONE,
		TOP,
		RIGHT,
		BOTTOM,
		LEFT
	}
	[CCode (cheader_filename = "livechart.h")]
	public enum RegionHandleStatus {
		ENTER,
		EXIT,
		WITHIN,
		OUT
	}
	[CCode (cheader_filename = "livechart.h")]
	public errordomain ChartError {
		EXPORT_ERROR,
		SERIE_NOT_FOUND
	}
	[CCode (cheader_filename = "livechart.h")]
	public delegate LiveChart.Coord? GetIntersection (double at_value);
	[CCode (cheader_filename = "livechart.h")]
	public static LiveChart.BezierCurve build_bezier_curve_from_points (LiveChart.Point previous, LiveChart.Point target);
	[CCode (cheader_filename = "livechart.h")]
	public static float cap (float value);
	[CCode (cheader_filename = "livechart.h")]
	public static Gee.List<LiveChart.Coord?> find_intersections_between (LiveChart.Segment segment, LiveChart.BezierCurve bezier);
	[CCode (cheader_filename = "livechart.h")]
	public static string format_for_y_axis (string unit, float value);
	[CCode (cheader_filename = "livechart.h")]
	public static Gee.List<float?> golden_divisors (float value);
	[CCode (cheader_filename = "livechart.h")]
	public static bool has_fractional_part (float value);
}
