# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACASChaco clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACASChaco requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACASChaco build
## ---------------------------------------------------------------------------

set(SEACASChaco_CXX_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/g++.exe")

set(SEACASChaco_C_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/gcc.exe")

set(SEACASChaco_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACASChaco_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACASChaco build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACASChaco_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACASChaco_CXX_FLAGS [[ ]])

set(SEACASChaco_C_FLAGS [[  -Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACASChaco_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACASChaco_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACASChaco_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACASChaco_SHARED_LIB_RPATH_COMMAND "${CMAKE_CURRENT_LIST_DIR}/../../../lib")
set(SEACASChaco_BUILD_SHARED_LIBS "ON")

set(SEACASChaco_LINKER ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ld.exe)
set(SEACASChaco_AR ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACASChaco_INSTALL_DIR "${CMAKE_CURRENT_LIST_DIR}/../../..")

## List of package libraries
set(SEACASChaco_LIBRARIES SEACASChaco::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACASChaco_MPI_LIBRARIES "")
set(SEACASChaco_MPI_LIBRARY_DIRS "")
set(SEACASChaco_MPI_INCLUDE_DIRS "")
set(SEACASChaco_MPI_EXEC "")
set(SEACASChaco_MPI_EXEC_MAX_NUMPROCS "")
set(SEACASChaco_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages

# Import SEACASChaco targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASChacoTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACASChaco_IS_TRIBITS_COMPLIANT TRUE)
set(SEACASChaco_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACASChaco_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACASChaco_EXPORTED_PACKAGE_LIBS_NAMES "chaco")

foreach(libname IN LISTS SEACASChaco_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACASChaco::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACASChaco::${libname}', or better yet,"
      " 'SEACASChaco::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACASChaco'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACASChaco_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
