; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -x86-asm-syntax=intel -mcpu=i486 | FileCheck %s

; Test that the load of the constant is folded into the operation.


define double @foo_add(double %P) {
; CHECK-LABEL: foo_add:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fld qword ptr [esp + 4]
; CHECK-NEXT:    fadd dword ptr [{{\.?LCPI[0-9]+_[0-9]+}}]
; CHECK-NEXT:    ret
	%tmp.1 = fadd double %P, 1.230000e+02		; <double> [#uses=1]
	ret double %tmp.1
}

define double @foo_mul(double %P) {
; CHECK-LABEL: foo_mul:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fld qword ptr [esp + 4]
; CHECK-NEXT:    fmul dword ptr [{{\.?LCPI[0-9]+_[0-9]+}}]
; CHECK-NEXT:    ret
	%tmp.1 = fmul double %P, 1.230000e+02		; <double> [#uses=1]
	ret double %tmp.1
}

define double @foo_sub(double %P) {
; CHECK-LABEL: foo_sub:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fld qword ptr [esp + 4]
; CHECK-NEXT:    fadd dword ptr [{{\.?LCPI[0-9]+_[0-9]+}}]
; CHECK-NEXT:    ret
	%tmp.1 = fsub double %P, 1.230000e+02		; <double> [#uses=1]
	ret double %tmp.1
}

define double @foo_subr(double %P) {
; CHECK-LABEL: foo_subr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fld dword ptr [{{\.?LCPI[0-9]+_[0-9]+}}]
; CHECK-NEXT:    fsub qword ptr [esp + 4]
; CHECK-NEXT:    ret
	%tmp.1 = fsub double 1.230000e+02, %P		; <double> [#uses=1]
	ret double %tmp.1
}

define double @foo_div(double %P) {
; CHECK-LABEL: foo_div:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fld qword ptr [esp + 4]
; CHECK-NEXT:    fdiv dword ptr [{{\.?LCPI[0-9]+_[0-9]+}}]
; CHECK-NEXT:    ret
	%tmp.1 = fdiv double %P, 1.230000e+02		; <double> [#uses=1]
	ret double %tmp.1
}

define double @foo_divr(double %P) {
; CHECK-LABEL: foo_divr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fld dword ptr [{{\.?LCPI[0-9]+_[0-9]+}}]
; CHECK-NEXT:    fdiv qword ptr [esp + 4]
; CHECK-NEXT:    ret
	%tmp.1 = fdiv double 1.230000e+02, %P		; <double> [#uses=1]
	ret double %tmp.1
}

