/*
Copyright (c) 2023 Cedalo GmbH

All rights reserved. This program and the accompanying materials
are made available under the terms of the Eclipse Public License 2.0
and Eclipse Distribution License v1.0 which accompany this distribution.

The Eclipse Public License is available at
   https://www.eclipse.org/legal/epl-2.0/
and the Eclipse Distribution License is available at
  http://www.eclipse.org/org/documents/edl-v10.php.

SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause

Contributors:
   Roger Light - initial implementation and documentation.
*/
#include <mosquitto.h>
#include <cstdlib>
#include <cstring>


extern "C" int LLVMFuzzerTestOneInput(const uint8_t *data, size_t size)
{
	char *buf;
	buf = (char *)calloc(1, size+1); /* ensure ull terminated */
	if(buf){
		char **topics = NULL;;
		int count;

		memcpy(buf, data, size);
		mosquitto_sub_topic_tokenise(buf, &topics, &count);
		mosquitto_sub_topic_tokens_free(&topics, count);
		free(buf);
	}
	return 0;
}
